#!/bin/sh

set -e

test_pubkey() {
    echo "Testing pubkey generation"
    expected_key="L+V9o0fNYkMVKNqsX7spBzD/9oSvxM/C7ZCZX1jLO3Q="
    generated_key="$(head -c 32 /dev/zero | base64 | src/wg pubkey)"
    echo "Expected and generated keys must be equal"
    echo "expected_key=$expected_key"
    echo "generated_key=$generated_key"
    test "$expected_key" = "$generated_key"
}

test_wg_command() {
    echo "Testing command $1"
    echo "\"a\" and \"b\" must be different"
    a="$(src/wg $1)"
    b="$(src/wg $1)"
    echo "a=$a"
    echo "b=$b"
    test -n "$a"
    test -n "$b"
    test "$a" != "$b"
}

test_pubkey
test_wg_command genpsk
test_wg_command genkey
