/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JAbstractMethod;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.dev.util.Pair;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.UiBinderContext;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.model.OwnerFieldClass;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UiChildParser
implements ElementParser {
    private String fieldName;
    private Map<String, Integer> numCallsToChildMethod = new HashMap<String, Integer>();
    private Map<String, Pair<JMethod, Integer>> uiChildMethods;
    private UiBinderWriter writer;
    private final UiBinderContext uiBinderCtx;

    public UiChildParser(UiBinderContext uiBinderCtx) {
        this.uiBinderCtx = uiBinderCtx;
    }

    public void parse(final XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        this.fieldName = fieldName;
        this.writer = writer;
        OwnerFieldClass ownerFieldClass = OwnerFieldClass.getFieldClass((JClassType)type, (MortalLogger)writer.getLogger(), (UiBinderContext)this.uiBinderCtx);
        this.uiChildMethods = ownerFieldClass.getUiChildMethods();
        elem.consumeChildElements((XMLElement.Interpreter)new XMLElement.Interpreter<Boolean>(){

            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (UiChildParser.this.isValidChildElement(elem, child)) {
                    UiChildParser.this.handleChild(child);
                    return true;
                }
                return false;
            }
        });
    }

    private void checkLimit(int limit, String tag, XMLElement toAdd) throws UnableToCompleteException {
        Integer priorCalls = this.numCallsToChildMethod.get(tag);
        if (priorCalls == null) {
            priorCalls = 0;
        }
        if (limit > 0 && priorCalls > 0 && priorCalls + 1 > limit) {
            this.writer.die(toAdd, "Can only use the @UiChild tag " + tag + " " + limit + " time(s).", new Object[0]);
        }
        this.numCallsToChildMethod.put(tag, priorCalls + 1);
    }

    private void handleChild(XMLElement child) throws UnableToCompleteException {
        String tag = child.getLocalName();
        Pair<JMethod, Integer> methodPair = this.uiChildMethods.get(tag);
        JMethod method = (JMethod)methodPair.left;
        int limit = (Integer)methodPair.right;
        Iterator children = child.consumeChildElements().iterator();
        if (!children.hasNext()) {
            return;
        }
        XMLElement toAdd = (XMLElement)children.next();
        if (!this.writer.isWidgetElement(toAdd)) {
            this.writer.die(child, "Expecting only widgets in %s", new Object[]{child});
        }
        if (children.hasNext()) {
            this.writer.die(toAdd, "Can only have one element per @UiChild parser tag.", new Object[0]);
        }
        this.checkLimit(limit, tag, toAdd);
        String[] parameters = this.makeArgsList(child, (JAbstractMethod)method, toAdd);
        this.writer.addStatement("%1$s.%2$s(%3$s);", new Object[]{this.fieldName, method.getName(), UiBinderWriter.asCommaSeparatedList((String[])parameters)});
    }

    private boolean isValidChildElement(XMLElement parent, XMLElement child) {
        return child != null && child.getNamespaceUri() != null && child.getNamespaceUri().equals(parent.getNamespaceUri()) && this.uiChildMethods.containsKey(child.getLocalName());
    }

    private String[] makeArgsList(XMLElement element, JAbstractMethod method, XMLElement toAdd) throws UnableToCompleteException {
        JParameter[] params = method.getParameters();
        String[] args = new String[params.length];
        args[0] = this.writer.parseElementToField(toAdd);
        for (int index = 1; index < params.length; ++index) {
            String value;
            JParameter param = params[index];
            String defaultValue = null;
            if (param.getType().isPrimitive() != null) {
                defaultValue = param.getType().isPrimitive().getUninitializedFieldExpression();
            }
            args[index] = value = element.consumeAttributeWithDefault(param.getName(), defaultValue, param.getType());
        }
        return args;
    }
}

