/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.model;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestFactory {
    private static final Log LOG = LogFactory.getLog(RequestFactory.class);

    public static CLIRequest getRequest(Class<? extends CLIRequest> clazz, String[] args) {
        CLIRequest request = null;
        try {
            request = clazz.newInstance();
        }
        catch (InstantiationException e1) {
            Utils.exit(1, e1.getMessage(), e1);
        }
        catch (IllegalAccessException e1) {
            Utils.exit(1, e1.getMessage(), e1);
        }
        CmdLineParser parser = new CmdLineParser((Object)request);
        for (String arg : args) {
            if (!arg.equals("-h")) continue;
            RequestFactory.printHelp(request, parser);
            Utils.exit(1, null, null);
        }
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error((Object)e.getMessage());
            RequestFactory.printHelp(request, parser);
            Utils.exit(1, null, null);
        }
        return request;
    }

    private static void printHelp(CLIRequest request, CmdLineParser parser) {
        StringWriter writer = new StringWriter();
        LOG.error((Object)request.getDescription());
        LOG.error((Object)(request.getRequestName() + " [options...] arguments..."));
        parser.printUsage((Writer)writer, null);
        LOG.error((Object)writer.getBuffer().toString());
    }
}

