/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJListCellReader;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListContentQuery;
import org.fest.swing.driver.JListItemCountQuery;
import org.fest.swing.driver.JListItemIndexValidator;
import org.fest.swing.driver.JListItemValueQuery;
import org.fest.swing.driver.JListMatchingItemQuery;
import org.fest.swing.driver.JListScrollToItemTask;
import org.fest.swing.driver.JListSelectedIndexQuery;
import org.fest.swing.driver.JListSelectionIndicesQuery;
import org.fest.swing.driver.JListSelectionValueQuery;
import org.fest.swing.driver.JListSelectionValuesQuery;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Arrays;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.Range;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JListDriver
extends JComponentDriver {
    private static final String SELECTED_INDICES_PROPERTY = "selectedIndices";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private JListCellReader cellReader;

    public JListDriver(Robot robot) {
        super(robot);
        this.cellReader(new BasicJListCellReader());
    }

    @RunsInEDT
    public String[] contentsOf(JList list) {
        return JListContentQuery.contents(list, this.cellReader);
    }

    @RunsInEDT
    public void selectItems(JList list, String[] values) {
        this.selectItems(list, new StringTextMatcher(values));
    }

    @RunsInEDT
    public void selectItems(JList list, Pattern[] patterns) {
        this.selectItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void selectItems(final JList list, TextMatcher matcher) {
        final List<Integer> indices = JListMatchingItemQuery.matchingItemIndices(list, matcher, this.cellReader);
        if (indices.isEmpty()) {
            throw this.failMatchingNotFound(list, matcher);
        }
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return indices.size();
            }

            void selectElement(int index) {
                JListDriver.this.selectItem(list, (Integer)indices.get(index));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void selectItem(JList list, String value) {
        this.selectItem(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(JList list, Pattern pattern) {
        this.selectItem(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(JList list, TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, matcher, this.cellReader);
        this.robot.waitForIdle();
        this.verify(list, scrollInfo, matcher);
        if (scrollInfo.ii == null) {
            return;
        }
        this.robot.click((Component)list, this.cellCenterIn(scrollInfo));
    }

    public void clickItem(JList list, String value, MouseButton button, int times) {
        this.clickItem(list, new StringTextMatcher(value), button, times);
    }

    public void clickItem(JList list, Pattern pattern, MouseButton button, int times) {
        this.clickItem(list, new PatternTextMatcher(pattern), button, times);
    }

    private void clickItem(JList list, TextMatcher matcher, MouseButton button, int times) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader);
        this.robot.waitForIdle();
        this.verify(list, scrollInfo, matcher);
        this.robot.click(list, this.cellCenterIn(scrollInfo), button, times);
    }

    public void selectItems(final JList list, final int[] indices) {
        this.validateArrayOfIndices(indices);
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return indices.length;
            }

            void selectElement(int index) {
                JListDriver.this.selectItem(list, indices[index]);
            }
        }.multiSelect();
    }

    public void clearSelection(JList list) {
        JListDriver.clearSelectionOf(list);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void clearSelectionOf(final JList list) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                list.clearSelection();
            }
        });
    }

    @RunsInEDT
    public void selectItems(JList list, Range.From from, Range.To to) {
        this.selectItems(list, from.value, to.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    public void selectItems(JList list, int start, int end) {
        JListDriver.validateIndicesAndClearSelection(list, start, end);
        this.selectItem(list, start);
        this.robot.pressKey(16);
        try {
            this.clickItem(list, end, MouseButton.LEFT_BUTTON, 1);
        }
        finally {
            this.robot.releaseKey(16);
        }
    }

    @RunsInEDT
    private static void validateIndicesAndClearSelection(final JList list, final int ... indices) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JListItemIndexValidator.validateIndices(list, indices);
                list.clearSelection();
            }
        });
    }

    @RunsInEDT
    public void selectItem(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, index);
        this.robot.waitForIdle();
        if (cellCenter == null) {
            return;
        }
        this.robot.click((Component)list, cellCenter);
    }

    @RunsInEDT
    public void clickItem(JList list, int index, MouseButton button, int times) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        this.robot.click(list, cellCenter, button, times);
    }

    @RunsInEDT
    public void requireSelection(JList list, String value) {
        String selection = this.requiredSelection(list);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(JList list, Pattern pattern) {
        String selection = this.requiredSelection(list);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list)).matches(pattern);
    }

    private String requiredSelection(JList list) {
        Object selection = JListSelectionValueQuery.singleSelectionValue(list, this.cellReader);
        if (JListSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            this.failNoSelection(list);
        }
        return (String)selection;
    }

    @RunsInEDT
    public void requireSelection(JList list, int index) {
        int selectedIndex = JListSelectedIndexQuery.selectedIndexOf(list);
        if (selectedIndex == -1) {
            this.failNoSelection(list);
        }
        Assertions.assertThat((int)selectedIndex).as(this.selectedIndexProperty(list)).isEqualTo(index);
    }

    @RunsInEDT
    public String[] selectionOf(JList list) {
        List<String> selection = JListSelectionValuesQuery.selectionValues(list, this.cellReader);
        return selection.toArray(new String[selection.size()]);
    }

    @RunsInEDT
    public void requireSelectedItems(JList list, String ... items) {
        this.requireSelectedItems(list, new StringTextMatcher(items));
    }

    @RunsInEDT
    public void requireSelectedItems(JList list, Pattern ... patterns) {
        this.requireSelectedItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void requireSelectedItems(JList list, TextMatcher matcher) {
        List<String> matchingValues = JListMatchingItemQuery.matchingItemValues(list, matcher, this.cellReader);
        Assertions.assertThat(JListSelectionValuesQuery.selectionValues(list, this.cellReader)).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY)).isEqualTo(matchingValues);
    }

    @RunsInEDT
    public void requireSelectedItems(JList list, int ... indices) {
        this.validateArrayOfIndices(indices);
        java.util.Arrays.sort(indices);
        Assertions.assertThat((int[])JListSelectionIndicesQuery.selectedIndices(list)).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY)).isEqualTo(indices);
    }

    private void validateArrayOfIndices(int[] indices) {
        if (indices == null) {
            throw new NullPointerException("The array of indices should not be null");
        }
        if (Arrays.isEmptyIntArray(indices)) {
            throw new IllegalArgumentException("The array of indices should not be empty");
        }
    }

    @RunsInEDT
    public void requireNoSelection(JList list) {
        Assertions.assertThat((int)JListSelectedIndexQuery.selectedIndexOf(list)).as(this.selectedIndexProperty(list)).isEqualTo(-1);
    }

    @RunsInEDT
    private void failNoSelection(JList list) {
        Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(list).value(), "] No selection"}));
    }

    @RunsInEDT
    private Description selectedIndexProperty(JList list) {
        return JListDriver.propertyName(list, SELECTED_INDEX_PROPERTY);
    }

    @RunsInEDT
    public void drag(JList list, String value) {
        this.drag(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void drag(JList list, Pattern pattern) {
        this.drag(list, new PatternTextMatcher(pattern));
    }

    private void drag(JList list, TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader);
        this.robot.waitForIdle();
        this.verify(list, scrollInfo, matcher);
        super.drag(list, this.cellCenterIn(scrollInfo));
    }

    @RunsInEDT
    public void drop(JList list, String value) {
        this.drop(list, new StringTextMatcher(value));
    }

    public void drop(JList list, Pattern pattern) {
        this.drop(list, new PatternTextMatcher(pattern));
    }

    private void drop(JList list, TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader);
        this.robot.waitForIdle();
        this.verify(list, scrollInfo, matcher);
        super.drop(list, this.cellCenterIn(scrollInfo));
    }

    private void verify(JList list, Pair<Integer, Point> scrollInfo, TextMatcher matcher) {
        if (JListScrollToItemTask.ITEM_NOT_FOUND.equals(scrollInfo)) {
            throw this.failMatchingNotFound(list, matcher);
        }
    }

    @RunsInEDT
    public void drag(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drag(list, cellCenter);
    }

    @RunsInEDT
    public void drop(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drop(list, cellCenter);
    }

    @RunsInEDT
    public void drop(JList list) {
        JListDriver.assertIsEnabledAndShowing(list);
        super.drop(list, AWT.visibleCenterOf(list));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JList list, String value) {
        return this.showPopupMenu(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JList list, Pattern pattern) {
        return this.showPopupMenu(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private JPopupMenu showPopupMenu(JList list, TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader);
        this.robot.waitForIdle();
        this.verify(list, scrollInfo, matcher);
        return this.robot.showPopupMenu(list, this.cellCenterIn(scrollInfo));
    }

    private Point cellCenterIn(Pair<Integer, Point> scrollInfo) {
        return (Point)scrollInfo.ii;
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        return this.robot.showPopupMenu(list, cellCenter);
    }

    @RunsInEDT
    public Point pointAt(JList list, String value) {
        return JListMatchingItemQuery.centerOfMatchingItemCell(list, value, this.cellReader);
    }

    @RunsInEDT
    public int indexOf(JList list, String value) {
        return this.indexOf(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public int indexOf(JList list, Pattern pattern) {
        return this.indexOf(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private int indexOf(JList list, TextMatcher matcher) {
        int index = JListDriver.itemIndex(list, matcher, this.cellReader);
        if (index >= 0) {
            return index;
        }
        throw this.failMatchingNotFound(list, matcher);
    }

    @RunsInEDT
    private static int itemIndex(final JList list, final TextMatcher matcher, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                return JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
            }
        });
    }

    private LocationUnavailableException failMatchingNotFound(JList list, TextMatcher matcher) {
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find item matching the ", matcher.description(), " ", matcher.formattedValues(), " among the JList contents ", org.fest.util.Arrays.format((Object)JListContentQuery.contents(list, this.cellReader))}));
    }

    @RunsInEDT
    public String value(JList list, int index) {
        return JListItemValueQuery.itemValue(list, index, this.cellReader);
    }

    public void cellReader(JListCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }

    @RunsInEDT
    public void requireItemCount(JList list, int expected) {
        int actual = JListItemCountQuery.itemCountIn(list);
        Assertions.assertThat((int)actual).as(JListDriver.propertyName(list, "itemCount")).isEqualTo(expected);
    }
}

