/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.util.ArrayList;
import jnlp.sample.servlet.XMLAttribute;
import jnlp.sample.servlet.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLParsing {
    public static XMLNode convert(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            return new XMLNode(text.getNodeValue());
        }
        if (node instanceof Element) {
            Object object;
            Element element = (Element)node;
            XMLAttribute xMLAttribute = null;
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                object = (Attr)namedNodeMap.item(i);
                xMLAttribute = new XMLAttribute(object.getName(), object.getValue(), xMLAttribute);
            }
            XMLNode xMLNode = new XMLNode(element.getNodeName(), xMLAttribute, null, null);
            object = null;
            for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (xMLNode.getNested() == null) {
                    object = XMLParsing.convert(node2);
                    xMLNode.setNested((XMLNode)object);
                } else {
                    XMLNode xMLNode2 = XMLParsing.convert(node2);
                    ((XMLNode)object).setNext(xMLNode2);
                    object = xMLNode2;
                }
                ((XMLNode)object).setParent(xMLNode);
            }
            return xMLNode;
        }
        return null;
    }

    public static boolean isElementPath(XMLNode xMLNode, String string) {
        return XMLParsing.findElementPath(xMLNode, string) != null;
    }

    public static String getPathString(XMLNode xMLNode) {
        return xMLNode == null || !xMLNode.isElement() ? "" : XMLParsing.getPathString(xMLNode.getParent()) + "<" + xMLNode.getName() + ">";
    }

    public static String getElementContent(XMLNode xMLNode, String string) {
        return XMLParsing.getElementContent(xMLNode, string, null);
    }

    public static String[] getMultiElementContent(XMLNode xMLNode, String string) {
        final ArrayList arrayList = new ArrayList();
        XMLParsing.visitElements(xMLNode, string, new ElementVisitor(){

            public void visitElement(XMLNode xMLNode) {
                String string = XMLParsing.getElementContent(xMLNode, "");
                if (string != null) {
                    arrayList.add(string);
                }
            }
        });
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getElementContent(XMLNode xMLNode, String string, String string2) {
        XMLNode xMLNode2 = XMLParsing.findElementPath(xMLNode, string);
        if (xMLNode2 == null) {
            return string2;
        }
        XMLNode xMLNode3 = xMLNode2.getNested();
        if (xMLNode3 != null && !xMLNode3.isElement()) {
            return xMLNode3.getName();
        }
        return string2;
    }

    public static XMLNode findElementPath(XMLNode xMLNode, String string) {
        if (xMLNode == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return xMLNode;
        }
        int n = string.indexOf(62);
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        return XMLParsing.findElementPath(XMLParsing.findChildElement(xMLNode, string2), string3);
    }

    public static XMLNode findChildElement(XMLNode xMLNode, String string) {
        for (XMLNode xMLNode2 = xMLNode.getNested(); xMLNode2 != null; xMLNode2 = xMLNode2.getNext()) {
            if (!xMLNode2.isElement() || !xMLNode2.getName().equals(string)) continue;
            return xMLNode2;
        }
        return null;
    }

    public static void visitElements(XMLNode xMLNode, String string, ElementVisitor elementVisitor) {
        int n = string.lastIndexOf(60);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        XMLNode xMLNode2 = XMLParsing.findElementPath(xMLNode, string2);
        if (xMLNode2 == null) {
            return;
        }
        for (XMLNode xMLNode3 = xMLNode2.getNested(); xMLNode3 != null; xMLNode3 = xMLNode3.getNext()) {
            if (!xMLNode3.isElement() || !xMLNode3.getName().equals(string3)) continue;
            elementVisitor.visitElement(xMLNode3);
        }
    }

    public static void visitChildrenElements(XMLNode xMLNode, ElementVisitor elementVisitor) {
        for (XMLNode xMLNode2 = xMLNode.getNested(); xMLNode2 != null; xMLNode2 = xMLNode2.getNext()) {
            if (!xMLNode2.isElement()) continue;
            elementVisitor.visitElement(xMLNode2);
        }
    }

    public static abstract class ElementVisitor {
        public abstract void visitElement(XMLNode var1);
    }
}

