# Print GStreamer decoders required by given package.
# USAGE: dependencies_gstreamer_list $package
dependencies_gstreamer_list() {
	local package
	package="$1"

	local dependencies_gstreamer
	dependencies_gstreamer=$(context_value "${package}_DEPENDENCIES_GSTREAMER_PLUGINS")

	# Fall back on default dependencies list for current game engine.
	if [ -z "$dependencies_gstreamer" ]; then
		local game_engine
		game_engine=$(game_engine)
		case "$game_engine" in
			('unrealengine4')
				dependencies_gstreamer=$(dependencies_gstreamer_list_unrealengine4 "$package")
			;;
		esac
	fi

	printf '%s' "$dependencies_gstreamer" | list_clean
}

# Print native packages providing GStreamer decoders required by given package.
# USAGE: dependencies_gstreamer_list_packages $package
dependencies_gstreamer_list_packages() {
	local package
	package="$1"

	local dependencies_gstreamer
	dependencies_gstreamer=$(dependencies_gstreamer_list "$package")
	# Return early if current package does not require any GStreamer decoder.
	if [ -z "$dependencies_gstreamer" ]; then
		return 0
	fi

	local option_package dependencies_packages
	option_package=$(option_value 'package')
	case "$option_package" in
		('arch')
			dependencies_packages=$(
				set_current_package "$package"
				dependencies_gstreamer_list_archlinux "$dependencies_gstreamer"
			)
		;;
		('deb')
			dependencies_packages=$(dependencies_gstreamer_list_debian "$dependencies_gstreamer")
		;;
		('gentoo')
			dependencies_packages=$(
				set_current_package "$package"
				dependencies_gstreamer_list_gentoo "$dependencies_gstreamer"
			)
		;;
	esac

	printf '%s' "$dependencies_packages" | list_clean
}

# Print the path to a temporary files used for unknown GStreamer media formats listing
# USAGE: dependencies_unknown_gstreamer_media_formats_file
dependencies_unknown_gstreamer_media_formats_file() {
	printf '%s/unknown_gstreamer_media_formats_list' "$PLAYIT_WORKDIR"
}

# Print a list of unknown GStreamer media formats
# USAGE: dependencies_unknown_gstreamer_media_formats_list
dependencies_unknown_gstreamer_media_formats_list() {
	local unknown_formats_list
	unknown_formats_list=$(dependencies_unknown_gstreamer_media_formats_file)

	# Return early if there is no unknown library
	if [ ! -e "$unknown_formats_list" ]; then
		return 0
	fi

	list_clean < "$unknown_formats_list"
}

# Clear the list of unknown GStreamer media formats
# USAGE: dependencies_unknown_gstreamer_media_formats_clear
dependencies_unknown_gstreamer_media_formats_clear() {
	local unknown_formats_list
	unknown_formats_list=$(dependencies_unknown_gstreamer_media_formats_file)

	rm --force "$unknown_formats_list"
}

# Add a GStreamer media format to the list of unknown ones
# USAGE: dependencies_unknown_gstreamer_media_formats_add $unknown_format
dependencies_unknown_gstreamer_media_formats_add() {
	local unknown_format unknown_formats_list
	unknown_format="$1"
	unknown_formats_list=$(dependencies_unknown_gstreamer_media_formats_file)

	# Do nothing if this format is already included in the list
	if
		[ -e "$unknown_formats_list" ] &&
		grep --quiet --fixed-strings --word-regexp "$unknown_format" "$unknown_formats_list"
	then
		return 0
	fi

	printf '%s\n' "$unknown_format" >> "$unknown_formats_list"
}
