import os
import subprocess
import unittest


PYFLAKES_BLACKLIST=[
    "DistUpgradeConfigParser.py"
    ]


class TestPyflakesClean(unittest.TestCase):
    """ ensure that the tree is pyflakes clean """

    def test_pyflakes_clean(self):
        basepath = os.path.join(os.path.dirname(__file__), "..")
        for path, dirnames, filenames in os.walk(basepath):
            for name in filenames:
                if name.endswith(".py") and not name in PYFLAKES_BLACKLIST:
                    pyfile = os.path.join(path, name)
                    self.assertEqual(subprocess.call(["pyflakes",  pyfile]), 0)



if __name__ == "__main__":
    unittest.main()
