//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/SampleEditorCommands.h
//! @brief     Defines command classes for LayerOrientedSampleEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLEEDITORCOMMANDS_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLEEDITORCOMMANDS_H

#include <QUndoCommand>

class SampleEditorController;
class LayerItem;

//! Command to change a double value
class CommandChangeValue : public QUndoCommand {
public:
    CommandChangeValue(const QString& label, SampleEditorController* ec, double oldValue,
                       double newValue, const QString& path, QUndoCommand* parent = nullptr);

    int id() const override;
    bool mergeWith(const QUndoCommand* command) override;

    void redo() override;
    void undo() override;

private:
    SampleEditorController* m_ec;
    double m_oldValue;
    double m_newValue;
    QString m_path;
    bool m_isFirst = true;
};

//! Command to add a layer to a sample
class CommandAddLayer : public QUndoCommand {
public:
    CommandAddLayer(SampleEditorController* ec, int atIndex, QUndoCommand* parent = nullptr);

    void redo() override;
    void undo() override;

private:
    SampleEditorController* m_ec;
    int m_atIndex;
};

//! Command to remove a layer from a sample
class CommandRemoveLayer : public QUndoCommand {
public:
    CommandRemoveLayer(SampleEditorController* ec, LayerItem* layerItem,
                       QUndoCommand* parent = nullptr);

    void redo() override;
    void undo() override;

private:
    SampleEditorController* m_ec;
    QByteArray m_layerItemBackup;
    int m_indexOfLayer;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLEEDITORCOMMANDS_H
