MACRO(MD5SUM expected filename)
  EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E md5sum ${filename}
    OUTPUT_VARIABLE md5)
  IF (NOT md5 MATCHES ${expected})
    MESSAGE(FATAL_ERROR "unexpected md5sum: " ${md5})
  ENDIF()
ENDMACRO()
MACRO(EXECUTE_PROGRAM)
  EXECUTE_PROCESS(COMMAND ${ARGV} RESULT_VARIABLE res)
  IF (res)
    MESSAGE(FATAL_ERROR "${ARGV} failed: " ${res})
  ENDIF()
ENDMACRO()
MACRO(EXECUTE_PROGRAM_EXPECT expect_res)
  EXECUTE_PROCESS(COMMAND ${ARGN} RESULT_VARIABLE res)
  IF (NOT res EQUAL ${expect_res})
    MESSAGE(FATAL_ERROR "${ARGN} failed: " ${res})
  ENDIF()
ENDMACRO()
MACRO(CBMCONVERT)
  EXECUTE_PROGRAM(${CBMCONVERT} ${ARGV})
ENDMACRO()

FILE(REMOVE 123.d64 123.d71 123.d81 123.lnx 123.c2n 5.d64 5.lnx 5.l7f 5.rel)
FILE(WRITE 1,S "1")
FILE(WRITE 2,U "12")
FILE(WRITE 3,D "123")
FOREACH(i RANGE 1 254)
  LIST(APPEND b ${i})
ENDFOREACH()
LIST(REMOVE_ITEM b 59)
STRING(ASCII ${b} b)
FILE(WRITE 4,P "${b};")
FILE(WRITE 5.l7F "${b}:")

CBMCONVERT(-D4 123.d64 1,S 2,U 3,D 4,P 5.l7F)
MD5SUM(f068fc93ce11c33ba3dbc273b151a83e 123.d64)

EXECUTE_PROGRAM_EXPECT(1 ${CBMCONVERT} -D 123.d64 5.l7F)
CBMCONVERT(-D4o 123.d64 5.l7F)
MD5SUM(f068fc93ce11c33ba3dbc273b151a83e 123.d64)
CBMCONVERT(-L 123.lnx -d 123.d64)
MD5SUM(0b8f4594e8dd8677934882d2456422b0 123.lnx)
CBMCONVERT(-vv -C 123.c2n -d 123.d64)
MD5SUM(b0170b67e12cbc190049e1da61718521 123.c2n)

EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 123.d64 -c 123.c2n)
MD5SUM(f068fc93ce11c33ba3dbc273b151a83e 123.d64)
FILE(REMOVE 123.lnx 123.d64)
CBMCONVERT(-L 123.lnx -c 123.c2n)
MD5SUM(a8bc8ccd4608261c72bd56d455ad7235 123.lnx)
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -C 123.c2n -p 123.lnx)
FILE(REMOVE 123.c2n 123.lnx)

FILE(RENAME 1,S 1,s)
FILE(RENAME 2,U 2,u)
FILE(RENAME 3,D 3,d)
FILE(RENAME 4,P 4,p)
FILE(RENAME 5.l7F 5.l7f)
CBMCONVERT(-L 123.lnx -n 1,s 2,u 3,d 4,p 5.l7f)
MD5SUM(0b8f4594e8dd8677934882d2456422b0 123.lnx)
CBMCONVERT(-D4o 123.d64 -l 123.lnx)
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 123.d64 -l 123.lnx)
MD5SUM(f068fc93ce11c33ba3dbc273b151a83e 123.d64)
CBMCONVERT(-D4o 123.d64 5.l7f)
MD5SUM(f068fc93ce11c33ba3dbc273b151a83e 123.d64)

CBMCONVERT(-P -l 123.lnx)
MD5SUM(ca80b5d5492283789cb53c1868783b83 1.s00)
MD5SUM(2abfea98086627c448530dae6f19970f 2.u00)
MD5SUM(ac1246d517a9d6db969185fe60746900 3.d00)
MD5SUM(95b1642dcb7ff9761d0e8924c5a52c37 4.p00)
MD5SUM(ed5d3175a2f116893991f8d25604d2b0 5.r00)

EXECUTE_PROGRAM(${DISK2ZIP} 123.d64 123)
MD5SUM(0c66b6561fb968faeb751eb94a68098b 1!123)
MD5SUM(ef4bae7508940492d5452b4f13965cab 2!123)
MD5SUM(c23f22ebdf4b51136abb86818f180333 3!123)
MD5SUM(0cae9f355cf09bc153272c4b8d2b97cd 4!123)
EXECUTE_PROGRAM(${ZIP2DISK} 123 4.d64)
EXECUTE_PROGRAM(${CMAKE_COMMAND} -E compare_files 123.d64 4.d64)
EXECUTE_PROGRAM_EXPECT(3 ${CBMCONVERT} -i0 -D4 123.d64 4.d64)
EXECUTE_PROGRAM_EXPECT(3 ${CBMCONVERT} -i1 -D4 123.d64 4.d64)
EXECUTE_PROGRAM_EXPECT(3 ${CBMCONVERT} -i2 -D4 123.d64 4.d64)
MD5SUM(274f94a63ada0913cf717677e536cdf9 124.d64)
FILE(REMOVE 124.d64)
EXECUTE_PROGRAM(${CMAKE_COMMAND} -E compare_files 123.d64 4.d64)
EXECUTE_PROGRAM_EXPECT(1 ${CBMCONVERT} -D4 123.d64 -i-)
EXECUTE_PROGRAM_EXPECT(1 ${CBMCONVERT} -L 4.lnx -i)

FILE(REMOVE 123.d64)
CBMCONVERT(-p -D4o 123.d64 1.s00 2.u00 3.d00 4.p00 5.r00)
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT}
  -p -D4 123.d64 1.s00 2.u00 3.d00 4.p00 5.r00)
CBMCONVERT(-D4o 123.d64 -n 5.l7f)
EXECUTE_PROGRAM(${CMAKE_COMMAND} -E compare_files 123.d64 4.d64)
CBMCONVERT(-D7 123.d71 -d 123.d64)
MD5SUM(04c5320430d7d4747a1b95c824cb4943 123.d71)
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D8 123.d81 -d 123.d71)
MD5SUM(6ebe65648231d6d170faf073de4dd90c 123.d81)
FILE(REMOVE 123.d81)
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D8 123.d81 -d 123.d64)
MD5SUM(6ebe65648231d6d170faf073de4dd90c 123.d81)
FILE(REMOVE 123.d81 123.d64)
CBMCONVERT(-D4 123.d64 -d 123.d71)
FILE(REMOVE 123.d71 123.d81)
EXECUTE_PROGRAM(${CMAKE_COMMAND} -E compare_files 123.d64 4.d64)

FILE(RENAME 5.l7f 5.lFF)
CBMCONVERT(-P 5.lFF)
MD5SUM(5efaffddcbebb247092bd9b4b11dde78 5_lff.p00)
FILE(RENAME 5.lFF 5,f)
CBMCONVERT(-P 5,f)
MD5SUM(8a757d89cb216af47a66a6a8632fa5ed 5_f.p00)
FILE(RENAME 5,f 5.rel)
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 123.d64 5.rel)

FILE(REMOVE 1,s 2,u 3,d 4,p 5_lff.p00 5_f.p00
  1.s00 2.u00 3.d00 4.p00 5.r00 123.lnx 123.d64 4.d64
  1!123 2!123 3!123 4!123)

FILE(RENAME 5.rel 5.l7f)

FILE(APPEND 5.l7f "${b}:${b}:${b}:${b}:${b}:${b}:${b}")
FILE(READ 5.l7f b8)
FILE(APPEND 5.l7f "${b8}:${b8}:${b8}:${b8}:${b8}:${b8}:${b8}")
FILE(READ 5.l7f b8)
FILE(APPEND 5.l7f "${b8}:${b8}:${b8}:${b8}:${b8}:${b8}:${b8}:${b8}:${b8}")
CBMCONVERT(-L 5.lnx 5.l7f)
MD5SUM(3a72dcc312183124d05987ddd8b28205 5.lnx)
CBMCONVERT(-D4 5.d64 5.l7f)
MD5SUM(4e8315ba00cecef6883a1ed58cc66911 5.d64)
FILE(RENAME 5.l7f 5.rel)
CBMCONVERT(-I -l 5.lnx)
EXECUTE_PROGRAM(${CMAKE_COMMAND} -E compare_files 5.l7F 5.rel)
FILE(REMOVE 5.l7F)
CBMCONVERT(-d 5.d64)
EXECUTE_PROGRAM(${CMAKE_COMMAND} -E compare_files 5.l7F 5.rel)
FILE(REMOVE 5.l7F 5.rel 5.lnx 5.d64)

STRING(ASCII 1 1 1 1 129 1 t)
FILE(WRITE 1!foo "${t}")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
FILE(APPEND 1!foo "1")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
FILE(APPEND 1!foo "2")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
FILE(APPEND 1!foo "2")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
STRING(ASCII 1 1 1 1 129 1 1 1 1 t)
FILE(WRITE 1!foo "${t}")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
STRING(ASCII 1 1 1 1 129 1 100 1 1 255 2 3 4 t)
FILE(WRITE 1!foo "${t}")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
STRING(ASCII 1 1 1 1 129 1 2 3 4 5 t)
FILE(WRITE 1!foo "${t}")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
STRING(ASCII 1 1 1 1 65 1 t)
FILE(WRITE 1!foo "${t}")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
STRING(ASCII 1 1 1 1 1 1 t)
FILE(WRITE 1!foo "${t}")
EXECUTE_PROGRAM_EXPECT(4 ${ZIP2DISK} foo foo.d64)
FILE(REMOVE 1!foo foo.d64)

STRING(ASCII 1 2 1 2 1 r)
STRING(RANDOM LENGTH 187 r2)
FILE(WRITE foo.c2n "${r}${r2}")
STRING(ASCII 4 2 1 2 1 s)
FILE(APPEND foo.c2n "${s}${r2}")
STRING(ASCII 2 t)
STRING(ASCII 5 v)
STRING(ASCII 6 w)
STRING(RANDOM LENGTH 191 u)
FILE(APPEND foo.c2n "${t}${u}${v}${u}${w}${u}")
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 foo.d64 -c foo.c2n)
FILE(WRITE foo.c2n "${u}")
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 foo.d64 -c foo.c2n)
FILE(WRITE foo.c2n "${s}${s2}")
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 foo.d64 -c foo.c2n)
FILE(APPEND foo.c2n "${t}truncated")
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 foo.d64 -c foo.c2n)
STRING(ASCII 1 1 4 2 4 x)
FILE(WRITE foo.c2n "${x}${r2}")
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -D4 foo.d64 -c foo.c2n)
FILE(REMOVE foo.c2n foo.d64)
