struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 906,
		.content = "processor\t: 0\n"
			   "model name\t: AArch64 Processor rev 2 (aarch64)\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x1\n"
			   "CPU part\t: 0x211\n"
			   "CPU revision\t: 2\n"
			   "\n"
			   "processor\t: 1\n"
			   "model name\t: AArch64 Processor rev 2 (aarch64)\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x1\n"
			   "CPU part\t: 0x211\n"
			   "CPU revision\t: 2\n"
			   "\n"
			   "processor\t: 2\n"
			   "model name\t: AArch64 Processor rev 2 (aarch64)\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x1\n"
			   "CPU part\t: 0x205\n"
			   "CPU revision\t: 2\n"
			   "\n"
			   "processor\t: 3\n"
			   "model name\t: AArch64 Processor rev 2 (aarch64)\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x1\n"
			   "CPU part\t: 0x205\n"
			   "CPU revision\t: 2\n"
			   "\n"
			   "Hardware\t: Qualcomm Technologies, Inc MSM8996\n"
			   "Revision\t: 000f\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 1137,
		.content =
			"processor\t: 0\n"
			"model name\t: AArch64 Processor rev 2 (aarch64)\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x51\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x1\n"
			"CPU part\t: 0x211\n"
			"CPU revision\t: 2\n"
			"\n"
			"processor\t: 1\n"
			"model name\t: AArch64 Processor rev 2 (aarch64)\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x51\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x1\n"
			"CPU part\t: 0x211\n"
			"CPU revision\t: 2\n"
			"\n"
			"processor\t: 2\n"
			"model name\t: AArch64 Processor rev 2 (aarch64)\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x51\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x1\n"
			"CPU part\t: 0x205\n"
			"CPU revision\t: 2\n"
			"\n"
			"processor\t: 3\n"
			"model name\t: AArch64 Processor rev 2 (aarch64)\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x51\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x1\n"
			"CPU part\t: 0x205\n"
			"CPU revision\t: 2\n"
			"\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8996\n"
			"Revision\t: 000f",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 9222,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=MMB29M\n"
			"ro.build.display.id=MMB29M.G930AUCS4APK1\n"
			"ro.build.version.incremental=G930AUCS4APK1\n"
			"ro.build.version.sdk=23\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=6.0.1\n"
			"ro.build.version.security_patch=2016-11-01\n"
			"ro.build.version.base_os=samsung/heroqlteuc/heroqlteatt:6.0.1/MMB29M/G930AUCU4APJ4:user/release-keys\n"
			"ro.build.date=Tue Nov  8 11:46:56 KST 2016\n"
			"ro.build.date.utc=1478573216\n"
			"ro.build.type=user\n"
			"ro.build.user=dpi\n"
			"ro.build.host=SWHC3505\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=heroqlteuc-user\n"
			"ro.product.model=SAMSUNG-SM-G930A\n"
			"ro.product.brand=samsung\n"
			"ro.product.name=heroqlteuc\n"
			"ro.product.device=heroqlteatt\n"
			"ro.product.board=msm8996\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=samsung\n"
			"ro.product.locale=en-US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8996\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=heroqlteatt\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=heroqlteuc-user 6.0.1 MMB29M G930AUCS4APK1 release-keys\n"
			"ro.build.fingerprint=samsung/heroqlteuc/heroqlteatt:6.0.1/MMB29M/G930AUCS4APK1:user/release-keys\n"
			"ro.build.characteristics=att\n"
			"# Samsung Specific Properties\n"
			"ro.build.PDA=G930AUCS4APK1\n"
			"ro.build.hidden_ver=G930AUCS4APK1\n"
			"ro.config.rm_preload_enabled=0\n"
			"ro.build.changelist=9439621\n"
			"ro.product_ship=true\n"
			"ro.build.official.release=true\n"
			"ro.chipname=MSM8996\n"
			"# end build properties\n"
			"\n"
			"#\n"
			"# HWUI_BUILD_PROPERTIES\n"
			"#\n"
			"ro.hwui.texture_cache_size=88\n"
			"ro.hwui.layer_cache_size=58\n"
			"ro.hwui.path_cache_size=16\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.shape_cache_size=4\n"
			"ro.hwui.gradient_cache_size=2\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=4096\n"
			"ro.hwui.text_large_cache_height=2048\n"
			"ro.hwui.fbo_cache_size=16\n"
			"#\n"
			"# from device/samsung/heroqlteatt/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for msm8996\n"
			"#\n"
			"\n"
			"ro.sf.lcd_density=640\n"
			"\n"
			"debug.sf.hw=1\n"
			"debug.egl.hw=1\n"
			"debug.gralloc.enable_fb_ubwc=1\n"
			"dalvik.vm.heapsize=36m\n"
			"dev.pm.dyn_samplingrate=1\n"
			"persist.demo.hdmirotationlock=false\n"
			"\n"
			"#ro.hdmi.enable=true\n"
			"#persist.speaker.prot.enable=false\n"
			"qcom.hw.aac.encoder=true\n"
			"\n"
			"#system props for the MM modules\n"
			"media.stagefright.enable-player=true\n"
			"media.stagefright.enable-http=true\n"
			"media.stagefright.enable-aac=true\n"
			"media.stagefright.enable-qcp=true\n"
			"media.stagefright.enable-fma2dp=true\n"
			"media.stagefright.enable-scan=true\n"
			"mmp.enable.3g2=true\n"
			"media.aac_51_output_enabled=true\n"
			"mm.enable.smoothstreaming=true\n"
			"#3314291: Decimal sum after adding FLAC parser flag 131072\n"
			"#37491 is decimal sum of supported codecs in AAL\n"
			"#codecs: DivX DivXHD AVI AC3 ASF AAC QCP DTS 3G2 MP2TS\n"
			"mm.enable.qcom_parser=3314291\n"
			"persist.mm.enable.prefetch=true\n"
			"\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"#ro.use_data_netmgrd=true\n"
			"#persist.data.netmgrd.qos.enable=true\n"
			"#persist.data.mode=concurrent\n"
			"persist.data.dpm.enable=true\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"#\n"
			"# 196608 is decimal for 0x30000 to report version 3\n"
			"ro.opengles.version=196609\n"
			"\n"
			"# system property for maximum number of HFP client connections\n"
			"#bt.max.hfpclient.connections=1\n"
			"\n"
			"# System property for cabl\n"
			"ro.qualcomm.cabl=1\n"
			"\n"
			"#Simulate sdcard on /data/media\n"
			"#\n"
			"persist.fuse_sdcard=true\n"
			"\n"
			"#system prop for Bluetooth SOC type\n"
			"#qcom.bluetooth.soc=rome\n"
			"\n"
			"#system prop for A4WP profile support\n"
			"#ro.bluetooth.a4wp=true\n"
			"\n"
			"#system prop for wipower support\n"
			"#ro.bluetooth.wipower=true\n"
			"\n"
			"#Set this true as ROME which is programmed\n"
			"#as embedded wipower mode by deafult\n"
			"#ro.bluetooth.emb_wp_mode=true\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"\n"
			"##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			"ro.qc.sdk.audio.fluencetype=none\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.voicerec=false\n"
			"persist.audio.fluence.speaker=true\n"
			"\n"
			"#system prop for RmNet Data\n"
			"persist.rmnet.data.enable=true\n"
			"persist.data.wda.enable=true\n"
			"persist.data.df.dl_mode=5\n"
			"persist.data.df.ul_mode=5\n"
			"persist.data.df.agg.dl_pkt=10\n"
			"persist.data.df.agg.dl_size=4096\n"
			"persist.data.df.mux_count=8\n"
			"persist.data.df.iwlan_mux=9\n"
			"persist.data.df.dev_name=rmnet_usb0\n"
			"\n"
			"#property to enable user to access Google WFD settings\n"
			"persist.debug.wfd.enable=1\n"
			"##property to choose between virtual/external wfd display\n"
			"persist.sys.wfd.virtual=0\n"
			"\n"
			"#property to enable sde downscale feature for external display\n"
			"#sdm.debug.downscale_external=1\n"
			"\n"
			"#property to specify the number of frames to skip before setting hint\n"
			"sdm.perf_hint_window=50\n"
			"\n"
			"#disable tunnel encoding\n"
			"tunnel.audio.encode=false\n"
			"\n"
			"#disable gapless by default\n"
			"audio.offload.gapless.enabled=false\n"
			"\n"
			"#Buffer size in kbytes for compress offload playback\n"
			"audio.offload.buffer.size.kb=32\n"
			"\n"
			"#Enable offload audio video playback by default\n"
			"av.offload.enable=true\n"
			"\n"
			"#Enable 16 bit PCM offload by default\n"
			"audio.offload.pcm.16bit.enable=true\n"
			"\n"
			"#Enable 24 bit PCM offload by default\n"
			"audio.offload.pcm.24bit.enable=true\n"
			"\n"
			"#Enable audio track offload by default\n"
			"audio.offload.track.enabled=true\n"
			"\n"
			"#enable voice path for PCM VoIP by default\n"
			"use.voice.path.for.pcm.voip=true\n"
			"\n"
			"# system prop for NFC DT\n"
			"ro.nfc.port=I2C\n"
			"\n"
			"#hwui properties\n"
			"ro.hwui.texture_cache_size=72\n"
			"ro.hwui.layer_cache_size=48\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.hwui.path_cache_size=32\n"
			"ro.hwui.gradient_cache_size=1\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"\n"
			"#enable voice path for PCM VoIP by default\n"
			"use.voice.path.for.pcm.voip=true\n"
			"\n"
			"#Disable property for Dolby ds2\n"
			"audio.dolby.ds2.enabled=false\n"
			"\n"
			"#Disable property for hard bypass\n"
			"audio.dolby.ds2.hardbypass=false\n"
			"\n"
			"audio.offload.passthrough=false\n"
			"audio.offload.multiple.enabled=false\n"
			"\n"
			"# enable navigation bar\n"
			"qemu.hw.mainkeys=1\n"
			"\n"
			"#property to enable VDS WFD solution\n"
			"persist.hwc.enable_vds=1\n"
			"\n"
			"#Enable stm events\n"
			"#Samsung Disable this because of too poor performance when it enabled.\n"
			"ro.dbg.coresight.config=stm_events_disabled\n"
			"#property to enable fingerprint\n"
			"persist.qfp=false\n"
			"\n"
			"#Set SSC Debug Level on AP Side\n"
			"persist.debug.sensors.hal=W\n"
			"debug.qualcomm.sns.daemon=I\n"
			"debug.qualcomm.sns.libsensor1=I\n"
			"\n"
			"#Disable Sensor Feature\n"
			"ro.qti.sensors.georv=false\n"
			"ro.qti.sensors.cmc=false\n"
			"ro.qti.sensors.dpc=false\n"
			"ro.qti.sensors.facing=false\n"
			"ro.qti.sensors.fast_amd=false\n"
			"ro.qti.sensors.scrn_ortn=false\n"
			"\n"
			"#Disable rotator split feature\n"
			"sdm.debug.disable_rotator_split=1\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.astcenc.astcsupport=1\n"
			"ro.mct.compressiontype=ETC1\n"
			"ro.config.dmverity=true\n"
			"ro.config.kap_default_on=true\n"
			"ro.config.kap=true\n"
			"ro.use_data_netmgrd=true\n"
			"persist.radio.sib16_support=0\n"
			"ro.telephony.default_network=9\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"keyguard.no_require_sim=true\n"
			"ro.carrier=unknown\n"
			"ro.security.icd.flagmode=multi\n"
			"security.ASKS.policy_version=000000\n"
			"ro.vendor.extension_library=libqti-perfd-client.so\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"persist.radio.custom_ecc=1\n"
			"af.fast_track_multiplier=1\n"
			"audio_hal.period_size=192\n"
			"camera.disable_zsl_mode=1\n"
			"security.mdpp.mass=skmm\n"
			"ro.build.scafe.version=2016A\n"
			"ro.build.scafe.size=short\n"
			"ro.build.scafe.shot=single\n"
			"ro.build.scafe.cream=white\n"
			"ro.frp.pst=/dev/block/persistent\n"
			"ro.error.receiver.default=com.samsung.receiver.error\n"
			"ro.hdcp2.rx=tz\n"
			"ro.secwvk=144\n"
			"ro.securestorage.support=true\n"
			"security.mdpp=None\n"
			"ro.security.mdpp.ver=2.0\n"
			"ro.security.mdpp.release=7\n"
			"security.mdpp.result=None\n"
			"ro.hardware.keystore=mdfpp\n"
			"ro.hardware.gatekeeper=mdfpp\n"
			"ro.security.vpnpp.ver=1.4\n"
			"ro.security.vpnpp.release=6.1\n"
			"ro.sec.fle.encryption=true\n"
			"sys.config.bigdata_enable=true\n"
			"sys.config.bigdata_mem_enable=true\n"
			"ro.config.dha_cached_min=8\n"
			"ro.config.dha_cached_max=16\n"
			"ro.config.dha_empty_min=8\n"
			"ro.config.dha_empty_max=32\n"
			"ro.config.dha_th_rate=1.7\n"
			"ro.config.dha_pwhitelist_enable=1\n"
			"ro.config.ringtone=ATT_Firefly_Default.ogg\n"
			"ro.config.notification_sound=Whisper.ogg\n"
			"ro.config.alarm_alert=Morning_Flower.ogg\n"
			"ro.config.media_sound=Media_preview_Touch_the_light.ogg\n"
			"ro.config.ringtone_2=Basic_Bell.ogg\n"
			"ro.config.notification_sound_2=S_Charming_Bell.ogg\n"
			"ro.security.mdpp.ux=Enabled\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=6.0_r6\n"
			"ro.com.google.clientidbase=android-samsung\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.variant=kryo\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"ro.build.selinux=1\n"
			"ro.config.knox=v30\n"
			"ro.config.tima=1\n"
			"ro.config.timaversion=3.0\n"
			"ro.config.iccc_version=1.0\n"
			"ro.kernel.qemu=0\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"persist.gps.qc_nlp_in_use=1\n"
			"persist.loc.nlp_name=com.qualcomm.location\n"
			"ro.gps.agps_provider=1\n"
			"ro.build.version.sdl=2301\n"
			"ro.expect.recovery_id=0x1bf16698c3b2cca6006ec8c8426e001ecad484d7000000000000000000000000\n"
			"\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/bus_split",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/deep_nap_timer",
		.size = 4,
		.content = "20\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/default_pwrlevel",
		.size = 3,
		.content = "5\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/dev",
		.size = 7,
		.content = "236:0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies",
		.size = 71,
		.content = "133000000 214000000 315000000 401800000 510000000 560000000 624000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_governors",
		.size = 176,
		.content =
			"spdm_bw_hyp cache_hwmon mem_latency bw_hwmon msm-vidc-vmem+ msm-vidc-vmem msm-vidc-ddr bw_vbif gpubw_mon msm-adreno-tz cpufreq userspace powersave performance simple_ondemand\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/cur_freq",
		.size = 11,
		.content = "214000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/governor",
		.size = 15,
		.content = "msm-adreno-tz\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/max_freq",
		.size = 11,
		.content = "624000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/min_freq",
		.size = 11,
		.content = "133000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/polling_interval",
		.size = 4,
		.content = "10\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/target_freq",
		.size = 11,
		.content = "214000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/trans_stat",
		.size = 679,
		.content = "   From  :   To\r\n"
			   "         :624000000560000000510000000401800000315000000214000000133000000   time(ms)\r\n"
			   " 624000000:       0       1       0       0       0       0       0        90\r\n"
			   " 560000000:       0       0       1       0       0       0       0       230\r\n"
			   " 510000000:       0       0       0       1       0       0       0       150\r\n"
			   " 401800000:       0       0       0       0       1       0       0       100\r\n"
			   " 315000000:       0       0       0       0       0       3       0      2420\r\n"
			   "*214000000:       1       0       0       0       1       0       3     52360\r\n"
			   " 133000000:       0       0       0       0       1       2       0      3450\r\n"
			   "Total transition : 15\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_fast_hang_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_hang_intr_status",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_long_ib_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_pagefault_policy",
		.size = 5,
		.content = "0x0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_policy",
		.size = 6,
		.content = "0xC2\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpu_available_frequencies",
		.size = 72,
		.content = "624000000 560000000 510000000 401800000 315000000 214000000 133000000 \r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpubusy",
		.size = 17,
		.content = " 118419 1010111\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpuclk",
		.size = 11,
		.content = "214000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/idle_timer",
		.size = 4,
		.content = "80\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/lm",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_gpuclk",
		.size = 11,
		.content = "624000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/min_pwrlevel",
		.size = 3,
		.content = "6\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/num_pwrlevels",
		.size = 3,
		.content = "7\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/pmqos_active_latency",
		.size = 5,
		.content = "501\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/popp",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/reset_count",
		.size = 4,
		.content = "44\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/sptp_pc",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/thermal_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_nice",
		.size = 4,
		.content = "-7\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_timeout",
		.size = 5,
		.content = "100\r\n",
	},
	{
		.path = "/sys/devices/soc0/accessory_chip",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/build_id",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/soc0/family",
		.size = 11,
		.content = "Snapdragon\n",
	},
	{
		.path = "/sys/devices/soc0/foundry_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/soc0/hw_platform",
		.size = 4,
		.content = "MTP\n",
	},
	{
		.path = "/sys/devices/soc0/image_crm_version",
		.size = 5,
		.content = "REL\n"
			   "\n",
	},
	{
		.path = "/sys/devices/soc0/image_variant",
		.size = 17,
		.content = "heroqlteuc-user\n"
			   "\n",
	},
	{
		.path = "/sys/devices/soc0/image_version",
		.size = 25,
		.content = "10:MMB29M:G930AUCS4APK1\n"
			   "\n",
	},
	{
		.path = "/sys/devices/soc0/images",
		.size = 611,
		.content = "0:\n"
			   "\tCRM:\t\t00:BOOT.XF.1.0.C1-00023\n"
			   "\tVariant:\tM8996LAB\n"
			   "\tVersion:\tSWHC3505\n"
			   "\n"
			   "1:\n"
			   "\tCRM:\t\t01:TZ.BF.2.0.T200053.2\n"
			   "\tVariant:\t\n"
			   "\tVersion:\tOEM VERSION GOES IN THESE BYTES.\n"
			   "\n"
			   "3:\n"
			   "\tCRM:\t\t03:RPM.BF.1.6.C3-00004\n"
			   "\tVariant:\tAAAAANAAR\n"
			   "\tVersion:\tSWHC3505\n"
			   "\n"
			   "10:\n"
			   "\tCRM:\t\t10:MMB29M:G930AUCS4APK1\n"
			   "\n"
			   "\tVariant:\theroqlteuc-user\n"
			   "\n"
			   "\tVersion:\tREL\n"
			   "\n"
			   "\n"
			   "11:\n"
			   "\tCRM:\t\t11:MPSS.TH.2.0.C2.1-00021\n"
			   "\tVariant:\t8996.gen.prodQ\n"
			   "\tVersion:\tSWDB4606\n"
			   "\n"
			   "12:\n"
			   "\tCRM:\t\t12:ADSP.8996.2.7.C1-00026\n"
			   "\tVariant:\tAAAAAAAAQ\n"
			   "\tVersion:\tSWDB4606\n"
			   "\n"
			   "14:\n"
			   "\tCRM:\t\t14:VIDEO.VE.4.0-00109\n"
			   "\tVariant:\tPROD\n"
			   "\tVersion:\t:CRM\n"
			   "\n"
			   "15:\n"
			   "\tCRM:\t\t15:SLPI.HB.1.0.C1-49586\n"
			   "\tVariant:\tAAAAAAAAQ\n"
			   "\tVersion:\tSWHC3505\n"
			   "\n",
	},
	{
		.path = "/sys/devices/soc0/machine",
		.size = 8,
		.content = "MSM8996\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype",
		.size = 8,
		.content = "Unknown\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/platform_version",
		.size = 6,
		.content = "65536\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_die_revision",
		.size = 7,
		.content = "131072\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_model",
		.size = 6,
		.content = "65545\n",
	},
	{
		.path = "/sys/devices/soc0/raw_id",
		.size = 5,
		.content = "2375\n",
	},
	{
		.path = "/sys/devices/soc0/raw_version",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/soc0/revision",
		.size = 6,
		.content = "3.1.3\n",
	},
	{
		.path = "/sys/devices/soc0/select_image",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/soc0/serial_number",
		.size = 11,
		.content = "2593997263\n",
	},
	{
		.path = "/sys/devices/soc0/soc_id",
		.size = 4,
		.content = "246\n",
	},
	{
		.path = "/sys/devices/soc0/vendor",
		.size = 9,
		.content = "Qualcomm\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 31,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 494,
		.content =
			"CPU2:307200=0 403200=0 480000=0 556800=0 652800=0 729600=0 806400=0 883200=0 940800=0 1036800=0 1113600=0 1190400=0 1248000=0 1324800=0 1401600=0 1478400=0 1555200=0 1632000=0 1708800=0 1785600=0 1824000=0 1920000=0 1996800=0 2073600=0 2150400=0 \n"
			"CPU3:307200=0 403200=0 480000=0 556800=0 652800=0 729600=0 806400=0 883200=0 940800=0 1036800=0 1113600=0 1190400=0 1248000=0 1324800=0 1401600=0 1478400=0 1555200=0 1632000=0 1708800=0 1785600=0 1824000=0 1920000=0 1996800=0 2073600=0 2150400=0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/big_cpu_num",
		.size = 4,
		.content = "2-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/big_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/big_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/hmp_boost_type",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "qcom\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1593600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 121,
		.content =
			"307200 422400 480000 556800 652800 729600 844800 960000 1036800 1113600 1190400 1228800 1324800 1401600 1478400 1593600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1593600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 163,
		.content = "307200 2\n"
			   "422400 1\n"
			   "480000 0\n"
			   "556800 3\n"
			   "652800 2\n"
			   "729600 1\n"
			   "844800 2\n"
			   "960000 67\n"
			   "1036800 37\n"
			   "1113600 1836\n"
			   "1190400 4\n"
			   "1228800 9\n"
			   "1324800 21\n"
			   "1401600 14\n"
			   "1478400 19\n"
			   "1593600 4340\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "785\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1593600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 121,
		.content =
			"307200 422400 480000 556800 652800 729600 844800 960000 1036800 1113600 1190400 1228800 1324800 1401600 1478400 1593600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1593600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 163,
		.content = "307200 2\n"
			   "422400 1\n"
			   "480000 0\n"
			   "556800 3\n"
			   "652800 2\n"
			   "729600 1\n"
			   "844800 2\n"
			   "960000 67\n"
			   "1036800 37\n"
			   "1113600 1836\n"
			   "1190400 5\n"
			   "1228800 9\n"
			   "1324800 23\n"
			   "1401600 14\n"
			   "1478400 19\n"
			   "1593600 4606\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "807\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 192,
		.content =
			"307200 403200 480000 556800 652800 729600 806400 883200 940800 1036800 1113600 1190400 1248000 1324800 1401600 1478400 1555200 1632000 1708800 1785600 1824000 1920000 1996800 2073600 2150400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 8,
		.content = "1824000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 248,
		.content = "307200 0\n"
			   "403200 0\n"
			   "480000 0\n"
			   "556800 1\n"
			   "652800 0\n"
			   "729600 2\n"
			   "806400 1\n"
			   "883200 0\n"
			   "940800 2\n"
			   "1036800 2\n"
			   "1113600 1905\n"
			   "1190400 0\n"
			   "1248000 11\n"
			   "1324800 2\n"
			   "1401600 1\n"
			   "1478400 7\n"
			   "1555200 1\n"
			   "1632000 4\n"
			   "1708800 0\n"
			   "1785600 0\n"
			   "1824000 2\n"
			   "1920000 1\n"
			   "1996800 6\n"
			   "2073600 6\n"
			   "2150400 4953\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "243\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "c\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "2-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 192,
		.content =
			"307200 403200 480000 556800 652800 729600 806400 883200 940800 1036800 1113600 1190400 1248000 1324800 1401600 1478400 1555200 1632000 1708800 1785600 1824000 1920000 1996800 2073600 2150400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 8,
		.content = "1824000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 248,
		.content = "307200 0\n"
			   "403200 0\n"
			   "480000 0\n"
			   "556800 1\n"
			   "652800 0\n"
			   "729600 2\n"
			   "806400 1\n"
			   "883200 0\n"
			   "940800 2\n"
			   "1036800 2\n"
			   "1113600 1905\n"
			   "1190400 0\n"
			   "1248000 11\n"
			   "1324800 2\n"
			   "1401600 1\n"
			   "1478400 7\n"
			   "1555200 1\n"
			   "1632000 4\n"
			   "1708800 0\n"
			   "1785600 0\n"
			   "1824000 2\n"
			   "1920000 1\n"
			   "1996800 7\n"
			   "2073600 6\n"
			   "2150400 5224\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "245\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "c\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "2-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 2,
		.content = "8\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{NULL},
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.fast_track_multiplier",
		.value = "1",
	},
	{
		.key = "audio.dolby.ds2.enabled",
		.value = "false",
	},
	{
		.key = "audio.dolby.ds2.hardbypass",
		.value = "false",
	},
	{
		.key = "audio.offload.buffer.size.kb",
		.value = "32",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "false",
	},
	{
		.key = "audio.offload.multiple.enabled",
		.value = "false",
	},
	{
		.key = "audio.offload.passthrough",
		.value = "false",
	},
	{
		.key = "audio.offload.pcm.16bit.enable",
		.value = "true",
	},
	{
		.key = "audio.offload.pcm.24bit.enable",
		.value = "true",
	},
	{
		.key = "audio.offload.track.enabled",
		.value = "true",
	},
	{
		.key = "audio_hal.period_size",
		.value = "192",
	},
	{
		.key = "audioflinger.bootsnd",
		.value = "0",
	},
	{
		.key = "av.offload.enable",
		.value = "true",
	},
	{
		.key = "boot.sfbootcomplete",
		.value = "0",
	},
	{
		.key = "camera.disable_zsl_mode",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.variant",
		.value = "kryo",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.gralloc.enable_fb_ubwc",
		.value = "1",
	},
	{
		.key = "debug.qualcomm.sns.daemon",
		.value = "I",
	},
	{
		.key = "debug.qualcomm.sns.libsensor1",
		.value = "I",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "debug.sf.layerdump",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.kies.deviceowner",
		.value = "0",
	},
	{
		.key = "dev.kies.drivedisplay",
		.value = "0",
	},
	{
		.key = "dev.kies.drivedisplay.trust",
		.value = "1",
	},
	{
		.key = "dev.kies.sommode",
		.value = "TRUE",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "dev.knoxapp.running",
		.value = "false",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "dev.ssrm.app.type",
		.value = "true",
	},
	{
		.key = "dev.ssrm.appsync3p",
		.value = "false",
	},
	{
		.key = "dev.ssrm.current",
		.value = "NA",
	},
	{
		.key = "dev.ssrm.dex2oat.affinity",
		.value = "",
	},
	{
		.key = "dev.ssrm.hmt_level",
		.value = "0",
	},
	{
		.key = "dev.ssrm.init",
		.value = "1",
	},
	{
		.key = "dev.ssrm.live_thumbnail",
		.value = "1",
	},
	{
		.key = "dev.ssrm.lpc_ver",
		.value = "1.0.21",
	},
	{
		.key = "dev.ssrm.mode",
		.value = "",
	},
	{
		.key = "dev.ssrm.pst",
		.value = "380",
	},
	{
		.key = "dev.ssrm.smart_switch",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "us",
	},
	{
		.key = "gsm.operator.ispsroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "310410",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "G930AUCS4APK1",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Samsung RIL v3.0",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.RIDL",
		.value = "stopped",
	},
	{
		.key = "init.svc.SIDESYNC_service",
		.value = "running",
	},
	{
		.key = "init.svc.SMD-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.TvoutService_C",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.adsprpcd",
		.value = "running",
	},
	{
		.key = "init.svc.apaservice",
		.value = "running",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "stopped",
	},
	{
		.key = "init.svc.audiod",
		.value = "running",
	},
	{
		.key = "init.svc.auditd",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootchecker",
		.value = "running",
	},
	{
		.key = "init.svc.ccm",
		.value = "running",
	},
	{
		.key = "init.svc.cs-early-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs_service",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.defaultcrypto",
		.value = "stopped",
	},
	{
		.key = "init.svc.diag_uart_log",
		.value = "stopping",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.edmaudit",
		.value = "running",
	},
	{
		.key = "init.svc.energy-awareness",
		.value = "stopped",
	},
	{
		.key = "init.svc.epmlogd",
		.value = "stopped",
	},
	{
		.key = "init.svc.esecomm",
		.value = "running",
	},
	{
		.key = "init.svc.factory_adsp",
		.value = "running",
	},
	{
		.key = "init.svc.fingerprintd",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.icd",
		.value = "stopped",
	},
	{
		.key = "init.svc.imsd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.insthk",
		.value = "stopped",
	},
	{
		.key = "init.svc.ipacm",
		.value = "running",
	},
	{
		.key = "init.svc.ipsec-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.jackservice",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.otp",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.per_mgr",
		.value = "running",
	},
	{
		.key = "init.svc.per_proxy",
		.value = "running",
	},
	{
		.key = "init.svc.perfd",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "stopped",
	},
	{
		.key = "init.svc.prepare_param",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.qseeproxydaemon",
		.value = "running",
	},
	{
		.key = "init.svc.qti",
		.value = "running",
	},
	{
		.key = "init.svc.qti-testscripts",
		.value = "stopped",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.run-mobicore",
		.value = "running",
	},
	{
		.key = "init.svc.scs",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdp_cryptod",
		.value = "running",
	},
	{
		.key = "init.svc.sec-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.secure_storage",
		.value = "running",
	},
	{
		.key = "init.svc.sem_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.sensor-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.sensorhubservice",
		.value = "running",
	},
	{
		.key = "init.svc.sensors",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.ss_kb_service",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.swapon",
		.value = "stopped",
	},
	{
		.key = "init.svc.tbaseLoader",
		.value = "stopped",
	},
	{
		.key = "init.svc.tftp_server",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.usf-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.usf_proximity",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "logd.auditd",
		.value = "false",
	},
	{
		.key = "logd.klogd",
		.value = "false",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "3314291",
	},
	{
		.key = "mm.enable.smoothstreaming",
		.value = "true",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.lte_ca_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-63546c54c799d6a8",
	},
	{
		.key = "net.knox.shareddevice.version",
		.value = "2.6.0",
	},
	{
		.key = "net.knoxscep.version",
		.value = "2.0.1",
	},
	{
		.key = "net.knoxsso.version",
		.value = "2.5.0",
	},
	{
		.key = "net.knoxvpn.version",
		.value = "2.2.5",
	},
	{
		.key = "net.lte_ca_enabled",
		.value = "false",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.smart_switch.disabled",
		.value = "1",
	},
	{
		.key = "net.tcp.2g_init_rwnd",
		.value = "10",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,524288,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,524288,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "2097152,4194304,8388608,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,2097152,4194304,262144,524288,1048576",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "nfc.delay.boot",
		.value = "0",
	},
	{
		.key = "nfc.fw.downloadmode_force",
		.value = "0",
	},
	{
		.key = "nfc.fw.rfreg_mode",
		.value = "normal",
	},
	{
		.key = "nfc.fw.rfreg_ver",
		.value = "MAJ: 1, MIN: 1",
	},
	{
		.key = "nfc.nxp.fwdnldstatus",
		.value = "0",
	},
	{
		.key = "nfc.smartcard.binded",
		.value = "true",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.cpufreq",
		.value = "350000",
	},
	{
		.key = "persist.audio.finemediavolume",
		.value = "1",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.audio.globaleffect",
		.value = "1",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.k2hd",
		.value = "1",
	},
	{
		.key = "persist.audio.mpseek",
		.value = "0",
	},
	{
		.key = "persist.audio.mysound",
		.value = "1",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "0",
	},
	{
		.key = "persist.audio.soundalivefxsec",
		.value = "1",
	},
	{
		.key = "persist.audio.stereospeaker",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.uhqa",
		.value = "1",
	},
	{
		.key = "persist.audio.voipcpufreq",
		.value = "350000",
	},
	{
		.key = "persist.bluetooth_fw_ver",
		.value = "bcm4359C0_V0044.0062_semco.hcd",
	},
	{
		.key = "persist.camera.c2d.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.camera.cpp.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.camera.debug.logfile",
		.value = "0",
	},
	{
		.key = "persist.camera.global.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.hal.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.iface.logs",
		.value = "1",
	},
	{
		.key = "persist.camera.imglib.ea_bypass",
		.value = "1",
	},
	{
		.key = "persist.camera.imglib.logs",
		.value = "1",
	},
	{
		.key = "persist.camera.imglib.oemfeat1",
		.value = "0",
	},
	{
		.key = "persist.camera.isp.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.mct.debug",
		.value = "2",
	},
	{
		.key = "persist.camera.mmstill.logs",
		.value = "1",
	},
	{
		.key = "persist.camera.pproc.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.camera.sensor.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.stats.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.data.df.agg.dl_pkt",
		.value = "10",
	},
	{
		.key = "persist.data.df.agg.dl_size",
		.value = "4096",
	},
	{
		.key = "persist.data.df.dev_name",
		.value = "rmnet_usb0",
	},
	{
		.key = "persist.data.df.dl_mode",
		.value = "5",
	},
	{
		.key = "persist.data.df.iwlan_mux",
		.value = "9",
	},
	{
		.key = "persist.data.df.mux_count",
		.value = "8",
	},
	{
		.key = "persist.data.df.ul_mode",
		.value = "5",
	},
	{
		.key = "persist.data.dpm.enable",
		.value = "true",
	},
	{
		.key = "persist.data.dropssdp",
		.value = "false",
	},
	{
		.key = "persist.data.ibfc.enable",
		.value = "true",
	},
	{
		.key = "persist.data.mode",
		.value = "concurrent",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "true",
	},
	{
		.key = "persist.data.wda.enable",
		.value = "true",
	},
	{
		.key = "persist.debug.sensors.hal",
		.value = "W",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.eons.enabled",
		.value = "true",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "1",
	},
	{
		.key = "persist.hwc.enable_vds",
		.value = "1",
	},
	{
		.key = "persist.loc.nlp_name",
		.value = "com.qualcomm.location",
	},
	{
		.key = "persist.logd.size",
		.value = "",
	},
	{
		.key = "persist.mm.enable.prefetch",
		.value = "true",
	},
	{
		.key = "persist.qfp",
		.value = "false",
	},
	{
		.key = "persist.radio.add_power_save",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.calldefault.simid",
		.value = "0",
	},
	{
		.key = "persist.radio.custom_ecc",
		.value = "1",
	},
	{
		.key = "persist.radio.dataprefer.slotId",
		.value = "0",
	},
	{
		.key = "persist.radio.defdataSIMchange",
		.value = "true",
	},
	{
		.key = "persist.radio.initphone-type",
		.value = "1",
	},
	{
		.key = "persist.radio.lte_vrte_ltd",
		.value = "1",
	},
	{
		.key = "persist.radio.plmnname_1",
		.value = "",
	},
	{
		.key = "persist.radio.plmnname_2",
		.value = "",
	},
	{
		.key = "persist.radio.process_sups_ind",
		.value = "1",
	},
	{
		.key = "persist.radio.sib16_support",
		.value = "0",
	},
	{
		.key = "persist.radio.silent-reset",
		.value = "1",
	},
	{
		.key = "persist.radio.ss.voiceclass_1",
		.value = "false",
	},
	{
		.key = "persist.ril.ims.eutranParam",
		.value = "3",
	},
	{
		.key = "persist.ril.ims.pdnFailCause",
		.value = "0",
	},
	{
		.key = "persist.ril.ims.utranParam",
		.value = "0",
	},
	{
		.key = "persist.ril.modem.board",
		.value = "MSM8996",
	},
	{
		.key = "persist.ril.radiocapa.tdscdma",
		.value = "true",
	},
	{
		.key = "persist.ril.xcap.pdnFailCause",
		.value = "0",
	},
	{
		.key = "persist.rmnet.data.enable",
		.value = "true",
	},
	{
		.key = "persist.security.ams.enforcing",
		.value = "3",
	},
	{
		.key = "persist.security.tlc.ccm",
		.value = "0",
	},
	{
		.key = "persist.security.tlc.esecomm",
		.value = "0",
	},
	{
		.key = "persist.security.tlc.otp",
		.value = "0",
	},
	{
		.key = "persist.security.tlc.tui",
		.value = "1",
	},
	{
		.key = "persist.service.bdroid.version",
		.value = "4.2",
	},
	{
		.key = "persist.service.tspcmd.spay",
		.value = "true",
	},
	{
		.key = "persist.sys.SUWRebootReason",
		.value = "",
	},
	{
		.key = "persist.sys.ccm.date",
		.value = "Tue Nov  8 11:46:56 KST 2016",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.drs.date",
		.value = "Tue Nov  8 11:46:56 KST 2016",
	},
	{
		.key = "persist.sys.kap.date",
		.value = "Tue Nov  8 11:46:56 KST 2016",
	},
	{
		.key = "persist.sys.kap.status",
		.value = "NONE",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.localedefault",
		.value = "",
	},
	{
		.key = "persist.sys.localenosim",
		.value = "en-US",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.setupwizard",
		.value = "FINISH",
	},
	{
		.key = "persist.sys.silent",
		.value = "1",
	},
	{
		.key = "persist.sys.ssrm_unbox_cnt",
		.value = "0",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.timezone",
		.value = "Asia/Seoul",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.usb.config.extra",
		.value = "none",
	},
	{
		.key = "persist.sys.webview.vmsize",
		.value = "125731824",
	},
	{
		.key = "persist.sys.wfd.virtual",
		.value = "0",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "qcom.hw.aac.encoder",
		.value = "true",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "1",
	},
	{
		.key = "ril.CompleteMsg",
		.value = "OK",
	},
	{
		.key = "ril.ICC_TYPE",
		.value = "0",
	},
	{
		.key = "ril.RildInit",
		.value = "1",
	},
	{
		.key = "ril.approved_codever",
		.value = "none",
	},
	{
		.key = "ril.approved_cscver",
		.value = "none",
	},
	{
		.key = "ril.approved_modemver",
		.value = "none",
	},
	{
		.key = "ril.atd_status",
		.value = "1_0_0",
	},
	{
		.key = "ril.backoffstate",
		.value = "1024",
	},
	{
		.key = "ril.cs_svc",
		.value = "1",
	},
	{
		.key = "ril.data.intfprefix",
		.value = "rmnet_data",
	},
	{
		.key = "ril.deviceOffRes",
		.value = "0",
	},
	{
		.key = "ril.ecclist0",
		.value = "",
	},
	{
		.key = "ril.ecclist00",
		.value = "112,911,999,000,110,118,119,911,112,08,000,110,118,119,999",
	},
	{
		.key = "ril.ecclist_net0",
		.value = "",
	},
	{
		.key = "ril.epdg.handover.enable",
		.value = "true",
	},
	{
		.key = "ril.eri_num",
		.value = "1",
	},
	{
		.key = "ril.eri_ver_1",
		.value = "E:None ",
	},
	{
		.key = "ril.hasisim",
		.value = "0",
	},
	{
		.key = "ril.hw_ver",
		.value = "REV0.6",
	},
	{
		.key = "ril.ims.ecsupport",
		.value = "0",
	},
	{
		.key = "ril.manufacturedate",
		.value = "161201",
	},
	{
		.key = "ril.modem.board",
		.value = "MSM8996",
	},
	{
		.key = "ril.official_cscver",
		.value = "G930AATT4APK1",
	},
	{
		.key = "ril.product_code",
		.value = "SM-G930AZKAATT",
	},
	{
		.key = "ril.radiostate",
		.value = "10",
	},
	{
		.key = "ril.rfcal_date",
		.value = "2016.12.02",
	},
	{
		.key = "ril.serialnumber",
		.value = "R38HC00LX5H",
	},
	{
		.key = "ril.servicestate",
		.value = "2",
	},
	{
		.key = "ril.ss.routing",
		.value = "1",
	},
	{
		.key = "ril.subinfo",
		.value = "0:2147483643",
	},
	{
		.key = "ril.sw_ver",
		.value = "G930AUCS4APK1",
	},
	{
		.key = "ril.timezoneID",
		.value = "",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib64/libsec-ril.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.astcenc.astcsupport",
		.value = "1",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8996",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.boot.bootdevice",
		.value = "624000.ufshc",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "G930AUCS4APK1",
	},
	{
		.key = "ro.boot.carrierid.param.offset",
		.value = "9438268",
	},
	{
		.key = "ro.boot.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.boot.cp_reserved_mem",
		.value = "off",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.hmac_mismatch",
		.value = "0",
	},
	{
		.key = "ro.boot.im.param.offset",
		.value = "9437232",
	},
	{
		.key = "ro.boot.me.param.offset",
		.value = "9437312",
	},
	{
		.key = "ro.boot.pr.param.offset",
		.value = "9437472",
	},
	{
		.key = "ro.boot.revision",
		.value = "15",
	},
	{
		.key = "ro.boot.sec_atd.tty",
		.value = "/dev/ttyHSL0",
	},
	{
		.key = "ro.boot.security_mode",
		.value = "1526595585",
	},
	{
		.key = "ro.boot.serialno",
		.value = "7755e8c9",
	},
	{
		.key = "ro.boot.sku.param.offset",
		.value = "9437552",
	},
	{
		.key = "ro.boot.sn.param.offset",
		.value = "9437392",
	},
	{
		.key = "ro.boot.ucs_mode",
		.value = "0",
	},
	{
		.key = "ro.boot.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Tue Nov 8 11:47:02 KST 2016",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1478573222",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "samsung/heroqlteuc/heroqlteatt:6.0.1/MMB29M/G930AUCS4APK1:user/test-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "G930AUCS4APK1",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.build.PDA",
		.value = "G930AUCS4APK1",
	},
	{
		.key = "ro.build.changelist",
		.value = "9439621",
	},
	{
		.key = "ro.build.characteristics",
		.value = "att",
	},
	{
		.key = "ro.build.date",
		.value = "Tue Nov  8 11:46:56 KST 2016",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1478573216",
	},
	{
		.key = "ro.build.description",
		.value = "heroqlteuc-user 6.0.1 MMB29M G930AUCS4APK1 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "MMB29M.G930AUCS4APK1",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/heroqlteuc/heroqlteatt:6.0.1/MMB29M/G930AUCS4APK1:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "heroqlteuc-user",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "G930AUCS4APK1",
	},
	{
		.key = "ro.build.host",
		.value = "SWHC3505",
	},
	{
		.key = "ro.build.id",
		.value = "MMB29M",
	},
	{
		.key = "ro.build.official.release",
		.value = "true",
	},
	{
		.key = "ro.build.product",
		.value = "heroqlteatt",
	},
	{
		.key = "ro.build.scafe.cream",
		.value = "white",
	},
	{
		.key = "ro.build.scafe.shot",
		.value = "single",
	},
	{
		.key = "ro.build.scafe.size",
		.value = "short",
	},
	{
		.key = "ro.build.scafe.version",
		.value = "2016A",
	},
	{
		.key = "ro.build.selinux",
		.value = "1",
	},
	{
		.key = "ro.build.selinux.enforce",
		.value = "1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "dpi",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "samsung/heroqlteuc/heroqlteatt:6.0.1/MMB29M/G930AUCU4APJ4:user/release-keys",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "G930AUCS4APK1",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "6.0.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "23",
	},
	{
		.key = "ro.build.version.sdl",
		.value = "2301",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-11-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.carrierid.param.offset",
		.value = "9438268",
	},
	{
		.key = "ro.chipname",
		.value = "MSM8996",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "6.0_r6",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Morning_Flower.ogg",
	},
	{
		.key = "ro.config.dha_cached_max",
		.value = "16",
	},
	{
		.key = "ro.config.dha_cached_min",
		.value = "8",
	},
	{
		.key = "ro.config.dha_empty_max",
		.value = "32",
	},
	{
		.key = "ro.config.dha_empty_min",
		.value = "8",
	},
	{
		.key = "ro.config.dha_pwhitelist_enable",
		.value = "1",
	},
	{
		.key = "ro.config.dha_th_rate",
		.value = "1.7",
	},
	{
		.key = "ro.config.dmverity",
		.value = "true",
	},
	{
		.key = "ro.config.iccc_version",
		.value = "1.0",
	},
	{
		.key = "ro.config.kap",
		.value = "true",
	},
	{
		.key = "ro.config.kap_default_on",
		.value = "true",
	},
	{
		.key = "ro.config.knox",
		.value = "v30",
	},
	{
		.key = "ro.config.media_sound",
		.value = "Media_preview_Touch_the_light.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Whisper.ogg",
	},
	{
		.key = "ro.config.notification_sound_2",
		.value = "S_Charming_Bell.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "ATT_Firefly_Default.ogg",
	},
	{
		.key = "ro.config.ringtone_2",
		.value = "Basic_Bell.ogg",
	},
	{
		.key = "ro.config.rm_preload_enabled",
		.value = "0",
	},
	{
		.key = "ro.config.tima",
		.value = "1",
	},
	{
		.key = "ro.config.timaversion",
		.value = "3.0",
	},
	{
		.key = "ro.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.crypto.default.encrypted",
		.value = "true",
	},
	{
		.key = "ro.crypto.fs_crypto_blkdev",
		.value = "/dev/block/dm-1",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "block",
	},
	{
		.key = "ro.csc.country_code",
		.value = "USA",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "US",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "ATT",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.dbg.coresight.config",
		.value = "stm_events_disabled",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x1bf16698c3b2cca6006ec8c8426e001ecad484d7000000000000000000000000",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/persistent",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hardware.gatekeeper",
		.value = "mdfpp",
	},
	{
		.key = "ro.hardware.keystore",
		.value = "mdfpp",
	},
	{
		.key = "ro.hdcp2.rx",
		.value = "tz",
	},
	{
		.key = "ro.hmac_mismatch",
		.value = "0",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.fbo_cache_size",
		.value = "16",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "58",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "16",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.shape_cache_size",
		.value = "4",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "4096",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "88",
	},
	{
		.key = "ro.im.param.offset",
		.value = "9437232",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.mct.compressiontype",
		.value = "ETC1",
	},
	{
		.key = "ro.me.param.offset",
		.value = "9437312",
	},
	{
		.key = "ro.min_freq_0",
		.value = "384000",
	},
	{
		.key = "ro.min_freq_4",
		.value = "384000",
	},
	{
		.key = "ro.mst.support",
		.value = "1",
	},
	{
		.key = "ro.nfc.port",
		.value = "I2C",
	},
	{
		.key = "ro.opengles.version",
		.value = "196609",
	},
	{
		.key = "ro.pr.param.offset",
		.value = "9437472",
	},
	{
		.key = "ro.product.board",
		.value = "msm8996",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.device",
		.value = "heroqlteatt",
	},
	{
		.key = "ro.product.locale",
		.value = "en-US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SAMSUNG-SM-G930A",
	},
	{
		.key = "ro.product.name",
		.value = "heroqlteuc",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "none",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.us.proximity",
		.value = "1",
	},
	{
		.key = "ro.qti.sensors.cmc",
		.value = "false",
	},
	{
		.key = "ro.qti.sensors.dpc",
		.value = "false",
	},
	{
		.key = "ro.qti.sensors.facing",
		.value = "false",
	},
	{
		.key = "ro.qti.sensors.fast_amd",
		.value = "false",
	},
	{
		.key = "ro.qti.sensors.georv",
		.value = "false",
	},
	{
		.key = "ro.qti.sensors.scrn_ortn",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "1",
	},
	{
		.key = "ro.revision",
		.value = "15",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1524181447608",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.securestorage.support",
		.value = "true",
	},
	{
		.key = "ro.security.ese.cosname",
		.value = "JCOP3.3_00484552",
	},
	{
		.key = "ro.security.esest",
		.value = "per0201exi",
	},
	{
		.key = "ro.security.icd.flagmode",
		.value = "multi",
	},
	{
		.key = "ro.security.mdpp.release",
		.value = "7",
	},
	{
		.key = "ro.security.mdpp.ux",
		.value = "Enabled",
	},
	{
		.key = "ro.security.mdpp.ver",
		.value = "2.0",
	},
	{
		.key = "ro.security.reactive.version",
		.value = "2.0.9",
	},
	{
		.key = "ro.security.vpnpp.release",
		.value = "6.1",
	},
	{
		.key = "ro.security.vpnpp.ver",
		.value = "1.4",
	},
	{
		.key = "ro.security_mode",
		.value = "1526595585",
	},
	{
		.key = "ro.secwvk",
		.value = "144",
	},
	{
		.key = "ro.serialno",
		.value = "7755e8c9",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "640",
	},
	{
		.key = "ro.sku.param.offset",
		.value = "9437552",
	},
	{
		.key = "ro.sn.param.offset",
		.value = "9437392",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.vold.forceencryption",
		.value = "1",
	},
	{
		.key = "ro.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "sdm.debug.disable_rotator_split",
		.value = "1",
	},
	{
		.key = "sdm.perf_hint_window",
		.value = "50",
	},
	{
		.key = "sec.fle.encryption.status",
		.value = "Dec NewFile IncludeMedia",
	},
	{
		.key = "secmm.player.gp.url",
		.value = "true",
	},
	{
		.key = "secmm.player.uhqamode",
		.value = "True",
	},
	{
		.key = "security.ASKS.policy_version",
		.value = "161011",
	},
	{
		.key = "security.mdpp",
		.value = "Ready",
	},
	{
		.key = "security.mdpp.mass",
		.value = "skmm",
	},
	{
		.key = "security.mdpp.result",
		.value = "None",
	},
	{
		.key = "security.semdaemonfinish",
		.value = "1",
	},
	{
		.key = "selinux.policy_version",
		.value = "SEPF_SECMOBILE_6.0.1_0030",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.bt.security.policy.mode",
		.value = "2",
	},
	{
		.key = "service.camera.hdmi_preview",
		.value = "0",
	},
	{
		.key = "service.camera.rec.running",
		.value = "0",
	},
	{
		.key = "service.camera.running",
		.value = "0",
	},
	{
		.key = "service.camera.samsung.enabled",
		.value = "0",
	},
	{
		.key = "service.camera.samsung.parall",
		.value = "0",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "storage.efs_sync.done",
		.value = "0",
	},
	{
		.key = "storage.mmc.size",
		.value = "31927042048",
	},
	{
		.key = "sys.adaptivedisplay.eadon",
		.value = "true",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.cameramode.blackbox",
		.value = "0",
	},
	{
		.key = "sys.cameramode.vtcall",
		.value = "0",
	},
	{
		.key = "sys.config.bigdata_enable",
		.value = "true",
	},
	{
		.key = "sys.config.bigdata_mem_enable",
		.value = "true",
	},
	{
		.key = "sys.dockstate",
		.value = "0",
	},
	{
		.key = "sys.enterprise.billing.version",
		.value = "1.2.0",
	},
	{
		.key = "sys.enterprise.otp.version",
		.value = "2.6.0",
	},
	{
		.key = "sys.ims.service_started",
		.value = "true",
	},
	{
		.key = "sys.keyguard.connected",
		.value = "true",
	},
	{
		.key = "sys.knox.exists",
		.value = "0",
	},
	{
		.key = "sys.knox.store",
		.value = "0",
	},
	{
		.key = "sys.listeners.registered",
		.value = "true",
	},
	{
		.key = "sys.mdniecontrolservice.mscon",
		.value = "true",
	},
	{
		.key = "sys.mobicore.loaded",
		.value = "true",
	},
	{
		.key = "sys.mobicoredaemon.enable",
		.value = "true",
	},
	{
		.key = "sys.nfc.support",
		.value = "1",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "0",
	},
	{
		.key = "sys.qseecomd.enable",
		.value = "true",
	},
	{
		.key = "sys.reset_reason",
		.value = "N|NP",
	},
	{
		.key = "sys.settings_global_version",
		.value = "4",
	},
	{
		.key = "sys.settings_secure_version",
		.value = "1",
	},
	{
		.key = "sys.settings_system_version",
		.value = "7",
	},
	{
		.key = "sys.siop.level",
		.value = "0",
	},
	{
		.key = "sys.ssrm.mdnie",
		.value = "-1",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "43200",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "system.camera.CC.disable",
		.value = "0",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "0",
	},
	{
		.key = "tunnel.audio.encode",
		.value = "false",
	},
	{
		.key = "use.voice.path.for.pcm.voip",
		.value = "true",
	},
	{
		.key = "vold.crypt.type",
		.value = "default",
	},
	{
		.key = "vold.decrypt",
		.value = "trigger_restart_framework",
	},
	{
		.key = "vold.encrypt_progress",
		.value = "",
	},
	{
		.key = "vold.has_adoptable",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{
		.key = "wlan.wfd.status",
		.value = "disconnected",
	},
	{NULL},
};
#endif /* __ANDROID__ */
