/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <QWidget>
#include <QIcon>
#include <QFormLayout>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QSpinBox>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QDebug>


class ConfigDialog : public QWidget
{
    Q_OBJECT

public:
    ConfigDialog(QString dataDirectory,
                 int updateInterval,
                 int postsPerPageMain,
                 int postsPerPageOther,
                 int tabsPosition,
                 bool tabsMovable,
                 bool publicPosts,
                 int showNotifications,
                 QWidget *parent);
    ~ConfigDialog();


signals:
    void configurationChanged(int newUpdateInterval,
                              int newPostsPerPageMain,
                              int newPostsPerPageOther,
                              int newTabsPosition,
                              bool newTabsMovable,
                              bool newPublicPosts,
                              int newShowNotifications);


public slots:
    void saveConfiguration();


private:
    QVBoxLayout *mainLayout;

    QFormLayout *optionsLayout;

    QSpinBox *updateIntervalSpinbox;
    QSpinBox *postsPerPageMainSpinbox;
    QSpinBox *postsPerPageOtherSpinbox;
    QComboBox *tabsPositionCombobox;
    QCheckBox *tabsMovableCheckbox;
    QCheckBox *publicPostsCheckbox;
    QComboBox *showNotificationsCombobox;

    QLabel *dataDirectoryLabel;

    QHBoxLayout *buttonsLayout;
    QPushButton *saveConfigButton;
    QPushButton *cancelButton;
};

#endif // CONFIGDIALOG_H
