/*
 *  Copyright (C) 1995-2009 Maxime DOYEN
 *  Copyright 2009 Neil Williams  <linux@codehelp.co.uk>
 *
 *  This file was copied from HomeBank and modified since.
 *
 *  This package is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This package is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <gtk/gtkhbox.h>
#include <gtk/gtktogglebutton.h>
#include <gtk/gtkarrow.h>
#include <gtk/gtkeventbox.h>
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkwindow.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkframe.h>
#include <gtk/gtkcalendar.h>
#include <gtk/gtkentry.h>
#include "drivel.h"
#include "gtkdateentry.h"

enum {
	CHANGED,
	LAST_SIGNAL
};

enum {
	PROPERTY_DATE = 5,
};

/*
static void
gtk_dateentry_set_property (GObject		 *object,
						guint			prop_id,
						const GValue	*value,
						GParamSpec	  *pspec);

static void
gtk_dateentry_get_property (GObject		 *object,
						guint			prop_id,
						GValue		  *value,
						GParamSpec	  *pspec);
*/

static GtkHBoxClass *parent_class = NULL;
static guint dateentry_signals[LAST_SIGNAL] = {0,};

/* todo:finish this
 this is to be able to seizure d or d/m or m/d in the gtkdateentry
 * don't probably need this for drivel.
*/
/* order of these in the current locale */
static GDateDMY dmy_order[3] =
{
	G_DATE_DAY, G_DATE_MONTH, G_DATE_YEAR
};

struct _GDateParseTokens {
	gint num_ints;
	gint n[3];
	guint month;
};

typedef struct _GDateParseTokens GDateParseTokens;

#define NUM_LEN 10

static void
g_date_fill_parse_tokens (const gchar *str, GDateParseTokens *pt)
{
	/* bug: use a newly allocated gchar ** ? */
	gchar num[4][NUM_LEN+1];
	gint i;
	const guchar *s;

	debug (" (dateentry) fill parse token");

	/* We count 4, but store 3; so we can give an error
	* if there are 4.
	*/
	num[0][0] = num[1][0] = num[2][0] = num[3][0] = '\0';

	s = (const guchar *) str;
	pt->num_ints = 0;
	while (*s && pt->num_ints < 4)
	{

		i = 0;
		while (*s && g_ascii_isdigit (*s) && i < NUM_LEN)
		{
			num[pt->num_ints][i] = *s;
			++s;
			++i;
		}

		if (i > 0)
		{
			num[pt->num_ints][i] = '\0';
			++(pt->num_ints);
		}

		if (*s == '\0') break;

		++s;
	}

	pt->n[0] = pt->num_ints > 0 ? atoi (num[0]) : 0;
	pt->n[1] = pt->num_ints > 1 ? atoi (num[1]) : 0;
	pt->n[2] = pt->num_ints > 2 ? atoi (num[2]) : 0;

}

/* tries to work out whether the locale uses d-m-y or m-d-y
 * not necessarily needed for drivel. */
static void g_date_determine_dmy(void)
{
	GDate d;
	/* need a dynamic buffer here */
	gchar buf[128];
	GDateParseTokens testpt;
	gint i;

	debug (" (dateentry) determine dmy");


	g_date_clear (&d, 1);			  /* clear for scratch use */


	/* had to pick a random day - don't change this, some strftimes
	* are broken on some days, and this one is good so far. */
	g_date_set_dmy (&d, 4, 7, 1976);

	g_date_strftime (buf, 127, "%x", &d);

	g_date_fill_parse_tokens (buf, &testpt);

	i = 0;
	while (i < testpt.num_ints)
	{
		switch (testpt.n[i])
		{
			case 7:
				dmy_order[i] = G_DATE_MONTH;
				break;
			case 4:
				dmy_order[i] = G_DATE_DAY;
				break;
			/* case 76:
				using_twodigit_years = TRUE; *//* FALL THRU */
			case 1976:
				dmy_order[i] = G_DATE_YEAR;
				break;
		}
		++i;
	}

/*	debug (" dmy legend: 0=day, 1=month, 2=year\n");
	debug (" dmy is: %d %d %d\n", dmy_order[0], dmy_order[1], dmy_order[2]);*/
}

static void
gtk_dateentry_destroy (GtkObject * object)
{
	GtkDateEntry *dateentry;

	debug (" \n(dateentry) destroy");

	g_return_if_fail (GTK_IS_DATE_ENTRY (object));

	dateentry = GTK_DATE_ENTRY (object);

	if(dateentry->popwin)
		gtk_widget_destroy (dateentry->popwin);
	dateentry->popwin = NULL;

	if(dateentry->date)
		g_date_free(dateentry->date);
	dateentry->date = NULL;

	GTK_OBJECT_CLASS (parent_class)->destroy (object);
}

/*
** fill in our gtkentry from our GDate
* BUG: move this away from a Julian date?
*/
static void gtk_dateentry_datetoentry(GtkDateEntry * dateentry)
{
	/* bug: use a dynamic buffer? */
	gchar buffer[256];

	debug (" (dateentry) date2entry");

	if(g_date_valid(dateentry->date) == TRUE)
	{
		g_date_strftime (buffer, 256 - 1, "%x", dateentry->date);
		gtk_entry_set_text (GTK_ENTRY (dateentry->entry), buffer);
	}
	else
		gtk_entry_set_text (GTK_ENTRY (dateentry->entry), "??");


	/* emit the signal */
	if(dateentry->lastdate != g_date_get_julian(dateentry->date))
	{
		debug (" **emit signal**");

		g_signal_emit_by_name (dateentry, "changed", NULL, NULL);
	}

	dateentry->lastdate = g_date_get_julian(dateentry->date);

}

/*
** store the calendar date to GDate, update our gtkentry
*/
static void gtk_dateentry_calendar_getfrom(GtkWidget * calendar, GtkDateEntry * dateentry)
{
	guint year, month, day;

	debug (" (dateentry) get from calendar");

	/* julian date used elsewhere, gregorian here? */
	gtk_calendar_get_date (GTK_CALENDAR (dateentry->calendar), &year, &month, &day);
	g_date_set_dmy (dateentry->date, day, month + 1, year);
	gtk_dateentry_datetoentry(dateentry);
}

static void
position_popup (GtkDateEntry * dateentry)
{
	gint x, y;
	gint bwidth, bheight;
	GtkRequisition req;

	debug (" (dateentry) position popup");

	gtk_widget_size_request (dateentry->popwin, &req);

	gdk_window_get_origin (dateentry->arrow->window, &x, &y);

	x += dateentry->arrow->allocation.x;
	y += dateentry->arrow->allocation.y;
	bwidth = dateentry->arrow->allocation.width;
	bheight = dateentry->arrow->allocation.height;

	x += bwidth - req.width;
	y += bheight;

	if (x < 0)
		x = 0;

	if (y < 0)
		y = 0;

	gtk_window_move (GTK_WINDOW (dateentry->popwin), x, y);
}

static void
gtk_dateentry_popup_display (GtkDateEntry * dateentry)
{
	const gchar *str;
	gint month;

	/*gint height, width, x, y;*/
	gint G_GNUC_UNUSED old_width, G_GNUC_UNUSED old_height;

	debug (" (dateentry) popup_display");

	old_width = dateentry->popwin->allocation.width;
	old_height  = dateentry->popwin->allocation.height;

	/* update */
	str = gtk_entry_get_text (GTK_ENTRY (dateentry->entry));
	g_date_set_parse (dateentry->date, str);

	if(g_date_valid(dateentry->date) == TRUE)
	{
		/* GtkCalendar expects month to be in 0-11 range (inclusive) */
		month = g_date_get_month (dateentry->date) - 1;
		gtk_calendar_select_month (GTK_CALENDAR (dateentry->calendar),
				   CLAMP (month, 0, 11),
				   g_date_get_year (dateentry->date));
		gtk_calendar_select_day (GTK_CALENDAR (dateentry->calendar),
				 g_date_get_day (dateentry->date));
	}

	position_popup(dateentry);

	gtk_widget_show (dateentry->popwin);

	gtk_grab_add (dateentry->popwin);

	/* this close the popup */

	gdk_pointer_grab (dateentry->popwin->window, TRUE,
			GDK_BUTTON_PRESS_MASK |
			GDK_BUTTON_RELEASE_MASK |
			GDK_POINTER_MOTION_MASK,
			NULL, NULL, GDK_CURRENT_TIME);
}

static gint
gtk_dateentry_arrow_press (GtkWidget * widget, GtkDateEntry * dateentry)
{
	GtkToggleButton *button;

	debug (" (dateentry) arrow_press");

	button = GTK_TOGGLE_BUTTON(widget);

	if(!button->active){
		gtk_widget_hide (dateentry->popwin);
		gtk_grab_remove (dateentry->popwin);
		gdk_pointer_ungrab (GDK_CURRENT_TIME);

		gtk_dateentry_calendar_getfrom(NULL, dateentry);
		return TRUE;
	}

	gtk_dateentry_popup_display(dateentry);
	return TRUE;
}

GtkWidget * gtk_dateentry_new ()
{
GtkDateEntry *dateentry;

	debug (" (dateentry) new");

	dateentry = g_object_new (GTK_TYPE_DATE_ENTRY, NULL);

	return GTK_WIDGET(dateentry);
}

/*
** parse the gtkentry and store the GDate
*/
static void gtk_dateentry_entry_new(GtkWidget *gtkentry, gpointer user_data)
{
	GtkDateEntry *dateentry = user_data;
	const gchar *str;
	GDateParseTokens pt;

	debug (" (dateentry) entry validation");

	str = gtk_entry_get_text (GTK_ENTRY (dateentry->entry));

	g_date_fill_parse_tokens(str, &pt);

	g_date_set_time_t(dateentry->date, time(NULL));

	switch( pt.num_ints )
	{
		case 1:
			debug (" -> seizured 1 number");
			g_date_set_day(dateentry->date, pt.n[0]);
			break;
		case 2:
			debug (" -> seizured 2 numbers");
			if( dmy_order[0] != G_DATE_YEAR )
			{
				if( dmy_order[0] == G_DATE_DAY )
				{
					g_date_set_day(dateentry->date, pt.n[0]);
					g_date_set_month(dateentry->date, pt.n[1]);
				}
				else
				{
					g_date_set_day(dateentry->date, pt.n[1]);
					g_date_set_month(dateentry->date, pt.n[0]);
				}
			}
			break;
		default:
			g_date_set_parse (dateentry->date, str);
			break;
	}

	if(g_date_valid(dateentry->date) == FALSE)
	{
		/* today's date */
		g_date_set_time_t(dateentry->date, time(NULL));
	}

	gtk_dateentry_datetoentry(dateentry);

}

static gboolean gtk_dateentry_focus(GtkWidget *widget,
					GdkEventFocus *event, gpointer user_data)
{
	GtkDateEntry *dateentry = user_data;

	gtk_dateentry_entry_new(GTK_WIDGET(dateentry), dateentry);

	return FALSE;
}

static gint
gtk_dateentry_entry_key (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	GtkDateEntry *dateentry = user_data;

	if( event->keyval == GDK_Up )
	{
		if( !(event->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK)) )
		{
			g_date_add_days (dateentry->date, 1);
			gtk_dateentry_datetoentry(dateentry);
		}
		else
		if( event->state & GDK_SHIFT_MASK )
		{
			g_date_add_months (dateentry->date, 1);
			gtk_dateentry_datetoentry(dateentry);
		}
		else
		if( event->state & GDK_CONTROL_MASK )
		{
			g_date_add_years (dateentry->date, 1);
			gtk_dateentry_datetoentry(dateentry);
		}
		return TRUE;
	}
	else
	if( event->keyval == GDK_Down )
	{
		if( !(event->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK)) )
		{
			g_date_subtract_days (dateentry->date, 1);
			gtk_dateentry_datetoentry(dateentry);
		}
		else
		if( event->state & GDK_SHIFT_MASK )
		{
			g_date_subtract_months (dateentry->date, 1);
			gtk_dateentry_datetoentry(dateentry);
		}
		else
		if( event->state & GDK_CONTROL_MASK )
		{
			g_date_subtract_years (dateentry->date, 1);
			gtk_dateentry_datetoentry(dateentry);
		}
		return TRUE;
	}

	return FALSE;
}

static void
gtk_dateentry_hide_popdown_window(GtkDateEntry *dateentry)
{
	debug (" (dateentry) hide_popdown_window");

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dateentry->arrow), FALSE);

	gtk_grab_remove(dateentry->popwin);
	gdk_pointer_ungrab(GDK_CURRENT_TIME);
	gtk_widget_hide(dateentry->popwin);
}

static gint
key_press_popup (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	GtkDateEntry *dateentry = user_data;

	if (event->keyval != GDK_Escape)
		return FALSE;

	g_signal_stop_emission_by_name (widget, "key_press_event");

	gtk_dateentry_hide_popdown_window(dateentry);

	return TRUE;
}

static gint
gtk_dateentry_button_press (GtkWidget * widget, GdkEvent * event, gpointer data)
{
	GtkWidget *child;

	debug (" (dateentry) button_press");

	child = gtk_get_event_widget (event);

	if (child != widget)
	{
		while (child)
		{
			if (child == widget)
				return FALSE;
			child = child->parent;
		}
	}

	gtk_widget_hide (widget);
	gtk_grab_remove (widget);
	gdk_pointer_ungrab (GDK_CURRENT_TIME);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(GTK_DATE_ENTRY(data)->arrow), FALSE);

	return TRUE;
}

static void gtk_dateentry_calendar_select(GtkWidget * calendar, gpointer user_data)
{
	GtkDateEntry *dateentry = user_data;

	debug (" (dateentry) calendar_select");

	gtk_dateentry_hide_popdown_window(dateentry);
	gtk_dateentry_calendar_getfrom(NULL, dateentry);
}

static void
gtk_dateentry_init (GtkDateEntry * dateentry)
{
	GtkWidget *widget;
	GtkWidget *arrow;

	debug (" (dateentry) init");

	widget=GTK_WIDGET(dateentry);

	GTK_BOX(widget)->homogeneous = FALSE;

	dateentry->date = g_date_new();
	/* today's date */
	g_date_set_time_t(dateentry->date, time(NULL));

	dateentry->entry = gtk_entry_new ();
	gtk_widget_set_size_request(dateentry->entry, 90, -1);
	gtk_box_pack_start (GTK_BOX (dateentry), dateentry->entry, TRUE, TRUE, 0);

	dateentry->arrow = gtk_toggle_button_new ();
	arrow = gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_IN);
	gtk_container_add (GTK_CONTAINER (dateentry->arrow), arrow);
	gtk_box_pack_end (GTK_BOX (dateentry), dateentry->arrow, FALSE, FALSE, 0);

	gtk_widget_show (dateentry->entry);
	gtk_widget_show (dateentry->arrow);

	g_signal_connect (GTK_OBJECT (dateentry->arrow), "toggled",
				G_CALLBACK (gtk_dateentry_arrow_press), dateentry);

	g_signal_connect (GTK_OBJECT (dateentry->entry), "activate",
				G_CALLBACK (gtk_dateentry_entry_new), dateentry);

	g_signal_connect (GTK_OBJECT (dateentry->entry), "focus-out-event",
				G_CALLBACK (gtk_dateentry_focus), dateentry);


	g_signal_connect (GTK_OBJECT (dateentry->entry), "key_press_event",
				G_CALLBACK (gtk_dateentry_entry_key), dateentry);

	/* our popup window */
	dateentry->popwin = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_widget_set_events (dateentry->popwin,
				gtk_widget_get_events(dateentry->popwin) | GDK_KEY_PRESS_MASK);

	dateentry->frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (dateentry->popwin), dateentry->frame);
	gtk_frame_set_shadow_type (GTK_FRAME (dateentry->frame), GTK_SHADOW_OUT);
	gtk_widget_show (dateentry->frame);

	dateentry->calendar = gtk_calendar_new ();
	gtk_container_add (GTK_CONTAINER (dateentry->frame), dateentry->calendar);
	gtk_widget_show (dateentry->calendar);


	g_signal_connect (GTK_OBJECT (dateentry->popwin), "key_press_event",
				G_CALLBACK (key_press_popup), dateentry);


	g_signal_connect (GTK_OBJECT (dateentry->popwin), "button_press_event",
				G_CALLBACK (gtk_dateentry_button_press), dateentry);

	g_signal_connect (GTK_OBJECT (dateentry->calendar), "day-selected",
				G_CALLBACK (gtk_dateentry_calendar_getfrom), dateentry);

	g_signal_connect (GTK_OBJECT (dateentry->calendar), "day-selected-double-click",
				G_CALLBACK (gtk_dateentry_calendar_select), dateentry);

	gtk_dateentry_calendar_getfrom(NULL, dateentry);
}

static void
gtk_dateentry_class_init (GtkDateEntryClass * klass)
{
	GObjectClass * G_GNUC_UNUSED gobject_class;
	GtkObjectClass *object_class;
	GtkWidgetClass * G_GNUC_UNUSED widget_class;

	gobject_class = (GObjectClass*) klass;
	object_class = (GtkObjectClass*) klass;
	widget_class = (GtkWidgetClass*) klass;

	parent_class = g_type_class_peek_parent (klass);

	debug (" (dateentry) class_init");


	object_class->destroy = gtk_dateentry_destroy;

	dateentry_signals[CHANGED] =
	g_signal_new ("changed",
		G_OBJECT_CLASS_TYPE (klass),
		G_SIGNAL_RUN_LAST,
		G_STRUCT_OFFSET (GtkDateEntryClass, changed),
		NULL, NULL,
		g_cclosure_marshal_VOID__VOID,
		G_TYPE_NONE, 0);

	g_date_determine_dmy();

 /*
	gobject_class->set_property = gtk_dateentry_set_property;
	gobject_class->get_property = gtk_dateentry_get_property;

	g_object_class_install_property (gobject_class,
			PROPERTY_DATE,
			g_param_spec_uint(	"date",
								"Date",
								"The date currently selected",
								0, G_MAXUINT,
								0,
								(G_PARAM_READABLE | G_PARAM_WRITABLE)
							   )
			);
	*/
}

/* end */

GType
gtk_dateentry_get_type ()
{
static GType dateentry_type = 0;

	debug (" (dateentry) get_type");

	if (!dateentry_type)
	{
		static const GTypeInfo dateentry_info =
		{
			sizeof (GtkDateEntryClass),
			NULL,		/* base_init */
			NULL,		/* base_finalize */
			(GClassInitFunc) gtk_dateentry_class_init,
			NULL,		/* class_finalize */
			NULL,		/* class_data */
			sizeof (GtkDateEntry),
			0,		/* n_preallocs */
			(GInstanceInitFunc) gtk_dateentry_init,
			NULL

		};

		/* dateentry_type = gtk_type_unique (gtk_hbox_get_type (), &dateentry_info);*/

		dateentry_type = g_type_register_static (GTK_TYPE_HBOX, "GtkDateEntry",
							 &dateentry_info, 0);


	}
	return dateentry_type;
}

/*
**
*/
void gtk_dateentry_set_date(GtkDateEntry * dateentry, guint julian_days)
{
	g_return_if_fail (GTK_IS_DATE_ENTRY (dateentry));

	if(g_date_valid_julian(julian_days))
	{
		g_date_set_julian (dateentry->date, julian_days);
	}
	else
	{
		g_date_set_time_t(dateentry->date, time(NULL));
	}
	gtk_dateentry_datetoentry(dateentry);
}

/*
**
*/
guint gtk_dateentry_get_date(GtkDateEntry * dateentry)
{
	g_return_val_if_fail (GTK_IS_DATE_ENTRY (dateentry), 0);

	return(g_date_get_julian(dateentry->date));
}

/*
static void
gtk_dateentry_set_property (GObject		 *object,
						guint			prop_id,
						const GValue	*value,
						GParamSpec	  *pspec)
{
GtkDateEntry *dateentry = GTK_DATE_ENTRY (object);

	debug( g_print(" (dateentry) set %d\n", prop_id) );


  switch (prop_id)
	{
	case PROPERTY_DATE:
	   debug( g_print(" -> date to %d\n", g_value_get_uint (value)) );

		g_date_set_julian (dateentry->date, g_value_get_uint (value));
		gtk_dateentry_datetoentry(dateentry);
	break;


	default:
	  //G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	  break;
	}
}



static void
gtk_dateentry_get_property (GObject		 *object,
						guint			prop_id,
						GValue		  *value,
						GParamSpec	  *pspec)
{
GtkDateEntry *dateentry = GTK_DATE_ENTRY (object);

	debug( g_print(" (dateentry) get\n") );

  switch (prop_id)
	{
	case PROPERTY_DATE:
	   debug( g_print(" -> date is %d\n", 0) );
		g_value_set_uint (value, g_date_get_julian(dateentry->date));
		break;

	default:
	  //G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	  break;
	}
}
*/
