/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.elasticsearch.indices.analysis;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.*;

public class DummyIndicesAnalysis extends AbstractComponent {

    @Inject
    public DummyIndicesAnalysis(Settings settings, IndicesAnalysisService indicesAnalysisService) {
        super(settings);
        indicesAnalysisService.analyzerProviderFactories().put("dummy",
                new PreBuiltAnalyzerProviderFactory("dummy", AnalyzerScope.INDICES,
                        new DummyAnalyzer(Lucene.ANALYZER_VERSION)));
        indicesAnalysisService.tokenFilterFactories().put("dummy_token_filter",
                new PreBuiltTokenFilterFactoryFactory(new DummyTokenFilterFactory()));
        indicesAnalysisService.charFilterFactories().put("dummy_char_filter",
                new PreBuiltCharFilterFactoryFactory(new DummyCharFilterFactory()));
        indicesAnalysisService.tokenizerFactories().put("dummy_tokenizer",
                new PreBuiltTokenizerFactoryFactory(new DummyTokenizerFactory()));
    }
}
