/* S/390-64 for IBM z13 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2021 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

#define HAVE_NATIVE_mpn_addmul_2 1
#define HAVE_NATIVE_mpn_mul_2 1

/* Generated by tuneup.c, 2021-07-30, gcc 10.2 */

#define DIVREM_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIVREM_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define MOD_1_1P_METHOD                      2
#define MOD_1_NORM_THRESHOLD             MP_SIZE_T_MAX  /* never */
#define MOD_1_UNNORM_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define MOD_1N_TO_MOD_1_1_THRESHOLD         17
#define MOD_1U_TO_MOD_1_1_THRESHOLD         15
#define MOD_1_1_TO_MOD_1_2_THRESHOLD         0  /* never mpn_mod_1_1p */
#define MOD_1_2_TO_MOD_1_4_THRESHOLD         0  /* never mpn_mod_1s_2p */
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      5
#define USE_PREINV_DIVREM_1                  0
#define DIV_QR_1N_PI1_METHOD                 3
#define DIV_QR_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD             996
#define DIVEXACT_1_THRESHOLD                 4
#define BMOD_1_TO_MOD_1_THRESHOLD            0  /* always */

#define DIV_1_VS_MUL_1_PERCENT             404

#define MUL_TOOM22_THRESHOLD                23
#define MUL_TOOM33_THRESHOLD                94
#define MUL_TOOM44_THRESHOLD               166
#define MUL_TOOM6H_THRESHOLD               286
#define MUL_TOOM8H_THRESHOLD               626

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     113
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     138
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     143
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     145
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     130

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 12
#define SQR_TOOM3_THRESHOLD                 84
#define SQR_TOOM4_THRESHOLD                234
#define SQR_TOOM6_THRESHOLD                318
#define SQR_TOOM8_THRESHOLD                478

#define MULMID_TOOM42_THRESHOLD             42

#define MULMOD_BNM1_THRESHOLD               13
#define SQRMOD_BNM1_THRESHOLD                7

#define MUL_FFT_MODF_THRESHOLD             332  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    332, 5}, {     19, 6}, {     10, 5}, {     21, 6}, \
    {     21, 7}, {     21, 8}, {     11, 7}, {     24, 8}, \
    {     13, 7}, {     27, 8}, {     15, 7}, {     31, 8}, \
    {     17, 7}, {     35, 8}, {     19, 7}, {     39, 8}, \
    {     21, 9}, {     11, 8}, {     27, 9}, {     15, 8}, \
    {     35, 9}, {     19, 8}, {     41, 9}, {     23, 8}, \
    {     47, 9}, {     27,10}, {     15, 9}, {     39,10}, \
    {     23, 9}, {     47,11}, {     15,10}, {     31, 9}, \
    {     67,10}, {     47,11}, {   2048,12}, {   4096,13}, \
    {   8192,14}, {  16384,15}, {  32768,16}, {  65536,17}, \
    { 131072,18}, { 262144,19}, { 524288,20}, {1048576,21}, \
    {2097152,22}, {4194304,23}, {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 47
#define MUL_FFT_THRESHOLD                 2752

#define SQR_FFT_MODF_THRESHOLD             240  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    240, 5}, {      8, 4}, {     17, 5}, {     13, 6}, \
    {      7, 5}, {     15, 6}, {      8, 5}, {     17, 6}, \
    {      9, 5}, {     19, 6}, {     15, 7}, {      8, 6}, \
    {     17, 7}, {      9, 6}, {     19, 7}, {     10, 6}, \
    {     21, 7}, {     17, 8}, {      9, 7}, {     20, 8}, \
    {     11, 7}, {     23, 8}, {     13, 9}, {      7, 8}, \
    {     21, 9}, {     11, 8}, {     23, 9}, {     15, 8}, \
    {     31, 9}, {     19, 8}, {     39, 9}, {     23,10}, \
    {     15, 9}, {     39,10}, {     23,11}, {     15,10}, \
    {     31, 9}, {     63,10}, {     47,11}, {   2048,12}, \
    {   4096,13}, {   8192,14}, {  16384,15}, {  32768,16}, \
    {  65536,17}, { 131072,18}, { 262144,19}, { 524288,20}, \
    {1048576,21}, {2097152,22}, {4194304,23}, {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 52
#define SQR_FFT_THRESHOLD                 1856

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  25
#define MULLO_MUL_N_THRESHOLD             5397
#define SQRLO_BASECASE_THRESHOLD             0  /* always */
#define SQRLO_DC_THRESHOLD                 396
#define SQRLO_SQR_THRESHOLD               3704

#define DC_DIV_QR_THRESHOLD                 15
#define DC_DIVAPPR_Q_THRESHOLD              50
#define DC_BDIV_QR_THRESHOLD                66
#define DC_BDIV_Q_THRESHOLD                202

#define INV_MULMOD_BNM1_THRESHOLD           46
#define INV_NEWTON_THRESHOLD                29
#define INV_APPR_THRESHOLD                  13

#define BINV_NEWTON_THRESHOLD              312
#define REDC_1_TO_REDC_2_THRESHOLD          79
#define REDC_2_TO_REDC_N_THRESHOLD           0  /* always */

#define MU_DIV_QR_THRESHOLD                979
#define MU_DIVAPPR_Q_THRESHOLD             979
#define MUPI_DIV_QR_THRESHOLD               13
#define MU_BDIV_QR_THRESHOLD               942
#define MU_BDIV_Q_THRESHOLD               1367

#define POWM_SEC_TABLE  3,19,215,1730

#define GET_STR_DC_THRESHOLD                10
#define GET_STR_PRECOMPUTE_THRESHOLD        15
#define SET_STR_DC_THRESHOLD               882
#define SET_STR_PRECOMPUTE_THRESHOLD      2520

#define FAC_DSC_THRESHOLD                  228
#define FAC_ODD_THRESHOLD                   24

#define MATRIX22_STRASSEN_THRESHOLD         19
#define HGCD2_DIV1_METHOD                    1
#define HGCD_THRESHOLD                      61
#define HGCD_APPR_THRESHOLD                 51
#define HGCD_REDUCE_THRESHOLD             1962
#define GCD_DC_THRESHOLD                   217
#define GCDEXT_DC_THRESHOLD                263
#define JACOBI_BASE_METHOD                   4

