/*
ucci.h/ucci.cpp - Source Code for ElephantEye, Part I

ElephantEye - a Chinese Chess Program (UCCI Engine)
Designed by Morning Yellow, Version: 3.15, Last Modified: Jul. 2008
Copyright (C) 2004-2008 www.elephantbase.net

This part (ucci.h/ucci.cpp only) of codes is NOT published under LGPL, and
can be used without restriction.
*/

#include "base.h"

#ifndef UCCI_H
#define UCCI_H

const int UCCI_MAX_DEPTH = 32; // UCCI˼ļ

// UCCIָйؼйصѡ
enum UcciOptionEnum {
  UCCI_OPTION_UNKNOWN, UCCI_OPTION_BATCH, UCCI_OPTION_DEBUG, UCCI_OPTION_PONDER, UCCI_OPTION_ALWAYSCHECK, UCCI_OPTION_USEHASH, UCCI_OPTION_USEBOOK, UCCI_OPTION_USEEGTB,
  UCCI_OPTION_BOOKFILES, UCCI_OPTION_EGTBPATHS, UCCI_OPTION_EVALAPI, UCCI_OPTION_HASHSIZE, UCCI_OPTION_THREADS, UCCI_OPTION_PROMOTION,
  UCCI_OPTION_IDLE, UCCI_OPTION_PRUNING, UCCI_OPTION_KNOWLEDGE, UCCI_OPTION_RANDOMNESS, UCCI_OPTION_STYLE, UCCI_OPTION_NEWGAME
}; // "setoption"ָѡ
enum UcciRepetEnum {
  UCCI_REPET_ALWAYSDRAW, UCCI_REPET_CHECKBAN, UCCI_REPET_ASIANRULE, UCCI_REPET_CHINESERULE
}; // ѡ"repetition"趨ֵ
enum UcciGradeEnum {
  UCCI_GRADE_NONE, UCCI_GRADE_SMALL, UCCI_GRADE_MEDIUM, UCCI_GRADE_LARGE
}; // ѡ"idle""pruning""knowledge""selectivity"趨ֵ
enum UcciStyleEnum {
  UCCI_STYLE_SOLID, UCCI_STYLE_NORMAL, UCCI_STYLE_RISKY
}; // ѡ"style"趨ֵ
enum UcciGoEnum {
  UCCI_GO_DEPTH, UCCI_GO_NODES, UCCI_GO_TIME_MOVESTOGO, UCCI_GO_TIME_INCREMENT
}; // "go"ָָʱģʽֱ޶ȡ޶ʱƺͼʱ
enum UcciCommEnum {
  UCCI_COMM_UNKNOWN, UCCI_COMM_UCCI, UCCI_COMM_ISREADY, UCCI_COMM_PONDERHIT, UCCI_COMM_PONDERHIT_DRAW, UCCI_COMM_STOP,
  UCCI_COMM_SETOPTION, UCCI_COMM_POSITION, UCCI_COMM_BANMOVES, UCCI_COMM_GO, UCCI_COMM_PROBE, UCCI_COMM_QUIT
}; // UCCIָ

// UCCIָԽͳĽṹ
union UcciCommStruct {

  /* ɵõϢUCCIָֻ4
   *
   * 1. "setoption"ָݵϢʺ"UCCI_COMM_SETOPTION"ָ
   *    "setoption"ָ趨ѡܵϢСѡ͡͡ѡֵ
   *    磬"setoption batch on"ѡ;"UCCI_OPTION_DEBUG"ֵ(Value.bCheck)"true"
   */
  struct {
    UcciOptionEnum Option; // ѡ
    union {                // ѡֵ
      int nSpin;           // "spin"͵ѡֵ
      bool bCheck;         // "check"͵ѡֵ
      UcciRepetEnum Repet; // "combo"͵ѡ"repetition"ֵ
      UcciGradeEnum Grade; // "combo"͵ѡ"pruning""knowledge""selectivity"ֵ
      UcciStyleEnum Style; // "combo"͵ѡ"style"ֵ
      char *szOption;      // "string"͵ѡֵ
    };                     // "button"͵ѡûֵ
  };

  /* 2. "position"ָݵϢʺ"e_CommPosition"ָ
   *    "position"ָþ棬ʼͬŷɵľ
   *    磬position startpos moves h2e2 h9g8FEN"startpos"FENŷ(MoveNum)2
   */
  struct {
    char *szFenStr;           // FEN("startpos")ҲɽתFEN
    int nMoveNum;             // ŷ
    uint32_t *lpdwMovesCoord; // ŷָ"IdleLine()"еһ̬飬԰"CoordList"
  };

  /* 3. "banmoves"ָݵϢʺ"e_CommBanMoves"ָ
   *    "banmoves"ָýֹŷݽṹʱ"position"ָĺŷûFEN
   */
  struct {
    int nBanMoveNum;
    uint32_t *lpdwBanMovesCoord;
  };

  /* 4. "go"ָݵϢʺ"UCCI_COMM_GOָ
   *    "go"ָ˼()ͬʱ趨˼ģʽ̶ȡʱƻǼʱ
   */
  struct {
    UcciGoEnum Go; // ˼ģʽ
    bool bPonder;  // ̨˼
    bool bDraw;    // 
    union {
      int nDepth, nNodes, nTime;
    }; // ȡʱ
    union {
      int nMovesToGo, nIncrement;
    }; // ޶ʱҪ߶ٲ(ʱ)ò޶ʱӶ(ʱ)
  };
};

// UCCIָڲͬ
UcciCommEnum BootLine(void);                                  // UCCIĵһָֻ"ucci"
UcciCommEnum IdleLine(UcciCommStruct &UcciComm, bool bDebug); // ʱָ
UcciCommEnum BusyLine(UcciCommStruct &UcciComm, bool bDebug); // ˼ʱָֻ"stop""ponderhit""probe"

#endif
