///////
   //    HtmlAttribute.cc
   //    HtmlAttribute Class definitions
   //
   //    Class for Html statements
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlAttribute.cc,v 1.8 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "HtmlAttribute.h"

// Static variables initialization
int HtmlAttribute::debug = 0;

// Static map of tags
HtmlAttribute::AttributesMap HtmlAttribute::AttrMap;

///////
   //    Construction
///////

HtmlAttribute::HtmlAttribute()
    : IDUrl(0), TagPosition(0), AttrPosition(0), Attribute(), LowercaseAttribute(), Content(), _attr_label(Attr_Unknown)
{
}

///////
   //    Destruction
///////

HtmlAttribute::~HtmlAttribute ()
{
}

///////
   //    Reset the schedule content
///////

void HtmlAttribute::Reset()
{
   IDUrl = 0;
   TagPosition = 0;
   AttrPosition = 0;
   Attribute.clear();
   LowercaseAttribute.clear();
   Content.clear();
   _attr_label = Attr_Unknown;
}


///////
   //    Output HtmlAttribute object
///////

std::ostream& operator<<(std::ostream& output, const HtmlAttribute& s)

{
   output << s.IDUrl << " / " << s.TagPosition << " / " << s.AttrPosition;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Attribute : " << s.Attribute << " - Content <"
      << s.Content << ">)";
   
   return output;
}

void HtmlAttribute::SetAttribute (const std::string &a)
{
    Attribute = a;
    LowercaseAttribute.clear();
    for (std::string::const_iterator c(a.begin());
	    c != a.end(); ++c) {
	LowercaseAttribute.push_back(tolower(*c));
    }

    // Assign the tag label
    AttributesMap::const_iterator e(AttrMap.find(LowercaseAttribute));
    if (e == AttrMap.end()) {
	_attr_label = Attr_Unknown;
	AttrMap.insert(std::make_pair(LowercaseAttribute, _attr_label)); // cache
	//std::cout << "Map " << LowercaseAttribute << " to UNKNOWN" << std::endl;
    }
    else {
	_attr_label = e->second;
	//std::cout << "Map " << LowercaseAttribute << " to " << e->second << std::endl;
    }
}

// Initialise the map of tags
void HtmlAttribute::initAttributesMap()
{
    if (AttrMap.empty()) {
	AttrMap.insert(std::make_pair("alt", Attr_ALT));
	AttrMap.insert(std::make_pair("href", Attr_HREF));
	AttrMap.insert(std::make_pair("id", Attr_ID));
	AttrMap.insert(std::make_pair("name", Attr_NAME));
	AttrMap.insert(std::make_pair("content", Attr_CONTENT));
	AttrMap.insert(std::make_pair("lang", Attr_LANG));
	AttrMap.insert(std::make_pair("xml:lang", Attr_XML_LANG));
	AttrMap.insert(std::make_pair("src", Attr_SRC));
	AttrMap.insert(std::make_pair("data", Attr_DATA));
	AttrMap.insert(std::make_pair("lowsrc", Attr_LOWSRC));
	AttrMap.insert(std::make_pair("type", Attr_TYPE));
	AttrMap.insert(std::make_pair("background", Attr_BACKGROUND));
    }
}

