/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "createdirdlg.h"


CreateDirWindow::CreateDirWindow(const QString caption)
        : QDialog(NULL, 0)
{
    setWindowTitle(caption);

    layout = new QGridLayout(this);

    lblInstructions = new QLabel(tr("Enter New Directory Name:"), this);
    lblInstructions->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

    dirTextBox = new QLineEdit("dirTextBox", this);
    dirTextBox->setText(tr("New Directory"));
    dirTextBox->setMinimumSize(100, 25);
    dirTextBox->setMaximumSize(1000, 25);
    dirTextBox->selectAll();

    btnCancel = new QPushButton(tr("Cancel"), this);
    btnCancel->setMaximumSize(200, 30);
    btnCancel->setDefault(FALSE);

    btnOk = new QPushButton("Ok", this);
    btnOk->setMaximumSize(200, 30);
    btnOk->setDefault(TRUE);

    connect(btnCancel, SIGNAL(clicked()),
            this, SLOT(btnCancelClicked()));
    connect(btnOk, SIGNAL(clicked()),
            this, SLOT(btnOkClicked()));

    layout->addWidget(lblInstructions, 1, 0, 1, 2);
    layout->addWidget(dirTextBox, 2, 0, 1, 2);
    layout->addWidget(btnCancel, 4, 0);
    layout->addWidget(btnOk, 4, 1);

    this->setModal(TRUE);
}

/*
 *  Destroys the object and frees any allocated resources
 */
CreateDirWindow::~CreateDirWindow()
{
    // no need to delete child widgets, Qt does it all for us
}

void CreateDirWindow::btnOkClicked()
{
    emit onOkClicked(dirTextBox->text());
    accept();
}

void CreateDirWindow::btnCancelClicked()
{
    emit onCancelClicked();
    reject();
}

void CreateDirWindow::setNewDirName(const QString &dirName)
{
    dirTextBox->setText(dirName);
    dirTextBox->selectAll();
}

