/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;

public class CyclicIteration<K, V>
implements Iterable<Map.Entry<K, V>> {
    private final NavigableMap<K, V> navigablemap;
    private final NavigableMap<K, V> tailmap;

    public CyclicIteration(NavigableMap<K, V> navigablemap, K startingkey) {
        if (navigablemap == null || navigablemap.isEmpty()) {
            this.navigablemap = null;
            this.tailmap = null;
        } else {
            this.navigablemap = navigablemap;
            this.tailmap = navigablemap.tailMap(startingkey, false);
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new CyclicIterator();
    }

    private class CyclicIterator
    implements Iterator<Map.Entry<K, V>> {
        private boolean hasnext;
        private Iterator<Map.Entry<K, V>> i;
        private final Map.Entry<K, V> first;
        private Map.Entry<K, V> next;

        private CyclicIterator() {
            boolean bl = this.hasnext = CyclicIteration.this.navigablemap != null;
            if (this.hasnext) {
                this.i = CyclicIteration.this.tailmap.entrySet().iterator();
                this.first = this.nextEntry();
                this.next = this.first;
            } else {
                this.i = null;
                this.first = null;
                this.next = null;
            }
        }

        private Map.Entry<K, V> nextEntry() {
            if (!this.i.hasNext()) {
                this.i = CyclicIteration.this.navigablemap.entrySet().iterator();
            }
            return this.i.next();
        }

        @Override
        public boolean hasNext() {
            return this.hasnext;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasnext) {
                throw new NoSuchElementException();
            }
            Map.Entry curr = this.next;
            this.next = this.nextEntry();
            this.hasnext = !((Object)this.next).equals(this.first);
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

