Prerequisites:

* `python3`
* `gcc` and/or `clang`
* [`libcpucycles`](https://cpucycles.cr.yp.to)
* [`librandombytes`](https://randombytes.cr.yp.to)

### For sysadmins

To install in `/usr/local/{include,lib,bin,man}`:

        ./configure && make -j8 install

### For developers with an unprivileged account

Typically you'll already have

        export LD_LIBRARY_PATH="$HOME/lib"
        export LIBRARY_PATH="$HOME/lib"
        export CPATH="$HOME/include"
        export PATH="$HOME/bin:$PATH"

in `$HOME/.profile`. To install in `$HOME/{include,lib,bin,man}`:

        ./configure --prefix=$HOME && make -j8 install

### For distributors creating a package

Run

        ./configure --prefix=/usr && make -j8

and then follow your usual packaging procedures for the
`build/0/package` files:

        build/0/package/include/lib25519.h
        build/0/package/lib/lib25519*
        build/0/package/bin/lib25519*
        build/0/package/man/man3/*.3
        build/0/package/man/man1/*.1

The `libcpucycles` and `librandombytes` packages are build-time and
run-time prerequisites; the `python3` and compiler packages are only
build-time prerequisites.

### More options

You can run

        ./configure --host=amd64

to override `./configure`'s guess of the architecture that it should
compile for. The architecture controls which implementations to try
(see `crypto_*/*/*/architectures`) and which compilers to try (see
`compilers/*`).

Inside the `build` directory, `0` is symlinked to `amd64` for
`--host=amd64`. Running `make clean` removes `build/amd64`. Re-running
`./configure` automatically starts with `make clean`.

A subsequent `./configure --host=arm64` will create `build/arm64` and
symlink `0 -> arm64`, without touching an existing `build/amd64`. However,
cross-compilers aren't yet selected automatically.
