/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import alt.jiapi.InstrumentationContext;
import alt.jiapi.JiapiException;
import alt.jiapi.Runtime;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.util.InstrumentationContextProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class InstrumentingClassLoader
extends URLClassLoader {
    private static Category log = Runtime.getLogCategory(InstrumentingClassLoader.class);
    protected Map classes;
    protected InstrumentationContext ctx;
    byte[] byteBuffer = new byte[65000];

    public static ClassLoader createClassLoader() {
        return InstrumentingClassLoader.createClassLoader((InstrumentationContext)null);
    }

    public static ClassLoader createClassLoader(InstrumentationContextProvider icp) throws JiapiException {
        return InstrumentingClassLoader.createClassLoader(icp.getInstrumentationContext());
    }

    public static ClassLoader createClassLoader(InstrumentationContextProvider icp, ClassLoader parent) throws JiapiException {
        return InstrumentingClassLoader.createClassLoader(icp.getInstrumentationContext(), parent);
    }

    public static ClassLoader createClassLoader(InstrumentationContext ctx) {
        return InstrumentingClassLoader.createClassLoader(ctx, InstrumentingClassLoader.getSystemClassLoader());
    }

    public static ClassLoader createClassLoader(InstrumentationContext ctx, ClassLoader parent) {
        URL[] urls = InstrumentingClassLoader.getClassPathUrls();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        return new InstrumentingClassLoader(ctx, urls, parent);
    }

    protected InstrumentingClassLoader(InstrumentationContext ctx, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.ctx = ctx;
        this.classes = Collections.synchronizedMap(new HashMap());
    }

    protected synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = null;
        JiapiClass jiapiClass = null;
        log.debug((Object)("loadClass(" + className + ")"));
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("alt.jiapi.")) {
            return this.getParent().loadClass(className);
        }
        cl = (Class<?>)this.classes.get(className);
        if (cl == null) {
            int i;
            log.debug((Object)("cache miss: " + className));
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && (i = className.lastIndexOf(46)) != -1) {
                sm.checkPackageAccess(className.substring(0, i));
            }
            if (this.ctx == null) {
                return this.bootstrap(className);
            }
            String path = className.replace('.', '/').concat(".class");
            URL location = super.findResource(path);
            if (location == null) {
                return this.getParent().loadClass(className);
            }
            try {
                jiapiClass = this.ctx.getLoader().loadClass(className, location);
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(className);
            }
            this.ctx.instrument(jiapiClass);
            byte[] bytes = jiapiClass.getByteCode();
            if (System.getProperty("dump") != null) {
                try {
                    jiapiClass.dump(new FileOutputStream(jiapiClass.getName() + ".dump"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (bytes != null) {
                CodeSource cs = this.createCodeSource(location);
                cl = this.defineClass(className, bytes, 0, bytes.length, cs);
            }
            log.debug((Object)(cl + " was loaded with " + cl.getClassLoader()));
            this.classes.put(className, cl);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    protected CodeSource createCodeSource(URL location) {
        Certificate[] certs = null;
        if (location.getProtocol().equals("jar")) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)location.openConnection();
                certs = jarConnection.getCertificates();
                location = jarConnection.getJarFileURL();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new RuntimeException(ioe.getMessage());
            }
        }
        return new CodeSource(location, certs);
    }

    private static URL[] getClassPathUrls() {
        String string = System.getProperty("java.class.path");
        ArrayList<URL> urls = new ArrayList<URL>();
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, File.pathSeparator);
            while (st.hasMoreTokens()) {
                try {
                    urls.add(new File(st.nextToken()).toURL());
                }
                catch (IOException iOException) {}
            }
        }
        return urls.toArray(new URL[0]);
    }

    public void setContext(InstrumentationContext ctx) {
        this.ctx = ctx;
    }

    public Class bootstrap(String className) throws ClassNotFoundException {
        String s = className.replace('.', '/') + ".class";
        return this.findClass(s);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        log.debug((Object)("findClass(" + name + ")"));
        Class<?> c = null;
        try {
            int elemsRead;
            URL url = this.findResource(name);
            if (url == null) {
                throw new ClassNotFoundException(name);
            }
            InputStream is = url.openStream();
            int count = 0;
            while (is.available() > 0 && (elemsRead = is.read(this.byteBuffer, count, is.available())) != -1) {
                count += elemsRead;
            }
            c = this.defineClass(name.substring(0, name.lastIndexOf(46)), this.byteBuffer, 0, count);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ClassNotFoundException(name);
        }
        this.classes.put(c.getName(), c);
        return c;
    }
}

