/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
/**
 * @defgroup XmlWbxmlPrivate WBXML Parser and Assembler Internals
 * @ingroup XmlPrivate
 * @brief XML parser and assembler details only known inside the internal XML/WBXML API.
 * 
 */
/*@{*/
 
#ifndef _SML_WBXML_INTERNALS_H_
#define _SML_WBXML_INTERNALS_H_

#include <wbxml.h>

SmlBool smlWbxmlConvertTo(WBXMLConvXML2WBXMLParams *params, const char *input, char **output, size_t *outputLen, SmlError** error);
SmlBool smlWbxmlConvertFrom(WBXMLConvWBXML2XMLParams *params, const char *input, size_t inputLen, char **output, size_t *outputLen, SmlError** error);

#endif //_SML_WBXML_INTERNALS_H_
/*@}*/
