/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes
#include <QList>


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "Polymer.hpp"
#include "Monomer.hpp"
#include "Modif.hpp"
#include "ChemicalGroup.hpp"

namespace MsXpS
{

namespace libXpertMass
{


class DECLSPEC PkaPhPi : public PropListHolder
{
  public:
  PkaPhPi(Polymer &,
          CalcOptions &,
          QList<Monomer *> * = 0,
          QList<Modif *>   * = 0);

  ~PkaPhPi();

  using PropListHolder::operator=;

  void setPh(double);
  double ph();

  double pi();
  double positiveCharges();
  double negativeCharges();

  void setCalcOptions(const CalcOptions &);

  void setMonomerList(QList<Monomer *> *);
  void setModifList(QList<Modif *> *);

  int calculateCharges();
  int calculatePi();

  double calculateChargeRatio(double, bool);

  int accountPolymerEndModif(PolymerChemEnt end_modif,
                             const ChemicalGroup &chemical_group);
  int accountMonomerModif(const Monomer &, ChemicalGroup &);

  protected:
  double m_ph = 7;
  double m_pi = 7;

  const Polymer &m_polymer;
  CalcOptions m_calcOptions;

  double m_positiveCharges = 0;
  double m_negativeCharges = 0;

  // Not allocated locally, but when set, *this takes ownership of
  // these lists, and these lists get freed upon destruction of *this.
  QList<Monomer *> *mpa_monomerList;
  QList<Modif *> *mpa_modifList;

  bool *mp_aborted = nullptr;
  int *mp_progress = nullptr;
};

} // namespace libXpertMass

} // namespace MsXpS
