/* $Id: Feature_field.cpp 443958 2014-08-20 17:34:00Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author: J. Chen
 *
 * File Description:
 *   DoesObjectMatchFeatureFieldConstraint
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Feature_field.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CFeature_field::~CFeature_field(void)
{
}

CSeqFeatData :: ESubtype CFeature_field :: GetFeatSubtype() const
{
   string strtmp
           = ENUM_METHOD_NAME(EMacro_feature_type)()->FindName(GetType(), true);
   if (strtmp == "cds") {
      strtmp = "cdregion";
   }
   else if (strtmp == "c-region") {
      strtmp = "C-region";
   }
   else if (strtmp == "caat-signal") {
      strtmp = "CAAT-signal";
   }
   else if (strtmp == "imp-CDS") {
      strtmp = "Imp-CDS";
   }
   else if (strtmp.substr(0,1) == "d-") {
      strtmp = "D-" + strtmp.substr(2);
   }
   else if (strtmp == "gC-signal") {
      strtmp = "GC-signal";
   }
   else if (strtmp == "j-segmrnt") {
      strtmp = "J-segment";
   }
   else if (strtmp == "ltr") {
      strtmp = "LTR";
   }
   else if (strtmp == "misc-RNA") {
      strtmp = "otherRNA";
   }
   else if (strtmp == "precursor-RNA") {
      strtmp = "preRNA";
   }
   else if (strtmp == "rbs") {
      strtmp = "RBS";
   }
   else if (strtmp == "s-region") {
      strtmp = "S-region";
   }
   else if (strtmp == "sts") {
      strtmp = "STS";
   }
   else if (strtmp == "tata-signal") {
      strtmp = "TATA-signal";
   }
   else if (strtmp.substr(0, 1) == "v-") {
      strtmp = "V-" + strtmp.substr(2);
   }
   else if (strtmp == "n35-signal") {
      strtmp = "35-signal";
   }
   else if (strtmp == "n10-signal") {
      strtmp = "10-signal";
   }
   else if (strtmp.find("n3") != string::npos
                  || strtmp.find("n5") != string::npos) {
      strtmp = strtmp.substr(1);
   }
   if (strtmp.empty()) {
       return CSeqFeatData::eSubtype_bad;
   }
   else {
       return (CSeqFeatData :: SubtypeNameToValue(strtmp));
   } 
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1732, CRC32: c3df647f */
