/*  $Id: ecnum_replaced.inc 580651 2019-02-19 12:38:48Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  The Enzyme Commission
 *
 * File Description:
 *   Built-in copy of ecnum_replaced.txt.
 *
 */

static const char* const kECNum_replaced[] = {
    "1.1.1.5\t1.1.1.303\t1.1.1.304",
    "1.1.1.63\t1.1.1.239",
    "1.1.1.68\t1.5.1.20",
    "1.1.1.70\t1.2.1.3",
    "1.1.1.89\t1.1.1.86",
    "1.1.1.109\t1.3.1.28",
    "1.1.1.139\t1.1.1.21",
    "1.1.1.155\t1.1.1.87",
    "1.1.1.158\t1.3.1.98",
    "1.1.1.171\t1.5.1.20",
    "1.1.1.180\t1.1.1.131",
    "1.1.1.182\t1.1.1.198\t1.1.1.227\t1.1.1.228",
    "1.1.1.204\t1.17.1.4",
    "1.1.1.242\t1.3.1.69",
    "1.1.1.246\t1.1.1.348\t4.2.1.139",
    "1.1.1.249\t2.5.1.46",
    "1.1.1.253\t1.5.1.33",
    "1.1.1.n1\t1.1.1.305",
    "1.1.1.n2\t1.1.1.300",
    "1.1.1.n3\t1.1.1.336",
    "1.1.1.n6\t1.1.1.369",
    "1.1.1.n7\t1.1.1.320",
    "1.1.1.n8\t1.1.1.366",
    "1.1.1.n9\t1.1.1.365",
    "1.1.1.n10\t1.1.1.301",
    "1.1.1.n13\t1.1.1.330",
    "1.1.1.n14\t1.1.1.347",
    "1.1.2.1\t1.1.5.3",
    "1.1.3.1\t1.1.3.15",
    "1.1.3.2\t1.13.12.4",
    "1.1.3.22\t1.17.3.2",
    "1.1.3.24\t1.3.3.12",
    "1.1.3.25\t1.1.99.18",
    "1.1.3.26\t1.21.3.2",
    "1.1.3.32\t1.14.19.64",
    "1.1.3.33\t1.14.19.65",
    "1.1.3.34\t1.14.19.66",
    "1.1.3.35\t1.14.19.67",
    "1.1.3.36\t1.14.19.68",
    "1.1.4.1\t1.17.4.4",
    "1.1.4.2\t1.17.4.5",
    "1.1.5.6\t1.17.5.3",
    "1.1.98.1\t1.1.9.1",
    "1.1.99.5\t1.1.5.3",
    "1.1.99.8\t1.1.2.7\t1.1.2.8",
    "1.1.99.10\t1.1.5.9",
    "1.1.99.15\t1.5.1.20",
    "1.1.99.16\t1.1.5.4",
    "1.1.99.17\t1.1.5.2",
    "1.1.99.19\t1.17.99.4",
    "1.1.99.23\t1.1.2.6",
    "1.1.99.25\t1.1.5.8",
    "1.1.99.33\t1.17.99.7",
    "1.1.99.34\t1.1.98.2",
    "1.2.1.1\t1.1.1.284\t4.4.1.22",
    "1.2.1.2\t1.17.1.9",
    "1.2.1.14\t1.1.1.205",
    "1.2.1.34\t1.1.1.131",
    "1.2.1.35\t1.1.1.203",
    "1.2.1.37\t1.17.1.4",
    "1.2.1.43\t1.17.1.10",
    "1.2.1.45\t1.1.1.312",
    "1.2.1.55\t1.1.1.279",
    "1.2.1.56\t1.1.1.280",
    "1.2.1.66\t1.1.1.306",
    "1.2.1.93\t1.17.1.11",
    "1.2.1.n1\t1.2.1.77",
    "1.2.1.n3\t1.2.1.86",
    "1.2.2.3\t1.17.2.3",
    "1.2.3.2\t1.17.3.2",
    "1.2.3.11\t1.2.3.1",
    "1.2.3.12\t1.14.13.82",
    "1.2.4.3\t1.2.4.4",
    "1.2.7.9\t1.2.7.3",
    "1.2.99.1\t1.17.99.4",
    "1.2.99.2\t1.2.7.4",
    "1.2.99.3\t1.2.5.2",
    "1.2.99.4\t1.2.98.1",
    "1.2.99.5\t1.2.7.12",
    "1.2.99.9\t1.17.98.3",
    "1.3.1.4\t1.3.1.22",
    "1.3.1.26\t1.17.1.8",
    "1.3.1.30\t1.3.1.22",
    "1.3.1.35\t1.14.19.22",
    "1.3.1.50\t1.1.1.252",
    "1.3.1.52\t1.3.8.5",
    "1.3.1.63\t1.21.1.2",
    "1.3.1.80\t1.3.7.12",
    "1.3.1.n1\t1.3.1.87",
    "1.3.1.n2\t1.14.19.52",
    "1.3.2.1\t1.3.8.1",
    "1.3.2.2\t1.3.8.7",
    "1.3.3.1\t1.3.98.1",
    "1.3.3.2\t1.14.19.20",
    "1.3.3.9\t1.14.19.62",
    "1.3.7.10\t1.14.19.8",
    "1.3.98.2\t1.3.4.1",
    "1.3.99.2\t1.3.8.1",
    "1.3.99.3\t1.3.8.7\t1.3.8.8\t1.3.8.9",
    "1.3.99.7\t1.3.8.6",
    "1.3.99.9\t1.21.99.1",
    "1.3.99.10\t1.3.8.4",
    "1.3.99.11\t1.3.5.2",
    "1.3.99.13\t1.3.8.8",
    "1.3.99.15\t1.3.7.8",
    "1.3.99.20\t1.3.7.9",
    "1.3.99.21\t1.3.8.3",
    "1.3.99.22\t1.3.98.3",
    "1.3.99.34\t1.3.7.11",
    "1.3.99.35\t1.3.7.15",
    "1.3.99.n2\t4.1.99.19",
    "1.3.99.n3\t1.3.99.36",
    "1.4.1.6\t1.21.4.1",
    "1.4.3.6\t1.4.3.21\t1.4.3.22",
    "1.4.3.9\t1.4.3.4",
    "1.4.3.17\t1.3.3.10",
    "1.4.4.1\t1.21.4.1",
    "1.4.98.1\t1.4.9.1",
    "1.4.99.1\t1.4.99.6",
    "1.4.99.3\t1.4.9.1",
    "1.4.99.4\t1.4.9.2",
    "1.5.1.4\t1.5.1.3",
    "1.5.1.12\t1.2.1.88",
    "1.5.1.13\t1.17.1.5",
    "1.5.1.14\t1.5.1.21",
    "1.5.1.29\t1.5.1.38\t1.5.1.39\t1.5.1.41",
    "1.5.1.35\t1.2.1.19",
    "1.5.3.8\t1.3.3.8",
    "1.5.3.9\t1.21.3.3",
    "1.5.3.11\t1.5.3.13\t1.5.3.14\t1.5.3.15\t1.5.3.16\t1.5.3.17",
    "1.5.3.n1\t1.5.3.16",
    "1.5.3.n2\t1.5.3.16",
    "1.5.3.n3\t1.5.3.13\t1.5.3.16",
    "1.5.3.n4\t1.5.3.13",
    "1.5.3.n5\t1.5.3.16",
    "1.5.3.n6\t1.5.3.14\t1.5.3.15",
    "1.5.3.n7\t1.5.3.14\t1.5.3.15",
    "1.5.3.n8\t1.5.3.14\t1.5.3.15",
    "1.5.3.n9\t1.5.3.14\t1.5.3.15",
    "1.5.3.n10\t1.5.3.13",
    "1.5.99.1\t1.5.8.3",
    "1.5.99.2\t1.5.8.4",
    "1.5.99.7\t1.5.8.2",
    "1.5.99.8\t1.5.5.2",
    "1.5.99.9\t1.5.98.1",
    "1.5.99.10\t1.5.8.1",
    "1.5.99.11\t1.5.98.2",
    "1.6.1.5\t7.1.1.1",
    "1.6.2.1\t1.6.99.3",
    "1.6.4.1\t1.8.1.6",
    "1.6.4.2\t1.8.1.7",
    "1.6.4.3\t1.8.1.4",
    "1.6.4.4\t1.8.1.8",
    "1.6.4.5\t1.8.1.9",
    "1.6.4.6\t1.8.1.10",
    "1.6.4.7\t1.8.1.11",
    "1.6.4.8\t1.8.1.12",
    "1.6.4.9\t1.8.1.13",
    "1.6.4.10\t1.8.1.14",
    "1.6.5.3\t7.1.1.2",
    "1.6.5.8\t7.2.1.1",
    "1.6.6.1\t1.7.1.1",
    "1.6.6.2\t1.7.1.2",
    "1.6.6.3\t1.7.1.3",
    "1.6.6.4\t1.7.1.4",
    "1.6.6.5\t1.7.2.1",
    "1.6.6.6\t1.7.1.5",
    "1.6.6.7\t1.7.1.6",
    "1.6.6.8\t1.7.1.7",
    "1.6.6.10\t1.7.1.9",
    "1.6.6.11\t1.7.1.10",
    "1.6.6.12\t1.7.1.11",
    "1.6.6.13\t1.7.1.12",
    "1.6.7.1\t1.18.1.2",
    "1.6.7.2\t1.18.1.1",
    "1.6.8.1\t1.5.1.38\t1.5.1.39\t1.5.1.41",
    "1.6.8.2\t1.5.1.30",
    "1.6.99.2\t1.6.5.2",
    "1.6.99.4\t1.18.1.2",
    "1.6.99.5\t1.6.5.11",
    "1.6.99.6\t1.6.5.10",
    "1.6.99.7\t1.5.1.34",
    "1.6.99.8\t1.16.1.3",
    "1.6.99.9\t1.16.1.4",
    "1.6.99.10\t1.5.1.34",
    "1.6.99.11\t1.16.1.5",
    "1.6.99.12\t1.16.1.6",
    "1.6.99.13\t1.16.1.7",
    "1.7.3.4\t1.7.2.6\t1.7.3.6",
    "1.7.99.3\t1.7.2.1",
    "1.7.99.5\t1.5.1.20",
    "1.7.99.6\t1.7.2.4",
    "1.7.99.7\t1.7.2.5",
    "1.7.99.8\t1.7.2.8",
    "1.8.4.5\t1.8.4.13\t1.8.4.14",
    "1.8.4.6\t1.8.4.11",
    "1.8.6.1\t2.5.1.18",
    "1.8.99.3\t1.8.99.5",
    "1.8.99.4\t1.8.4.8",
    "1.9.3.2\t1.7.2.1",
    "1.9.99.1\t1.9.98.1",
    "1.10.3.7\t1.21.3.4",
    "1.10.3.8\t1.21.3.5",
    "1.10.3.10\t7.1.1.3",
    "1.10.3.12\t7.1.1.5",
    "1.10.3.13\t7.1.1.4",
    "1.10.3.14\t7.1.1.7",
    "1.10.9.1\t7.1.1.6",
    "1.10.99.1\t7.1.1.6",
    "1.10.99.2\t1.10.5.1",
    "1.10.99.3\t1.23.5.1",
    "1.11.1.4\t1.13.11.11",
    "1.12.1.1\t1.12.7.2",
    "1.12.7.1\t1.12.7.2",
    "1.12.99.1\t1.12.98.1",
    "1.12.99.3\t1.12.5.1",
    "1.12.99.4\t1.12.98.2",
    "1.12.99.5\t1.13.11.47",
    "1.13.1.1\t1.13.11.1",
    "1.13.1.2\t1.13.11.2",
    "1.13.1.3\t1.13.11.3",
    "1.13.1.4\t1.13.11.4",
    "1.13.1.5\t1.13.11.5",
    "1.13.1.6\t1.13.11.6",
    "1.13.1.8\t1.13.11.8",
    "1.13.1.9\t1.13.11.9",
    "1.13.1.10\t1.13.11.10",
    "1.13.1.11\t1.13.99.1",
    "1.13.1.12\t1.13.11.11",
    "1.13.1.13\t1.13.11.12",
    "1.13.11.21\t1.13.11.63",
    "1.13.11.32\t1.13.12.16",
    "1.13.11.44\t1.13.11.60\t5.4.4.6",
    "1.13.11.n1\t1.13.11.74",
    "1.13.11.n2\t1.13.11.63",
    "1.13.12.11\t1.14.13.8",
    "1.13.12.12\t1.13.11.67",
    "1.13.12.14\t1.14.13.122",
    "1.13.99.2\t1.14.12.10",
    "1.13.99.4\t1.14.12.9",
    "1.13.99.5\t1.13.11.47",
    "1.14.1.1\t1.14.14.1",
    "1.14.1.2\t1.14.13.9",
    "1.14.1.3\t1.14.14.17\t5.4.99.7",
    "1.14.1.4\t1.14.99.2",
    "1.14.1.5\t1.14.13.5",
    "1.14.1.6\t1.14.15.4",
    "1.14.1.7\t1.14.14.19",
    "1.14.1.8\t1.14.14.16",
    "1.14.1.10\t1.14.99.11",
    "1.14.2.1\t1.14.17.1",
    "1.14.2.2\t1.13.11.27",
    "1.14.3.1\t1.14.16.1",
    "1.14.11.5\t1.14.11.6",
    "1.14.11.14\t1.14.20.13",
    "1.14.11.19\t1.14.20.4",
    "1.14.11.22\t1.14.20.5",
    "1.14.11.23\t1.14.20.6",
    "1.14.11.34\t1.14.20.7",
    "1.14.11.50\t1.14.20.8",
    "1.14.11.n1\t1.14.11.39",
    "1.14.11.n3\t1.14.11.56",
    "1.14.12.2\t1.14.13.35",
    "1.14.12.4\t1.14.13.242",
    "1.14.12.5\t1.14.13.241",
    "1.14.12.6\t1.14.13.66",
    "1.14.12.20\t1.14.15.17",
    "1.14.12.21\t1.14.13.208",
    "1.14.12.n1\t1.14.13.208",
    "1.14.13.3\t1.14.14.9",
    "1.14.13.11\t1.14.14.91",
    "1.14.13.12\t1.14.14.92",
    "1.14.13.13\t1.14.15.18",
    "1.14.13.15\t1.14.15.15",
    "1.14.13.17\t1.14.14.23",
    "1.14.13.21\t1.14.14.82",
    "1.14.13.26\t1.14.18.4",
    "1.14.13.28\t1.14.14.93",
    "1.14.13.30\t1.14.14.94",
    "1.14.13.36\t1.14.14.96",
    "1.14.13.37\t1.14.14.97",
    "1.14.13.41\t1.14.14.36",
    "1.14.13.45\t1.14.18.2",
    "1.14.13.47\t1.14.14.99",
    "1.14.13.48\t1.14.14.51",
    "1.14.13.49\t1.14.14.52",
    "1.14.13.52\t1.14.14.88",
    "1.14.13.53\t1.14.14.89",
    "1.14.13.55\t1.14.14.98",
    "1.14.13.56\t1.14.14.100",
    "1.14.13.57\t1.14.14.101",
    "1.14.13.60\t1.14.14.29",
    "1.14.13.67\t1.14.14.55",
    "1.14.13.68\t1.14.14.37",
    "1.14.13.70\t1.14.14.154",
    "1.14.13.71\t1.14.14.102",
    "1.14.13.72\t1.14.18.9",
    "1.14.13.73\t1.14.14.103",
    "1.14.13.74\t1.14.14.85",
    "1.14.13.75\t1.14.14.104",
    "1.14.13.76\t1.14.14.105",
    "1.14.13.77\t1.14.14.106",
    "1.14.13.78\t1.14.14.86",
    "1.14.13.79\t1.14.14.107",
    "1.14.13.80\t1.14.14.53",
    "1.14.13.85\t1.14.14.135",
    "1.14.13.86\t1.14.13.136",
    "1.14.13.87\t1.14.14.140",
    "1.14.13.88\t1.14.14.81",
    "1.14.13.89\t1.14.14.90",
    "1.14.13.90\t1.14.15.21",
    "1.14.13.91\t1.14.14.136",
    "1.14.13.93\t1.14.14.137",
    "1.14.13.94\t1.14.14.138",
    "1.14.13.95\t1.14.18.8",
    "1.14.13.96\t1.14.14.139",
    "1.14.13.97\t1.14.14.57",
    "1.14.13.98\t1.14.14.25",
    "1.14.13.99\t1.14.14.26",
    "1.14.13.100\t1.14.14.29",
    "1.14.13.102\t1.14.14.141",
    "1.14.13.103\t1.14.14.142",
    "1.14.13.104\t1.14.14.143",
    "1.14.13.108\t1.14.14.144",
    "1.14.13.109\t1.14.14.145",
    "1.14.13.110\t1.14.14.146",
    "1.14.13.112\t1.14.14.147",
    "1.14.13.115\t1.14.14.148",
    "1.14.13.117\t1.14.14.39",
    "1.14.13.118\t1.14.14.38",
    "1.14.13.119\t1.14.14.149",
    "1.14.13.120\t1.14.14.150",
    "1.14.13.121\t1.14.14.151",
    "1.14.13.123\t1.14.14.95",
    "1.14.13.124\t1.14.14.40",
    "1.14.13.125\t1.14.14.156",
    "1.14.13.126\t1.14.15.16",
    "1.14.13.129\t1.14.15.24",
    "1.14.13.132\t1.14.14.17",
    "1.14.13.133\t1.14.15.32",
    "1.14.13.134\t1.14.14.152",
    "1.14.13.136\t1.14.14.87",
    "1.14.13.137\t1.14.14.153",
    "1.14.13.138\t1.14.14.157",
    "1.14.13.139\t1.14.14.109",
    "1.14.13.140\t1.14.14.110",
    "1.14.13.141\t1.14.15.29",
    "1.14.13.142\t1.14.15.30",
    "1.14.13.143\t1.14.14.76",
    "1.14.13.144\t1.14.14.111",
    "1.14.13.145\t1.14.14.112",
    "1.14.13.150\t1.14.14.113",
    "1.14.13.151\t1.14.14.84",
    "1.14.13.152\t1.14.14.83",
    "1.14.13.156\t1.14.14.133",
    "1.14.13.157\t1.14.14.56",
    "1.14.13.158\t1.14.14.114",
    "1.14.13.159\t1.14.14.24",
    "1.14.13.162\t1.14.14.108",
    "1.14.13.164\t1.13.11.65",
    "1.14.13.165\t1.14.14.47",
    "1.14.13.169\t1.14.18.5",
    "1.14.13.173\t1.14.14.115",
    "1.14.13.174\t1.14.14.116",
    "1.14.13.175\t1.14.14.117",
    "1.14.13.176\t1.14.14.118",
    "1.14.13.177\t1.14.14.119",
    "1.14.13.183\t1.14.14.120",
    "1.14.13.184\t1.14.14.121",
    "1.14.13.185\t1.14.15.33",
    "1.14.13.186\t1.14.15.34",
    "1.14.13.188\t1.14.15.35",
    "1.14.13.191\t1.14.14.70",
    "1.14.13.192\t1.14.14.122",
    "1.14.13.193\t1.14.14.123",
    "1.14.13.194\t1.14.14.78",
    "1.14.13.197\t1.14.14.124",
    "1.14.13.198\t1.14.14.125",
    "1.14.13.199\t1.14.14.79",
    "1.14.13.201\t1.14.14.126",
    "1.14.13.202\t1.14.14.127",
    "1.14.13.203\t1.14.14.128",
    "1.14.13.204\t1.14.14.129",
    "1.14.13.205\t1.14.14.80",
    "1.14.13.206\t1.14.14.130",
    "1.14.13.207\t1.14.14.31",
    "1.14.13.213\t1.14.14.131",
    "1.14.13.214\t1.14.14.132",
    "1.14.13.221\t1.14.15.28",
    "1.14.13.n1\t1.14.14.40",
    "1.14.13.n2\t1.14.14.156",
    "1.14.13.n3\t1.14.13.127",
    "1.14.13.n4\t1.14.15.16",
    "1.14.13.n5\t1.14.14.42",
    "1.14.13.n8\t1.14.14.41",
    "1.14.13.n9\t1.14.13.149",
    "1.14.14.2\t1.14.14.1",
    "1.14.14.4\t1.14.15.7",
    "1.14.14.6\t1.14.13.111",
    "1.14.14.7\t1.14.19.9",
    "1.14.14.n1\t1.14.99.46",
    "1.14.15.2\t1.14.14.108",
    "1.14.15.12\t1.14.14.46",
    "1.14.17.2\t1.14.18.1",
    "1.14.19.7\t1.11.1.23",
    "1.14.19.n1\t1.14.19.4",
    "1.14.19.n2\t1.14.19.5",
    "1.14.19.n3\t1.14.19.6",
    "1.14.20.2\t1.14.11.59",
    "1.14.21.1\t1.14.19.64",
    "1.14.21.2\t1.14.19.65",
    "1.14.21.3\t1.14.19.66",
    "1.14.21.4\t1.14.19.67",
    "1.14.21.5\t1.14.19.68",
    "1.14.21.6\t1.14.19.20",
    "1.14.21.7\t1.14.19.69",
    "1.14.21.8\t1.14.19.63",
    "1.14.21.9\t1.14.19.70",
    "1.14.21.10\t1.14.19.71",
    "1.14.21.11\t1.14.19.72",
    "1.14.21.12\t1.14.19.73",
    "1.14.99.3\t1.14.14.18",
    "1.14.99.5\t1.14.19.1",
    "1.14.99.6\t1.14.19.2",
    "1.14.99.7\t1.14.14.17",
    "1.14.99.8\t1.14.14.1",
    "1.14.99.9\t1.14.14.19",
    "1.14.99.10\t1.14.14.16",
    "1.14.99.13\t1.14.13.23",
    "1.14.99.16\t1.14.18.9",
    "1.14.99.17\t1.14.16.5",
    "1.14.99.25\t1.14.19.3",
    "1.14.99.27\t1.17.3.4",
    "1.14.99.28\t1.14.14.84",
    "1.14.99.30\t1.3.5.6",
    "1.14.99.31\t1.14.19.24",
    "1.14.99.32\t1.14.19.5",
    "1.14.99.33\t1.14.19.39",
    "1.14.99.36\t1.13.11.63",
    "1.14.99.40\t1.13.11.79",
    "1.14.99.41\t1.13.11.75",
    "1.14.99.42\t1.13.11.84",
    "1.14.99.43\t1.14.14.134",
    "1.14.99.45\t1.14.14.158",
    "1.14.99.49\t1.14.15.31",
    "1.14.99.n1\t1.13.11.75",
    "1.14.99.n2\t1.13.11.71",
    "1.14.99.n3\t1.13.11.84",
    "1.14.99.n5\t1.13.11.70",
    "1.16.5.1\t7.2.1.3",
    "1.16.98.1\t1.16.9.1",
    "1.17.1.2\t1.17.7.4",
    "1.17.1.6\t1.1.1.395",
    "1.17.1.7\t1.2.1.91",
    "1.17.4.3\t1.17.7.1",
    "1.17.98.1\t1.1.1.395",
    "1.17.99.1\t1.17.9.1",
    "1.17.99.5\t1.1.1.395",
    "1.18.1.8\t7.2.1.2",
    "1.18.2.1\t1.18.6.1",
    "1.18.3.1\t1.12.7.2",
    "1.18.96.1\t1.15.1.2",
    "1.18.99.1\t1.12.7.2",
    "1.20.98.1\t1.20.9.1",
    "1.21.3.9\t1.21.98.2",
    "1.21.99.2\t1.21.98.1",
    "1.22.1.1\t1.21.1.1",
    "1.97.1.3\t1.12.98.4",
    "1.97.1.5\t1.20.4.1",
    "1.97.1.6\t1.20.99.1",
    "1.97.1.7\t1.20.4.2",
    "1.97.1.8\t1.21.99.5",
    "1.97.1.10\t1.21.99.4",
    "1.97.1.11\t1.21.99.3",
    "1.98.1.1\t1.12.7.2",
    "1.99.1.1\t1.14.14.1",
    "1.99.1.2\t1.14.16.1",
    "1.99.1.5\t1.14.13.9",
    "1.99.1.7\t1.14.15.4",
    "1.99.1.9\t1.14.14.19",
    "1.99.1.11\t1.14.14.16",
    "1.99.1.13\t1.14.14.17\t5.4.99.7",
    "1.99.1.14\t1.13.11.27",
    "1.99.2.1\t1.13.11.12",
    "1.99.2.2\t1.13.11.1",
    "1.99.2.3\t1.13.11.3",
    "1.99.2.4\t1.13.11.4",
    "1.99.2.5\t1.13.11.5",
    "1.99.2.6\t1.13.99.1",
    "2.1.1.23\t2.1.1.319\t2.1.1.320\t2.1.1.321\t2.1.1.322",
    "2.1.1.24\t2.1.1.77\t2.1.1.80\t2.1.1.100",
    "2.1.1.29\t2.1.1.202\t2.1.1.203\t2.1.1.204",
    "2.1.1.31\t2.1.1.221\t2.1.1.228",
    "2.1.1.32\t2.1.1.213\t2.1.1.214\t2.1.1.215\t2.1.1.216",
    "2.1.1.36\t2.1.1.217\t2.1.1.218\t2.1.1.219\t2.1.1.220",
    "2.1.1.48\t2.1.1.181\t2.1.1.182\t2.1.1.183\t2.1.1.184",
    "2.1.1.51\t2.1.1.187\t2.1.1.188",
    "2.1.1.52\t2.1.1.171\t2.1.1.172\t2.1.1.173\t2.1.1.174",
    "2.1.1.58\t2.1.1.57",
    "2.1.1.66\t2.1.1.230",
    "2.1.1.73\t2.1.1.37",
    "2.1.1.81\t2.1.1.49",
    "2.1.1.92\t2.1.1.69",
    "2.1.1.93\t2.1.1.70",
    "2.1.1.124\t2.1.1.319\t2.1.1.320\t2.1.1.321\t2.1.1.322",
    "2.1.1.125\t2.1.1.319\t2.1.1.320\t2.1.1.321\t2.1.1.322",
    "2.1.1.126\t2.1.1.319\t2.1.1.320\t2.1.1.321\t2.1.1.322",
    "2.1.1.134\t2.1.1.129",
    "2.1.1.135\t1.16.1.8",
    "2.1.1.149\t2.1.1.267",
    "2.1.1.n2\t2.1.1.211",
    "2.1.1.n3\t2.1.1.280",
    "2.1.1.n5\t2.1.1.244",
    "2.1.1.n6\t2.1.1.255",
    "2.1.1.n9\t2.1.1.274",
    "2.1.1.n10\t2.1.1.278",
    "2.1.1.n12\t2.1.1.329",
    "2.1.1.n13\t2.1.1.301",
    "2.1.1.n14\t2.1.1.300",
    "2.1.1.n15\t2.1.1.298",
    "2.1.1.n16\t2.1.1.297",
    "2.1.2.6\t2.1.2.5",
    "2.1.2.12\t2.1.1.74",
    "2.1.2.n1\t2.1.2.13",
    "2.1.3.13\t6.1.2.2",
    "2.1.3.14\t6.1.2.2",
    "2.3.1.55\t2.3.1.82",
    "2.3.1.88\t2.3.1.254\t2.3.1.255\t2.3.1.256\t2.3.1.257\t2.3.1.258\t2.3.1.259",
    "2.3.1.104\t2.3.1.25",
    "2.3.1.119\t1.1.1.330\t1.3.1.93\t2.3.1.199\t4.2.1.134",
    "2.3.1.128\t2.3.1.267",
    "2.3.1.154\t2.3.1.176",
    "2.3.1.n1\t2.3.1.191",
    "2.3.1.n2\t2.3.1.274",
    "2.3.1.n3\t2.3.1.275",
    "2.3.1.n8\t2.3.1.199",
    "2.3.1.n9\t2.3.1.211",
    "2.3.1.n10\t2.3.1.222",
    "2.3.1.n11\t2.3.1.223",
    "2.3.2.4\t4.3.2.9",
    "2.4.1.3\t2.4.1.25",
    "2.4.1.42\t2.4.1.17",
    "2.4.1.45\t2.4.1.47",
    "2.4.1.51\t2.4.1.101\t2.4.1.143\t2.4.1.144\t2.4.1.145",
    "2.4.1.55\t2.7.8.14",
    "2.4.1.57\t2.4.1.345",
    "2.4.1.59\t2.4.1.17",
    "2.4.1.61\t2.4.1.17",
    "2.4.1.72\t2.4.2.24",
    "2.4.1.76\t2.4.1.17",
    "2.4.1.77\t2.4.1.17",
    "2.4.1.84\t2.4.1.17",
    "2.4.1.89\t2.4.1.69",
    "2.4.1.93\t4.2.2.18",
    "2.4.1.98\t2.4.1.90",
    "2.4.1.107\t2.4.1.17",
    "2.4.1.108\t2.4.1.17",
    "2.4.1.112\t2.4.1.186",
    "2.4.1.119\t2.4.99.18",
    "2.4.1.124\t2.4.1.87",
    "2.4.1.130\t2.4.1.258\t2.4.1.259\t2.4.1.260\t2.4.1.261",
    "2.4.1.151\t2.4.1.87",
    "2.4.1.157\t2.4.1.336\t2.4.1.337",
    "2.4.1.163\t2.4.1.149",
    "2.4.1.169\t2.4.2.39",
    "2.4.1.200\t4.2.2.17",
    "2.4.1.204\t2.4.2.40",
    "2.4.1.233\t2.4.1.115",
    "2.4.1.307\t2.4.1.122",
    "2.4.1.n1\t2.4.1.245",
    "2.4.1.n3\t2.4.1.250",
    "2.4.1.n4\t2.4.1.131",
    "2.4.1.n5\t2.4.99.16",
    "2.4.2.11\t6.3.4.21",
    "2.4.2.13\t2.5.1.6",
    "2.4.2.23\t2.4.2.2\t2.4.2.3\t2.4.2.4",
    "2.4.2.n1\t2.4.2.43",
    "2.4.99.11\t2.4.99.1",
    "2.5.1.8\t2.5.1.75",
    "2.5.1.11\t2.5.1.84\t2.5.1.85",
    "2.5.1.12\t2.5.1.18",
    "2.5.1.13\t2.5.1.18",
    "2.5.1.14\t2.5.1.18",
    "2.5.1.33\t2.5.1.82\t2.5.1.83",
    "2.5.1.37\t4.4.1.20",
    "2.5.1.40\t4.2.3.9",
    "2.5.1.64\t2.2.1.9\t4.2.99.20",
    "2.5.1.77\t2.5.1.147",
    "2.5.1.n1\t2.2.1.9",
    "2.5.1.n2\t2.5.1.81",
    "2.5.1.n3\t2.5.1.73",
    "2.5.1.n4\t2.5.1.112",
    "2.5.1.n5\t2.5.1.113",
    "2.5.1.n6\t2.5.1.105",
    "2.5.1.n7\t2.5.1.108",
    "2.5.1.n8\t2.5.1.115",
    "2.6.1.10\t2.6.1.21",
    "2.6.1.25\t2.6.1.24",
    "2.6.1.53\t1.4.1.13",
    "2.6.1.61\t2.6.1.40",
    "2.6.1.91\t2.6.1.34",
    "2.6.1.n1\t2.6.1.87",
    "2.6.1.n2\t2.6.1.105",
    "2.6.2.1\t2.1.4.1",
    "2.6.99.4\t2.3.1.234",
    "2.7.1.37\t2.7.11.1\t2.7.11.8\t2.7.11.9\t2.7.11.10\t2.7.11.11\t2.7.11.12\t2.7.11.13\t2.7.11.21\t2.7.11.22\t2.7.11.24\t2.7.11.25\t2.7.11.30\t2.7.12.1",
    "2.7.1.38\t2.7.11.19",
    "2.7.1.69\t2.7.1.191\t2.7.1.192\t2.7.1.193\t2.7.1.194\t2.7.1.195\t2.7.1.196\t2.7.1.197\t2.7.1.198\t2.7.1.199\t2.7.1.200\t2.7.1.201\t2.7.1.202\t2.7.1.203\t2.7.1.204\t2.7.1.205\t2.7.1.206\t2.7.1.207\t2.7.1.208",
    "2.7.1.70\t2.7.11.1",
    "2.7.1.75\t2.7.1.21",
    "2.7.1.96\t2.7.1.86",
    "2.7.1.97\t2.7.11.14",
    "2.7.1.99\t2.7.11.2",
    "2.7.1.104\t2.7.99.1",
    "2.7.1.109\t2.7.11.31",
    "2.7.1.110\t2.7.11.3",
    "2.7.1.111\t2.7.11.27",
    "2.7.1.112\t2.7.10.1\t2.7.10.2",
    "2.7.1.115\t2.7.11.4",
    "2.7.1.116\t2.7.11.5",
    "2.7.1.117\t2.7.11.18",
    "2.7.1.120\t2.7.11.17",
    "2.7.1.123\t2.7.11.17",
    "2.7.1.124\t2.7.11.6",
    "2.7.1.125\t2.7.11.14",
    "2.7.1.126\t2.7.11.15",
    "2.7.1.128\t2.7.11.27",
    "2.7.1.129\t2.7.11.7",
    "2.7.1.131\t2.7.11.29",
    "2.7.1.132\t2.7.11.28",
    "2.7.1.133\t2.7.1.134",
    "2.7.1.135\t2.7.11.26",
    "2.7.1.139\t2.7.1.134",
    "2.7.1.141\t2.7.11.23",
    "2.7.1.152\t2.7.4.21",
    "2.7.1.155\t2.7.4.24",
    "2.7.1.n1\t2.7.1.170",
    "2.7.1.n2\t2.7.1.161",
    "2.7.1.n3\t2.7.1.164",
    "2.7.1.n4\t2.7.1.173",
    "2.7.1.n5\t2.7.1.174",
    "2.7.1.n6\t2.7.1.163",
    "2.7.1.n7\t2.7.1.176",
    "2.7.1.n8\t2.7.1.175",
    "2.7.2.5\t6.3.4.16",
    "2.7.2.9\t6.3.5.5",
    "2.7.3.11\t2.7.13.1",
    "2.7.3.12\t2.7.13.2",
    "2.7.4.5\t2.7.4.14",
    "2.7.4.30\t2.7.8.43",
    "2.7.4.n1\t2.7.4.27",
    "2.7.4.n2\t2.7.4.28",
    "2.7.5.1\t5.4.2.2",
    "2.7.5.2\t5.4.2.3",
    "2.7.5.3\t5.4.2.11\t5.4.2.12",
    "2.7.5.4\t5.4.2.4",
    "2.7.5.5\t5.4.2.5",
    "2.7.5.6\t5.4.2.7",
    "2.7.5.7\t5.4.2.8",
    "2.7.7.16\t3.1.27.5",
    "2.7.7.17\t3.1.27.1",
    "2.7.7.21\t2.7.7.72",
    "2.7.7.25\t2.7.7.72",
    "2.7.7.26\t3.1.27.3",
    "2.7.7.29\t2.7.7.28",
    "2.7.7.54\t6.3.2.40",
    "2.7.7.55\t6.3.2.40",
    "2.7.7.63\t6.3.1.20",
    "2.7.7.94\t6.2.1.51",
    "2.7.7.95\t6.2.1.49",
    "2.7.7.98\t6.2.1.50",
    "2.7.7.n2\t2.7.7.67",
    "2.7.7.n3\t2.7.7.73",
    "2.7.7.n4\t2.7.7.80",
    "2.7.7.n5\t2.7.7.75",
    "2.7.8.16\t2.7.8.2",
    "2.7.8.25\t2.4.2.52",
    "2.7.8.30\t2.4.2.53",
    "2.7.8.n1\t2.4.2.53",
    "2.7.8.n2\t2.7.8.33",
    "2.7.11.n1\t2.7.11.32",
    "2.7.11.n2\t2.7.11.33",
    "2.8.1.n1\t2.8.1.11",
    "2.8.2.12\t2.8.2.8",
    "2.8.2.n1\t2.8.2.20",
    "2.9.1.n1\t2.9.1.2",
    "3.1.1.12\t3.1.1.1",
    "3.1.1.16\t3.1.1.24\t5.3.3.4",
    "3.1.1.18\t3.1.1.17",
    "3.1.1.62\t3.5.1.47",
    "3.1.1.69\t3.5.1.89",
    "3.1.1.n1\t3.5.1.103",
    "3.1.2.8\t3.1.2.6",
    "3.1.2.24\t3.13.1.3",
    "3.1.2.26\t2.8.3.25",
    "3.1.2.n1\t3.1.2.28",
    "3.1.2.n2\t3.1.2.30",
    "3.1.3.30\t3.1.3.31",
    "3.1.3.65\t3.1.3.64",
    "3.1.3.98\t3.6.1.68",
    "3.1.3.n1\t3.1.3.86",
    "3.1.3.n2\t3.1.3.84",
    "3.1.3.n3\t3.1.3.78",
    "3.1.3.n4\t3.1.3.87",
    "3.1.3.n5\t3.1.3.93",
    "3.1.3.n6\t3.1.3.96",
    "3.1.4.5\t3.1.21.1",
    "3.1.4.6\t3.1.22.1",
    "3.1.4.7\t3.1.31.1",
    "3.1.4.8\t3.1.27.3",
    "3.1.4.9\t3.1.30.2",
    "3.1.4.10\t4.6.1.13",
    "3.1.4.15\t2.7.7.89",
    "3.1.4.18\t3.1.16.1",
    "3.1.4.19\t3.1.13.3",
    "3.1.4.20\t3.1.13.1",
    "3.1.4.21\t3.1.30.1",
    "3.1.4.22\t3.1.27.5",
    "3.1.4.23\t3.1.27.1",
    "3.1.4.25\t3.1.11.1",
    "3.1.4.27\t3.1.11.2",
    "3.1.4.28\t3.1.11.3",
    "3.1.4.30\t3.1.21.2",
    "3.1.4.31\t3.1.11.4",
    "3.1.4.36\t3.1.4.43",
    "3.1.4.47\t4.6.1.14",
    "3.1.4.n1\t3.1.4.53",
    "3.1.7.4\t4.2.1.133\t4.2.3.141",
    "3.1.7.7\t4.2.3.194",
    "3.1.22.3\t3.1.21.7",
    "3.1.23.1\t3.1.21.4",
    "3.1.23.2\t3.1.21.4",
    "3.1.23.3\t3.1.21.4",
    "3.1.23.4\t3.1.21.4",
    "3.1.23.5\t3.1.21.4",
    "3.1.23.6\t3.1.21.4",
    "3.1.23.7\t3.1.21.4",
    "3.1.23.8\t3.1.21.4",
    "3.1.23.9\t3.1.21.4",
    "3.1.23.10\t3.1.21.4",
    "3.1.23.11\t3.1.21.4",
    "3.1.23.12\t3.1.21.4",
    "3.1.23.13\t3.1.21.4",
    "3.1.23.14\t3.1.21.4",
    "3.1.23.15\t3.1.21.4",
    "3.1.23.16\t3.1.21.4",
    "3.1.23.17\t3.1.21.4",
    "3.1.23.18\t3.1.21.4",
    "3.1.23.19\t3.1.21.4",
    "3.1.23.20\t3.1.21.4",
    "3.1.23.21\t3.1.21.4",
    "3.1.23.22\t3.1.21.4",
    "3.1.23.23\t3.1.21.4",
    "3.1.23.24\t3.1.21.4",
    "3.1.23.25\t3.1.21.4",
    "3.1.23.26\t3.1.21.4",
    "3.1.23.27\t3.1.21.4",
    "3.1.23.28\t3.1.21.4",
    "3.1.23.29\t3.1.21.4",
    "3.1.23.30\t3.1.21.4",
    "3.1.23.31\t3.1.21.4",
    "3.1.23.32\t3.1.21.4",
    "3.1.23.33\t3.1.21.4",
    "3.1.23.34\t3.1.21.4",
    "3.1.23.35\t3.1.21.4",
    "3.1.23.36\t3.1.21.4",
    "3.1.23.37\t3.1.21.4",
    "3.1.23.38\t3.1.21.4",
    "3.1.23.39\t3.1.21.4",
    "3.1.23.40\t3.1.21.4",
    "3.1.23.41\t3.1.21.4",
    "3.1.23.42\t3.1.21.4",
    "3.1.23.43\t3.1.21.4",
    "3.1.23.44\t3.1.21.4",
    "3.1.23.45\t3.1.21.4",
    "3.1.23.46\t3.1.21.4",
    "3.1.23.47\t3.1.21.4",
    "3.1.23.48\t3.1.21.4",
    "3.1.23.49\t3.1.21.4",
    "3.1.23.50\t3.1.21.4",
    "3.1.23.51\t3.1.21.4",
    "3.1.23.52\t3.1.21.4",
    "3.1.23.53\t3.1.21.4",
    "3.1.23.54\t3.1.21.4",
    "3.1.23.55\t3.1.21.4",
    "3.1.23.56\t3.1.21.4",
    "3.1.23.57\t3.1.21.4",
    "3.1.23.58\t3.1.21.4",
    "3.1.23.59\t3.1.21.4",
    "3.1.24.1\t3.1.21.3",
    "3.1.24.2\t3.1.21.3",
    "3.1.24.3\t3.1.21.5",
    "3.1.24.4\t3.1.21.5",
    "3.1.25.2\t4.2.99.18",
    "3.1.26.n1\t3.1.26.12",
    "3.1.27.9\t4.6.1.16",
    "3.2.1.12\t3.2.1.54",
    "3.2.1.13\t3.2.1.54",
    "3.2.1.29\t3.2.1.52",
    "3.2.1.30\t3.2.1.52",
    "3.2.1.34\t3.2.1.35",
    "3.2.1.69\t3.2.1.41",
    "3.2.1.79\t3.2.1.55",
    "3.2.1.110\t3.2.1.97",
    "3.2.1.138\t4.2.2.15",
    "3.2.1.148\t4.4.1.21",
    "3.2.1.160\t3.2.1.155",
    "3.2.2.18\t3.5.1.52",
    "3.2.3.1\t3.2.1.147",
    "3.3.1.3\t4.4.1.21",
    "3.3.2.3\t3.3.2.9\t3.3.2.10",
    "3.3.2.5\t3.3.2.2",
    "3.4.1.1\t3.4.11.1",
    "3.4.1.2\t3.4.11.2",
    "3.4.1.3\t3.4.11.4",
    "3.4.1.4\t3.4.11.5",
    "3.4.2.1\t3.4.17.1",
    "3.4.2.2\t3.4.17.2",
    "3.4.2.3\t3.4.17.4",
    "3.4.3.1\t3.4.13.18\t3.4.13.19",
    "3.4.3.2\t3.4.13.18\t3.4.13.19",
    "3.4.3.3\t3.4.13.18\t3.4.13.20",
    "3.4.3.4\t3.4.13.5",
    "3.4.3.5\t3.4.11.2",
    "3.4.3.6\t3.4.13.18\t3.4.13.19",
    "3.4.3.7\t3.4.13.9",
    "3.4.4.1\t3.4.23.1",
    "3.4.4.2\t3.4.23.2",
    "3.4.4.3\t3.4.23.4",
    "3.4.4.4\t3.4.21.4",
    "3.4.4.5\t3.4.21.1",
    "3.4.4.6\t3.4.21.1",
    "3.4.4.7\t3.4.21.36\t3.4.21.37",
    "3.4.4.8\t3.4.21.9",
    "3.4.4.9\t3.4.14.1",
    "3.4.4.10\t3.4.22.2",
    "3.4.4.11\t3.4.22.6",
    "3.4.4.12\t3.4.22.3",
    "3.4.4.13\t3.4.21.5",
    "3.4.4.14\t3.4.21.7",
    "3.4.4.15\t3.4.23.15",
    "3.4.4.16\t3.4.21.62\t3.4.21.63\t3.4.21.64\t3.4.21.65\t3.4.21.66\t3.4.21.67",
    "3.4.4.17\t3.4.21.103\t3.4.23.20\t3.4.23.21\t3.4.23.22\t3.4.23.23\t3.4.23.24\t3.4.23.25\t3.4.23.26\t3.4.23.28\t3.4.23.29\t3.4.23.30",
    "3.4.4.18\t3.4.22.10",
    "3.4.4.19\t3.4.24.3",
    "3.4.4.20\t3.4.22.8",
    "3.4.4.21\t3.4.21.34",
    "3.4.4.22\t3.4.23.3",
    "3.4.4.23\t3.4.23.5",
    "3.4.4.24\t3.4.22.32\t3.4.22.33",
    "3.4.11.8\t3.4.19.3",
    "3.4.11.n1\t3.4.11.24",
    "3.4.12.1\t3.4.16.5\t3.4.16.6",
    "3.4.12.2\t3.4.17.1",
    "3.4.12.3\t3.4.17.2",
    "3.4.12.4\t3.4.16.2",
    "3.4.12.5\t3.5.1.28",
    "3.4.12.6\t3.4.17.8",
    "3.4.12.7\t3.4.17.3",
    "3.4.12.8\t3.4.17.4",
    "3.4.12.10\t3.4.19.9",
    "3.4.12.11\t3.4.17.6",
    "3.4.12.12\t3.4.16.5\t3.4.16.6",
    "3.4.13.1\t3.4.13.18\t3.4.13.19",
    "3.4.13.2\t3.4.13.18\t3.4.13.19",
    "3.4.13.3\t3.4.13.18\t3.4.13.20",
    "3.4.13.6\t3.4.11.2",
    "3.4.13.8\t3.4.13.18\t3.4.13.19",
    "3.4.13.10\t3.4.19.5",
    "3.4.13.11\t3.4.13.18\t3.4.13.19",
    "3.4.13.13\t3.4.13.18\t3.4.13.20",
    "3.4.13.15\t3.4.13.18\t3.4.13.19",
    "3.4.14.3\t3.4.19.1",
    "3.4.14.8\t3.4.14.9\t3.4.14.10",
    "3.4.15.2\t3.4.19.2",
    "3.4.15.3\t3.4.15.5",
    "3.4.16.1\t3.4.16.5\t3.4.16.6",
    "3.4.16.3\t3.4.16.5\t3.4.16.6",
    "3.4.17.7\t3.5.1.28",
    "3.4.17.9\t3.4.17.4",
    "3.4.17.n1\t3.13.1.6",
    "3.4.19.8\t3.4.17.21",
    "3.4.19.10\t3.5.1.28",
    "3.4.21.8\t3.4.21.34\t3.4.21.35",
    "3.4.21.11\t3.4.21.36\t3.4.21.37",
    "3.4.21.13\t3.4.16.5\t3.4.16.6",
    "3.4.21.14\t3.4.21.62\t3.4.21.63\t3.4.21.64\t3.4.21.65\t3.4.21.67",
    "3.4.21.15\t3.4.21.63",
    "3.4.21.28\t3.4.21.74",
    "3.4.21.29\t3.4.21.74",
    "3.4.21.30\t3.4.21.74",
    "3.4.21.31\t3.4.21.68\t3.4.21.73",
    "3.4.21.44\t3.4.21.43",
    "3.4.21.87\t3.4.23.49",
    "3.4.22.4\t3.4.22.32\t3.4.22.33",
    "3.4.22.5\t3.4.22.33",
    "3.4.22.9\t3.4.21.48",
    "3.4.22.11\t3.4.24.56",
    "3.4.22.12\t3.4.19.9",
    "3.4.22.17\t3.4.22.52\t3.4.22.53",
    "3.4.22.18\t3.4.21.26",
    "3.4.22.19\t3.4.24.15",
    "3.4.22.21\t3.4.25.1",
    "3.4.22.22\t3.4.24.37",
    "3.4.22.23\t3.4.21.61",
    "3.4.23.6\t3.4.21.103\t3.4.23.18\t3.4.23.19\t3.4.23.20\t3.4.23.21\t3.4.23.22\t3.4.23.23\t3.4.23.24\t3.4.23.25\t3.4.23.26\t3.4.23.28\t3.4.23.30",
    "3.4.23.7\t3.4.23.20",
    "3.4.23.8\t3.4.23.25",
    "3.4.23.9\t3.4.23.21",
    "3.4.23.10\t3.4.23.22",
    "3.4.23.27\t3.4.21.103",
    "3.4.23.33\t3.4.21.101",
    "3.4.23.37\t3.4.21.100",
    "3.4.24.4\t3.4.24.25\t3.4.24.26\t3.4.24.27\t3.4.24.28\t3.4.24.29\t3.4.24.30\t3.4.24.31\t3.4.24.32\t3.4.24.39\t3.4.24.40",
    "3.4.24.5\t3.4.22.52\t3.4.22.53\t3.4.25.1",
    "3.4.24.8\t3.4.24.3",
    "3.4.24.88\t3.4.19.15",
    "3.4.99.1\t3.4.23.28",
    "3.4.99.4\t3.4.23.12",
    "3.4.99.5\t3.4.24.3",
    "3.4.99.6\t3.4.24.21",
    "3.4.99.10\t3.4.24.56",
    "3.4.99.13\t3.4.24.32",
    "3.4.99.19\t3.4.23.15",
    "3.4.99.22\t3.4.24.29",
    "3.4.99.25\t3.4.23.21",
    "3.4.99.26\t3.4.21.68\t3.4.21.73",
    "3.4.99.28\t3.4.21.60",
    "3.4.99.30\t3.4.24.20",
    "3.4.99.31\t3.4.24.15",
    "3.4.99.32\t3.4.24.20",
    "3.4.99.35\t3.4.23.36",
    "3.4.99.36\t3.4.21.89",
    "3.4.99.38\t3.4.23.17",
    "3.4.99.41\t3.4.24.64",
    "3.4.99.43\t3.4.23.42",
    "3.4.99.44\t3.4.24.55",
    "3.4.99.45\t3.4.24.56",
    "3.4.99.46\t3.4.25.1",
    "3.5.1.34\t3.4.13.5",
    "3.5.1.37\t3.5.1.26",
    "3.5.1.45\t6.3.4.6",
    "3.5.1.80\t3.5.1.25",
    "3.5.1.120\t3.5.99.11",
    "3.5.1.n1\t3.5.1.108",
    "3.5.1.n2\t3.5.1.99",
    "3.5.1.n4\t3.5.1.110",
    "3.5.2.8\t3.5.2.6",
    "3.5.3.19\t3.5.1.116",
    "3.5.4.14\t3.5.4.5",
    "3.5.4.n1\t3.5.4.31",
    "3.5.4.n2\t3.5.4.39",
    "3.5.4.n3\t3.5.4.45",
    "3.5.5.3\t4.2.1.104",
    "3.5.99.3\t3.5.4.43",
    "3.5.99.4\t3.5.4.42",
    "3.6.1.4\t3.6.1.3",
    "3.6.1.19\t3.6.1.9",
    "3.6.1.30\t3.6.1.59\t3.6.1.62",
    "3.6.1.32\t3.6.4.1",
    "3.6.1.33\t3.6.4.2",
    "3.6.1.34\t7.1.2.2",
    "3.6.1.35\t7.1.2.1",
    "3.6.1.36\t3.6.3.10",
    "3.6.1.37\t3.6.3.9",
    "3.6.1.38\t3.6.3.8",
    "3.6.1.46\t3.6.5.1",
    "3.6.1.47\t3.6.5.2",
    "3.6.1.48\t3.6.5.3",
    "3.6.1.49\t3.6.5.4",
    "3.6.1.50\t3.6.5.5",
    "3.6.1.51\t3.6.5.6",
    "3.6.1.n4\t3.6.1.67",
    "3.6.1.n5\t3.6.1.54",
    "3.6.3.1\t7.6.2.1",
    "3.6.3.6\t7.1.2.1",
    "3.6.3.7\t7.2.2.3",
    "3.6.3.12\t7.2.2.6",
    "3.6.3.13\t3.6.3.1",
    "3.6.3.14\t7.1.2.2",
    "3.6.3.15\t7.2.2.1",
    "3.6.3.18\t7.5.2.2",
    "3.6.3.19\t7.5.2.1",
    "3.6.3.21\t7.4.2.1",
    "3.6.3.22\t7.4.2.2",
    "3.6.3.23\t7.4.2.6",
    "3.6.3.25\t7.3.2.3",
    "3.6.3.26\t7.3.2.4",
    "3.6.3.27\t7.3.2.1",
    "3.6.3.28\t7.3.2.2",
    "3.6.3.29\t7.3.2.5",
    "3.6.3.30\t7.2.2.7",
    "3.6.3.35\t7.2.2.5",
    "3.6.3.36\t7.6.2.7",
    "3.6.3.37\t7.6.2.6",
    "3.6.3.39\t7.5.2.5",
    "3.6.3.40\t7.5.2.4",
    "3.6.3.41\t7.6.2.5",
    "3.6.3.42\t7.5.2.3",
    "3.6.3.43\t7.4.2.5",
    "3.6.3.44\t7.6.2.2",
    "3.6.3.45\t3.6.3.44",
    "3.6.3.46\t7.2.2.2",
    "3.6.3.47\t7.6.2.4",
    "3.6.3.48\t7.4.2.7",
    "3.6.3.51\t7.4.2.3",
    "3.6.3.52\t7.4.2.4",
    "3.6.3.54\t7.2.2.8",
    "3.6.3.n1\t7.2.2.8",
    "3.6.4.3\t5.6.1.1",
    "3.7.1.15\t4.2.1.138",
    "3.7.1.16\t3.3.2.12",
    "3.7.1.n1\t3.7.1.14",
    "3.7.1.n2\t3.7.1.22",
    "3.8.1.4\t1.21.99.4",
    "3.8.2.1\t3.1.8.2",
    "4.1.1.3\t4.1.1.112",
    "4.1.1.10\t4.1.1.12",
    "4.1.1.26\t4.1.1.28",
    "4.1.1.27\t4.1.1.28",
    "4.1.1.41\t7.2.4.3",
    "4.1.1.n1\t4.1.1.97",
    "4.1.1.n2\t4.1.1.94",
    "4.1.2.1\t4.1.3.16",
    "4.1.2.7\t4.1.2.13",
    "4.1.2.15\t2.5.1.54",
    "4.1.2.16\t2.5.1.55",
    "4.1.2.30\t1.14.14.32",
    "4.1.2.31\t4.1.3.16",
    "4.1.2.37\t4.1.2.46\t4.1.2.47",
    "4.1.2.39\t4.1.2.46\t4.1.2.47",
    "4.1.2.n1\t4.1.2.44",
    "4.1.2.n3\t4.1.2.53",
    "4.1.2.n4\t4.1.2.52",
    "4.1.2.n5\t2.2.1.10",
    "4.1.2.n6\t4.1.2.56",
    "4.1.3.2\t2.3.3.9",
    "4.1.3.5\t2.3.3.10",
    "4.1.3.7\t2.3.3.1",
    "4.1.3.8\t2.3.3.8",
    "4.1.3.9\t2.3.3.11",
    "4.1.3.10\t2.3.3.7",
    "4.1.3.11\t2.3.3.12",
    "4.1.3.12\t2.3.3.13",
    "4.1.3.15\t2.2.1.5",
    "4.1.3.18\t2.2.1.6",
    "4.1.3.19\t2.5.1.56",
    "4.1.3.20\t2.5.1.57",
    "4.1.3.21\t2.3.3.14",
    "4.1.3.23\t2.3.3.2",
    "4.1.3.28\t2.3.3.3",
    "4.1.3.29\t2.3.3.4",
    "4.1.3.31\t2.3.3.5",
    "4.1.3.33\t2.3.3.6",
    "4.1.3.37\t2.2.1.7",
    "4.1.3.n1\t4.1.3.43",
    "4.1.99.4\t3.5.99.7",
    "4.1.99.6\t4.2.3.6",
    "4.1.99.7\t4.2.3.9",
    "4.1.99.8\t4.2.3.119\t4.2.3.120",
    "4.1.99.9\t4.2.3.15",
    "4.1.99.10\t4.2.3.16",
    "4.1.99.18\t4.1.99.22\t4.6.1.17",
    "4.1.99.21\t4.2.3.153",
    "4.2.1.4\t4.2.1.3",
    "4.2.1.13\t4.3.1.17",
    "4.2.1.14\t4.3.1.18",
    "4.2.1.15\t4.4.1.1",
    "4.2.1.16\t4.3.1.19",
    "4.2.1.21\t4.2.1.22",
    "4.2.1.26\t4.3.1.9",
    "4.2.1.29\t4.99.1.6",
    "4.2.1.37\t3.3.2.4",
    "4.2.1.38\t4.3.1.20",
    "4.2.1.52\t4.3.3.7",
    "4.2.1.58\t4.2.1.59",
    "4.2.1.60\t4.2.1.59",
    "4.2.1.61\t4.2.1.59",
    "4.2.1.63\t3.3.2.9\t3.3.2.10",
    "4.2.1.64\t3.3.2.9\t3.3.2.10",
    "4.2.1.71\t4.2.1.27",
    "4.2.1.72\t4.1.1.78",
    "4.2.1.86\t4.2.1.98",
    "4.2.1.89\t2.8.3.21\t4.2.1.149",
    "4.2.1.102\t4.2.1.100",
    "4.2.1.n1\t4.2.1.126",
    "4.2.1.n2\t4.2.1.134",
    "4.2.2.4\t4.2.2.20\t4.2.2.21",
    "4.2.3.14\t4.2.3.119\t4.2.3.120",
    "4.2.3.n1\t4.2.3.38",
    "4.2.3.n3\t4.2.3.56",
    "4.2.3.n4\t4.2.3.117",
    "4.2.3.n5\t4.2.3.52",
    "4.2.3.n6\t4.2.3.113",
    "4.2.3.n7\t4.2.3.119",
    "4.2.3.n8\t4.2.3.103",
    "4.2.3.n9\t4.2.3.44",
    "4.2.3.n10\t4.2.3.62",
    "4.2.3.n12\t4.2.3.65",
    "4.2.3.n13\t4.2.3.75",
    "4.2.3.n14\t4.2.3.118",
    "4.2.99.1\t4.2.2.1",
    "4.2.99.2\t4.2.3.1",
    "4.2.99.3\t4.2.2.2",
    "4.2.99.4\t4.2.2.3",
    "4.2.99.6\t4.2.2.5\t4.2.2.20\t4.2.2.21",
    "4.2.99.7\t4.2.3.2",
    "4.2.99.8\t2.5.1.47",
    "4.2.99.9\t2.5.1.48",
    "4.2.99.10\t2.5.1.49",
    "4.2.99.11\t4.2.3.3",
    "4.2.99.13\t2.5.1.50",
    "4.2.99.14\t2.5.1.51",
    "4.2.99.15\t2.5.1.52",
    "4.2.99.16\t2.5.1.53",
    "4.2.99.17\t2.5.1.51",
    "4.2.99.19\t4.4.1.23",
    "4.2.99.n1\t4.2.99.20",
    "4.3.1.5\t4.3.1.23\t4.3.1.24\t4.3.1.25",
    "4.3.1.8\t2.5.1.61",
    "4.3.1.21\t4.3.1.9",
    "4.3.1.26\t1.21.98.2",
    "4.3.3.n1\t4.1.99.20",
    "4.3.99.1\t4.2.1.104",
    "4.3.99.2\t7.2.4.1",
    "4.4.1.7\t2.5.1.18",
    "4.4.1.18\t1.8.3.5",
    "4.4.1.27\t3.13.1.5",
    "4.6.1.3\t4.2.3.4",
    "4.6.1.4\t4.2.3.5",
    "4.6.1.5\t4.2.3.7",
    "4.6.1.7\t4.2.3.8",
    "4.6.1.8\t4.2.3.10",
    "4.6.1.9\t4.2.3.11",
    "4.6.1.10\t4.2.3.12",
    "4.6.1.11\t4.2.3.13",
    "5.1.1.n1\t5.1.1.20",
    "5.1.3.n1\t5.1.3.24",
    "5.1.3.n2\t5.1.3.29",
    "5.1.3.n3\t5.1.3.32",
    "5.2.1.7\t3.1.1.64",
    "5.3.1.10\t3.5.99.6",
    "5.3.1.19\t2.6.1.16",
    "5.3.1.n1\t5.3.1.30",
    "5.3.1.n2\t5.3.1.29",
    "5.3.2.n1\t5.3.2.5",
    "5.3.3.15\t5.3.2.7",
    "5.3.3.16\t5.3.2.8",
    "5.3.3.20\t5.4.99.64",
    "5.3.99.n1\t5.3.99.11",
    "5.4.1.2\t5.4.99.61",
    "5.4.2.1\t5.4.2.11\t5.4.2.12",
    "5.4.99.6\t5.4.4.2",
    "5.4.99.10\t5.4.99.11",
    "5.4.99.n1\t5.4.99.39",
    "5.4.99.n2\t5.4.99.41",
    "5.5.1.21\t4.2.1.133",
    "5.5.1.n1\t5.4.99.62",
    "5.5.1.n2\t5.5.1.19",
    "6.1.1.n1\t6.3.1.13",
    "6.1.1.n2\t6.1.1.27",
    "6.2.1.21\t6.2.1.30",
    "6.2.1.29\t6.2.1.7",
    "6.2.1.n1\t6.2.1.37",
    "6.3.1.3\t6.3.4.13",
    "6.3.1.16\t6.3.3.6",
    "6.3.2.15\t6.3.2.10",
    "6.3.2.19\t2.3.2.23\t2.3.2.27\t6.2.1.45",
    "6.3.2.21\t2.3.2.27\t6.2.1.45",
    "6.3.2.22\t6.3.1.14",
    "6.3.2.27\t6.3.2.38\t6.3.2.39",
    "6.3.2.28\t6.3.2.49",
    "6.3.2.n1\t6.3.2.37",
    "6.3.2.n2\t6.3.1.19",
    "6.3.2.n4\t6.3.2.43",
    "6.3.2.n5\t6.3.2.44",
    "6.3.2.n6\t6.3.2.41",
    "6.3.4.1\t6.3.5.2",
    "6.3.5.8\t2.6.1.85"
};
