/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GLOBAL__
#define __GLOBAL__

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>


//types scalaires de base
typedef int Entier;
typedef double Reel;
typedef char Caractere;
typedef char* Chaine;
typedef char* Texte;
typedef void* Pointeur;

//precision sur certains concepts

typedef Entier Indice;
typedef Entier Taille;
typedef Entier IdNoeud;
typedef char* NomNoeud;
//identifiant lisible d'un noeud
typedef Entier IdIdee;
//indice dans la liste d'idees et identifiant d'une idee
typedef Entier Pertinence;
//sert a quantifier la pertinence d'une liaison dans un graphe
typedef Entier NiveauHierarchique;
//precise le niveau hierarchique d'un noeud d'un graphe
//cela a une consequence sur la sortie du plan

typedef Chaine NomFichier;
//Nom de fichier, avec le chemin.

typedef FILE* DescripteurFichier;
//Descripteur de fichier, utilis pour les entres sorties.

typedef Chaine NomOption;
//Nom d'option.

typedef Chaine NomMacro;
//Nom de macro.

typedef Chaine Label;
//Label utilis dans la commande de slection d'options.

//types particuliers
typedef enum {RESULTAT_OK , RESULTAT_ERREUR , RESULTAT_ERREUR_DEPASSEMENT , RESULTAT_ERREUR_DOMAINE , RESULTAT_ERREUR_MEMOIRE , RESULTAT_ERREUR_TAILLE , RESULTAT_ERREUR_NONTROUVE , RESULTAT_ERREUR_PASORPHELINES , RESULTAT_ERREUR_TROPORPHELINES , RESULTAT_ERREUR_PASDIDEES} Resultat;

typedef enum {FAUX , VRAI} Booleen;

typedef enum {IDEE_VIDE , IDEE_PRESENTE , IDEE_MANQUANTE , IDEE_GENERIQUE , IDEE_RACINE} TypeIdee;

typedef enum {REFERENCE_INDEFINIE , REFERENCE_REDUCTIBLE , REFERENCE_IRREDUCTIBLE} TypeReference;

typedef struct
{
	Indice referencesreductibles;
	Indice referencesirreductibles;
} References;

typedef struct
{
	Indice nombreideestotal;
	Indice nombreideesmanquantes;
	Indice nombreideesgeneralites;
	Indice nombrereferencestotal;
	Indice nombrereferencesirreductibles;
} Statistiques;

//raz le bol...
#define DEBUTZONESECURISEE	{ Resultat _resultat_;
#define SECURISE(appel)	if((_resultat_=(appel))!=RESULTAT_OK) return _resultat_
// /!\ au ;
#define FINZONESECURISEE	}

/* Couche d'abstraction des structures de donnes.
 *
 * Les structures seront divises en deux catgories :
 * 1) les structures scalaires :
 * 	Les structures scalaires sont des structures qui
 * 	sont leur propre reprsentant. On y accde donc
 * 	directement. Cela implique que la modification 
 * 	d'un travail scalaire revient  le transformer
 * 	en son propre rsultat. 	
 * 	Elles sont constitus de :
 * 	- les types dfinis dans global.h ;
 * 	- les types dfinis comme 'enum' ;
 * 	- les champs de structure prciss comme tels.
 * 2) les autres structures :
 * 	Les autres structures sont des structures qui sont
 * 	compltement opaques, puisqu'elles sont toujours
 * 	accessibles via un reprsentant. Ceci implique qu'une
 * 	modification d'un travail non scalaire ne revient pas
 * 	 le transformer en son propre rsultat. Bien sr, un
 * 	travail non scalaire peut tre un rsultat de fonction.
 *
 * Ces deux catgories ont un point commun : elles obissent
 *  5 niveaux d'utilisation diffrents :
 * 1) le niveau conteneur :
 * 	- reprsentant du type de donne ;
 * 	- utilis pour obtenir la taille du type
 * 	  dans les malloc/realloc.
 * 2) le niveau stockage :
 * 	- reprsentant une instance du type ;
 * 	- champ d'une autre structure de donne.
 * 3) le niveau corfrence :
 * 	- reprsente une indirection simple ;
 * 	- utilis comme paramtre de fonction lorsque
 * 	  celui-ci est un rsultat de celle-ci, mais
 * 	  obtenu par effet de bord. Ce niveau accepte
 * 	  les oprateurs standard du C =, ++, --,
 * 	  +<entier>, -<entier> et les comparaisons.
 * 4) le niveau travail :
 * 	- reprsente la structure de donne manipulable ;
 * 	- utilis comme paramtre de fonction sur laquelle
 * 	  elle peut agir.
 * 5) le niveau rfrence :
 * 	- reprsente la structure par une pure indirection ;
 * 	- utilis lorsqu'une fonction doit renvoyer une structure
 * 	  de donne sur laquelle on peut travailler. Ce niveau
 * 	  peut accepter les oprateurs standard du C =, ++, --,
 * 	  +<entier>, -<entier> et les comparaisons.
 *
 *
 * Ces cinq niveaux ont des comportements bien prcis, selon leur
 * dclaration :
 * 1) variable locale ou globale :
 * 	conteneur => la dfinition en tant que conteneur est
 * 		interdite ;
 *	stockage => la variable doit etre initialise, utilise
 *		puis ventuellement dtruite ;
 *	corfrence => la dfinition en tant que corfrence est
 *		interdite ;
 *	travail => la variable n'a pas  tre initialise et
 *		dtruite. Elle est obtenue par lecture dans une
 *		structure de donne ;
 *	rfrence => la dfinition en tant que rfrence est
 *		interdite.
 * 2) paramtre de fonction :
 * 	conteneur => la dfinition en tant que conteneur est
 * 		interdite ;
 * 	stockage => la dfinition en tant que stockage est
 * 		interdite ;
 *	corfrence => la dfinition est permise, et cette structure
 *		n'a pas  tre explicitement initialis ou dtruit ;
 * 	travail => la dfinition est permise, et cette variable
 * 		n'a pas a tre initialise et dtruite. En revanche,
 * 		toute action sur un paramtre travail est une
 * 		opration qui ne doit en aucun cas produire un
 * 		rsultat de la fonction ;
 * 	rfrence => la dfinition est permise, mais uniquement dans le
 * 		cas o le paramtre de rfrence est uniquement destin
 * 		 recevoir le rsultat de la fonction. Dans ce cas,
 * 		l'affectation est ralise au niveau travail. Toute
 * 		autre affectation sera au niveau stockage.
 * 3) champ de structure :
 * 	conteneur => la dfinition en tant que conteneur est
 * 		interdite ;
 * 	stockage => la dfinition est permise, mme accompagn
 * 		du spcificateur de tableau ;
 *	corfrence => la dfinition en tant que corfrence est
 *		interdite ;
 * 	travail => la dfinition en tant que travail est
 * 		interdite ;
 * 	rfrence => la dfinition en tant que rfrence est
 * 		interdite.
 * 4) oprations de type :
 * 	stockage => l'utilisation est permise,  la fois lors
 * 		de la dclaration du type, que de l'utilisation
 * 		de l'oprateur sizeof() ;
 * 	stockage => la dfinition en tant que stockage est
 * 		interdite ;
 *	corfrence => la dfinition en tant que corfrence est
 *		interdite ;
 * 	travail => la dfinition en tant que travail est
 * 		interdite ;
 * 	rfrence => la dfinition en tant que rfrence est
 * 		interdite.
 * 
 * A cela s'ajoute des possibilits de conversions entre certains
 * niveaux, et la possibilit, au niveau stockage, de rcuprer un
 * champ d'une structure.
 * 
 * Afin de bien pouvoir communiquer sur cette couche d'abstraction,
 * il semble ncessaire de fixer les dnominations :
 * 1) pour les niveaux d'une structure de donnes :
 * 	TRAVAIL(Type) valeur; //valeur est un travail de Type.
 * 2) pour les valeurs utilises :
 * 	valeur; //un travail valeur
 * 	S_T(valeur); //un stockage du travail valeur
 *
 * Niveaux associs aux diffrentes commandes :
 * T_S :		stockage                             => travail
 * S_T :		travail                              => stockage
 * C_S :                stockage                             => coreference
 * S_C :                coreference                          => stockage
 * R_T :		travail                              => reference
 * T_R :		reference                            => travail
 * CHAMP :		(travail  , champ)                   => stockage ou stockage_scalaire ou tableau ou tableau_scalaire
 * CHAMP_STOCKAGE :	(stockage , champ)                   => stockage ou stockage_scalaire ou tableau ou tableau_scalaire
 * CHAMP_TRAVAIL :	(travail  , champ)                   => travail  ou tableau
 * TABLEAU :		stockage                             => tableau
 * ELEMENT :		(tableau  , travail_indice)          => stockage
 * ELEMENT_TRAVAIL :	(tableau  , travail_indice)          => travail
 * SIZEOF :		conteneur                            => travail_scalaire
 * SIZEOF_STOCKAGE :	conteneur                            => stockage_scalaire
 *
 * T_S_ :		stockage_scalaire                    => travail_scalaire
 * S_T_ :		travail_scalaire                     => stockage_scalaire
 * C_S_ :               stockage_scalaire                    => coreference_scalaire
 * S_C_ :               coreference_scalaire                 => stockage_scalaire
 * R_T_ :		travail_scalaire                     => reference_scalaire
 * T_R_ :		reference_scalaire                   => travail_scalaire
 * R_S_ :		stockage_scalaire                    => reference_scalaire
 * S_R_ :		reference_scalaire                   => stockage_scalaire
 * CHAMP_ :		(travail_scalaire  , champ)          => stockage_scalaire ou stockage ou tableau_scalaire ou tableau
 * CHAMP_STOCKAGE_ :	(stockage_scalaire , champ)          => stockage_scalaire ou stockage ou tableau_scalaire ou tableau
 * CHAMP_TRAVAIL_ :	(travail_scalaire  , champ)          => travail           ou tableau
 * TABLEAU_ :		stockage_scalaire                    => tableau_scalaire
 * ELEMENT_ :		(tableau_scalaire  , travail_indice) => stockage_scalaire
 * ELEMENT_TRAVAIL_ :	(tableau_scalaire  , travail_indice) => travail_scalaire
 * SIZEOF_ :		conteneur_scalaire                   => travail_scalaire
 * SIZEOF_STOCKAGE_ :	conteneur_scalaire                   => stockage_scalaire
 */

/* Structures normales : niveaux
 */
#define   CONTENEUR(type)	type
#define    STOCKAGE(type)	type*
#define COREFERENCE(type)	type**
#define     TRAVAIL(type)	type**
#define   REFERENCE(type)	type***

/* Structures normales : conversions de niveaux
 */
#define T_S(stockage)		(&(stockage))
#define S_T(travail)		(*(travail))
#define C_S(stockage)		(&(stockage))
#define S_C(coreference)	(*(coreference))
#define R_T(travail)		(&(travail))
#define T_R(reference)		(*(reference))

/* Structures normales : extraction de champs
 */
#define          CHAMP(travail,champ)	((*travail)->champ)
#define CHAMP_STOCKAGE(stockage,champ)	((stockage)->champ)
#define  CHAMP_TRAVAIL(travail,champ)	(&((*travail)->champ))

/* Structures normales : tableaux
 */
#define TABLEAU(stockage) 			stockage*
#define ELEMENT(tableau,travail_indice)		((tableau)[travail_indice])
#define ELEMENT_TRAVAIL(tableau,travail_indice)	(&((tableau)[travail_indice]))

/* Structures normales : taille du conteneur
 */
#define          SIZEOF(conteneur)	sizeof(conteneur)
#define SIZEOF_STOCKAGE(conteneur)	sizeof(conteneur)

/* Structures scalaires : niveaux
 */
#define   CONTENEUR_SCALAIRE(type_scalaire)	type_scalaire
#define    STOCKAGE_SCALAIRE(type_scalaire)	type_scalaire
#define COREFERENCE_SCALAIRE(type_scalaire)	type_scalaire*
#define     TRAVAIL_SCALAIRE(type_scalaire)	type_scalaire
#define   REFERENCE_SCALAIRE(type_scalaire)	type_scalaire*

/* Structures scalaires : conversions de niveaux
 */
#define T_S_(stockage_scalaire)		(stockage_scalaire)
#define S_T_(travail_scalaire)		(travail_scalaire)
#define C_S_(stockage_scalaire)		(&(stockage_scalaire))
#define S_C_(coreference_scalaire)	(*(coreference_scalaire))
#define R_T_(travail_scalaire) 		(&(travail_scalaire))
#define T_R_(reference_scalaire)	(*(reference_scalaire))
/* Ces deux dernires ne devraient normalement pas servir,
 * mme si elles sont autorises. A n'utiliser qu'en dernier
 * recours.
 */
#define R_S_(stockage_scalaire)		(&(stockage_scalaire))
#define S_R_(reference_scalaire)	(*(reference_scalaire))

/* Structures scalaires : extraction de champs
 */
#define          CHAMP_(travail_scalaire,champ)		((travail_scalaire).champ)
#define CHAMP_STOCKAGE_(stockage_scalaire,champ)	((stockage_scalaire).champ)
#define  CHAMP_TRAVAIL_(travail_scalaire,champ)		(&((travail_scalaire).champ))

/* Structures scalaires : tableaux scalaires
 */
#define TABLEAU_(stockage_scalaire) 				stockage_scalaire*
#define ELEMENT_(tableau_scalaire,travail_scalaire)		((tableau_scalaire)[travail_scalaire])
#define ELEMENT_TRAVAIL_(tableau_scalaire,travail_scalaire)	((tableau_scalaire)[travail_scalaire])

/* Structures scalaires : taille du conteneur scalaire
 */
#define          SIZEOF_(conteneur)	sizeof(conteneur)
#define SIZEOF_STOCKAGE_(conteneur)	sizeof(conteneur)

/* Fonctions :
 */
#define FONCTION(fonction)	(*fonction)
#define REFFONCTION(fonction)	(**fonction)
#define F_R(reffonction)	(*reffonction)
#define R_F(fonction)		(&fonction)

#endif
