/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef USERPROFILE_H
#define USERPROFILE_H

#include <QString>

class QChatSettings;
class UserInfo;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class UserProfile
{
  private:
    QString        m_name;
    QChatSettings* m_prefs;
    UserInfo*      m_info;

  public:
    UserProfile(QString name, QChatSettings* prefs = 0, UserInfo* info = 0) : m_name(name), m_prefs(prefs), m_info(info){}
    ~UserProfile(){};

    bool            inited() const {return m_prefs && m_info;}
    UserInfo*       info  () const {return m_info;}
    QChatSettings*  prefs () const {return m_prefs;}
    const QString & name  () const {return m_name;}

    void rename(const QString & name){m_name = name;}
    void setProfile(QChatSettings* prefs, UserInfo* info){m_prefs = prefs; m_info  = info;}
};

#endif
