///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/branch.h"
using namespace rheolef;
using namespace std;
namespace rheolef { 

branch::~branch () 
{
    delete_macro (_p_data_out);
}
void
branch::put_header_rheolef (ostream& out) const
{
    // rheolef header
    int nval = -1;
    if (_n_value != numeric_limits<size_type>::max()) nval = _n_value;
    out << "#!branch" << endl
        << endl
        << "branch" << endl
        << "1 " << size() << " " << nval << endl
        << _parameter_name;
        ;
    for (size_type i = 0; i < size(); i++) {
        out << " " << operator[](i).first;
    }
    out << endl;
}
void
branch::put_header (ostream& out) const
{
    iorheo::flag_type format  = iorheo::flags(out) & iorheo::format_field;
    if      (format [iorheo::rheo])     { put_header_rheolef (out); }
    else if (format [iorheo::vtk])      { put_header_vtk     (out); }
    else if (format [iorheo::paraview]) { put_header_paraview     (out); }
    else if (format [iorheo::gnuplot])  { put_header_gnuplot     (out); }
    else if (format [iorheo::plotmtv])  { 
	error_macro ("unsupported plotmtv animations");
    }
    _header_printed = true;
}
void
branch::get_header (istream& in)
{
    check_macro (scatch(in,"\nbranch"), "input stream does not contains a branch");
    size_type version;
    size_type sz;
    int       nval;
    in >> version >> sz >> nval >> _parameter_name;
    _n_value = ((nval == -1) ? numeric_limits<size_type>::max() : nval);
    resize(sz);
    for (size_type i = 0; i < sz; i++) {
        in >> operator[](i).first;
    }
}
istream& 
operator >> (istream& in, branch& x)
{
    if (!in || !scatch(in, x._parameter_name)) {
	// no more events
	return in;
    }
    Float value;
    in >> value;
    if (!in) {
	// no more events...
	return in;
    }
    x._parameter_value = value;
    for (branch::size_type i = 0; in && i < x.size(); i++) {
       in >> catchmark (x[i].first) >> x[i].second;
    }
    // increment counter
    if (x._count_value == numeric_limits<branch::size_type>::max()) {
        x._count_value = 0;
    } else {
        x._count_value++;
    }
    return in;
}
void 
branch::put_event_rheolef (ostream& out) const
{
    out << endl
        << "#" << _parameter_name << " " << _parameter_value << endl
        << endl
       ;
    for (branch::size_type i = 0; i < size(); i++) {
       out << catchmark (operator[](i).first) << operator[](i).second; 
    }
}
ostream& 
operator << (ostream& out, const branch& x)
{
    if (!x._header_printed) x.put_header(out);
    iorheo::flag_type format  = iorheo::flags(out) & iorheo::format_field;
    // increment counter
    if      (format [iorheo::vtk])     { x.put_event_vtk (out); }
    else if (format [iorheo::paraview]){ x.put_event_paraview (out); }
    else if (format [iorheo::gnuplot]) { x.put_event_gnuplot (out); }
    else                               { x.put_event_rheolef (out); }

    return out;
}
void
branch::put_finalize (ostream& out) const
{
    iorheo::flag_type format  = iorheo::flags(out) & iorheo::format_field;

    if (format [iorheo::vtk])          { put_finalize_vtk(out); }
    else if (format [iorheo::gnuplot]) { put_finalize_paraview(out); }
    else if (format [iorheo::gnuplot]) { put_finalize_gnuplot(out); }
}
}// namespace rheolef
