%option noyywrap
%{
// This file is part of Rheolef.
//
// Copyright (C) 2000-2009 Pierre Saramito 
//
// Rheolef is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Rheolef is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Rheolef; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// lexer for qmg mesh files
// =========================================================================
//
// lexer for qmg boundary mesh files
//
// author: Pierre.Saramito@imag.fr
//
// date: 14 february 2002
//
%}
EXP	([eE]([\-+])?([0-9]+))

%%
[\n]     { /* newline */ ++cad_qmg_line_no; }
[ \t]    { /* space  */; }
"("      { return '('; }
")"      { return ')'; }
":"      { return ':'; }
([\-])?[0-9]+"."[0-9]*{EXP}? |
([\-])?[0-9]*"."[0-9]+{EXP}? |
([\-])?[0-9]+{EXP}      { yylval.float_value = atof(yytext); return FLOAT_NUMBER; }
([\-])?[0-9]+            { yylval.int_value   = atoi(yytext); return INT_NUMBER; }
"brep"([^ \t]*)([ \t]+)"2"([ \t]+)"2"		{ return BREP2D; }
"brep"([^ \t]*)([ \t]+)"3"([ \t]+)"3"		{ return BREP3D; }
"vertex"					{ yylval.geo_value = cad_element::p; return VERTEX; }
"bezier_curve"					{ yylval.geo_value = cad_element::e; return BEZIER_CURVE; }
"bezier_triangle"				{ yylval.geo_value = cad_element::t; return BEZIER_TRIANGLE; }
"bezier_quad"					{ yylval.geo_value = cad_element::q; return BEZIER_QUAD; }
[a-zA-Z][a-zA-Z0-9\-_\.]* {
           yylval.string_value = insert(yytext);
	   return IDENTIFIER;
	 }
"#".*    { /* comment */; }
%{
     // for PC-DOS files
     // filters out reverse (and half reverse) line feeds so the output is in
     // the correct order with only forward and half forward line feeds
    // \011	 { /* ESC-011 forward half-line feed */ }
%}
\013	 { /* vertical tab (aka reverse line feed) */ }
\007	 { /* ESC-07 reverse line feed */ }
\010	 { /* ESC-010 reverse half-line feed */ }

.        { return *yytext ;  /* default */ }
%%
