#ifndef _ROOTLS_H
#define _ROOTLS_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/* rootls.f -- translated by f2c (version 19931217).*/

/*****************************************************************/
/*********     ROOTLS ..... ROOTED LEVEL STRUCTURE      **********/
/*****************************************************************/
/*    PURPOSE - ROOTLS GENERATES THE LEVEL STRUCTURE ROOTED */
/*       AT THE INPUT NODE CALLED ROOT. ONLY THOSE NODES FOR*/
/*       WHICH MASK IS NONZERO WILL BE CONSIDERED.*/
/*                                                */
/*    INPUT PARAMETERS -                          */
/*       ROOT - THE NODE AT WHICH THE LEVEL STRUCTURE IS TO*/
/*              BE ROOTED.*/
/*       (XADJ, ADJNCY) - ADJACENCY STRUCTURE PAIR FOR THE*/
/*              GIVEN GRAPH.*/
/*       MASK - IS USED TO SPECIFY A SECTION SUBGRAPH. NODES*/
/*              WITH MASK(I)=0 ARE IGNORED.*/
/*    OUTPUT PARAMETERS -*/
/*       NLVL - IS THE NUMBER OF LEVELS IN THE LEVEL STRUCTURE.*/
/*       (XLS, LS) - ARRAY PAIR FOR THE ROOTED LEVEL STRUCTURE.*/
/*****************************************************************/

namespace rheolef { 
template <class Iterator>
void
rootls(
	Iterator root,
	Iterator xadj,
	Iterator adjncy, 
	Iterator mask,
	Iterator nlvl,
	Iterator xls,
	Iterator ls)
{
    typedef typename std::iterator_traits<Iterator>::value_type  Integer;

    /* System generated locals */
    Integer i__1, i__2;

    /* Local variables */
    static Integer node, i, j, jstop, jstrt, lbegin, ccsize, lvlend, lvsize, 
	    nbr;

/*       INITIALIZATION ...*/


    /* Parameter adjustments */
    --ls;
    --xls;
    --mask;
    --adjncy;
    --xadj;

    mask[*root] = 0;
    ls[1] = *root;
    *nlvl = 0;
    lvlend = 0;
    ccsize = 1;
/*       LBEGIN IS THE POINTER TO THE BEGINNING OF THE CURRENT*/
/*       LEVEL, AND LVLEND POINTS TO THE END OF THIS LEVEL.*/
L200:
    lbegin = lvlend + 1;
    lvlend = ccsize;
    ++(*nlvl);
    xls[*nlvl] = lbegin;
/*       GENERATE THE NEXT LEVEL BY FINDING ALL THE MASKED */
/*       NEIGHBORS OF NODES IN THE CURRENT LEVEL.*/
    i__1 = lvlend;
    for (i = lbegin; i <= i__1; ++i) {
	node = ls[i];
	jstrt = xadj[node];
	jstop = xadj[node + 1] - 1;
	if (jstop < jstrt) {
	    goto L400;
	}
	i__2 = jstop;
	for (j = jstrt; j <= i__2; ++j) {
	    nbr = adjncy[j];
	    if (mask[nbr] == 0) {
		goto L300;
	    }
	    ++ccsize;
	    ls[ccsize] = nbr;
	    mask[nbr] = 0;
L300:
	    ;
	}
L400:
	;
    }
/*       COMPUTE THE CURRENT LEVEL WIDTH.*/
/*       IF IT IS NONZERO, GENERATE THE NEXT LEVEL.*/
    lvsize = ccsize - lvlend;
    if (lvsize > 0) {
	goto L200;
    }
/*       RESET MASK TO ONE FOR THE NODES IN THE LEVEL STRUCTURE.*/
    xls[*nlvl + 1] = lvlend + 1;
    i__1 = ccsize;
    for (i = 1; i <= i__1; ++i) {
	node = ls[i];
	mask[node] = 1;
    }
}
}// namespace rheolef
#endif // _ROOTLS_H
