#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:43:43 
# _install-smb.sh 

### P A R A M S

MYNARGS=$#
MYREALM="$1"
MYDOMAIN="$2"
MYSERVER="$3"
MYADMIN="$4"
MYUSERS="$5"
MYHOSTALLOW="$6"
MYWINSSERVER="$7"
if [ ${MYNARGS} -lt 7 ]
then
	echo Incorrect number of parameters
	exit 1
fi

### I N C L U D E

. ./_include.sh

### S T A R T

# S T A T U S
[ -d /var/lib/sadms ] || mkdir -p /var/lib/sadms
echo '0' > /var/lib/sadms/smb

# H E A D E R
echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "configure Samba"
echo "-------------------------------------------------------------------------------"
echo "[BEGIN]"

# make sure real is uppercase
realm=`echo "${MYREALM}" | tr '[:lower:]' '[:upper:]'`

# make sure real is uppercase
pushd conf > /dev/null
./config-smbconf.sh "${realm}" "${MYDOMAIN}" "${MYSERVER}" "${MYADMIN}" "${MYUSERS}" "${MYHOSTALLOW}" "${MYWINSSERVER}"
popd > /dev/null
echo "[END]"
