// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL <pierre.marechal@scilab.org>
// Copyright (C) 2012 - Scilab Enterprises - Cedric Delamarre
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// unit tests for asin() function (element wise coasine inverse)
// =============================================================================


// 1. Interface
// ============

assert_checkfalse(execstr("asin()", "errcatch") == 0);
assert_checkfalse(execstr("asin(1,2)", "errcatch") == 0);

// 2. Singular Values
// ==================

rt2 = sqrt(2);
rt3 = sqrt(3);
v   = [0 , %pi/6 , %pi/4 , %pi/3 , %pi/2    , %pi/3 , %pi/4 , %pi/6 , 0 ];
x   = [0 , 1/2   , rt2/2 , rt3/2 , 1        , rt3/2 , rt2/2 , 1/2   , 0 ];

y = asin(x);
assert_checkalmostequal(y,v);


// 3. Not A Number
// ===============

assert_checktrue(isnan(asin(%nan)));
assert_checktrue(isnan(asin(-%nan)));


// 4. Limit values
// ===============

assert_checkequal(imag(asin(%inf)),-%inf);
assert_checkequal(imag(asin(-%inf)),%inf);


// 5. Properties
// =============

A = rand(100,100);

// asin(-x) = - asin(x)
assert_checkalmostequal(asin(-A), -asin(A));


// asin(x) = acos(-x) - pi/2
assert_checkalmostequal(asin(A), acos(-A) - %pi / 2);

