/*
 *  this code is derived from RawTherapee

 *  Copyright (c) 2004-2010 Gabor Horvath <hgabor@rawtherapee.com>
 *
 *  RawTherapee is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  RawTherapee is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with RawTherapee.  If not, see <https://www.gnu.org/licenses/>.
 *
 *  These median implementations from Flssie and Ingo Weyrich are inspired by this work:
 *
 *  http://ndevilla.free.fr/median/median.pdf
 *  http://pages.ripco.net/~jgamble/nw.html
 *  https://github.com/hoytech/Algorithm-Networksort-Chooser
 *
 *  Instead of using the PIX_SORT and PIX_SWAP macros we use mymin() and mymax()
 *  because it turned out that it generates much faster (branch free) code on machines which support SSE
 *
*/
 
#include "median_fast.h"

float median3x3(float* array)
{
    float tmp = mymin(array[1], array[2]);
    array[2] = mymax(array[1], array[2]);
    array[1] = tmp;
    tmp = mymin(array[4], array[5]);
    array[5] = mymax(array[4], array[5]);
    array[4] = tmp;
    tmp = mymin(array[7], array[8]);
    array[8] = mymax(array[7], array[8]);
    array[7] = tmp;
    tmp = mymin(array[0], array[1]);
    array[1] = mymax(array[0], array[1]);
    array[0] = tmp;
    tmp = mymin(array[3], array[4]);
    array[4] = mymax(array[3], array[4]);
    array[3] = tmp;
    tmp = mymin(array[6], array[7]);
    array[7] = mymax(array[6], array[7]);
    array[6] = tmp;
    tmp = mymin(array[1], array[2]);
    array[2] = mymax(array[1], array[2]);
    array[1] = tmp;
    tmp = mymin(array[4], array[5]);
    array[5] = mymax(array[4], array[5]);
    array[4] = tmp;
    tmp = mymin(array[7], array[8]);
    array[8] = mymax(array[7], array[8]);
    array[3] = mymax(array[0], array[3]);
    array[5] = mymin(array[5], array[8]);
    array[7] = mymax(array[4], tmp);
    tmp = mymin(array[4], tmp);
    array[6] = mymax(array[3], array[6]);
    array[4] = mymax(array[1], tmp);
    array[2] = mymin(array[2], array[5]);
    array[4] = mymin(array[4], array[7]);
    tmp = mymin(array[4], array[2]);
    array[2] = mymax(array[4], array[2]);
    array[4] = mymax(array[6], tmp);
    return mymin(array[4], array[2]);
}

#define CSWAP(a,b) t = mymax(a,b); a = mymin(a,b); b = t;

float median24(float *array) {
    float t;
    CSWAP(array[1], array[2]);
    CSWAP(array[0], array[2]);
    CSWAP(array[0], array[1]);
    CSWAP(array[4], array[5]);
    CSWAP(array[3], array[5]);
    CSWAP(array[3], array[4]);
    CSWAP(array[0], array[3]);
    CSWAP(array[1], array[4]);
    CSWAP(array[2], array[5]);
    CSWAP(array[2], array[4]);
    CSWAP(array[1], array[3]);
    CSWAP(array[2], array[3]);
    CSWAP(array[7], array[8]);
    CSWAP(array[6], array[8]);
    CSWAP(array[6], array[7]);
    float a11 = array[11];
    CSWAP(array[10], a11);
    CSWAP(array[9], a11);
    CSWAP(array[9], array[10]);
    CSWAP(array[6], array[9]);
    CSWAP(array[7], array[10]);
    CSWAP(array[8], a11);
    CSWAP(array[8], array[10]);
    CSWAP(array[7], array[9]);
    CSWAP(array[8], array[9]);
    CSWAP(array[0], array[6]);
    CSWAP(array[1], array[7]);
    CSWAP(array[2], array[8]);
    CSWAP(array[2], array[7]);
    CSWAP(array[1], array[6]);
    CSWAP(array[2], array[6]);
    CSWAP(array[3], array[9]);
    CSWAP(array[4], array[10]);
    CSWAP(array[5], a11);
    CSWAP(array[5], array[10]);
    CSWAP(array[4], array[9]);
    CSWAP(array[5], array[9]);
    CSWAP(array[3], array[6]);
    CSWAP(array[4], array[7]);
    CSWAP(array[5], array[8]);
    CSWAP(array[5], array[7]);
    CSWAP(array[4], array[6]);
    CSWAP(array[5], array[6]);
    CSWAP(array[13], array[14]);
    float a12 = array[12];
    CSWAP(a12, array[14]);
    CSWAP(a12, array[13]);
    CSWAP(array[16], array[17]);
    CSWAP(array[15], array[17]);
    CSWAP(array[15], array[16]);
    CSWAP(a12, array[15]);
    CSWAP(array[13], array[16]);
    CSWAP(array[14], array[17]);
    CSWAP(array[14], array[16]);
    CSWAP(array[13], array[15]);
    CSWAP(array[14], array[15]);
    CSWAP(array[19], array[20]);
    CSWAP(array[18], array[20]);
    CSWAP(array[18], array[19]);
    CSWAP(array[22], array[23]);
    CSWAP(array[21], array[23]);
    CSWAP(array[21], array[22]);
    CSWAP(array[18], array[21]);
    CSWAP(array[19], array[22]);
    CSWAP(array[20], array[23]);
    CSWAP(array[20], array[22]);
    CSWAP(array[19], array[21]);
    CSWAP(array[20], array[21]);
    CSWAP(a12, array[18]);
    CSWAP(array[13], array[19]);
    CSWAP(array[14], array[20]);
    CSWAP(array[14], array[19]);
    CSWAP(array[13], array[18]);
    CSWAP(array[14], array[18]);
    CSWAP(array[15], array[21]);
    CSWAP(array[16], array[22]);
    CSWAP(array[17], array[23]);
    CSWAP(array[17], array[22]);
    CSWAP(array[16], array[21]);
    CSWAP(array[17], array[21]);
    CSWAP(array[15], array[18]);
    CSWAP(array[16], array[19]);
    CSWAP(array[17], array[20]);
    CSWAP(array[17], array[19]);
    CSWAP(array[16], array[18]);
    CSWAP(array[17], array[18]);
    a12 = mymax(a12, array[0]);
    CSWAP(array[1], array[13]);
    CSWAP(array[2], array[14]);
    CSWAP(array[2], array[13]);
    a12 = mymax(a12, array[1]);
    a12 = mymax(a12, array[2]);
    CSWAP(array[3], array[15]);
    CSWAP(array[4], array[16]);
    CSWAP(array[5], array[17]);
    CSWAP(array[5], array[16]);
    CSWAP(array[4], array[15]);
    CSWAP(array[5], array[15]);
    a12 = mymax(a12, array[3]);
    CSWAP(array[4], array[13]);
    CSWAP(array[5], array[14]);
    CSWAP(array[5], array[13]);
    a12 = mymax(a12, array[4]);
    a12 = mymax(a12, array[5]);
    CSWAP(array[6], array[18]);
    CSWAP(array[7], array[19]);
    CSWAP(array[8], array[20]);
    CSWAP(array[8], array[19]);
    CSWAP(array[7], array[18]);
    CSWAP(array[8], array[18]);
    CSWAP(array[9], array[21]);
    CSWAP(array[10], array[22]);
    a11 = mymin(a11, array[23]);
    a11 = mymin(a11, array[22]);
    CSWAP(array[10], array[21]);
    a11 = mymin(a11, array[21]);
    CSWAP(array[9], array[18]);
    CSWAP(array[10], array[19]);
    a11 = mymin(a11, array[20]);
    a11 = mymin(a11, array[20]);
    a11 = mymin(a11, array[19]);
    CSWAP(array[10], array[18]);
    a11 = mymin(a11, array[18]);
    a12 = mymax(a12, array[6]);
    CSWAP(array[7], array[13]);
    CSWAP(array[8], array[14]);
    CSWAP(array[8], array[13]);
    a12 = mymax(a12, array[7]);
    a12 = mymax(a12, array[8]);
    CSWAP(array[9], array[15]);
    CSWAP(array[10], array[16]);
    a11 = mymin(a11, array[17]);
    a11 = mymin(a11, array[16]);
    CSWAP(array[10], array[15]);
    a11 = mymin(a11, array[15]);
    a12 = mymax(a12, array[9]);
    CSWAP(array[10], array[13]);
    a11 = mymin(a11, array[14]);
    a11 = mymin(a11, array[13]);
    a12 = mymax(a12, array[10]);

    return (a11 + a12) / 2;
}

float median5x5(float* array)
{
    float tmp = mymin(array[0], array[1]);
    array[1] = mymax(array[0], array[1]);
    array[0] = tmp;
    tmp = mymin(array[3], array[4]);
    array[4] = mymax(array[3], array[4]);
    array[3] = tmp;
    tmp = mymin(array[2], array[4]);
    array[4] = mymax(array[2], array[4]);
    array[2] = mymin(tmp, array[3]);
    array[3] = mymax(tmp, array[3]);
    tmp = mymin(array[6], array[7]);
    array[7] = mymax(array[6], array[7]);
    array[6] = tmp;
    tmp = mymin(array[5], array[7]);
    array[7] = mymax(array[5], array[7]);
    array[5] = mymin(tmp, array[6]);
    array[6] = mymax(tmp, array[6]);
    tmp = mymin(array[9], array[10]);
    array[10] = mymax(array[9], array[10]);
    array[9] = tmp;
    tmp = mymin(array[8], array[10]);
    array[10] = mymax(array[8], array[10]);
    array[8] = mymin(tmp, array[9]);
    array[9] = mymax(tmp, array[9]);
    tmp = mymin(array[12], array[13]);
    array[13] = mymax(array[12], array[13]);
    array[12] = tmp;
    tmp = mymin(array[11], array[13]);
    array[13] = mymax(array[11], array[13]);
    array[11] = mymin(tmp, array[12]);
    array[12] = mymax(tmp, array[12]);
    tmp = mymin(array[15], array[16]);
    array[16] = mymax(array[15], array[16]);
    array[15] = tmp;
    tmp = mymin(array[14], array[16]);
    array[16] = mymax(array[14], array[16]);
    array[14] = mymin(tmp, array[15]);
    array[15] = mymax(tmp, array[15]);
    tmp = mymin(array[18], array[19]);
    array[19] = mymax(array[18], array[19]);
    array[18] = tmp;
    tmp = mymin(array[17], array[19]);
    array[19] = mymax(array[17], array[19]);
    array[17] = mymin(tmp, array[18]);
    array[18] = mymax(tmp, array[18]);
    tmp = mymin(array[21], array[22]);
    array[22] = mymax(array[21], array[22]);
    array[21] = tmp;
    tmp = mymin(array[20], array[22]);
    array[22] = mymax(array[20], array[22]);
    array[20] = mymin(tmp, array[21]);
    array[21] = mymax(tmp, array[21]);
    tmp = mymin(array[23], array[24]);
    array[24] = mymax(array[23], array[24]);
    array[23] = tmp;
    tmp = mymin(array[2], array[5]);
    array[5] = mymax(array[2], array[5]);
    array[2] = tmp;
    tmp = mymin(array[3], array[6]);
    array[6] = mymax(array[3], array[6]);
    array[3] = tmp;
    tmp = mymin(array[0], array[6]);
    array[6] = mymax(array[0], array[6]);
    array[0] = mymin(tmp, array[3]);
    array[3] = mymax(tmp, array[3]);
    tmp = mymin(array[4], array[7]);
    array[7] = mymax(array[4], array[7]);
    array[4] = tmp;
    tmp = mymin(array[1], array[7]);
    array[7] = mymax(array[1], array[7]);
    array[1] = mymin(tmp, array[4]);
    array[4] = mymax(tmp, array[4]);
    tmp = mymin(array[11], array[14]);
    array[14] = mymax(array[11], array[14]);
    array[11] = tmp;
    tmp = mymin(array[8], array[14]);
    array[14] = mymax(array[8], array[14]);
    array[8] = mymin(tmp, array[11]);
    array[11] = mymax(tmp, array[11]);
    tmp = mymin(array[12], array[15]);
    array[15] = mymax(array[12], array[15]);
    array[12] = tmp;
    tmp = mymin(array[9], array[15]);
    array[15] = mymax(array[9], array[15]);
    array[9] = mymin(tmp, array[12]);
    array[12] = mymax(tmp, array[12]);
    tmp = mymin(array[13], array[16]);
    array[16] = mymax(array[13], array[16]);
    array[13] = tmp;
    tmp = mymin(array[10], array[16]);
    array[16] = mymax(array[10], array[16]);
    array[10] = mymin(tmp, array[13]);
    array[13] = mymax(tmp, array[13]);
    tmp = mymin(array[20], array[23]);
    array[23] = mymax(array[20], array[23]);
    array[20] = tmp;
    tmp = mymin(array[17], array[23]);
    array[23] = mymax(array[17], array[23]);
    array[17] = mymin(tmp, array[20]);
    array[20] = mymax(tmp, array[20]);
    tmp = mymin(array[21], array[24]);
    array[24] = mymax(array[21], array[24]);
    array[21] = tmp;
    tmp = mymin(array[18], array[24]);
    array[24] = mymax(array[18], array[24]);
    array[18] = mymin(tmp, array[21]);
    array[21] = mymax(tmp, array[21]);
    tmp = mymin(array[19], array[22]);
    array[22] = mymax(array[19], array[22]);
    array[19] = tmp;
    array[17] = mymax(array[8], array[17]);
    tmp = mymin(array[9], array[18]);
    array[18] = mymax(array[9], array[18]);
    array[9] = tmp;
    tmp = mymin(array[0], array[18]);
    array[18] = mymax(array[0], array[18]);
    array[9] = mymax(tmp, array[9]);
    tmp = mymin(array[10], array[19]);
    array[19] = mymax(array[10], array[19]);
    array[10] = tmp;
    tmp = mymin(array[1], array[19]);
    array[19] = mymax(array[1], array[19]);
    array[1] = mymin(tmp, array[10]);
    array[10] = mymax(tmp, array[10]);
    tmp = mymin(array[11], array[20]);
    array[20] = mymax(array[11], array[20]);
    array[11] = tmp;
    tmp = mymin(array[2], array[20]);
    array[20] = mymax(array[2], array[20]);
    array[11] = mymax(tmp, array[11]);
    tmp = mymin(array[12], array[21]);
    array[21] = mymax(array[12], array[21]);
    array[12] = tmp;
    tmp = mymin(array[3], array[21]);
    array[21] = mymax(array[3], array[21]);
    array[3] = mymin(tmp, array[12]);
    array[12] = mymax(tmp, array[12]);
    tmp = mymin(array[13], array[22]);
    array[22] = mymax(array[13], array[22]);
    array[4] = mymin(array[4], array[22]);
    array[13] = mymax(array[4], tmp);
    tmp = mymin(array[4], tmp);
    array[4] = tmp;
    tmp = mymin(array[14], array[23]);
    array[23] = mymax(array[14], array[23]);
    array[14] = tmp;
    tmp = mymin(array[5], array[23]);
    array[23] = mymax(array[5], array[23]);
    array[5] = mymin(tmp, array[14]);
    array[14] = mymax(tmp, array[14]);
    tmp = mymin(array[15], array[24]);
    array[24] = mymax(array[15], array[24]);
    array[15] = tmp;
    array[6] = mymin(array[6], array[24]);
    tmp = mymin(array[6], array[15]);
    array[15] = mymax(array[6], array[15]);
    array[6] = tmp;
    tmp = mymin(array[7], array[16]);
    array[7] = mymin(tmp, array[19]);
    tmp = mymin(array[13], array[21]);
    array[15] = mymin(array[15], array[23]);
    tmp = mymin(array[7], tmp);
    array[7] = mymin(tmp, array[15]);
    array[9] = mymax(array[1], array[9]);
    array[11] = mymax(array[3], array[11]);
    array[17] = mymax(array[5], array[17]);
    array[17] = mymax(array[11], array[17]);
    array[17] = mymax(array[9], array[17]);
    tmp = mymin(array[4], array[10]);
    array[10] = mymax(array[4], array[10]);
    array[4] = tmp;
    tmp = mymin(array[6], array[12]);
    array[12] = mymax(array[6], array[12]);
    array[6] = tmp;
    tmp = mymin(array[7], array[14]);
    array[14] = mymax(array[7], array[14]);
    array[7] = tmp;
    tmp = mymin(array[4], array[6]);
    array[6] = mymax(array[4], array[6]);
    array[7] = mymax(tmp, array[7]);
    tmp = mymin(array[12], array[14]);
    array[14] = mymax(array[12], array[14]);
    array[12] = tmp;
    array[10] = mymin(array[10], array[14]);
    tmp = mymin(array[6], array[7]);
    array[7] = mymax(array[6], array[7]);
    array[6] = tmp;
    tmp = mymin(array[10], array[12]);
    array[12] = mymax(array[10], array[12]);
    array[10] = mymax(array[6], tmp);
    tmp = mymin(array[6], tmp);
    array[17] = mymax(tmp, array[17]);
    tmp = mymin(array[12], array[17]);
    array[17] = mymax(array[12], array[17]);
    array[12] = tmp;
    array[7] = mymin(array[7], array[17]);
    tmp = mymin(array[7], array[10]);
    array[10] = mymax(array[7], array[10]);
    array[7] = tmp;
    tmp = mymin(array[12], array[18]);
    array[18] = mymax(array[12], array[18]);
    array[12] = mymax(array[7], tmp);
    array[10] = mymin(array[10], array[18]);
    tmp = mymin(array[12], array[20]);
    array[20] = mymax(array[12], array[20]);
    array[12] = tmp;
    tmp = mymin(array[10], array[20]);
    return mymax(tmp, array[12]);
}

float median7x7(float* array)
{
    float tmp = mymin(array[0], array[32]);
    array[32] = mymax(array[0], array[32]);
    array[0] = tmp;
    tmp = mymin(array[1], array[33]);
    array[33] = mymax(array[1], array[33]);
    array[1] = tmp;
    tmp = mymin(array[2], array[34]);
    array[34] = mymax(array[2], array[34]);
    array[2] = tmp;
    tmp = mymin(array[3], array[35]);
    array[35] = mymax(array[3], array[35]);
    array[3] = tmp;
    tmp = mymin(array[4], array[36]);
    array[36] = mymax(array[4], array[36]);
    array[4] = tmp;
    tmp = mymin(array[5], array[37]);
    array[37] = mymax(array[5], array[37]);
    array[5] = tmp;
    tmp = mymin(array[6], array[38]);
    array[38] = mymax(array[6], array[38]);
    array[6] = tmp;
    tmp = mymin(array[7], array[39]);
    array[39] = mymax(array[7], array[39]);
    array[7] = tmp;
    tmp = mymin(array[8], array[40]);
    array[40] = mymax(array[8], array[40]);
    array[8] = tmp;
    tmp = mymin(array[9], array[41]);
    array[41] = mymax(array[9], array[41]);
    array[9] = tmp;
    tmp = mymin(array[10], array[42]);
    array[42] = mymax(array[10], array[42]);
    array[10] = tmp;
    tmp = mymin(array[11], array[43]);
    array[43] = mymax(array[11], array[43]);
    array[11] = tmp;
    tmp = mymin(array[12], array[44]);
    array[44] = mymax(array[12], array[44]);
    array[12] = tmp;
    tmp = mymin(array[13], array[45]);
    array[45] = mymax(array[13], array[45]);
    array[13] = tmp;
    tmp = mymin(array[14], array[46]);
    array[46] = mymax(array[14], array[46]);
    array[14] = tmp;
    tmp = mymin(array[15], array[47]);
    array[47] = mymax(array[15], array[47]);
    array[15] = tmp;
    tmp = mymin(array[16], array[48]);
    array[48] = mymax(array[16], array[48]);
    array[16] = tmp;
    tmp = mymin(array[0], array[16]);
    array[16] = mymax(array[0], array[16]);
    array[0] = tmp;
    tmp = mymin(array[1], array[17]);
    array[17] = mymax(array[1], array[17]);
    array[1] = tmp;
    tmp = mymin(array[2], array[18]);
    array[18] = mymax(array[2], array[18]);
    array[2] = tmp;
    tmp = mymin(array[3], array[19]);
    array[19] = mymax(array[3], array[19]);
    array[3] = tmp;
    tmp = mymin(array[4], array[20]);
    array[20] = mymax(array[4], array[20]);
    array[4] = tmp;
    tmp = mymin(array[5], array[21]);
    array[21] = mymax(array[5], array[21]);
    array[5] = tmp;
    tmp = mymin(array[6], array[22]);
    array[22] = mymax(array[6], array[22]);
    array[6] = tmp;
    tmp = mymin(array[7], array[23]);
    array[23] = mymax(array[7], array[23]);
    array[7] = tmp;
    tmp = mymin(array[8], array[24]);
    array[24] = mymax(array[8], array[24]);
    array[8] = tmp;
    tmp = mymin(array[9], array[25]);
    array[25] = mymax(array[9], array[25]);
    array[9] = tmp;
    tmp = mymin(array[10], array[26]);
    array[26] = mymax(array[10], array[26]);
    array[10] = tmp;
    tmp = mymin(array[11], array[27]);
    array[27] = mymax(array[11], array[27]);
    array[11] = tmp;
    tmp = mymin(array[12], array[28]);
    array[28] = mymax(array[12], array[28]);
    array[12] = tmp;
    tmp = mymin(array[13], array[29]);
    array[29] = mymax(array[13], array[29]);
    array[13] = tmp;
    tmp = mymin(array[14], array[30]);
    array[30] = mymax(array[14], array[30]);
    array[14] = tmp;
    tmp = mymin(array[15], array[31]);
    array[31] = mymax(array[15], array[31]);
    array[15] = tmp;
    tmp = mymin(array[32], array[48]);
    array[48] = mymax(array[32], array[48]);
    array[32] = tmp;
    tmp = mymin(array[16], array[32]);
    array[32] = mymax(array[16], array[32]);
    array[16] = tmp;
    tmp = mymin(array[17], array[33]);
    array[33] = mymax(array[17], array[33]);
    array[17] = tmp;
    tmp = mymin(array[18], array[34]);
    array[34] = mymax(array[18], array[34]);
    array[18] = tmp;
    tmp = mymin(array[19], array[35]);
    array[35] = mymax(array[19], array[35]);
    array[19] = tmp;
    tmp = mymin(array[20], array[36]);
    array[36] = mymax(array[20], array[36]);
    array[20] = tmp;
    tmp = mymin(array[21], array[37]);
    array[37] = mymax(array[21], array[37]);
    array[21] = tmp;
    tmp = mymin(array[22], array[38]);
    array[38] = mymax(array[22], array[38]);
    array[22] = tmp;
    tmp = mymin(array[23], array[39]);
    array[39] = mymax(array[23], array[39]);
    array[23] = tmp;
    tmp = mymin(array[24], array[40]);
    array[40] = mymax(array[24], array[40]);
    array[24] = tmp;
    tmp = mymin(array[25], array[41]);
    array[41] = mymax(array[25], array[41]);
    array[25] = tmp;
    tmp = mymin(array[26], array[42]);
    array[42] = mymax(array[26], array[42]);
    array[26] = tmp;
    tmp = mymin(array[27], array[43]);
    array[43] = mymax(array[27], array[43]);
    array[27] = tmp;
    tmp = mymin(array[28], array[44]);
    array[44] = mymax(array[28], array[44]);
    array[28] = tmp;
    tmp = mymin(array[29], array[45]);
    array[45] = mymax(array[29], array[45]);
    array[29] = tmp;
    tmp = mymin(array[30], array[46]);
    array[46] = mymax(array[30], array[46]);
    array[30] = tmp;
    tmp = mymin(array[31], array[47]);
    array[47] = mymax(array[31], array[47]);
    array[31] = tmp;
    tmp = mymin(array[0], array[8]);
    array[8] = mymax(array[0], array[8]);
    array[0] = tmp;
    tmp = mymin(array[1], array[9]);
    array[9] = mymax(array[1], array[9]);
    array[1] = tmp;
    tmp = mymin(array[2], array[10]);
    array[10] = mymax(array[2], array[10]);
    array[2] = tmp;
    tmp = mymin(array[3], array[11]);
    array[11] = mymax(array[3], array[11]);
    array[3] = tmp;
    tmp = mymin(array[4], array[12]);
    array[12] = mymax(array[4], array[12]);
    array[4] = tmp;
    tmp = mymin(array[5], array[13]);
    array[13] = mymax(array[5], array[13]);
    array[5] = tmp;
    tmp = mymin(array[6], array[14]);
    array[14] = mymax(array[6], array[14]);
    array[6] = tmp;
    tmp = mymin(array[7], array[15]);
    array[15] = mymax(array[7], array[15]);
    array[7] = tmp;
    tmp = mymin(array[16], array[24]);
    array[24] = mymax(array[16], array[24]);
    array[16] = tmp;
    tmp = mymin(array[17], array[25]);
    array[25] = mymax(array[17], array[25]);
    array[17] = tmp;
    tmp = mymin(array[18], array[26]);
    array[26] = mymax(array[18], array[26]);
    array[18] = tmp;
    tmp = mymin(array[19], array[27]);
    array[27] = mymax(array[19], array[27]);
    array[19] = tmp;
    tmp = mymin(array[20], array[28]);
    array[28] = mymax(array[20], array[28]);
    array[20] = tmp;
    tmp = mymin(array[21], array[29]);
    array[29] = mymax(array[21], array[29]);
    array[21] = tmp;
    tmp = mymin(array[22], array[30]);
    array[30] = mymax(array[22], array[30]);
    array[22] = tmp;
    tmp = mymin(array[23], array[31]);
    array[31] = mymax(array[23], array[31]);
    array[23] = tmp;
    tmp = mymin(array[32], array[40]);
    array[40] = mymax(array[32], array[40]);
    array[32] = tmp;
    tmp = mymin(array[33], array[41]);
    array[41] = mymax(array[33], array[41]);
    array[33] = tmp;
    tmp = mymin(array[34], array[42]);
    array[42] = mymax(array[34], array[42]);
    array[34] = tmp;
    tmp = mymin(array[35], array[43]);
    array[43] = mymax(array[35], array[43]);
    array[35] = tmp;
    tmp = mymin(array[36], array[44]);
    array[44] = mymax(array[36], array[44]);
    array[36] = tmp;
    tmp = mymin(array[37], array[45]);
    array[45] = mymax(array[37], array[45]);
    array[37] = tmp;
    tmp = mymin(array[38], array[46]);
    array[46] = mymax(array[38], array[46]);
    array[38] = tmp;
    tmp = mymin(array[39], array[47]);
    array[47] = mymax(array[39], array[47]);
    array[39] = tmp;
    tmp = mymin(array[8], array[32]);
    array[32] = mymax(array[8], array[32]);
    array[8] = tmp;
    tmp = mymin(array[9], array[33]);
    array[33] = mymax(array[9], array[33]);
    array[9] = tmp;
    tmp = mymin(array[10], array[34]);
    array[34] = mymax(array[10], array[34]);
    array[10] = tmp;
    tmp = mymin(array[11], array[35]);
    array[35] = mymax(array[11], array[35]);
    array[11] = tmp;
    tmp = mymin(array[12], array[36]);
    array[36] = mymax(array[12], array[36]);
    array[12] = tmp;
    tmp = mymin(array[13], array[37]);
    array[37] = mymax(array[13], array[37]);
    array[13] = tmp;
    tmp = mymin(array[14], array[38]);
    array[38] = mymax(array[14], array[38]);
    array[14] = tmp;
    tmp = mymin(array[15], array[39]);
    array[39] = mymax(array[15], array[39]);
    array[15] = tmp;
    tmp = mymin(array[24], array[48]);
    array[48] = mymax(array[24], array[48]);
    array[24] = tmp;
    tmp = mymin(array[8], array[16]);
    array[16] = mymax(array[8], array[16]);
    array[8] = tmp;
    tmp = mymin(array[9], array[17]);
    array[17] = mymax(array[9], array[17]);
    array[9] = tmp;
    tmp = mymin(array[10], array[18]);
    array[18] = mymax(array[10], array[18]);
    array[10] = tmp;
    tmp = mymin(array[11], array[19]);
    array[19] = mymax(array[11], array[19]);
    array[11] = tmp;
    tmp = mymin(array[12], array[20]);
    array[20] = mymax(array[12], array[20]);
    array[12] = tmp;
    tmp = mymin(array[13], array[21]);
    array[21] = mymax(array[13], array[21]);
    array[13] = tmp;
    tmp = mymin(array[14], array[22]);
    array[22] = mymax(array[14], array[22]);
    array[14] = tmp;
    tmp = mymin(array[15], array[23]);
    array[23] = mymax(array[15], array[23]);
    array[15] = tmp;
    tmp = mymin(array[24], array[32]);
    array[32] = mymax(array[24], array[32]);
    array[24] = tmp;
    tmp = mymin(array[25], array[33]);
    array[33] = mymax(array[25], array[33]);
    array[25] = tmp;
    tmp = mymin(array[26], array[34]);
    array[34] = mymax(array[26], array[34]);
    array[26] = tmp;
    tmp = mymin(array[27], array[35]);
    array[35] = mymax(array[27], array[35]);
    array[27] = tmp;
    tmp = mymin(array[28], array[36]);
    array[36] = mymax(array[28], array[36]);
    array[28] = tmp;
    tmp = mymin(array[29], array[37]);
    array[37] = mymax(array[29], array[37]);
    array[29] = tmp;
    tmp = mymin(array[30], array[38]);
    array[38] = mymax(array[30], array[38]);
    array[30] = tmp;
    tmp = mymin(array[31], array[39]);
    array[39] = mymax(array[31], array[39]);
    array[31] = tmp;
    tmp = mymin(array[40], array[48]);
    array[48] = mymax(array[40], array[48]);
    array[40] = tmp;
    tmp = mymin(array[0], array[4]);
    array[4] = mymax(array[0], array[4]);
    array[0] = tmp;
    tmp = mymin(array[1], array[5]);
    array[5] = mymax(array[1], array[5]);
    array[1] = tmp;
    tmp = mymin(array[2], array[6]);
    array[6] = mymax(array[2], array[6]);
    array[2] = tmp;
    tmp = mymin(array[3], array[7]);
    array[7] = mymax(array[3], array[7]);
    array[3] = tmp;
    tmp = mymin(array[8], array[12]);
    array[12] = mymax(array[8], array[12]);
    array[8] = tmp;
    tmp = mymin(array[9], array[13]);
    array[13] = mymax(array[9], array[13]);
    array[9] = tmp;
    tmp = mymin(array[10], array[14]);
    array[14] = mymax(array[10], array[14]);
    array[10] = tmp;
    tmp = mymin(array[11], array[15]);
    array[15] = mymax(array[11], array[15]);
    array[11] = tmp;
    tmp = mymin(array[16], array[20]);
    array[20] = mymax(array[16], array[20]);
    array[16] = tmp;
    tmp = mymin(array[17], array[21]);
    array[21] = mymax(array[17], array[21]);
    array[17] = tmp;
    tmp = mymin(array[18], array[22]);
    array[22] = mymax(array[18], array[22]);
    array[18] = tmp;
    tmp = mymin(array[19], array[23]);
    array[23] = mymax(array[19], array[23]);
    array[19] = tmp;
    tmp = mymin(array[24], array[28]);
    array[28] = mymax(array[24], array[28]);
    array[24] = tmp;
    tmp = mymin(array[25], array[29]);
    array[29] = mymax(array[25], array[29]);
    array[25] = tmp;
    tmp = mymin(array[26], array[30]);
    array[30] = mymax(array[26], array[30]);
    array[26] = tmp;
    tmp = mymin(array[27], array[31]);
    array[31] = mymax(array[27], array[31]);
    array[27] = tmp;
    tmp = mymin(array[32], array[36]);
    array[36] = mymax(array[32], array[36]);
    array[32] = tmp;
    tmp = mymin(array[33], array[37]);
    array[37] = mymax(array[33], array[37]);
    array[33] = tmp;
    tmp = mymin(array[34], array[38]);
    array[38] = mymax(array[34], array[38]);
    array[34] = tmp;
    tmp = mymin(array[35], array[39]);
    array[39] = mymax(array[35], array[39]);
    array[35] = tmp;
    tmp = mymin(array[40], array[44]);
    array[44] = mymax(array[40], array[44]);
    array[40] = tmp;
    tmp = mymin(array[41], array[45]);
    array[45] = mymax(array[41], array[45]);
    array[41] = tmp;
    tmp = mymin(array[42], array[46]);
    array[46] = mymax(array[42], array[46]);
    array[42] = tmp;
    tmp = mymin(array[43], array[47]);
    array[47] = mymax(array[43], array[47]);
    array[43] = tmp;
    tmp = mymin(array[4], array[32]);
    array[32] = mymax(array[4], array[32]);
    array[4] = tmp;
    tmp = mymin(array[5], array[33]);
    array[33] = mymax(array[5], array[33]);
    array[5] = tmp;
    tmp = mymin(array[6], array[34]);
    array[34] = mymax(array[6], array[34]);
    array[6] = tmp;
    tmp = mymin(array[7], array[35]);
    array[35] = mymax(array[7], array[35]);
    array[7] = tmp;
    tmp = mymin(array[12], array[40]);
    array[40] = mymax(array[12], array[40]);
    array[12] = tmp;
    tmp = mymin(array[13], array[41]);
    array[41] = mymax(array[13], array[41]);
    array[13] = tmp;
    tmp = mymin(array[14], array[42]);
    array[42] = mymax(array[14], array[42]);
    array[14] = tmp;
    tmp = mymin(array[15], array[43]);
    array[43] = mymax(array[15], array[43]);
    array[15] = tmp;
    tmp = mymin(array[20], array[48]);
    array[48] = mymax(array[20], array[48]);
    array[20] = tmp;
    tmp = mymin(array[4], array[16]);
    array[16] = mymax(array[4], array[16]);
    array[4] = tmp;
    tmp = mymin(array[5], array[17]);
    array[17] = mymax(array[5], array[17]);
    array[5] = tmp;
    tmp = mymin(array[6], array[18]);
    array[18] = mymax(array[6], array[18]);
    array[6] = tmp;
    tmp = mymin(array[7], array[19]);
    array[19] = mymax(array[7], array[19]);
    array[7] = tmp;
    tmp = mymin(array[12], array[24]);
    array[24] = mymax(array[12], array[24]);
    array[12] = tmp;
    tmp = mymin(array[13], array[25]);
    array[25] = mymax(array[13], array[25]);
    array[13] = tmp;
    tmp = mymin(array[14], array[26]);
    array[26] = mymax(array[14], array[26]);
    array[14] = tmp;
    tmp = mymin(array[15], array[27]);
    array[27] = mymax(array[15], array[27]);
    array[15] = tmp;
    tmp = mymin(array[20], array[32]);
    array[32] = mymax(array[20], array[32]);
    array[20] = tmp;
    tmp = mymin(array[21], array[33]);
    array[33] = mymax(array[21], array[33]);
    array[21] = tmp;
    tmp = mymin(array[22], array[34]);
    array[34] = mymax(array[22], array[34]);
    array[22] = tmp;
    tmp = mymin(array[23], array[35]);
    array[35] = mymax(array[23], array[35]);
    array[23] = tmp;
    tmp = mymin(array[28], array[40]);
    array[40] = mymax(array[28], array[40]);
    array[28] = tmp;
    tmp = mymin(array[29], array[41]);
    array[41] = mymax(array[29], array[41]);
    array[29] = tmp;
    tmp = mymin(array[30], array[42]);
    array[42] = mymax(array[30], array[42]);
    array[30] = tmp;
    tmp = mymin(array[31], array[43]);
    array[43] = mymax(array[31], array[43]);
    array[31] = tmp;
    tmp = mymin(array[36], array[48]);
    array[48] = mymax(array[36], array[48]);
    array[36] = tmp;
    tmp = mymin(array[4], array[8]);
    array[8] = mymax(array[4], array[8]);
    array[4] = tmp;
    tmp = mymin(array[5], array[9]);
    array[9] = mymax(array[5], array[9]);
    array[5] = tmp;
    tmp = mymin(array[6], array[10]);
    array[10] = mymax(array[6], array[10]);
    array[6] = tmp;
    tmp = mymin(array[7], array[11]);
    array[11] = mymax(array[7], array[11]);
    array[7] = tmp;
    tmp = mymin(array[12], array[16]);
    array[16] = mymax(array[12], array[16]);
    array[12] = tmp;
    tmp = mymin(array[13], array[17]);
    array[17] = mymax(array[13], array[17]);
    array[13] = tmp;
    tmp = mymin(array[14], array[18]);
    array[18] = mymax(array[14], array[18]);
    array[14] = tmp;
    tmp = mymin(array[15], array[19]);
    array[19] = mymax(array[15], array[19]);
    array[15] = tmp;
    tmp = mymin(array[20], array[24]);
    array[24] = mymax(array[20], array[24]);
    array[20] = tmp;
    tmp = mymin(array[21], array[25]);
    array[25] = mymax(array[21], array[25]);
    array[21] = tmp;
    tmp = mymin(array[22], array[26]);
    array[26] = mymax(array[22], array[26]);
    array[22] = tmp;
    tmp = mymin(array[23], array[27]);
    array[27] = mymax(array[23], array[27]);
    array[23] = tmp;
    tmp = mymin(array[28], array[32]);
    array[32] = mymax(array[28], array[32]);
    array[28] = tmp;
    tmp = mymin(array[29], array[33]);
    array[33] = mymax(array[29], array[33]);
    array[29] = tmp;
    tmp = mymin(array[30], array[34]);
    array[34] = mymax(array[30], array[34]);
    array[30] = tmp;
    tmp = mymin(array[31], array[35]);
    array[35] = mymax(array[31], array[35]);
    array[31] = tmp;
    tmp = mymin(array[36], array[40]);
    array[40] = mymax(array[36], array[40]);
    array[36] = tmp;
    tmp = mymin(array[37], array[41]);
    array[41] = mymax(array[37], array[41]);
    array[37] = tmp;
    tmp = mymin(array[38], array[42]);
    array[42] = mymax(array[38], array[42]);
    array[38] = tmp;
    tmp = mymin(array[39], array[43]);
    array[43] = mymax(array[39], array[43]);
    array[39] = tmp;
    tmp = mymin(array[44], array[48]);
    array[48] = mymax(array[44], array[48]);
    array[44] = tmp;
    tmp = mymin(array[0], array[2]);
    array[2] = mymax(array[0], array[2]);
    array[0] = tmp;
    tmp = mymin(array[1], array[3]);
    array[3] = mymax(array[1], array[3]);
    array[1] = tmp;
    tmp = mymin(array[4], array[6]);
    array[6] = mymax(array[4], array[6]);
    array[4] = tmp;
    tmp = mymin(array[5], array[7]);
    array[7] = mymax(array[5], array[7]);
    array[5] = tmp;
    tmp = mymin(array[8], array[10]);
    array[10] = mymax(array[8], array[10]);
    array[8] = tmp;
    tmp = mymin(array[9], array[11]);
    array[11] = mymax(array[9], array[11]);
    array[9] = tmp;
    tmp = mymin(array[12], array[14]);
    array[14] = mymax(array[12], array[14]);
    array[12] = tmp;
    tmp = mymin(array[13], array[15]);
    array[15] = mymax(array[13], array[15]);
    array[13] = tmp;
    tmp = mymin(array[16], array[18]);
    array[18] = mymax(array[16], array[18]);
    array[16] = tmp;
    tmp = mymin(array[17], array[19]);
    array[19] = mymax(array[17], array[19]);
    array[17] = tmp;
    tmp = mymin(array[20], array[22]);
    array[22] = mymax(array[20], array[22]);
    array[20] = tmp;
    tmp = mymin(array[21], array[23]);
    array[23] = mymax(array[21], array[23]);
    array[21] = tmp;
    tmp = mymin(array[24], array[26]);
    array[26] = mymax(array[24], array[26]);
    array[24] = tmp;
    tmp = mymin(array[25], array[27]);
    array[27] = mymax(array[25], array[27]);
    array[25] = tmp;
    tmp = mymin(array[28], array[30]);
    array[30] = mymax(array[28], array[30]);
    array[28] = tmp;
    tmp = mymin(array[29], array[31]);
    array[31] = mymax(array[29], array[31]);
    array[29] = tmp;
    tmp = mymin(array[32], array[34]);
    array[34] = mymax(array[32], array[34]);
    array[32] = tmp;
    tmp = mymin(array[33], array[35]);
    array[35] = mymax(array[33], array[35]);
    array[33] = tmp;
    tmp = mymin(array[36], array[38]);
    array[38] = mymax(array[36], array[38]);
    array[36] = tmp;
    tmp = mymin(array[37], array[39]);
    array[39] = mymax(array[37], array[39]);
    array[37] = tmp;
    tmp = mymin(array[40], array[42]);
    array[42] = mymax(array[40], array[42]);
    array[40] = tmp;
    tmp = mymin(array[41], array[43]);
    array[43] = mymax(array[41], array[43]);
    array[41] = tmp;
    tmp = mymin(array[44], array[46]);
    array[46] = mymax(array[44], array[46]);
    array[44] = tmp;
    tmp = mymin(array[45], array[47]);
    array[47] = mymax(array[45], array[47]);
    array[45] = tmp;
    tmp = mymin(array[2], array[32]);
    array[32] = mymax(array[2], array[32]);
    array[2] = tmp;
    tmp = mymin(array[3], array[33]);
    array[33] = mymax(array[3], array[33]);
    array[3] = tmp;
    tmp = mymin(array[6], array[36]);
    array[36] = mymax(array[6], array[36]);
    array[6] = tmp;
    tmp = mymin(array[7], array[37]);
    array[37] = mymax(array[7], array[37]);
    array[7] = tmp;
    tmp = mymin(array[10], array[40]);
    array[40] = mymax(array[10], array[40]);
    array[10] = tmp;
    tmp = mymin(array[11], array[41]);
    array[41] = mymax(array[11], array[41]);
    array[11] = tmp;
    tmp = mymin(array[14], array[44]);
    array[44] = mymax(array[14], array[44]);
    array[14] = tmp;
    tmp = mymin(array[15], array[45]);
    array[45] = mymax(array[15], array[45]);
    array[15] = tmp;
    tmp = mymin(array[18], array[48]);
    array[48] = mymax(array[18], array[48]);
    array[18] = tmp;
    tmp = mymin(array[2], array[16]);
    array[16] = mymax(array[2], array[16]);
    array[2] = tmp;
    tmp = mymin(array[3], array[17]);
    array[17] = mymax(array[3], array[17]);
    array[3] = tmp;
    tmp = mymin(array[6], array[20]);
    array[20] = mymax(array[6], array[20]);
    array[6] = tmp;
    tmp = mymin(array[7], array[21]);
    array[21] = mymax(array[7], array[21]);
    array[7] = tmp;
    tmp = mymin(array[10], array[24]);
    array[24] = mymax(array[10], array[24]);
    array[10] = tmp;
    tmp = mymin(array[11], array[25]);
    array[25] = mymax(array[11], array[25]);
    array[11] = tmp;
    tmp = mymin(array[14], array[28]);
    array[28] = mymax(array[14], array[28]);
    array[14] = tmp;
    tmp = mymin(array[15], array[29]);
    array[29] = mymax(array[15], array[29]);
    array[15] = tmp;
    tmp = mymin(array[18], array[32]);
    array[32] = mymax(array[18], array[32]);
    array[18] = tmp;
    tmp = mymin(array[19], array[33]);
    array[33] = mymax(array[19], array[33]);
    array[19] = tmp;
    tmp = mymin(array[22], array[36]);
    array[36] = mymax(array[22], array[36]);
    array[22] = tmp;
    tmp = mymin(array[23], array[37]);
    array[37] = mymax(array[23], array[37]);
    array[23] = tmp;
    tmp = mymin(array[26], array[40]);
    array[40] = mymax(array[26], array[40]);
    array[26] = tmp;
    tmp = mymin(array[27], array[41]);
    array[41] = mymax(array[27], array[41]);
    array[27] = tmp;
    tmp = mymin(array[30], array[44]);
    array[44] = mymax(array[30], array[44]);
    array[30] = tmp;
    tmp = mymin(array[31], array[45]);
    array[45] = mymax(array[31], array[45]);
    array[31] = tmp;
    tmp = mymin(array[34], array[48]);
    array[48] = mymax(array[34], array[48]);
    array[34] = tmp;
    tmp = mymin(array[2], array[8]);
    array[8] = mymax(array[2], array[8]);
    array[2] = tmp;
    tmp = mymin(array[3], array[9]);
    array[9] = mymax(array[3], array[9]);
    array[3] = tmp;
    tmp = mymin(array[6], array[12]);
    array[12] = mymax(array[6], array[12]);
    array[6] = tmp;
    tmp = mymin(array[7], array[13]);
    array[13] = mymax(array[7], array[13]);
    array[7] = tmp;
    tmp = mymin(array[10], array[16]);
    array[16] = mymax(array[10], array[16]);
    array[10] = tmp;
    tmp = mymin(array[11], array[17]);
    array[17] = mymax(array[11], array[17]);
    array[11] = tmp;
    tmp = mymin(array[14], array[20]);
    array[20] = mymax(array[14], array[20]);
    array[14] = tmp;
    tmp = mymin(array[15], array[21]);
    array[21] = mymax(array[15], array[21]);
    array[15] = tmp;
    tmp = mymin(array[18], array[24]);
    array[24] = mymax(array[18], array[24]);
    array[18] = tmp;
    tmp = mymin(array[19], array[25]);
    array[25] = mymax(array[19], array[25]);
    array[19] = tmp;
    tmp = mymin(array[22], array[28]);
    array[28] = mymax(array[22], array[28]);
    array[22] = tmp;
    tmp = mymin(array[23], array[29]);
    array[29] = mymax(array[23], array[29]);
    array[23] = tmp;
    tmp = mymin(array[26], array[32]);
    array[32] = mymax(array[26], array[32]);
    array[26] = tmp;
    tmp = mymin(array[27], array[33]);
    array[33] = mymax(array[27], array[33]);
    array[27] = tmp;
    tmp = mymin(array[30], array[36]);
    array[36] = mymax(array[30], array[36]);
    array[30] = tmp;
    tmp = mymin(array[31], array[37]);
    array[37] = mymax(array[31], array[37]);
    array[31] = tmp;
    tmp = mymin(array[34], array[40]);
    array[40] = mymax(array[34], array[40]);
    array[34] = tmp;
    tmp = mymin(array[35], array[41]);
    array[41] = mymax(array[35], array[41]);
    array[35] = tmp;
    tmp = mymin(array[38], array[44]);
    array[44] = mymax(array[38], array[44]);
    array[38] = tmp;
    tmp = mymin(array[39], array[45]);
    array[45] = mymax(array[39], array[45]);
    array[39] = tmp;
    tmp = mymin(array[42], array[48]);
    array[48] = mymax(array[42], array[48]);
    array[42] = tmp;
    tmp = mymin(array[2], array[4]);
    array[4] = mymax(array[2], array[4]);
    array[2] = tmp;
    tmp = mymin(array[3], array[5]);
    array[5] = mymax(array[3], array[5]);
    array[3] = tmp;
    tmp = mymin(array[6], array[8]);
    array[8] = mymax(array[6], array[8]);
    array[6] = tmp;
    tmp = mymin(array[7], array[9]);
    array[9] = mymax(array[7], array[9]);
    array[7] = tmp;
    tmp = mymin(array[10], array[12]);
    array[12] = mymax(array[10], array[12]);
    array[10] = tmp;
    tmp = mymin(array[11], array[13]);
    array[13] = mymax(array[11], array[13]);
    array[11] = tmp;
    tmp = mymin(array[14], array[16]);
    array[16] = mymax(array[14], array[16]);
    array[14] = tmp;
    tmp = mymin(array[15], array[17]);
    array[17] = mymax(array[15], array[17]);
    array[15] = tmp;
    tmp = mymin(array[18], array[20]);
    array[20] = mymax(array[18], array[20]);
    array[18] = tmp;
    tmp = mymin(array[19], array[21]);
    array[21] = mymax(array[19], array[21]);
    array[19] = tmp;
    tmp = mymin(array[22], array[24]);
    array[24] = mymax(array[22], array[24]);
    array[22] = tmp;
    tmp = mymin(array[23], array[25]);
    array[25] = mymax(array[23], array[25]);
    array[23] = tmp;
    tmp = mymin(array[26], array[28]);
    array[28] = mymax(array[26], array[28]);
    array[26] = tmp;
    tmp = mymin(array[27], array[29]);
    array[29] = mymax(array[27], array[29]);
    array[27] = tmp;
    tmp = mymin(array[30], array[32]);
    array[32] = mymax(array[30], array[32]);
    array[30] = tmp;
    tmp = mymin(array[31], array[33]);
    array[33] = mymax(array[31], array[33]);
    array[31] = tmp;
    tmp = mymin(array[34], array[36]);
    array[36] = mymax(array[34], array[36]);
    array[34] = tmp;
    tmp = mymin(array[35], array[37]);
    array[37] = mymax(array[35], array[37]);
    array[35] = tmp;
    tmp = mymin(array[38], array[40]);
    array[40] = mymax(array[38], array[40]);
    array[38] = tmp;
    tmp = mymin(array[39], array[41]);
    array[41] = mymax(array[39], array[41]);
    array[39] = tmp;
    tmp = mymin(array[42], array[44]);
    array[44] = mymax(array[42], array[44]);
    array[42] = tmp;
    tmp = mymin(array[43], array[45]);
    array[45] = mymax(array[43], array[45]);
    array[43] = tmp;
    tmp = mymin(array[46], array[48]);
    array[48] = mymax(array[46], array[48]);
    array[46] = tmp;
    array[1] = mymax(array[0], array[1]);
    array[3] = mymax(array[2], array[3]);
    array[5] = mymax(array[4], array[5]);
    array[7] = mymax(array[6], array[7]);
    array[9] = mymax(array[8], array[9]);
    array[11] = mymax(array[10], array[11]);
    array[13] = mymax(array[12], array[13]);
    array[15] = mymax(array[14], array[15]);
    array[17] = mymax(array[16], array[17]);
    array[19] = mymax(array[18], array[19]);
    array[21] = mymax(array[20], array[21]);
    array[23] = mymax(array[22], array[23]);
    array[24] = mymin(array[24], array[25]);
    array[26] = mymin(array[26], array[27]);
    array[28] = mymin(array[28], array[29]);
    array[30] = mymin(array[30], array[31]);
    array[32] = mymin(array[32], array[33]);
    array[34] = mymin(array[34], array[35]);
    array[36] = mymin(array[36], array[37]);
    array[38] = mymin(array[38], array[39]);
    array[40] = mymin(array[40], array[41]);
    array[42] = mymin(array[42], array[43]);
    array[44] = mymin(array[44], array[45]);
    array[46] = mymin(array[46], array[47]);
    array[32] = mymax(array[1], array[32]);
    array[34] = mymax(array[3], array[34]);
    array[36] = mymax(array[5], array[36]);
    array[38] = mymax(array[7], array[38]);
    array[9] = mymin(array[9], array[40]);
    array[11] = mymin(array[11], array[42]);
    array[13] = mymin(array[13], array[44]);
    array[15] = mymin(array[15], array[46]);
    array[17] = mymin(array[17], array[48]);
    array[24] = mymax(array[9], array[24]);
    array[26] = mymax(array[11], array[26]);
    array[28] = mymax(array[13], array[28]);
    array[30] = mymax(array[15], array[30]);
    array[17] = mymin(array[17], array[32]);
    array[19] = mymin(array[19], array[34]);
    array[21] = mymin(array[21], array[36]);
    array[23] = mymin(array[23], array[38]);
    array[24] = mymax(array[17], array[24]);
    array[26] = mymax(array[19], array[26]);
    array[21] = mymin(array[21], array[28]);
    array[23] = mymin(array[23], array[30]);
    array[24] = mymax(array[21], array[24]);
    array[23] = mymin(array[23], array[26]);
    return mymax(array[23], array[24]);
}


float median9x9(float* array)
{
    float tmp = mymin(array[0], array[64]);
    array[64] = mymax(array[0], array[64]);
    array[0] = tmp;
    tmp = mymin(array[1], array[65]);
    array[65] = mymax(array[1], array[65]);
    array[1] = tmp;
    tmp = mymin(array[2], array[66]);
    array[66] = mymax(array[2], array[66]);
    array[2] = tmp;
    tmp = mymin(array[3], array[67]);
    array[67] = mymax(array[3], array[67]);
    array[3] = tmp;
    tmp = mymin(array[4], array[68]);
    array[68] = mymax(array[4], array[68]);
    array[4] = tmp;
    tmp = mymin(array[5], array[69]);
    array[69] = mymax(array[5], array[69]);
    array[5] = tmp;
    tmp = mymin(array[6], array[70]);
    array[70] = mymax(array[6], array[70]);
    array[6] = tmp;
    tmp = mymin(array[7], array[71]);
    array[71] = mymax(array[7], array[71]);
    array[7] = tmp;
    tmp = mymin(array[8], array[72]);
    array[72] = mymax(array[8], array[72]);
    array[8] = tmp;
    tmp = mymin(array[9], array[73]);
    array[73] = mymax(array[9], array[73]);
    array[9] = tmp;
    tmp = mymin(array[10], array[74]);
    array[74] = mymax(array[10], array[74]);
    array[10] = tmp;
    tmp = mymin(array[11], array[75]);
    array[75] = mymax(array[11], array[75]);
    array[11] = tmp;
    tmp = mymin(array[12], array[76]);
    array[76] = mymax(array[12], array[76]);
    array[12] = tmp;
    tmp = mymin(array[13], array[77]);
    array[77] = mymax(array[13], array[77]);
    array[13] = tmp;
    tmp = mymin(array[14], array[78]);
    array[78] = mymax(array[14], array[78]);
    array[14] = tmp;
    tmp = mymin(array[15], array[79]);
    array[79] = mymax(array[15], array[79]);
    array[15] = tmp;
    tmp = mymin(array[16], array[80]);
    array[80] = mymax(array[16], array[80]);
    array[16] = tmp;
    tmp = mymin(array[0], array[32]);
    array[32] = mymax(array[0], array[32]);
    array[0] = tmp;
    tmp = mymin(array[1], array[33]);
    array[33] = mymax(array[1], array[33]);
    array[1] = tmp;
    tmp = mymin(array[2], array[34]);
    array[34] = mymax(array[2], array[34]);
    array[2] = tmp;
    tmp = mymin(array[3], array[35]);
    array[35] = mymax(array[3], array[35]);
    array[3] = tmp;
    tmp = mymin(array[4], array[36]);
    array[36] = mymax(array[4], array[36]);
    array[4] = tmp;
    tmp = mymin(array[5], array[37]);
    array[37] = mymax(array[5], array[37]);
    array[5] = tmp;
    tmp = mymin(array[6], array[38]);
    array[38] = mymax(array[6], array[38]);
    array[6] = tmp;
    tmp = mymin(array[7], array[39]);
    array[39] = mymax(array[7], array[39]);
    array[7] = tmp;
    tmp = mymin(array[8], array[40]);
    array[40] = mymax(array[8], array[40]);
    array[8] = tmp;
    tmp = mymin(array[9], array[41]);
    array[41] = mymax(array[9], array[41]);
    array[9] = tmp;
    tmp = mymin(array[10], array[42]);
    array[42] = mymax(array[10], array[42]);
    array[10] = tmp;
    tmp = mymin(array[11], array[43]);
    array[43] = mymax(array[11], array[43]);
    array[11] = tmp;
    tmp = mymin(array[12], array[44]);
    array[44] = mymax(array[12], array[44]);
    array[12] = tmp;
    tmp = mymin(array[13], array[45]);
    array[45] = mymax(array[13], array[45]);
    array[13] = tmp;
    tmp = mymin(array[14], array[46]);
    array[46] = mymax(array[14], array[46]);
    array[14] = tmp;
    tmp = mymin(array[15], array[47]);
    array[47] = mymax(array[15], array[47]);
    array[15] = tmp;
    tmp = mymin(array[16], array[48]);
    array[48] = mymax(array[16], array[48]);
    array[16] = tmp;
    tmp = mymin(array[17], array[49]);
    array[49] = mymax(array[17], array[49]);
    array[17] = tmp;
    tmp = mymin(array[18], array[50]);
    array[50] = mymax(array[18], array[50]);
    array[18] = tmp;
    tmp = mymin(array[19], array[51]);
    array[51] = mymax(array[19], array[51]);
    array[19] = tmp;
    tmp = mymin(array[20], array[52]);
    array[52] = mymax(array[20], array[52]);
    array[20] = tmp;
    tmp = mymin(array[21], array[53]);
    array[53] = mymax(array[21], array[53]);
    array[21] = tmp;
    tmp = mymin(array[22], array[54]);
    array[54] = mymax(array[22], array[54]);
    array[22] = tmp;
    tmp = mymin(array[23], array[55]);
    array[55] = mymax(array[23], array[55]);
    array[23] = tmp;
    tmp = mymin(array[24], array[56]);
    array[56] = mymax(array[24], array[56]);
    array[24] = tmp;
    tmp = mymin(array[25], array[57]);
    array[57] = mymax(array[25], array[57]);
    array[25] = tmp;
    tmp = mymin(array[26], array[58]);
    array[58] = mymax(array[26], array[58]);
    array[26] = tmp;
    tmp = mymin(array[27], array[59]);
    array[59] = mymax(array[27], array[59]);
    array[27] = tmp;
    tmp = mymin(array[28], array[60]);
    array[60] = mymax(array[28], array[60]);
    array[28] = tmp;
    tmp = mymin(array[29], array[61]);
    array[61] = mymax(array[29], array[61]);
    array[29] = tmp;
    tmp = mymin(array[30], array[62]);
    array[62] = mymax(array[30], array[62]);
    array[30] = tmp;
    tmp = mymin(array[31], array[63]);
    array[63] = mymax(array[31], array[63]);
    array[31] = tmp;
    tmp = mymin(array[32], array[64]);
    array[64] = mymax(array[32], array[64]);
    array[32] = tmp;
    tmp = mymin(array[33], array[65]);
    array[65] = mymax(array[33], array[65]);
    array[33] = tmp;
    tmp = mymin(array[34], array[66]);
    array[66] = mymax(array[34], array[66]);
    array[34] = tmp;
    tmp = mymin(array[35], array[67]);
    array[67] = mymax(array[35], array[67]);
    array[35] = tmp;
    tmp = mymin(array[36], array[68]);
    array[68] = mymax(array[36], array[68]);
    array[36] = tmp;
    tmp = mymin(array[37], array[69]);
    array[69] = mymax(array[37], array[69]);
    array[37] = tmp;
    tmp = mymin(array[38], array[70]);
    array[70] = mymax(array[38], array[70]);
    array[38] = tmp;
    tmp = mymin(array[39], array[71]);
    array[71] = mymax(array[39], array[71]);
    array[39] = tmp;
    tmp = mymin(array[40], array[72]);
    array[72] = mymax(array[40], array[72]);
    array[40] = tmp;
    tmp = mymin(array[41], array[73]);
    array[73] = mymax(array[41], array[73]);
    array[41] = tmp;
    tmp = mymin(array[42], array[74]);
    array[74] = mymax(array[42], array[74]);
    array[42] = tmp;
    tmp = mymin(array[43], array[75]);
    array[75] = mymax(array[43], array[75]);
    array[43] = tmp;
    tmp = mymin(array[44], array[76]);
    array[76] = mymax(array[44], array[76]);
    array[44] = tmp;
    tmp = mymin(array[45], array[77]);
    array[77] = mymax(array[45], array[77]);
    array[45] = tmp;
    tmp = mymin(array[46], array[78]);
    array[78] = mymax(array[46], array[78]);
    array[46] = tmp;
    tmp = mymin(array[47], array[79]);
    array[79] = mymax(array[47], array[79]);
    array[47] = tmp;
    tmp = mymin(array[48], array[80]);
    array[80] = mymax(array[48], array[80]);
    array[48] = tmp;
    tmp = mymin(array[0], array[16]);
    array[16] = mymax(array[0], array[16]);
    array[0] = tmp;
    tmp = mymin(array[1], array[17]);
    array[17] = mymax(array[1], array[17]);
    array[1] = tmp;
    tmp = mymin(array[2], array[18]);
    array[18] = mymax(array[2], array[18]);
    array[2] = tmp;
    tmp = mymin(array[3], array[19]);
    array[19] = mymax(array[3], array[19]);
    array[3] = tmp;
    tmp = mymin(array[4], array[20]);
    array[20] = mymax(array[4], array[20]);
    array[4] = tmp;
    tmp = mymin(array[5], array[21]);
    array[21] = mymax(array[5], array[21]);
    array[5] = tmp;
    tmp = mymin(array[6], array[22]);
    array[22] = mymax(array[6], array[22]);
    array[6] = tmp;
    tmp = mymin(array[7], array[23]);
    array[23] = mymax(array[7], array[23]);
    array[7] = tmp;
    tmp = mymin(array[8], array[24]);
    array[24] = mymax(array[8], array[24]);
    array[8] = tmp;
    tmp = mymin(array[9], array[25]);
    array[25] = mymax(array[9], array[25]);
    array[9] = tmp;
    tmp = mymin(array[10], array[26]);
    array[26] = mymax(array[10], array[26]);
    array[10] = tmp;
    tmp = mymin(array[11], array[27]);
    array[27] = mymax(array[11], array[27]);
    array[11] = tmp;
    tmp = mymin(array[12], array[28]);
    array[28] = mymax(array[12], array[28]);
    array[12] = tmp;
    tmp = mymin(array[13], array[29]);
    array[29] = mymax(array[13], array[29]);
    array[13] = tmp;
    tmp = mymin(array[14], array[30]);
    array[30] = mymax(array[14], array[30]);
    array[14] = tmp;
    tmp = mymin(array[15], array[31]);
    array[31] = mymax(array[15], array[31]);
    array[15] = tmp;
    tmp = mymin(array[32], array[48]);
    array[48] = mymax(array[32], array[48]);
    array[32] = tmp;
    tmp = mymin(array[33], array[49]);
    array[49] = mymax(array[33], array[49]);
    array[33] = tmp;
    tmp = mymin(array[34], array[50]);
    array[50] = mymax(array[34], array[50]);
    array[34] = tmp;
    tmp = mymin(array[35], array[51]);
    array[51] = mymax(array[35], array[51]);
    array[35] = tmp;
    tmp = mymin(array[36], array[52]);
    array[52] = mymax(array[36], array[52]);
    array[36] = tmp;
    tmp = mymin(array[37], array[53]);
    array[53] = mymax(array[37], array[53]);
    array[37] = tmp;
    tmp = mymin(array[38], array[54]);
    array[54] = mymax(array[38], array[54]);
    array[38] = tmp;
    tmp = mymin(array[39], array[55]);
    array[55] = mymax(array[39], array[55]);
    array[39] = tmp;
    tmp = mymin(array[40], array[56]);
    array[56] = mymax(array[40], array[56]);
    array[40] = tmp;
    tmp = mymin(array[41], array[57]);
    array[57] = mymax(array[41], array[57]);
    array[41] = tmp;
    tmp = mymin(array[42], array[58]);
    array[58] = mymax(array[42], array[58]);
    array[42] = tmp;
    tmp = mymin(array[43], array[59]);
    array[59] = mymax(array[43], array[59]);
    array[43] = tmp;
    tmp = mymin(array[44], array[60]);
    array[60] = mymax(array[44], array[60]);
    array[44] = tmp;
    tmp = mymin(array[45], array[61]);
    array[61] = mymax(array[45], array[61]);
    array[45] = tmp;
    tmp = mymin(array[46], array[62]);
    array[62] = mymax(array[46], array[62]);
    array[46] = tmp;
    tmp = mymin(array[47], array[63]);
    array[63] = mymax(array[47], array[63]);
    array[47] = tmp;
    tmp = mymin(array[64], array[80]);
    array[80] = mymax(array[64], array[80]);
    array[64] = tmp;
    tmp = mymin(array[16], array[64]);
    array[64] = mymax(array[16], array[64]);
    array[16] = tmp;
    tmp = mymin(array[17], array[65]);
    array[65] = mymax(array[17], array[65]);
    array[17] = tmp;
    tmp = mymin(array[18], array[66]);
    array[66] = mymax(array[18], array[66]);
    array[18] = tmp;
    tmp = mymin(array[19], array[67]);
    array[67] = mymax(array[19], array[67]);
    array[19] = tmp;
    tmp = mymin(array[20], array[68]);
    array[68] = mymax(array[20], array[68]);
    array[20] = tmp;
    tmp = mymin(array[21], array[69]);
    array[69] = mymax(array[21], array[69]);
    array[21] = tmp;
    tmp = mymin(array[22], array[70]);
    array[70] = mymax(array[22], array[70]);
    array[22] = tmp;
    tmp = mymin(array[23], array[71]);
    array[71] = mymax(array[23], array[71]);
    array[23] = tmp;
    tmp = mymin(array[24], array[72]);
    array[72] = mymax(array[24], array[72]);
    array[24] = tmp;
    tmp = mymin(array[25], array[73]);
    array[73] = mymax(array[25], array[73]);
    array[25] = tmp;
    tmp = mymin(array[26], array[74]);
    array[74] = mymax(array[26], array[74]);
    array[26] = tmp;
    tmp = mymin(array[27], array[75]);
    array[75] = mymax(array[27], array[75]);
    array[27] = tmp;
    tmp = mymin(array[28], array[76]);
    array[76] = mymax(array[28], array[76]);
    array[28] = tmp;
    tmp = mymin(array[29], array[77]);
    array[77] = mymax(array[29], array[77]);
    array[29] = tmp;
    tmp = mymin(array[30], array[78]);
    array[78] = mymax(array[30], array[78]);
    array[30] = tmp;
    tmp = mymin(array[31], array[79]);
    array[79] = mymax(array[31], array[79]);
    array[31] = tmp;
    tmp = mymin(array[16], array[32]);
    array[32] = mymax(array[16], array[32]);
    array[16] = tmp;
    tmp = mymin(array[17], array[33]);
    array[33] = mymax(array[17], array[33]);
    array[17] = tmp;
    tmp = mymin(array[18], array[34]);
    array[34] = mymax(array[18], array[34]);
    array[18] = tmp;
    tmp = mymin(array[19], array[35]);
    array[35] = mymax(array[19], array[35]);
    array[19] = tmp;
    tmp = mymin(array[20], array[36]);
    array[36] = mymax(array[20], array[36]);
    array[20] = tmp;
    tmp = mymin(array[21], array[37]);
    array[37] = mymax(array[21], array[37]);
    array[21] = tmp;
    tmp = mymin(array[22], array[38]);
    array[38] = mymax(array[22], array[38]);
    array[22] = tmp;
    tmp = mymin(array[23], array[39]);
    array[39] = mymax(array[23], array[39]);
    array[23] = tmp;
    tmp = mymin(array[24], array[40]);
    array[40] = mymax(array[24], array[40]);
    array[24] = tmp;
    tmp = mymin(array[25], array[41]);
    array[41] = mymax(array[25], array[41]);
    array[25] = tmp;
    tmp = mymin(array[26], array[42]);
    array[42] = mymax(array[26], array[42]);
    array[26] = tmp;
    tmp = mymin(array[27], array[43]);
    array[43] = mymax(array[27], array[43]);
    array[27] = tmp;
    tmp = mymin(array[28], array[44]);
    array[44] = mymax(array[28], array[44]);
    array[28] = tmp;
    tmp = mymin(array[29], array[45]);
    array[45] = mymax(array[29], array[45]);
    array[29] = tmp;
    tmp = mymin(array[30], array[46]);
    array[46] = mymax(array[30], array[46]);
    array[30] = tmp;
    tmp = mymin(array[31], array[47]);
    array[47] = mymax(array[31], array[47]);
    array[31] = tmp;
    tmp = mymin(array[48], array[64]);
    array[64] = mymax(array[48], array[64]);
    array[48] = tmp;
    tmp = mymin(array[49], array[65]);
    array[65] = mymax(array[49], array[65]);
    array[49] = tmp;
    tmp = mymin(array[50], array[66]);
    array[66] = mymax(array[50], array[66]);
    array[50] = tmp;
    tmp = mymin(array[51], array[67]);
    array[67] = mymax(array[51], array[67]);
    array[51] = tmp;
    tmp = mymin(array[52], array[68]);
    array[68] = mymax(array[52], array[68]);
    array[52] = tmp;
    tmp = mymin(array[53], array[69]);
    array[69] = mymax(array[53], array[69]);
    array[53] = tmp;
    tmp = mymin(array[54], array[70]);
    array[70] = mymax(array[54], array[70]);
    array[54] = tmp;
    tmp = mymin(array[55], array[71]);
    array[71] = mymax(array[55], array[71]);
    array[55] = tmp;
    tmp = mymin(array[56], array[72]);
    array[72] = mymax(array[56], array[72]);
    array[56] = tmp;
    tmp = mymin(array[57], array[73]);
    array[73] = mymax(array[57], array[73]);
    array[57] = tmp;
    tmp = mymin(array[58], array[74]);
    array[74] = mymax(array[58], array[74]);
    array[58] = tmp;
    tmp = mymin(array[59], array[75]);
    array[75] = mymax(array[59], array[75]);
    array[59] = tmp;
    tmp = mymin(array[60], array[76]);
    array[76] = mymax(array[60], array[76]);
    array[60] = tmp;
    tmp = mymin(array[61], array[77]);
    array[77] = mymax(array[61], array[77]);
    array[61] = tmp;
    tmp = mymin(array[62], array[78]);
    array[78] = mymax(array[62], array[78]);
    array[62] = tmp;
    tmp = mymin(array[63], array[79]);
    array[79] = mymax(array[63], array[79]);
    array[63] = tmp;
    tmp = mymin(array[0], array[8]);
    array[8] = mymax(array[0], array[8]);
    array[0] = tmp;
    tmp = mymin(array[1], array[9]);
    array[9] = mymax(array[1], array[9]);
    array[1] = tmp;
    tmp = mymin(array[2], array[10]);
    array[10] = mymax(array[2], array[10]);
    array[2] = tmp;
    tmp = mymin(array[3], array[11]);
    array[11] = mymax(array[3], array[11]);
    array[3] = tmp;
    tmp = mymin(array[4], array[12]);
    array[12] = mymax(array[4], array[12]);
    array[4] = tmp;
    tmp = mymin(array[5], array[13]);
    array[13] = mymax(array[5], array[13]);
    array[5] = tmp;
    tmp = mymin(array[6], array[14]);
    array[14] = mymax(array[6], array[14]);
    array[6] = tmp;
    tmp = mymin(array[7], array[15]);
    array[15] = mymax(array[7], array[15]);
    array[7] = tmp;
    tmp = mymin(array[16], array[24]);
    array[24] = mymax(array[16], array[24]);
    array[16] = tmp;
    tmp = mymin(array[17], array[25]);
    array[25] = mymax(array[17], array[25]);
    array[17] = tmp;
    tmp = mymin(array[18], array[26]);
    array[26] = mymax(array[18], array[26]);
    array[18] = tmp;
    tmp = mymin(array[19], array[27]);
    array[27] = mymax(array[19], array[27]);
    array[19] = tmp;
    tmp = mymin(array[20], array[28]);
    array[28] = mymax(array[20], array[28]);
    array[20] = tmp;
    tmp = mymin(array[21], array[29]);
    array[29] = mymax(array[21], array[29]);
    array[21] = tmp;
    tmp = mymin(array[22], array[30]);
    array[30] = mymax(array[22], array[30]);
    array[22] = tmp;
    tmp = mymin(array[23], array[31]);
    array[31] = mymax(array[23], array[31]);
    array[23] = tmp;
    tmp = mymin(array[32], array[40]);
    array[40] = mymax(array[32], array[40]);
    array[32] = tmp;
    tmp = mymin(array[33], array[41]);
    array[41] = mymax(array[33], array[41]);
    array[33] = tmp;
    tmp = mymin(array[34], array[42]);
    array[42] = mymax(array[34], array[42]);
    array[34] = tmp;
    tmp = mymin(array[35], array[43]);
    array[43] = mymax(array[35], array[43]);
    array[35] = tmp;
    tmp = mymin(array[36], array[44]);
    array[44] = mymax(array[36], array[44]);
    array[36] = tmp;
    tmp = mymin(array[37], array[45]);
    array[45] = mymax(array[37], array[45]);
    array[37] = tmp;
    tmp = mymin(array[38], array[46]);
    array[46] = mymax(array[38], array[46]);
    array[38] = tmp;
    tmp = mymin(array[39], array[47]);
    array[47] = mymax(array[39], array[47]);
    array[39] = tmp;
    tmp = mymin(array[48], array[56]);
    array[56] = mymax(array[48], array[56]);
    array[48] = tmp;
    tmp = mymin(array[49], array[57]);
    array[57] = mymax(array[49], array[57]);
    array[49] = tmp;
    tmp = mymin(array[50], array[58]);
    array[58] = mymax(array[50], array[58]);
    array[50] = tmp;
    tmp = mymin(array[51], array[59]);
    array[59] = mymax(array[51], array[59]);
    array[51] = tmp;
    tmp = mymin(array[52], array[60]);
    array[60] = mymax(array[52], array[60]);
    array[52] = tmp;
    tmp = mymin(array[53], array[61]);
    array[61] = mymax(array[53], array[61]);
    array[53] = tmp;
    tmp = mymin(array[54], array[62]);
    array[62] = mymax(array[54], array[62]);
    array[54] = tmp;
    tmp = mymin(array[55], array[63]);
    array[63] = mymax(array[55], array[63]);
    array[55] = tmp;
    tmp = mymin(array[64], array[72]);
    array[72] = mymax(array[64], array[72]);
    array[64] = tmp;
    tmp = mymin(array[65], array[73]);
    array[73] = mymax(array[65], array[73]);
    array[65] = tmp;
    tmp = mymin(array[66], array[74]);
    array[74] = mymax(array[66], array[74]);
    array[66] = tmp;
    tmp = mymin(array[67], array[75]);
    array[75] = mymax(array[67], array[75]);
    array[67] = tmp;
    tmp = mymin(array[68], array[76]);
    array[76] = mymax(array[68], array[76]);
    array[68] = tmp;
    tmp = mymin(array[69], array[77]);
    array[77] = mymax(array[69], array[77]);
    array[69] = tmp;
    tmp = mymin(array[70], array[78]);
    array[78] = mymax(array[70], array[78]);
    array[70] = tmp;
    tmp = mymin(array[71], array[79]);
    array[79] = mymax(array[71], array[79]);
    array[71] = tmp;
    tmp = mymin(array[8], array[64]);
    array[64] = mymax(array[8], array[64]);
    array[8] = tmp;
    tmp = mymin(array[9], array[65]);
    array[65] = mymax(array[9], array[65]);
    array[9] = tmp;
    tmp = mymin(array[10], array[66]);
    array[66] = mymax(array[10], array[66]);
    array[10] = tmp;
    tmp = mymin(array[11], array[67]);
    array[67] = mymax(array[11], array[67]);
    array[11] = tmp;
    tmp = mymin(array[12], array[68]);
    array[68] = mymax(array[12], array[68]);
    array[12] = tmp;
    tmp = mymin(array[13], array[69]);
    array[69] = mymax(array[13], array[69]);
    array[13] = tmp;
    tmp = mymin(array[14], array[70]);
    array[70] = mymax(array[14], array[70]);
    array[14] = tmp;
    tmp = mymin(array[15], array[71]);
    array[71] = mymax(array[15], array[71]);
    array[15] = tmp;
    tmp = mymin(array[24], array[80]);
    array[80] = mymax(array[24], array[80]);
    array[24] = tmp;
    tmp = mymin(array[8], array[32]);
    array[32] = mymax(array[8], array[32]);
    array[8] = tmp;
    tmp = mymin(array[9], array[33]);
    array[33] = mymax(array[9], array[33]);
    array[9] = tmp;
    tmp = mymin(array[10], array[34]);
    array[34] = mymax(array[10], array[34]);
    array[10] = tmp;
    tmp = mymin(array[11], array[35]);
    array[35] = mymax(array[11], array[35]);
    array[11] = tmp;
    tmp = mymin(array[12], array[36]);
    array[36] = mymax(array[12], array[36]);
    array[12] = tmp;
    tmp = mymin(array[13], array[37]);
    array[37] = mymax(array[13], array[37]);
    array[13] = tmp;
    tmp = mymin(array[14], array[38]);
    array[38] = mymax(array[14], array[38]);
    array[14] = tmp;
    tmp = mymin(array[15], array[39]);
    array[39] = mymax(array[15], array[39]);
    array[15] = tmp;
    tmp = mymin(array[24], array[48]);
    array[48] = mymax(array[24], array[48]);
    array[24] = tmp;
    tmp = mymin(array[25], array[49]);
    array[49] = mymax(array[25], array[49]);
    array[25] = tmp;
    tmp = mymin(array[26], array[50]);
    array[50] = mymax(array[26], array[50]);
    array[26] = tmp;
    tmp = mymin(array[27], array[51]);
    array[51] = mymax(array[27], array[51]);
    array[27] = tmp;
    tmp = mymin(array[28], array[52]);
    array[52] = mymax(array[28], array[52]);
    array[28] = tmp;
    tmp = mymin(array[29], array[53]);
    array[53] = mymax(array[29], array[53]);
    array[29] = tmp;
    tmp = mymin(array[30], array[54]);
    array[54] = mymax(array[30], array[54]);
    array[30] = tmp;
    tmp = mymin(array[31], array[55]);
    array[55] = mymax(array[31], array[55]);
    array[31] = tmp;
    tmp = mymin(array[40], array[64]);
    array[64] = mymax(array[40], array[64]);
    array[40] = tmp;
    tmp = mymin(array[41], array[65]);
    array[65] = mymax(array[41], array[65]);
    array[41] = tmp;
    tmp = mymin(array[42], array[66]);
    array[66] = mymax(array[42], array[66]);
    array[42] = tmp;
    tmp = mymin(array[43], array[67]);
    array[67] = mymax(array[43], array[67]);
    array[43] = tmp;
    tmp = mymin(array[44], array[68]);
    array[68] = mymax(array[44], array[68]);
    array[44] = tmp;
    tmp = mymin(array[45], array[69]);
    array[69] = mymax(array[45], array[69]);
    array[45] = tmp;
    tmp = mymin(array[46], array[70]);
    array[70] = mymax(array[46], array[70]);
    array[46] = tmp;
    tmp = mymin(array[47], array[71]);
    array[71] = mymax(array[47], array[71]);
    array[47] = tmp;
    tmp = mymin(array[56], array[80]);
    array[80] = mymax(array[56], array[80]);
    array[56] = tmp;
    tmp = mymin(array[8], array[16]);
    array[16] = mymax(array[8], array[16]);
    array[8] = tmp;
    tmp = mymin(array[9], array[17]);
    array[17] = mymax(array[9], array[17]);
    array[9] = tmp;
    tmp = mymin(array[10], array[18]);
    array[18] = mymax(array[10], array[18]);
    array[10] = tmp;
    tmp = mymin(array[11], array[19]);
    array[19] = mymax(array[11], array[19]);
    array[11] = tmp;
    tmp = mymin(array[12], array[20]);
    array[20] = mymax(array[12], array[20]);
    array[12] = tmp;
    tmp = mymin(array[13], array[21]);
    array[21] = mymax(array[13], array[21]);
    array[13] = tmp;
    tmp = mymin(array[14], array[22]);
    array[22] = mymax(array[14], array[22]);
    array[14] = tmp;
    tmp = mymin(array[15], array[23]);
    array[23] = mymax(array[15], array[23]);
    array[15] = tmp;
    tmp = mymin(array[24], array[32]);
    array[32] = mymax(array[24], array[32]);
    array[24] = tmp;
    tmp = mymin(array[25], array[33]);
    array[33] = mymax(array[25], array[33]);
    array[25] = tmp;
    tmp = mymin(array[26], array[34]);
    array[34] = mymax(array[26], array[34]);
    array[26] = tmp;
    tmp = mymin(array[27], array[35]);
    array[35] = mymax(array[27], array[35]);
    array[27] = tmp;
    tmp = mymin(array[28], array[36]);
    array[36] = mymax(array[28], array[36]);
    array[28] = tmp;
    tmp = mymin(array[29], array[37]);
    array[37] = mymax(array[29], array[37]);
    array[29] = tmp;
    tmp = mymin(array[30], array[38]);
    array[38] = mymax(array[30], array[38]);
    array[30] = tmp;
    tmp = mymin(array[31], array[39]);
    array[39] = mymax(array[31], array[39]);
    array[31] = tmp;
    tmp = mymin(array[40], array[48]);
    array[48] = mymax(array[40], array[48]);
    array[40] = tmp;
    tmp = mymin(array[41], array[49]);
    array[49] = mymax(array[41], array[49]);
    array[41] = tmp;
    tmp = mymin(array[42], array[50]);
    array[50] = mymax(array[42], array[50]);
    array[42] = tmp;
    tmp = mymin(array[43], array[51]);
    array[51] = mymax(array[43], array[51]);
    array[43] = tmp;
    tmp = mymin(array[44], array[52]);
    array[52] = mymax(array[44], array[52]);
    array[44] = tmp;
    tmp = mymin(array[45], array[53]);
    array[53] = mymax(array[45], array[53]);
    array[45] = tmp;
    tmp = mymin(array[46], array[54]);
    array[54] = mymax(array[46], array[54]);
    array[46] = tmp;
    tmp = mymin(array[47], array[55]);
    array[55] = mymax(array[47], array[55]);
    array[47] = tmp;
    tmp = mymin(array[56], array[64]);
    array[64] = mymax(array[56], array[64]);
    array[56] = tmp;
    tmp = mymin(array[57], array[65]);
    array[65] = mymax(array[57], array[65]);
    array[57] = tmp;
    tmp = mymin(array[58], array[66]);
    array[66] = mymax(array[58], array[66]);
    array[58] = tmp;
    tmp = mymin(array[59], array[67]);
    array[67] = mymax(array[59], array[67]);
    array[59] = tmp;
    tmp = mymin(array[60], array[68]);
    array[68] = mymax(array[60], array[68]);
    array[60] = tmp;
    tmp = mymin(array[61], array[69]);
    array[69] = mymax(array[61], array[69]);
    array[61] = tmp;
    tmp = mymin(array[62], array[70]);
    array[70] = mymax(array[62], array[70]);
    array[62] = tmp;
    tmp = mymin(array[63], array[71]);
    array[71] = mymax(array[63], array[71]);
    array[63] = tmp;
    tmp = mymin(array[72], array[80]);
    array[80] = mymax(array[72], array[80]);
    array[72] = tmp;
    tmp = mymin(array[0], array[4]);
    array[4] = mymax(array[0], array[4]);
    array[0] = tmp;
    tmp = mymin(array[1], array[5]);
    array[5] = mymax(array[1], array[5]);
    array[1] = tmp;
    tmp = mymin(array[2], array[6]);
    array[6] = mymax(array[2], array[6]);
    array[2] = tmp;
    tmp = mymin(array[3], array[7]);
    array[7] = mymax(array[3], array[7]);
    array[3] = tmp;
    tmp = mymin(array[8], array[12]);
    array[12] = mymax(array[8], array[12]);
    array[8] = tmp;
    tmp = mymin(array[9], array[13]);
    array[13] = mymax(array[9], array[13]);
    array[9] = tmp;
    tmp = mymin(array[10], array[14]);
    array[14] = mymax(array[10], array[14]);
    array[10] = tmp;
    tmp = mymin(array[11], array[15]);
    array[15] = mymax(array[11], array[15]);
    array[11] = tmp;
    tmp = mymin(array[16], array[20]);
    array[20] = mymax(array[16], array[20]);
    array[16] = tmp;
    tmp = mymin(array[17], array[21]);
    array[21] = mymax(array[17], array[21]);
    array[17] = tmp;
    tmp = mymin(array[18], array[22]);
    array[22] = mymax(array[18], array[22]);
    array[18] = tmp;
    tmp = mymin(array[19], array[23]);
    array[23] = mymax(array[19], array[23]);
    array[19] = tmp;
    tmp = mymin(array[24], array[28]);
    array[28] = mymax(array[24], array[28]);
    array[24] = tmp;
    tmp = mymin(array[25], array[29]);
    array[29] = mymax(array[25], array[29]);
    array[25] = tmp;
    tmp = mymin(array[26], array[30]);
    array[30] = mymax(array[26], array[30]);
    array[26] = tmp;
    tmp = mymin(array[27], array[31]);
    array[31] = mymax(array[27], array[31]);
    array[27] = tmp;
    tmp = mymin(array[32], array[36]);
    array[36] = mymax(array[32], array[36]);
    array[32] = tmp;
    tmp = mymin(array[33], array[37]);
    array[37] = mymax(array[33], array[37]);
    array[33] = tmp;
    tmp = mymin(array[34], array[38]);
    array[38] = mymax(array[34], array[38]);
    array[34] = tmp;
    tmp = mymin(array[35], array[39]);
    array[39] = mymax(array[35], array[39]);
    array[35] = tmp;
    tmp = mymin(array[40], array[44]);
    array[44] = mymax(array[40], array[44]);
    array[40] = tmp;
    tmp = mymin(array[41], array[45]);
    array[45] = mymax(array[41], array[45]);
    array[41] = tmp;
    tmp = mymin(array[42], array[46]);
    array[46] = mymax(array[42], array[46]);
    array[42] = tmp;
    tmp = mymin(array[43], array[47]);
    array[47] = mymax(array[43], array[47]);
    array[43] = tmp;
    tmp = mymin(array[48], array[52]);
    array[52] = mymax(array[48], array[52]);
    array[48] = tmp;
    tmp = mymin(array[49], array[53]);
    array[53] = mymax(array[49], array[53]);
    array[49] = tmp;
    tmp = mymin(array[50], array[54]);
    array[54] = mymax(array[50], array[54]);
    array[50] = tmp;
    tmp = mymin(array[51], array[55]);
    array[55] = mymax(array[51], array[55]);
    array[51] = tmp;
    tmp = mymin(array[56], array[60]);
    array[60] = mymax(array[56], array[60]);
    array[56] = tmp;
    tmp = mymin(array[57], array[61]);
    array[61] = mymax(array[57], array[61]);
    array[57] = tmp;
    tmp = mymin(array[58], array[62]);
    array[62] = mymax(array[58], array[62]);
    array[58] = tmp;
    tmp = mymin(array[59], array[63]);
    array[63] = mymax(array[59], array[63]);
    array[59] = tmp;
    tmp = mymin(array[64], array[68]);
    array[68] = mymax(array[64], array[68]);
    array[64] = tmp;
    tmp = mymin(array[65], array[69]);
    array[69] = mymax(array[65], array[69]);
    array[65] = tmp;
    tmp = mymin(array[66], array[70]);
    array[70] = mymax(array[66], array[70]);
    array[66] = tmp;
    tmp = mymin(array[67], array[71]);
    array[71] = mymax(array[67], array[71]);
    array[67] = tmp;
    tmp = mymin(array[72], array[76]);
    array[76] = mymax(array[72], array[76]);
    array[72] = tmp;
    tmp = mymin(array[73], array[77]);
    array[77] = mymax(array[73], array[77]);
    array[73] = tmp;
    tmp = mymin(array[74], array[78]);
    array[78] = mymax(array[74], array[78]);
    array[74] = tmp;
    tmp = mymin(array[75], array[79]);
    array[79] = mymax(array[75], array[79]);
    array[75] = tmp;
    tmp = mymin(array[4], array[64]);
    array[64] = mymax(array[4], array[64]);
    array[4] = tmp;
    tmp = mymin(array[5], array[65]);
    array[65] = mymax(array[5], array[65]);
    array[5] = tmp;
    tmp = mymin(array[6], array[66]);
    array[66] = mymax(array[6], array[66]);
    array[6] = tmp;
    tmp = mymin(array[7], array[67]);
    array[67] = mymax(array[7], array[67]);
    array[7] = tmp;
    tmp = mymin(array[12], array[72]);
    array[72] = mymax(array[12], array[72]);
    array[12] = tmp;
    tmp = mymin(array[13], array[73]);
    array[73] = mymax(array[13], array[73]);
    array[13] = tmp;
    tmp = mymin(array[14], array[74]);
    array[74] = mymax(array[14], array[74]);
    array[14] = tmp;
    tmp = mymin(array[15], array[75]);
    array[75] = mymax(array[15], array[75]);
    array[15] = tmp;
    tmp = mymin(array[20], array[80]);
    array[80] = mymax(array[20], array[80]);
    array[20] = tmp;
    tmp = mymin(array[4], array[32]);
    array[32] = mymax(array[4], array[32]);
    array[4] = tmp;
    tmp = mymin(array[5], array[33]);
    array[33] = mymax(array[5], array[33]);
    array[5] = tmp;
    tmp = mymin(array[6], array[34]);
    array[34] = mymax(array[6], array[34]);
    array[6] = tmp;
    tmp = mymin(array[7], array[35]);
    array[35] = mymax(array[7], array[35]);
    array[7] = tmp;
    tmp = mymin(array[12], array[40]);
    array[40] = mymax(array[12], array[40]);
    array[12] = tmp;
    tmp = mymin(array[13], array[41]);
    array[41] = mymax(array[13], array[41]);
    array[13] = tmp;
    tmp = mymin(array[14], array[42]);
    array[42] = mymax(array[14], array[42]);
    array[14] = tmp;
    tmp = mymin(array[15], array[43]);
    array[43] = mymax(array[15], array[43]);
    array[15] = tmp;
    tmp = mymin(array[20], array[48]);
    array[48] = mymax(array[20], array[48]);
    array[20] = tmp;
    tmp = mymin(array[21], array[49]);
    array[49] = mymax(array[21], array[49]);
    array[21] = tmp;
    tmp = mymin(array[22], array[50]);
    array[50] = mymax(array[22], array[50]);
    array[22] = tmp;
    tmp = mymin(array[23], array[51]);
    array[51] = mymax(array[23], array[51]);
    array[23] = tmp;
    tmp = mymin(array[28], array[56]);
    array[56] = mymax(array[28], array[56]);
    array[28] = tmp;
    tmp = mymin(array[29], array[57]);
    array[57] = mymax(array[29], array[57]);
    array[29] = tmp;
    tmp = mymin(array[30], array[58]);
    array[58] = mymax(array[30], array[58]);
    array[30] = tmp;
    tmp = mymin(array[31], array[59]);
    array[59] = mymax(array[31], array[59]);
    array[31] = tmp;
    tmp = mymin(array[36], array[64]);
    array[64] = mymax(array[36], array[64]);
    array[36] = tmp;
    tmp = mymin(array[37], array[65]);
    array[65] = mymax(array[37], array[65]);
    array[37] = tmp;
    tmp = mymin(array[38], array[66]);
    array[66] = mymax(array[38], array[66]);
    array[38] = tmp;
    tmp = mymin(array[39], array[67]);
    array[67] = mymax(array[39], array[67]);
    array[39] = tmp;
    tmp = mymin(array[44], array[72]);
    array[72] = mymax(array[44], array[72]);
    array[44] = tmp;
    tmp = mymin(array[45], array[73]);
    array[73] = mymax(array[45], array[73]);
    array[45] = tmp;
    tmp = mymin(array[46], array[74]);
    array[74] = mymax(array[46], array[74]);
    array[46] = tmp;
    tmp = mymin(array[47], array[75]);
    array[75] = mymax(array[47], array[75]);
    array[47] = tmp;
    tmp = mymin(array[52], array[80]);
    array[80] = mymax(array[52], array[80]);
    array[52] = tmp;
    tmp = mymin(array[4], array[16]);
    array[16] = mymax(array[4], array[16]);
    array[4] = tmp;
    tmp = mymin(array[5], array[17]);
    array[17] = mymax(array[5], array[17]);
    array[5] = tmp;
    tmp = mymin(array[6], array[18]);
    array[18] = mymax(array[6], array[18]);
    array[6] = tmp;
    tmp = mymin(array[7], array[19]);
    array[19] = mymax(array[7], array[19]);
    array[7] = tmp;
    tmp = mymin(array[12], array[24]);
    array[24] = mymax(array[12], array[24]);
    array[12] = tmp;
    tmp = mymin(array[13], array[25]);
    array[25] = mymax(array[13], array[25]);
    array[13] = tmp;
    tmp = mymin(array[14], array[26]);
    array[26] = mymax(array[14], array[26]);
    array[14] = tmp;
    tmp = mymin(array[15], array[27]);
    array[27] = mymax(array[15], array[27]);
    array[15] = tmp;
    tmp = mymin(array[20], array[32]);
    array[32] = mymax(array[20], array[32]);
    array[20] = tmp;
    tmp = mymin(array[21], array[33]);
    array[33] = mymax(array[21], array[33]);
    array[21] = tmp;
    tmp = mymin(array[22], array[34]);
    array[34] = mymax(array[22], array[34]);
    array[22] = tmp;
    tmp = mymin(array[23], array[35]);
    array[35] = mymax(array[23], array[35]);
    array[23] = tmp;
    tmp = mymin(array[28], array[40]);
    array[40] = mymax(array[28], array[40]);
    array[28] = tmp;
    tmp = mymin(array[29], array[41]);
    array[41] = mymax(array[29], array[41]);
    array[29] = tmp;
    tmp = mymin(array[30], array[42]);
    array[42] = mymax(array[30], array[42]);
    array[30] = tmp;
    tmp = mymin(array[31], array[43]);
    array[43] = mymax(array[31], array[43]);
    array[31] = tmp;
    tmp = mymin(array[36], array[48]);
    array[48] = mymax(array[36], array[48]);
    array[36] = tmp;
    tmp = mymin(array[37], array[49]);
    array[49] = mymax(array[37], array[49]);
    array[37] = tmp;
    tmp = mymin(array[38], array[50]);
    array[50] = mymax(array[38], array[50]);
    array[38] = tmp;
    tmp = mymin(array[39], array[51]);
    array[51] = mymax(array[39], array[51]);
    array[39] = tmp;
    tmp = mymin(array[44], array[56]);
    array[56] = mymax(array[44], array[56]);
    array[44] = tmp;
    tmp = mymin(array[45], array[57]);
    array[57] = mymax(array[45], array[57]);
    array[45] = tmp;
    tmp = mymin(array[46], array[58]);
    array[58] = mymax(array[46], array[58]);
    array[46] = tmp;
    tmp = mymin(array[47], array[59]);
    array[59] = mymax(array[47], array[59]);
    array[47] = tmp;
    tmp = mymin(array[52], array[64]);
    array[64] = mymax(array[52], array[64]);
    array[52] = tmp;
    tmp = mymin(array[53], array[65]);
    array[65] = mymax(array[53], array[65]);
    array[53] = tmp;
    tmp = mymin(array[54], array[66]);
    array[66] = mymax(array[54], array[66]);
    array[54] = tmp;
    tmp = mymin(array[55], array[67]);
    array[67] = mymax(array[55], array[67]);
    array[55] = tmp;
    tmp = mymin(array[60], array[72]);
    array[72] = mymax(array[60], array[72]);
    array[60] = tmp;
    tmp = mymin(array[61], array[73]);
    array[73] = mymax(array[61], array[73]);
    array[61] = tmp;
    tmp = mymin(array[62], array[74]);
    array[74] = mymax(array[62], array[74]);
    array[62] = tmp;
    tmp = mymin(array[63], array[75]);
    array[75] = mymax(array[63], array[75]);
    array[63] = tmp;
    tmp = mymin(array[68], array[80]);
    array[80] = mymax(array[68], array[80]);
    array[68] = tmp;
    tmp = mymin(array[4], array[8]);
    array[8] = mymax(array[4], array[8]);
    array[4] = tmp;
    tmp = mymin(array[5], array[9]);
    array[9] = mymax(array[5], array[9]);
    array[5] = tmp;
    tmp = mymin(array[6], array[10]);
    array[10] = mymax(array[6], array[10]);
    array[6] = tmp;
    tmp = mymin(array[7], array[11]);
    array[11] = mymax(array[7], array[11]);
    array[7] = tmp;
    tmp = mymin(array[12], array[16]);
    array[16] = mymax(array[12], array[16]);
    array[12] = tmp;
    tmp = mymin(array[13], array[17]);
    array[17] = mymax(array[13], array[17]);
    array[13] = tmp;
    tmp = mymin(array[14], array[18]);
    array[18] = mymax(array[14], array[18]);
    array[14] = tmp;
    tmp = mymin(array[15], array[19]);
    array[19] = mymax(array[15], array[19]);
    array[15] = tmp;
    tmp = mymin(array[20], array[24]);
    array[24] = mymax(array[20], array[24]);
    array[20] = tmp;
    tmp = mymin(array[21], array[25]);
    array[25] = mymax(array[21], array[25]);
    array[21] = tmp;
    tmp = mymin(array[22], array[26]);
    array[26] = mymax(array[22], array[26]);
    array[22] = tmp;
    tmp = mymin(array[23], array[27]);
    array[27] = mymax(array[23], array[27]);
    array[23] = tmp;
    tmp = mymin(array[28], array[32]);
    array[32] = mymax(array[28], array[32]);
    array[28] = tmp;
    tmp = mymin(array[29], array[33]);
    array[33] = mymax(array[29], array[33]);
    array[29] = tmp;
    tmp = mymin(array[30], array[34]);
    array[34] = mymax(array[30], array[34]);
    array[30] = tmp;
    tmp = mymin(array[31], array[35]);
    array[35] = mymax(array[31], array[35]);
    array[31] = tmp;
    tmp = mymin(array[36], array[40]);
    array[40] = mymax(array[36], array[40]);
    array[36] = tmp;
    tmp = mymin(array[37], array[41]);
    array[41] = mymax(array[37], array[41]);
    array[37] = tmp;
    tmp = mymin(array[38], array[42]);
    array[42] = mymax(array[38], array[42]);
    array[38] = tmp;
    tmp = mymin(array[39], array[43]);
    array[43] = mymax(array[39], array[43]);
    array[39] = tmp;
    tmp = mymin(array[44], array[48]);
    array[48] = mymax(array[44], array[48]);
    array[44] = tmp;
    tmp = mymin(array[45], array[49]);
    array[49] = mymax(array[45], array[49]);
    array[45] = tmp;
    tmp = mymin(array[46], array[50]);
    array[50] = mymax(array[46], array[50]);
    array[46] = tmp;
    tmp = mymin(array[47], array[51]);
    array[51] = mymax(array[47], array[51]);
    array[47] = tmp;
    tmp = mymin(array[52], array[56]);
    array[56] = mymax(array[52], array[56]);
    array[52] = tmp;
    tmp = mymin(array[53], array[57]);
    array[57] = mymax(array[53], array[57]);
    array[53] = tmp;
    tmp = mymin(array[54], array[58]);
    array[58] = mymax(array[54], array[58]);
    array[54] = tmp;
    tmp = mymin(array[55], array[59]);
    array[59] = mymax(array[55], array[59]);
    array[55] = tmp;
    tmp = mymin(array[60], array[64]);
    array[64] = mymax(array[60], array[64]);
    array[60] = tmp;
    tmp = mymin(array[61], array[65]);
    array[65] = mymax(array[61], array[65]);
    array[61] = tmp;
    tmp = mymin(array[62], array[66]);
    array[66] = mymax(array[62], array[66]);
    array[62] = tmp;
    tmp = mymin(array[63], array[67]);
    array[67] = mymax(array[63], array[67]);
    array[63] = tmp;
    tmp = mymin(array[68], array[72]);
    array[72] = mymax(array[68], array[72]);
    array[68] = tmp;
    tmp = mymin(array[69], array[73]);
    array[73] = mymax(array[69], array[73]);
    array[69] = tmp;
    tmp = mymin(array[70], array[74]);
    array[74] = mymax(array[70], array[74]);
    array[70] = tmp;
    tmp = mymin(array[71], array[75]);
    array[75] = mymax(array[71], array[75]);
    array[71] = tmp;
    tmp = mymin(array[76], array[80]);
    array[80] = mymax(array[76], array[80]);
    array[76] = tmp;
    tmp = mymin(array[0], array[2]);
    array[2] = mymax(array[0], array[2]);
    array[0] = tmp;
    tmp = mymin(array[1], array[3]);
    array[3] = mymax(array[1], array[3]);
    array[1] = tmp;
    tmp = mymin(array[4], array[6]);
    array[6] = mymax(array[4], array[6]);
    array[4] = tmp;
    tmp = mymin(array[5], array[7]);
    array[7] = mymax(array[5], array[7]);
    array[5] = tmp;
    tmp = mymin(array[8], array[10]);
    array[10] = mymax(array[8], array[10]);
    array[8] = tmp;
    tmp = mymin(array[9], array[11]);
    array[11] = mymax(array[9], array[11]);
    array[9] = tmp;
    tmp = mymin(array[12], array[14]);
    array[14] = mymax(array[12], array[14]);
    array[12] = tmp;
    tmp = mymin(array[13], array[15]);
    array[15] = mymax(array[13], array[15]);
    array[13] = tmp;
    tmp = mymin(array[16], array[18]);
    array[18] = mymax(array[16], array[18]);
    array[16] = tmp;
    tmp = mymin(array[17], array[19]);
    array[19] = mymax(array[17], array[19]);
    array[17] = tmp;
    tmp = mymin(array[20], array[22]);
    array[22] = mymax(array[20], array[22]);
    array[20] = tmp;
    tmp = mymin(array[21], array[23]);
    array[23] = mymax(array[21], array[23]);
    array[21] = tmp;
    tmp = mymin(array[24], array[26]);
    array[26] = mymax(array[24], array[26]);
    array[24] = tmp;
    tmp = mymin(array[25], array[27]);
    array[27] = mymax(array[25], array[27]);
    array[25] = tmp;
    tmp = mymin(array[28], array[30]);
    array[30] = mymax(array[28], array[30]);
    array[28] = tmp;
    tmp = mymin(array[29], array[31]);
    array[31] = mymax(array[29], array[31]);
    array[29] = tmp;
    tmp = mymin(array[32], array[34]);
    array[34] = mymax(array[32], array[34]);
    array[32] = tmp;
    tmp = mymin(array[33], array[35]);
    array[35] = mymax(array[33], array[35]);
    array[33] = tmp;
    tmp = mymin(array[36], array[38]);
    array[38] = mymax(array[36], array[38]);
    array[36] = tmp;
    tmp = mymin(array[37], array[39]);
    array[39] = mymax(array[37], array[39]);
    array[37] = tmp;
    tmp = mymin(array[40], array[42]);
    array[42] = mymax(array[40], array[42]);
    array[40] = tmp;
    tmp = mymin(array[41], array[43]);
    array[43] = mymax(array[41], array[43]);
    array[41] = tmp;
    tmp = mymin(array[44], array[46]);
    array[46] = mymax(array[44], array[46]);
    array[44] = tmp;
    tmp = mymin(array[45], array[47]);
    array[47] = mymax(array[45], array[47]);
    array[45] = tmp;
    tmp = mymin(array[48], array[50]);
    array[50] = mymax(array[48], array[50]);
    array[48] = tmp;
    tmp = mymin(array[49], array[51]);
    array[51] = mymax(array[49], array[51]);
    array[49] = tmp;
    tmp = mymin(array[52], array[54]);
    array[54] = mymax(array[52], array[54]);
    array[52] = tmp;
    tmp = mymin(array[53], array[55]);
    array[55] = mymax(array[53], array[55]);
    array[53] = tmp;
    tmp = mymin(array[56], array[58]);
    array[58] = mymax(array[56], array[58]);
    array[56] = tmp;
    tmp = mymin(array[57], array[59]);
    array[59] = mymax(array[57], array[59]);
    array[57] = tmp;
    tmp = mymin(array[60], array[62]);
    array[62] = mymax(array[60], array[62]);
    array[60] = tmp;
    tmp = mymin(array[61], array[63]);
    array[63] = mymax(array[61], array[63]);
    array[61] = tmp;
    tmp = mymin(array[64], array[66]);
    array[66] = mymax(array[64], array[66]);
    array[64] = tmp;
    tmp = mymin(array[65], array[67]);
    array[67] = mymax(array[65], array[67]);
    array[65] = tmp;
    tmp = mymin(array[68], array[70]);
    array[70] = mymax(array[68], array[70]);
    array[68] = tmp;
    tmp = mymin(array[69], array[71]);
    array[71] = mymax(array[69], array[71]);
    array[69] = tmp;
    tmp = mymin(array[72], array[74]);
    array[74] = mymax(array[72], array[74]);
    array[72] = tmp;
    tmp = mymin(array[73], array[75]);
    array[75] = mymax(array[73], array[75]);
    array[73] = tmp;
    tmp = mymin(array[76], array[78]);
    array[78] = mymax(array[76], array[78]);
    array[76] = tmp;
    tmp = mymin(array[77], array[79]);
    array[79] = mymax(array[77], array[79]);
    array[77] = tmp;
    tmp = mymin(array[2], array[64]);
    array[64] = mymax(array[2], array[64]);
    array[2] = tmp;
    tmp = mymin(array[3], array[65]);
    array[65] = mymax(array[3], array[65]);
    array[3] = tmp;
    tmp = mymin(array[6], array[68]);
    array[68] = mymax(array[6], array[68]);
    array[6] = tmp;
    tmp = mymin(array[7], array[69]);
    array[69] = mymax(array[7], array[69]);
    array[7] = tmp;
    tmp = mymin(array[10], array[72]);
    array[72] = mymax(array[10], array[72]);
    array[10] = tmp;
    tmp = mymin(array[11], array[73]);
    array[73] = mymax(array[11], array[73]);
    array[11] = tmp;
    tmp = mymin(array[14], array[76]);
    array[76] = mymax(array[14], array[76]);
    array[14] = tmp;
    tmp = mymin(array[15], array[77]);
    array[77] = mymax(array[15], array[77]);
    array[15] = tmp;
    tmp = mymin(array[18], array[80]);
    array[80] = mymax(array[18], array[80]);
    array[18] = tmp;
    tmp = mymin(array[2], array[32]);
    array[32] = mymax(array[2], array[32]);
    array[2] = tmp;
    tmp = mymin(array[3], array[33]);
    array[33] = mymax(array[3], array[33]);
    array[3] = tmp;
    tmp = mymin(array[6], array[36]);
    array[36] = mymax(array[6], array[36]);
    array[6] = tmp;
    tmp = mymin(array[7], array[37]);
    array[37] = mymax(array[7], array[37]);
    array[7] = tmp;
    tmp = mymin(array[10], array[40]);
    array[40] = mymax(array[10], array[40]);
    array[10] = tmp;
    tmp = mymin(array[11], array[41]);
    array[41] = mymax(array[11], array[41]);
    array[11] = tmp;
    tmp = mymin(array[14], array[44]);
    array[44] = mymax(array[14], array[44]);
    array[14] = tmp;
    tmp = mymin(array[15], array[45]);
    array[45] = mymax(array[15], array[45]);
    array[15] = tmp;
    tmp = mymin(array[18], array[48]);
    array[48] = mymax(array[18], array[48]);
    array[18] = tmp;
    tmp = mymin(array[19], array[49]);
    array[49] = mymax(array[19], array[49]);
    array[19] = tmp;
    tmp = mymin(array[22], array[52]);
    array[52] = mymax(array[22], array[52]);
    array[22] = tmp;
    tmp = mymin(array[23], array[53]);
    array[53] = mymax(array[23], array[53]);
    array[23] = tmp;
    tmp = mymin(array[26], array[56]);
    array[56] = mymax(array[26], array[56]);
    array[26] = tmp;
    tmp = mymin(array[27], array[57]);
    array[57] = mymax(array[27], array[57]);
    array[27] = tmp;
    tmp = mymin(array[30], array[60]);
    array[60] = mymax(array[30], array[60]);
    array[30] = tmp;
    tmp = mymin(array[31], array[61]);
    array[61] = mymax(array[31], array[61]);
    array[31] = tmp;
    tmp = mymin(array[34], array[64]);
    array[64] = mymax(array[34], array[64]);
    array[34] = tmp;
    tmp = mymin(array[35], array[65]);
    array[65] = mymax(array[35], array[65]);
    array[35] = tmp;
    tmp = mymin(array[38], array[68]);
    array[68] = mymax(array[38], array[68]);
    array[38] = tmp;
    tmp = mymin(array[39], array[69]);
    array[69] = mymax(array[39], array[69]);
    array[39] = tmp;
    tmp = mymin(array[42], array[72]);
    array[72] = mymax(array[42], array[72]);
    array[42] = tmp;
    tmp = mymin(array[43], array[73]);
    array[73] = mymax(array[43], array[73]);
    array[43] = tmp;
    tmp = mymin(array[46], array[76]);
    array[76] = mymax(array[46], array[76]);
    array[46] = tmp;
    tmp = mymin(array[47], array[77]);
    array[77] = mymax(array[47], array[77]);
    array[47] = tmp;
    tmp = mymin(array[50], array[80]);
    array[80] = mymax(array[50], array[80]);
    array[50] = tmp;
    tmp = mymin(array[2], array[16]);
    array[16] = mymax(array[2], array[16]);
    array[2] = tmp;
    tmp = mymin(array[3], array[17]);
    array[17] = mymax(array[3], array[17]);
    array[3] = tmp;
    tmp = mymin(array[6], array[20]);
    array[20] = mymax(array[6], array[20]);
    array[6] = tmp;
    tmp = mymin(array[7], array[21]);
    array[21] = mymax(array[7], array[21]);
    array[7] = tmp;
    tmp = mymin(array[10], array[24]);
    array[24] = mymax(array[10], array[24]);
    array[10] = tmp;
    tmp = mymin(array[11], array[25]);
    array[25] = mymax(array[11], array[25]);
    array[11] = tmp;
    tmp = mymin(array[14], array[28]);
    array[28] = mymax(array[14], array[28]);
    array[14] = tmp;
    tmp = mymin(array[15], array[29]);
    array[29] = mymax(array[15], array[29]);
    array[15] = tmp;
    tmp = mymin(array[18], array[32]);
    array[32] = mymax(array[18], array[32]);
    array[18] = tmp;
    tmp = mymin(array[19], array[33]);
    array[33] = mymax(array[19], array[33]);
    array[19] = tmp;
    tmp = mymin(array[22], array[36]);
    array[36] = mymax(array[22], array[36]);
    array[22] = tmp;
    tmp = mymin(array[23], array[37]);
    array[37] = mymax(array[23], array[37]);
    array[23] = tmp;
    tmp = mymin(array[26], array[40]);
    array[40] = mymax(array[26], array[40]);
    array[26] = tmp;
    tmp = mymin(array[27], array[41]);
    array[41] = mymax(array[27], array[41]);
    array[27] = tmp;
    tmp = mymin(array[30], array[44]);
    array[44] = mymax(array[30], array[44]);
    array[30] = tmp;
    tmp = mymin(array[31], array[45]);
    array[45] = mymax(array[31], array[45]);
    array[31] = tmp;
    tmp = mymin(array[34], array[48]);
    array[48] = mymax(array[34], array[48]);
    array[34] = tmp;
    tmp = mymin(array[35], array[49]);
    array[49] = mymax(array[35], array[49]);
    array[35] = tmp;
    tmp = mymin(array[38], array[52]);
    array[52] = mymax(array[38], array[52]);
    array[38] = tmp;
    tmp = mymin(array[39], array[53]);
    array[53] = mymax(array[39], array[53]);
    array[39] = tmp;
    tmp = mymin(array[42], array[56]);
    array[56] = mymax(array[42], array[56]);
    array[42] = tmp;
    tmp = mymin(array[43], array[57]);
    array[57] = mymax(array[43], array[57]);
    array[43] = tmp;
    tmp = mymin(array[46], array[60]);
    array[60] = mymax(array[46], array[60]);
    array[46] = tmp;
    tmp = mymin(array[47], array[61]);
    array[61] = mymax(array[47], array[61]);
    array[47] = tmp;
    tmp = mymin(array[50], array[64]);
    array[64] = mymax(array[50], array[64]);
    array[50] = tmp;
    tmp = mymin(array[51], array[65]);
    array[65] = mymax(array[51], array[65]);
    array[51] = tmp;
    tmp = mymin(array[54], array[68]);
    array[68] = mymax(array[54], array[68]);
    array[54] = tmp;
    tmp = mymin(array[55], array[69]);
    array[69] = mymax(array[55], array[69]);
    array[55] = tmp;
    tmp = mymin(array[58], array[72]);
    array[72] = mymax(array[58], array[72]);
    array[58] = tmp;
    tmp = mymin(array[59], array[73]);
    array[73] = mymax(array[59], array[73]);
    array[59] = tmp;
    tmp = mymin(array[62], array[76]);
    array[76] = mymax(array[62], array[76]);
    array[62] = tmp;
    tmp = mymin(array[63], array[77]);
    array[77] = mymax(array[63], array[77]);
    array[63] = tmp;
    tmp = mymin(array[66], array[80]);
    array[80] = mymax(array[66], array[80]);
    array[66] = tmp;
    tmp = mymin(array[2], array[8]);
    array[8] = mymax(array[2], array[8]);
    array[2] = tmp;
    tmp = mymin(array[3], array[9]);
    array[9] = mymax(array[3], array[9]);
    array[3] = tmp;
    tmp = mymin(array[6], array[12]);
    array[12] = mymax(array[6], array[12]);
    array[6] = tmp;
    tmp = mymin(array[7], array[13]);
    array[13] = mymax(array[7], array[13]);
    array[7] = tmp;
    tmp = mymin(array[10], array[16]);
    array[16] = mymax(array[10], array[16]);
    array[10] = tmp;
    tmp = mymin(array[11], array[17]);
    array[17] = mymax(array[11], array[17]);
    array[11] = tmp;
    tmp = mymin(array[14], array[20]);
    array[20] = mymax(array[14], array[20]);
    array[14] = tmp;
    tmp = mymin(array[15], array[21]);
    array[21] = mymax(array[15], array[21]);
    array[15] = tmp;
    tmp = mymin(array[18], array[24]);
    array[24] = mymax(array[18], array[24]);
    array[18] = tmp;
    tmp = mymin(array[19], array[25]);
    array[25] = mymax(array[19], array[25]);
    array[19] = tmp;
    tmp = mymin(array[22], array[28]);
    array[28] = mymax(array[22], array[28]);
    array[22] = tmp;
    tmp = mymin(array[23], array[29]);
    array[29] = mymax(array[23], array[29]);
    array[23] = tmp;
    tmp = mymin(array[26], array[32]);
    array[32] = mymax(array[26], array[32]);
    array[26] = tmp;
    tmp = mymin(array[27], array[33]);
    array[33] = mymax(array[27], array[33]);
    array[27] = tmp;
    tmp = mymin(array[30], array[36]);
    array[36] = mymax(array[30], array[36]);
    array[30] = tmp;
    tmp = mymin(array[31], array[37]);
    array[37] = mymax(array[31], array[37]);
    array[31] = tmp;
    tmp = mymin(array[34], array[40]);
    array[40] = mymax(array[34], array[40]);
    array[34] = tmp;
    tmp = mymin(array[35], array[41]);
    array[41] = mymax(array[35], array[41]);
    array[35] = tmp;
    tmp = mymin(array[38], array[44]);
    array[44] = mymax(array[38], array[44]);
    array[38] = tmp;
    tmp = mymin(array[39], array[45]);
    array[45] = mymax(array[39], array[45]);
    array[39] = tmp;
    tmp = mymin(array[42], array[48]);
    array[48] = mymax(array[42], array[48]);
    array[42] = tmp;
    tmp = mymin(array[43], array[49]);
    array[49] = mymax(array[43], array[49]);
    array[43] = tmp;
    tmp = mymin(array[46], array[52]);
    array[52] = mymax(array[46], array[52]);
    array[46] = tmp;
    tmp = mymin(array[47], array[53]);
    array[53] = mymax(array[47], array[53]);
    array[47] = tmp;
    tmp = mymin(array[50], array[56]);
    array[56] = mymax(array[50], array[56]);
    array[50] = tmp;
    tmp = mymin(array[51], array[57]);
    array[57] = mymax(array[51], array[57]);
    array[51] = tmp;
    tmp = mymin(array[54], array[60]);
    array[60] = mymax(array[54], array[60]);
    array[54] = tmp;
    tmp = mymin(array[55], array[61]);
    array[61] = mymax(array[55], array[61]);
    array[55] = tmp;
    tmp = mymin(array[58], array[64]);
    array[64] = mymax(array[58], array[64]);
    array[58] = tmp;
    tmp = mymin(array[59], array[65]);
    array[65] = mymax(array[59], array[65]);
    array[59] = tmp;
    tmp = mymin(array[62], array[68]);
    array[68] = mymax(array[62], array[68]);
    array[62] = tmp;
    tmp = mymin(array[63], array[69]);
    array[69] = mymax(array[63], array[69]);
    array[63] = tmp;
    tmp = mymin(array[66], array[72]);
    array[72] = mymax(array[66], array[72]);
    array[66] = tmp;
    tmp = mymin(array[67], array[73]);
    array[73] = mymax(array[67], array[73]);
    array[67] = tmp;
    tmp = mymin(array[70], array[76]);
    array[76] = mymax(array[70], array[76]);
    array[70] = tmp;
    tmp = mymin(array[71], array[77]);
    array[77] = mymax(array[71], array[77]);
    array[71] = tmp;
    tmp = mymin(array[74], array[80]);
    array[80] = mymax(array[74], array[80]);
    array[74] = tmp;
    tmp = mymin(array[2], array[4]);
    array[4] = mymax(array[2], array[4]);
    array[2] = tmp;
    tmp = mymin(array[3], array[5]);
    array[5] = mymax(array[3], array[5]);
    array[3] = tmp;
    tmp = mymin(array[6], array[8]);
    array[8] = mymax(array[6], array[8]);
    array[6] = tmp;
    tmp = mymin(array[7], array[9]);
    array[9] = mymax(array[7], array[9]);
    array[7] = tmp;
    tmp = mymin(array[10], array[12]);
    array[12] = mymax(array[10], array[12]);
    array[10] = tmp;
    tmp = mymin(array[11], array[13]);
    array[13] = mymax(array[11], array[13]);
    array[11] = tmp;
    tmp = mymin(array[14], array[16]);
    array[16] = mymax(array[14], array[16]);
    array[14] = tmp;
    tmp = mymin(array[15], array[17]);
    array[17] = mymax(array[15], array[17]);
    array[15] = tmp;
    tmp = mymin(array[18], array[20]);
    array[20] = mymax(array[18], array[20]);
    array[18] = tmp;
    tmp = mymin(array[19], array[21]);
    array[21] = mymax(array[19], array[21]);
    array[19] = tmp;
    tmp = mymin(array[22], array[24]);
    array[24] = mymax(array[22], array[24]);
    array[22] = tmp;
    tmp = mymin(array[23], array[25]);
    array[25] = mymax(array[23], array[25]);
    array[23] = tmp;
    tmp = mymin(array[26], array[28]);
    array[28] = mymax(array[26], array[28]);
    array[26] = tmp;
    tmp = mymin(array[27], array[29]);
    array[29] = mymax(array[27], array[29]);
    array[27] = tmp;
    tmp = mymin(array[30], array[32]);
    array[32] = mymax(array[30], array[32]);
    array[30] = tmp;
    tmp = mymin(array[31], array[33]);
    array[33] = mymax(array[31], array[33]);
    array[31] = tmp;
    tmp = mymin(array[34], array[36]);
    array[36] = mymax(array[34], array[36]);
    array[34] = tmp;
    tmp = mymin(array[35], array[37]);
    array[37] = mymax(array[35], array[37]);
    array[35] = tmp;
    tmp = mymin(array[38], array[40]);
    array[40] = mymax(array[38], array[40]);
    array[38] = tmp;
    tmp = mymin(array[39], array[41]);
    array[41] = mymax(array[39], array[41]);
    array[39] = tmp;
    tmp = mymin(array[42], array[44]);
    array[44] = mymax(array[42], array[44]);
    array[42] = tmp;
    tmp = mymin(array[43], array[45]);
    array[45] = mymax(array[43], array[45]);
    array[43] = tmp;
    tmp = mymin(array[46], array[48]);
    array[48] = mymax(array[46], array[48]);
    array[46] = tmp;
    tmp = mymin(array[47], array[49]);
    array[49] = mymax(array[47], array[49]);
    array[47] = tmp;
    tmp = mymin(array[50], array[52]);
    array[52] = mymax(array[50], array[52]);
    array[50] = tmp;
    tmp = mymin(array[51], array[53]);
    array[53] = mymax(array[51], array[53]);
    array[51] = tmp;
    tmp = mymin(array[54], array[56]);
    array[56] = mymax(array[54], array[56]);
    array[54] = tmp;
    tmp = mymin(array[55], array[57]);
    array[57] = mymax(array[55], array[57]);
    array[55] = tmp;
    tmp = mymin(array[58], array[60]);
    array[60] = mymax(array[58], array[60]);
    array[58] = tmp;
    tmp = mymin(array[59], array[61]);
    array[61] = mymax(array[59], array[61]);
    array[59] = tmp;
    tmp = mymin(array[62], array[64]);
    array[64] = mymax(array[62], array[64]);
    array[62] = tmp;
    tmp = mymin(array[63], array[65]);
    array[65] = mymax(array[63], array[65]);
    array[63] = tmp;
    tmp = mymin(array[66], array[68]);
    array[68] = mymax(array[66], array[68]);
    array[66] = tmp;
    tmp = mymin(array[67], array[69]);
    array[69] = mymax(array[67], array[69]);
    array[67] = tmp;
    tmp = mymin(array[70], array[72]);
    array[72] = mymax(array[70], array[72]);
    array[70] = tmp;
    tmp = mymin(array[71], array[73]);
    array[73] = mymax(array[71], array[73]);
    array[71] = tmp;
    tmp = mymin(array[74], array[76]);
    array[76] = mymax(array[74], array[76]);
    array[74] = tmp;
    tmp = mymin(array[75], array[77]);
    array[77] = mymax(array[75], array[77]);
    array[75] = tmp;
    tmp = mymin(array[78], array[80]);
    array[80] = mymax(array[78], array[80]);
    array[78] = tmp;
    array[1] = mymax(array[0], array[1]);
    array[3] = mymax(array[2], array[3]);
    array[5] = mymax(array[4], array[5]);
    array[7] = mymax(array[6], array[7]);
    array[9] = mymax(array[8], array[9]);
    array[11] = mymax(array[10], array[11]);
    array[13] = mymax(array[12], array[13]);
    array[15] = mymax(array[14], array[15]);
    array[17] = mymax(array[16], array[17]);
    array[19] = mymax(array[18], array[19]);
    array[21] = mymax(array[20], array[21]);
    array[23] = mymax(array[22], array[23]);
    array[25] = mymax(array[24], array[25]);
    array[27] = mymax(array[26], array[27]);
    array[29] = mymax(array[28], array[29]);
    array[31] = mymax(array[30], array[31]);
    array[33] = mymax(array[32], array[33]);
    array[35] = mymax(array[34], array[35]);
    array[37] = mymax(array[36], array[37]);
    array[39] = mymax(array[38], array[39]);
    array[40] = mymin(array[40], array[41]);
    array[42] = mymin(array[42], array[43]);
    array[44] = mymin(array[44], array[45]);
    array[46] = mymin(array[46], array[47]);
    array[48] = mymin(array[48], array[49]);
    array[50] = mymin(array[50], array[51]);
    array[52] = mymin(array[52], array[53]);
    array[54] = mymin(array[54], array[55]);
    array[56] = mymin(array[56], array[57]);
    array[58] = mymin(array[58], array[59]);
    array[60] = mymin(array[60], array[61]);
    array[62] = mymin(array[62], array[63]);
    array[64] = mymin(array[64], array[65]);
    array[66] = mymin(array[66], array[67]);
    array[68] = mymin(array[68], array[69]);
    array[70] = mymin(array[70], array[71]);
    array[72] = mymin(array[72], array[73]);
    array[74] = mymin(array[74], array[75]);
    array[76] = mymin(array[76], array[77]);
    array[78] = mymin(array[78], array[79]);
    array[64] = mymax(array[1], array[64]);
    array[66] = mymax(array[3], array[66]);
    array[68] = mymax(array[5], array[68]);
    array[70] = mymax(array[7], array[70]);
    array[9] = mymin(array[9], array[72]);
    array[11] = mymin(array[11], array[74]);
    array[13] = mymin(array[13], array[76]);
    array[15] = mymin(array[15], array[78]);
    array[17] = mymin(array[17], array[80]);
    array[40] = mymax(array[9], array[40]);
    array[42] = mymax(array[11], array[42]);
    array[44] = mymax(array[13], array[44]);
    array[46] = mymax(array[15], array[46]);
    array[48] = mymax(array[17], array[48]);
    array[50] = mymax(array[19], array[50]);
    array[52] = mymax(array[21], array[52]);
    array[54] = mymax(array[23], array[54]);
    array[25] = mymin(array[25], array[56]);
    array[27] = mymin(array[27], array[58]);
    array[29] = mymin(array[29], array[60]);
    array[31] = mymin(array[31], array[62]);
    array[33] = mymin(array[33], array[64]);
    array[35] = mymin(array[35], array[66]);
    array[37] = mymin(array[37], array[68]);
    array[39] = mymin(array[39], array[70]);
    array[40] = mymax(array[25], array[40]);
    array[42] = mymax(array[27], array[42]);
    array[44] = mymax(array[29], array[44]);
    array[46] = mymax(array[31], array[46]);
    array[33] = mymin(array[33], array[48]);
    array[35] = mymin(array[35], array[50]);
    array[37] = mymin(array[37], array[52]);
    array[39] = mymin(array[39], array[54]);
    array[40] = mymax(array[33], array[40]);
    array[42] = mymax(array[35], array[42]);
    array[37] = mymin(array[37], array[44]);
    array[39] = mymin(array[39], array[46]);
    array[40] = mymax(array[37], array[40]);
    array[39] = mymin(array[39], array[42]);
    return mymax(array[39], array[40]);
}

#ifdef __SSE2__

__m128 median3x3sse(__m128* array)
{
    __m128 tmp = _mm_min_ps(array[1], array[2]);
    array[2] = _mm_max_ps(array[1], array[2]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[4], array[5]);
    array[5] = _mm_max_ps(array[4], array[5]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[7], array[8]);
    array[8] = _mm_max_ps(array[7], array[8]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[0], array[1]);
    array[1] = _mm_max_ps(array[0], array[1]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[3], array[4]);
    array[4] = _mm_max_ps(array[3], array[4]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[7]);
    array[7] = _mm_max_ps(array[6], array[7]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[1], array[2]);
    array[2] = _mm_max_ps(array[1], array[2]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[4], array[5]);
    array[5] = _mm_max_ps(array[4], array[5]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[7], array[8]);
    array[8] = _mm_max_ps(array[7], array[8]);
    array[3] = _mm_max_ps(array[0], array[3]);
    array[5] = _mm_min_ps(array[5], array[8]);
    array[7] = _mm_max_ps(array[4], tmp);
    tmp = _mm_min_ps(array[4], tmp);
    array[6] = _mm_max_ps(array[3], array[6]);
    array[4] = _mm_max_ps(array[1], tmp);
    array[2] = _mm_min_ps(array[2], array[5]);
    array[4] = _mm_min_ps(array[4], array[7]);
    tmp = _mm_min_ps(array[4], array[2]);
    array[2] = _mm_max_ps(array[4], array[2]);
    array[4] = _mm_max_ps(array[6], tmp);
    return _mm_min_ps(array[4], array[2]);
}

__m128 median5x5sse(__m128* array)
{
    __m128 tmp = _mm_min_ps(array[0], array[1]);
    array[1] = _mm_max_ps(array[0], array[1]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[3], array[4]);
    array[4] = _mm_max_ps(array[3], array[4]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[2], array[4]);
    array[4] = _mm_max_ps(array[2], array[4]);
    array[2] = _mm_min_ps(tmp, array[3]);
    array[3] = _mm_max_ps(tmp, array[3]);
    tmp = _mm_min_ps(array[6], array[7]);
    array[7] = _mm_max_ps(array[6], array[7]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[5], array[7]);
    array[7] = _mm_max_ps(array[5], array[7]);
    array[5] = _mm_min_ps(tmp, array[6]);
    array[6] = _mm_max_ps(tmp, array[6]);
    tmp = _mm_min_ps(array[9], array[10]);
    array[10] = _mm_max_ps(array[9], array[10]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[8], array[10]);
    array[10] = _mm_max_ps(array[8], array[10]);
    array[8] = _mm_min_ps(tmp, array[9]);
    array[9] = _mm_max_ps(tmp, array[9]);
    tmp = _mm_min_ps(array[12], array[13]);
    array[13] = _mm_max_ps(array[12], array[13]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[11], array[13]);
    array[13] = _mm_max_ps(array[11], array[13]);
    array[11] = _mm_min_ps(tmp, array[12]);
    array[12] = _mm_max_ps(tmp, array[12]);
    tmp = _mm_min_ps(array[15], array[16]);
    array[16] = _mm_max_ps(array[15], array[16]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[14], array[16]);
    array[16] = _mm_max_ps(array[14], array[16]);
    array[14] = _mm_min_ps(tmp, array[15]);
    array[15] = _mm_max_ps(tmp, array[15]);
    tmp = _mm_min_ps(array[18], array[19]);
    array[19] = _mm_max_ps(array[18], array[19]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[17], array[19]);
    array[19] = _mm_max_ps(array[17], array[19]);
    array[17] = _mm_min_ps(tmp, array[18]);
    array[18] = _mm_max_ps(tmp, array[18]);
    tmp = _mm_min_ps(array[21], array[22]);
    array[22] = _mm_max_ps(array[21], array[22]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[20], array[22]);
    array[22] = _mm_max_ps(array[20], array[22]);
    array[20] = _mm_min_ps(tmp, array[21]);
    array[21] = _mm_max_ps(tmp, array[21]);
    tmp = _mm_min_ps(array[23], array[24]);
    array[24] = _mm_max_ps(array[23], array[24]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[2], array[5]);
    array[5] = _mm_max_ps(array[2], array[5]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[6]);
    array[6] = _mm_max_ps(array[3], array[6]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[0], array[6]);
    array[6] = _mm_max_ps(array[0], array[6]);
    array[0] = _mm_min_ps(tmp, array[3]);
    array[3] = _mm_max_ps(tmp, array[3]);
    tmp = _mm_min_ps(array[4], array[7]);
    array[7] = _mm_max_ps(array[4], array[7]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[1], array[7]);
    array[7] = _mm_max_ps(array[1], array[7]);
    array[1] = _mm_min_ps(tmp, array[4]);
    array[4] = _mm_max_ps(tmp, array[4]);
    tmp = _mm_min_ps(array[11], array[14]);
    array[14] = _mm_max_ps(array[11], array[14]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[8], array[14]);
    array[14] = _mm_max_ps(array[8], array[14]);
    array[8] = _mm_min_ps(tmp, array[11]);
    array[11] = _mm_max_ps(tmp, array[11]);
    tmp = _mm_min_ps(array[12], array[15]);
    array[15] = _mm_max_ps(array[12], array[15]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[9], array[15]);
    array[15] = _mm_max_ps(array[9], array[15]);
    array[9] = _mm_min_ps(tmp, array[12]);
    array[12] = _mm_max_ps(tmp, array[12]);
    tmp = _mm_min_ps(array[13], array[16]);
    array[16] = _mm_max_ps(array[13], array[16]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[10], array[16]);
    array[16] = _mm_max_ps(array[10], array[16]);
    array[10] = _mm_min_ps(tmp, array[13]);
    array[13] = _mm_max_ps(tmp, array[13]);
    tmp = _mm_min_ps(array[20], array[23]);
    array[23] = _mm_max_ps(array[20], array[23]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[17], array[23]);
    array[23] = _mm_max_ps(array[17], array[23]);
    array[17] = _mm_min_ps(tmp, array[20]);
    array[20] = _mm_max_ps(tmp, array[20]);
    tmp = _mm_min_ps(array[21], array[24]);
    array[24] = _mm_max_ps(array[21], array[24]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[18], array[24]);
    array[24] = _mm_max_ps(array[18], array[24]);
    array[18] = _mm_min_ps(tmp, array[21]);
    array[21] = _mm_max_ps(tmp, array[21]);
    tmp = _mm_min_ps(array[19], array[22]);
    array[22] = _mm_max_ps(array[19], array[22]);
    array[19] = tmp;
    array[17] = _mm_max_ps(array[8], array[17]);
    tmp = _mm_min_ps(array[9], array[18]);
    array[18] = _mm_max_ps(array[9], array[18]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[0], array[18]);
    array[18] = _mm_max_ps(array[0], array[18]);
    array[9] = _mm_max_ps(tmp, array[9]);
    tmp = _mm_min_ps(array[10], array[19]);
    array[19] = _mm_max_ps(array[10], array[19]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[1], array[19]);
    array[19] = _mm_max_ps(array[1], array[19]);
    array[1] = _mm_min_ps(tmp, array[10]);
    array[10] = _mm_max_ps(tmp, array[10]);
    tmp = _mm_min_ps(array[11], array[20]);
    array[20] = _mm_max_ps(array[11], array[20]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[2], array[20]);
    array[20] = _mm_max_ps(array[2], array[20]);
    array[11] = _mm_max_ps(tmp, array[11]);
    tmp = _mm_min_ps(array[12], array[21]);
    array[21] = _mm_max_ps(array[12], array[21]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[3], array[21]);
    array[21] = _mm_max_ps(array[3], array[21]);
    array[3] = _mm_min_ps(tmp, array[12]);
    array[12] = _mm_max_ps(tmp, array[12]);
    tmp = _mm_min_ps(array[13], array[22]);
    array[22] = _mm_max_ps(array[13], array[22]);
    array[4] = _mm_min_ps(array[4], array[22]);
    array[13] = _mm_max_ps(array[4], tmp);
    tmp = _mm_min_ps(array[4], tmp);
    array[4] = tmp;
    tmp = _mm_min_ps(array[14], array[23]);
    array[23] = _mm_max_ps(array[14], array[23]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[5], array[23]);
    array[23] = _mm_max_ps(array[5], array[23]);
    array[5] = _mm_min_ps(tmp, array[14]);
    array[14] = _mm_max_ps(tmp, array[14]);
    tmp = _mm_min_ps(array[15], array[24]);
    array[24] = _mm_max_ps(array[15], array[24]);
    array[15] = tmp;
    array[6] = _mm_min_ps(array[6], array[24]);
    tmp = _mm_min_ps(array[6], array[15]);
    array[15] = _mm_max_ps(array[6], array[15]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[16]);
    array[7] = _mm_min_ps(tmp, array[19]);
    tmp = _mm_min_ps(array[13], array[21]);
    array[15] = _mm_min_ps(array[15], array[23]);
    tmp = _mm_min_ps(array[7], tmp);
    array[7] = _mm_min_ps(tmp, array[15]);
    array[9] = _mm_max_ps(array[1], array[9]);
    array[11] = _mm_max_ps(array[3], array[11]);
    array[17] = _mm_max_ps(array[5], array[17]);
    array[17] = _mm_max_ps(array[11], array[17]);
    array[17] = _mm_max_ps(array[9], array[17]);
    tmp = _mm_min_ps(array[4], array[10]);
    array[10] = _mm_max_ps(array[4], array[10]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[6], array[12]);
    array[12] = _mm_max_ps(array[6], array[12]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[14]);
    array[14] = _mm_max_ps(array[7], array[14]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[4], array[6]);
    array[6] = _mm_max_ps(array[4], array[6]);
    array[7] = _mm_max_ps(tmp, array[7]);
    tmp = _mm_min_ps(array[12], array[14]);
    array[14] = _mm_max_ps(array[12], array[14]);
    array[12] = tmp;
    array[10] = _mm_min_ps(array[10], array[14]);
    tmp = _mm_min_ps(array[6], array[7]);
    array[7] = _mm_max_ps(array[6], array[7]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[10], array[12]);
    array[12] = _mm_max_ps(array[10], array[12]);
    array[10] = _mm_max_ps(array[6], tmp);
    tmp = _mm_min_ps(array[6], tmp);
    array[17] = _mm_max_ps(tmp, array[17]);
    tmp = _mm_min_ps(array[12], array[17]);
    array[17] = _mm_max_ps(array[12], array[17]);
    array[12] = tmp;
    array[7] = _mm_min_ps(array[7], array[17]);
    tmp = _mm_min_ps(array[7], array[10]);
    array[10] = _mm_max_ps(array[7], array[10]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[18]);
    array[18] = _mm_max_ps(array[12], array[18]);
    array[12] = _mm_max_ps(array[7], tmp);
    array[10] = _mm_min_ps(array[10], array[18]);
    tmp = _mm_min_ps(array[12], array[20]);
    array[20] = _mm_max_ps(array[12], array[20]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[10], array[20]);
    return _mm_max_ps(tmp, array[12]);
}

__m128 median7x7sse(__m128* array)
{
    __m128 tmp = _mm_min_ps(array[0], array[32]);
    array[32] = _mm_max_ps(array[0], array[32]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[33]);
    array[33] = _mm_max_ps(array[1], array[33]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[34]);
    array[34] = _mm_max_ps(array[2], array[34]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[35]);
    array[35] = _mm_max_ps(array[3], array[35]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[4], array[36]);
    array[36] = _mm_max_ps(array[4], array[36]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[37]);
    array[37] = _mm_max_ps(array[5], array[37]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[38]);
    array[38] = _mm_max_ps(array[6], array[38]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[39]);
    array[39] = _mm_max_ps(array[7], array[39]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[8], array[40]);
    array[40] = _mm_max_ps(array[8], array[40]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[41]);
    array[41] = _mm_max_ps(array[9], array[41]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[42]);
    array[42] = _mm_max_ps(array[10], array[42]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[43]);
    array[43] = _mm_max_ps(array[11], array[43]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[44]);
    array[44] = _mm_max_ps(array[12], array[44]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[45]);
    array[45] = _mm_max_ps(array[13], array[45]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[46]);
    array[46] = _mm_max_ps(array[14], array[46]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[47]);
    array[47] = _mm_max_ps(array[15], array[47]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[16], array[48]);
    array[48] = _mm_max_ps(array[16], array[48]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[0], array[16]);
    array[16] = _mm_max_ps(array[0], array[16]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[17]);
    array[17] = _mm_max_ps(array[1], array[17]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[18]);
    array[18] = _mm_max_ps(array[2], array[18]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[19]);
    array[19] = _mm_max_ps(array[3], array[19]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[4], array[20]);
    array[20] = _mm_max_ps(array[4], array[20]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[21]);
    array[21] = _mm_max_ps(array[5], array[21]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[22]);
    array[22] = _mm_max_ps(array[6], array[22]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[23]);
    array[23] = _mm_max_ps(array[7], array[23]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[8], array[24]);
    array[24] = _mm_max_ps(array[8], array[24]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[25]);
    array[25] = _mm_max_ps(array[9], array[25]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[26]);
    array[26] = _mm_max_ps(array[10], array[26]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[27]);
    array[27] = _mm_max_ps(array[11], array[27]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[28]);
    array[28] = _mm_max_ps(array[12], array[28]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[29]);
    array[29] = _mm_max_ps(array[13], array[29]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[30]);
    array[30] = _mm_max_ps(array[14], array[30]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[31]);
    array[31] = _mm_max_ps(array[15], array[31]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[32], array[48]);
    array[48] = _mm_max_ps(array[32], array[48]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[16], array[32]);
    array[32] = _mm_max_ps(array[16], array[32]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[33]);
    array[33] = _mm_max_ps(array[17], array[33]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[34]);
    array[34] = _mm_max_ps(array[18], array[34]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[35]);
    array[35] = _mm_max_ps(array[19], array[35]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[20], array[36]);
    array[36] = _mm_max_ps(array[20], array[36]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[37]);
    array[37] = _mm_max_ps(array[21], array[37]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[38]);
    array[38] = _mm_max_ps(array[22], array[38]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[39]);
    array[39] = _mm_max_ps(array[23], array[39]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[24], array[40]);
    array[40] = _mm_max_ps(array[24], array[40]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[41]);
    array[41] = _mm_max_ps(array[25], array[41]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[42]);
    array[42] = _mm_max_ps(array[26], array[42]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[43]);
    array[43] = _mm_max_ps(array[27], array[43]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[28], array[44]);
    array[44] = _mm_max_ps(array[28], array[44]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[45]);
    array[45] = _mm_max_ps(array[29], array[45]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[46]);
    array[46] = _mm_max_ps(array[30], array[46]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[47]);
    array[47] = _mm_max_ps(array[31], array[47]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[0], array[8]);
    array[8] = _mm_max_ps(array[0], array[8]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[9]);
    array[9] = _mm_max_ps(array[1], array[9]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[10]);
    array[10] = _mm_max_ps(array[2], array[10]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[11]);
    array[11] = _mm_max_ps(array[3], array[11]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[4], array[12]);
    array[12] = _mm_max_ps(array[4], array[12]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[13]);
    array[13] = _mm_max_ps(array[5], array[13]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[14]);
    array[14] = _mm_max_ps(array[6], array[14]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[15]);
    array[15] = _mm_max_ps(array[7], array[15]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[16], array[24]);
    array[24] = _mm_max_ps(array[16], array[24]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[25]);
    array[25] = _mm_max_ps(array[17], array[25]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[26]);
    array[26] = _mm_max_ps(array[18], array[26]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[27]);
    array[27] = _mm_max_ps(array[19], array[27]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[20], array[28]);
    array[28] = _mm_max_ps(array[20], array[28]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[29]);
    array[29] = _mm_max_ps(array[21], array[29]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[30]);
    array[30] = _mm_max_ps(array[22], array[30]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[31]);
    array[31] = _mm_max_ps(array[23], array[31]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[32], array[40]);
    array[40] = _mm_max_ps(array[32], array[40]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[41]);
    array[41] = _mm_max_ps(array[33], array[41]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[34], array[42]);
    array[42] = _mm_max_ps(array[34], array[42]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[43]);
    array[43] = _mm_max_ps(array[35], array[43]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[36], array[44]);
    array[44] = _mm_max_ps(array[36], array[44]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[45]);
    array[45] = _mm_max_ps(array[37], array[45]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[46]);
    array[46] = _mm_max_ps(array[38], array[46]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[47]);
    array[47] = _mm_max_ps(array[39], array[47]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[8], array[32]);
    array[32] = _mm_max_ps(array[8], array[32]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[33]);
    array[33] = _mm_max_ps(array[9], array[33]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[34]);
    array[34] = _mm_max_ps(array[10], array[34]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[35]);
    array[35] = _mm_max_ps(array[11], array[35]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[36]);
    array[36] = _mm_max_ps(array[12], array[36]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[37]);
    array[37] = _mm_max_ps(array[13], array[37]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[38]);
    array[38] = _mm_max_ps(array[14], array[38]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[39]);
    array[39] = _mm_max_ps(array[15], array[39]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[24], array[48]);
    array[48] = _mm_max_ps(array[24], array[48]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[8], array[16]);
    array[16] = _mm_max_ps(array[8], array[16]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[17]);
    array[17] = _mm_max_ps(array[9], array[17]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[18]);
    array[18] = _mm_max_ps(array[10], array[18]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[19]);
    array[19] = _mm_max_ps(array[11], array[19]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[20]);
    array[20] = _mm_max_ps(array[12], array[20]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[21]);
    array[21] = _mm_max_ps(array[13], array[21]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[22]);
    array[22] = _mm_max_ps(array[14], array[22]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[23]);
    array[23] = _mm_max_ps(array[15], array[23]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[24], array[32]);
    array[32] = _mm_max_ps(array[24], array[32]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[33]);
    array[33] = _mm_max_ps(array[25], array[33]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[34]);
    array[34] = _mm_max_ps(array[26], array[34]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[35]);
    array[35] = _mm_max_ps(array[27], array[35]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[28], array[36]);
    array[36] = _mm_max_ps(array[28], array[36]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[37]);
    array[37] = _mm_max_ps(array[29], array[37]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[38]);
    array[38] = _mm_max_ps(array[30], array[38]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[39]);
    array[39] = _mm_max_ps(array[31], array[39]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[40], array[48]);
    array[48] = _mm_max_ps(array[40], array[48]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[0], array[4]);
    array[4] = _mm_max_ps(array[0], array[4]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[5]);
    array[5] = _mm_max_ps(array[1], array[5]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[6]);
    array[6] = _mm_max_ps(array[2], array[6]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[7]);
    array[7] = _mm_max_ps(array[3], array[7]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[8], array[12]);
    array[12] = _mm_max_ps(array[8], array[12]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[13]);
    array[13] = _mm_max_ps(array[9], array[13]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[14]);
    array[14] = _mm_max_ps(array[10], array[14]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[15]);
    array[15] = _mm_max_ps(array[11], array[15]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[16], array[20]);
    array[20] = _mm_max_ps(array[16], array[20]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[21]);
    array[21] = _mm_max_ps(array[17], array[21]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[22]);
    array[22] = _mm_max_ps(array[18], array[22]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[23]);
    array[23] = _mm_max_ps(array[19], array[23]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[24], array[28]);
    array[28] = _mm_max_ps(array[24], array[28]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[29]);
    array[29] = _mm_max_ps(array[25], array[29]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[30]);
    array[30] = _mm_max_ps(array[26], array[30]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[31]);
    array[31] = _mm_max_ps(array[27], array[31]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[32], array[36]);
    array[36] = _mm_max_ps(array[32], array[36]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[37]);
    array[37] = _mm_max_ps(array[33], array[37]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[34], array[38]);
    array[38] = _mm_max_ps(array[34], array[38]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[39]);
    array[39] = _mm_max_ps(array[35], array[39]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[40], array[44]);
    array[44] = _mm_max_ps(array[40], array[44]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[45]);
    array[45] = _mm_max_ps(array[41], array[45]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[42], array[46]);
    array[46] = _mm_max_ps(array[42], array[46]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[47]);
    array[47] = _mm_max_ps(array[43], array[47]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[4], array[32]);
    array[32] = _mm_max_ps(array[4], array[32]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[33]);
    array[33] = _mm_max_ps(array[5], array[33]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[34]);
    array[34] = _mm_max_ps(array[6], array[34]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[35]);
    array[35] = _mm_max_ps(array[7], array[35]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[40]);
    array[40] = _mm_max_ps(array[12], array[40]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[41]);
    array[41] = _mm_max_ps(array[13], array[41]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[42]);
    array[42] = _mm_max_ps(array[14], array[42]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[43]);
    array[43] = _mm_max_ps(array[15], array[43]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[20], array[48]);
    array[48] = _mm_max_ps(array[20], array[48]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[4], array[16]);
    array[16] = _mm_max_ps(array[4], array[16]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[17]);
    array[17] = _mm_max_ps(array[5], array[17]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[18]);
    array[18] = _mm_max_ps(array[6], array[18]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[19]);
    array[19] = _mm_max_ps(array[7], array[19]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[24]);
    array[24] = _mm_max_ps(array[12], array[24]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[25]);
    array[25] = _mm_max_ps(array[13], array[25]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[26]);
    array[26] = _mm_max_ps(array[14], array[26]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[27]);
    array[27] = _mm_max_ps(array[15], array[27]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[20], array[32]);
    array[32] = _mm_max_ps(array[20], array[32]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[33]);
    array[33] = _mm_max_ps(array[21], array[33]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[34]);
    array[34] = _mm_max_ps(array[22], array[34]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[35]);
    array[35] = _mm_max_ps(array[23], array[35]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[28], array[40]);
    array[40] = _mm_max_ps(array[28], array[40]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[41]);
    array[41] = _mm_max_ps(array[29], array[41]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[42]);
    array[42] = _mm_max_ps(array[30], array[42]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[43]);
    array[43] = _mm_max_ps(array[31], array[43]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[36], array[48]);
    array[48] = _mm_max_ps(array[36], array[48]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[4], array[8]);
    array[8] = _mm_max_ps(array[4], array[8]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[9]);
    array[9] = _mm_max_ps(array[5], array[9]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[10]);
    array[10] = _mm_max_ps(array[6], array[10]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[11]);
    array[11] = _mm_max_ps(array[7], array[11]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[16]);
    array[16] = _mm_max_ps(array[12], array[16]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[17]);
    array[17] = _mm_max_ps(array[13], array[17]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[18]);
    array[18] = _mm_max_ps(array[14], array[18]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[19]);
    array[19] = _mm_max_ps(array[15], array[19]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[20], array[24]);
    array[24] = _mm_max_ps(array[20], array[24]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[25]);
    array[25] = _mm_max_ps(array[21], array[25]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[26]);
    array[26] = _mm_max_ps(array[22], array[26]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[27]);
    array[27] = _mm_max_ps(array[23], array[27]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[28], array[32]);
    array[32] = _mm_max_ps(array[28], array[32]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[33]);
    array[33] = _mm_max_ps(array[29], array[33]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[34]);
    array[34] = _mm_max_ps(array[30], array[34]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[35]);
    array[35] = _mm_max_ps(array[31], array[35]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[36], array[40]);
    array[40] = _mm_max_ps(array[36], array[40]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[41]);
    array[41] = _mm_max_ps(array[37], array[41]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[42]);
    array[42] = _mm_max_ps(array[38], array[42]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[43]);
    array[43] = _mm_max_ps(array[39], array[43]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[44], array[48]);
    array[48] = _mm_max_ps(array[44], array[48]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[0], array[2]);
    array[2] = _mm_max_ps(array[0], array[2]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[3]);
    array[3] = _mm_max_ps(array[1], array[3]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[4], array[6]);
    array[6] = _mm_max_ps(array[4], array[6]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[7]);
    array[7] = _mm_max_ps(array[5], array[7]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[8], array[10]);
    array[10] = _mm_max_ps(array[8], array[10]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[11]);
    array[11] = _mm_max_ps(array[9], array[11]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[12], array[14]);
    array[14] = _mm_max_ps(array[12], array[14]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[15]);
    array[15] = _mm_max_ps(array[13], array[15]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[16], array[18]);
    array[18] = _mm_max_ps(array[16], array[18]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[19]);
    array[19] = _mm_max_ps(array[17], array[19]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[20], array[22]);
    array[22] = _mm_max_ps(array[20], array[22]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[23]);
    array[23] = _mm_max_ps(array[21], array[23]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[24], array[26]);
    array[26] = _mm_max_ps(array[24], array[26]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[27]);
    array[27] = _mm_max_ps(array[25], array[27]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[28], array[30]);
    array[30] = _mm_max_ps(array[28], array[30]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[31]);
    array[31] = _mm_max_ps(array[29], array[31]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[32], array[34]);
    array[34] = _mm_max_ps(array[32], array[34]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[35]);
    array[35] = _mm_max_ps(array[33], array[35]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[36], array[38]);
    array[38] = _mm_max_ps(array[36], array[38]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[39]);
    array[39] = _mm_max_ps(array[37], array[39]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[40], array[42]);
    array[42] = _mm_max_ps(array[40], array[42]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[43]);
    array[43] = _mm_max_ps(array[41], array[43]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[44], array[46]);
    array[46] = _mm_max_ps(array[44], array[46]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[47]);
    array[47] = _mm_max_ps(array[45], array[47]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[2], array[32]);
    array[32] = _mm_max_ps(array[2], array[32]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[33]);
    array[33] = _mm_max_ps(array[3], array[33]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[36]);
    array[36] = _mm_max_ps(array[6], array[36]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[37]);
    array[37] = _mm_max_ps(array[7], array[37]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[40]);
    array[40] = _mm_max_ps(array[10], array[40]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[41]);
    array[41] = _mm_max_ps(array[11], array[41]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[44]);
    array[44] = _mm_max_ps(array[14], array[44]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[45]);
    array[45] = _mm_max_ps(array[15], array[45]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[48]);
    array[48] = _mm_max_ps(array[18], array[48]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[2], array[16]);
    array[16] = _mm_max_ps(array[2], array[16]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[17]);
    array[17] = _mm_max_ps(array[3], array[17]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[20]);
    array[20] = _mm_max_ps(array[6], array[20]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[21]);
    array[21] = _mm_max_ps(array[7], array[21]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[24]);
    array[24] = _mm_max_ps(array[10], array[24]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[25]);
    array[25] = _mm_max_ps(array[11], array[25]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[28]);
    array[28] = _mm_max_ps(array[14], array[28]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[29]);
    array[29] = _mm_max_ps(array[15], array[29]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[32]);
    array[32] = _mm_max_ps(array[18], array[32]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[33]);
    array[33] = _mm_max_ps(array[19], array[33]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[22], array[36]);
    array[36] = _mm_max_ps(array[22], array[36]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[37]);
    array[37] = _mm_max_ps(array[23], array[37]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[26], array[40]);
    array[40] = _mm_max_ps(array[26], array[40]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[41]);
    array[41] = _mm_max_ps(array[27], array[41]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[30], array[44]);
    array[44] = _mm_max_ps(array[30], array[44]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[45]);
    array[45] = _mm_max_ps(array[31], array[45]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[34], array[48]);
    array[48] = _mm_max_ps(array[34], array[48]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[2], array[8]);
    array[8] = _mm_max_ps(array[2], array[8]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[9]);
    array[9] = _mm_max_ps(array[3], array[9]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[12]);
    array[12] = _mm_max_ps(array[6], array[12]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[13]);
    array[13] = _mm_max_ps(array[7], array[13]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[16]);
    array[16] = _mm_max_ps(array[10], array[16]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[17]);
    array[17] = _mm_max_ps(array[11], array[17]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[20]);
    array[20] = _mm_max_ps(array[14], array[20]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[21]);
    array[21] = _mm_max_ps(array[15], array[21]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[24]);
    array[24] = _mm_max_ps(array[18], array[24]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[25]);
    array[25] = _mm_max_ps(array[19], array[25]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[22], array[28]);
    array[28] = _mm_max_ps(array[22], array[28]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[29]);
    array[29] = _mm_max_ps(array[23], array[29]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[26], array[32]);
    array[32] = _mm_max_ps(array[26], array[32]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[33]);
    array[33] = _mm_max_ps(array[27], array[33]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[30], array[36]);
    array[36] = _mm_max_ps(array[30], array[36]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[37]);
    array[37] = _mm_max_ps(array[31], array[37]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[34], array[40]);
    array[40] = _mm_max_ps(array[34], array[40]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[41]);
    array[41] = _mm_max_ps(array[35], array[41]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[38], array[44]);
    array[44] = _mm_max_ps(array[38], array[44]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[45]);
    array[45] = _mm_max_ps(array[39], array[45]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[42], array[48]);
    array[48] = _mm_max_ps(array[42], array[48]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[2], array[4]);
    array[4] = _mm_max_ps(array[2], array[4]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[5]);
    array[5] = _mm_max_ps(array[3], array[5]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[8]);
    array[8] = _mm_max_ps(array[6], array[8]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[9]);
    array[9] = _mm_max_ps(array[7], array[9]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[12]);
    array[12] = _mm_max_ps(array[10], array[12]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[13]);
    array[13] = _mm_max_ps(array[11], array[13]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[16]);
    array[16] = _mm_max_ps(array[14], array[16]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[17]);
    array[17] = _mm_max_ps(array[15], array[17]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[20]);
    array[20] = _mm_max_ps(array[18], array[20]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[21]);
    array[21] = _mm_max_ps(array[19], array[21]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[22], array[24]);
    array[24] = _mm_max_ps(array[22], array[24]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[25]);
    array[25] = _mm_max_ps(array[23], array[25]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[26], array[28]);
    array[28] = _mm_max_ps(array[26], array[28]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[29]);
    array[29] = _mm_max_ps(array[27], array[29]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[30], array[32]);
    array[32] = _mm_max_ps(array[30], array[32]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[33]);
    array[33] = _mm_max_ps(array[31], array[33]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[34], array[36]);
    array[36] = _mm_max_ps(array[34], array[36]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[37]);
    array[37] = _mm_max_ps(array[35], array[37]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[38], array[40]);
    array[40] = _mm_max_ps(array[38], array[40]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[41]);
    array[41] = _mm_max_ps(array[39], array[41]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[42], array[44]);
    array[44] = _mm_max_ps(array[42], array[44]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[45]);
    array[45] = _mm_max_ps(array[43], array[45]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[46], array[48]);
    array[48] = _mm_max_ps(array[46], array[48]);
    array[46] = tmp;
    array[1] = _mm_max_ps(array[0], array[1]);
    array[3] = _mm_max_ps(array[2], array[3]);
    array[5] = _mm_max_ps(array[4], array[5]);
    array[7] = _mm_max_ps(array[6], array[7]);
    array[9] = _mm_max_ps(array[8], array[9]);
    array[11] = _mm_max_ps(array[10], array[11]);
    array[13] = _mm_max_ps(array[12], array[13]);
    array[15] = _mm_max_ps(array[14], array[15]);
    array[17] = _mm_max_ps(array[16], array[17]);
    array[19] = _mm_max_ps(array[18], array[19]);
    array[21] = _mm_max_ps(array[20], array[21]);
    array[23] = _mm_max_ps(array[22], array[23]);
    array[24] = _mm_min_ps(array[24], array[25]);
    array[26] = _mm_min_ps(array[26], array[27]);
    array[28] = _mm_min_ps(array[28], array[29]);
    array[30] = _mm_min_ps(array[30], array[31]);
    array[32] = _mm_min_ps(array[32], array[33]);
    array[34] = _mm_min_ps(array[34], array[35]);
    array[36] = _mm_min_ps(array[36], array[37]);
    array[38] = _mm_min_ps(array[38], array[39]);
    array[40] = _mm_min_ps(array[40], array[41]);
    array[42] = _mm_min_ps(array[42], array[43]);
    array[44] = _mm_min_ps(array[44], array[45]);
    array[46] = _mm_min_ps(array[46], array[47]);
    array[32] = _mm_max_ps(array[1], array[32]);
    array[34] = _mm_max_ps(array[3], array[34]);
    array[36] = _mm_max_ps(array[5], array[36]);
    array[38] = _mm_max_ps(array[7], array[38]);
    array[9] = _mm_min_ps(array[9], array[40]);
    array[11] = _mm_min_ps(array[11], array[42]);
    array[13] = _mm_min_ps(array[13], array[44]);
    array[15] = _mm_min_ps(array[15], array[46]);
    array[17] = _mm_min_ps(array[17], array[48]);
    array[24] = _mm_max_ps(array[9], array[24]);
    array[26] = _mm_max_ps(array[11], array[26]);
    array[28] = _mm_max_ps(array[13], array[28]);
    array[30] = _mm_max_ps(array[15], array[30]);
    array[17] = _mm_min_ps(array[17], array[32]);
    array[19] = _mm_min_ps(array[19], array[34]);
    array[21] = _mm_min_ps(array[21], array[36]);
    array[23] = _mm_min_ps(array[23], array[38]);
    array[24] = _mm_max_ps(array[17], array[24]);
    array[26] = _mm_max_ps(array[19], array[26]);
    array[21] = _mm_min_ps(array[21], array[28]);
    array[23] = _mm_min_ps(array[23], array[30]);
    array[24] = _mm_max_ps(array[21], array[24]);
    array[23] = _mm_min_ps(array[23], array[26]);
    return _mm_max_ps(array[23], array[24]);
}

__m128 median9x9sse(__m128* array)
{
    __m128 tmp = _mm_min_ps(array[0], array[64]);
    array[64] = _mm_max_ps(array[0], array[64]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[65]);
    array[65] = _mm_max_ps(array[1], array[65]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[66]);
    array[66] = _mm_max_ps(array[2], array[66]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[67]);
    array[67] = _mm_max_ps(array[3], array[67]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[4], array[68]);
    array[68] = _mm_max_ps(array[4], array[68]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[69]);
    array[69] = _mm_max_ps(array[5], array[69]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[70]);
    array[70] = _mm_max_ps(array[6], array[70]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[71]);
    array[71] = _mm_max_ps(array[7], array[71]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[8], array[72]);
    array[72] = _mm_max_ps(array[8], array[72]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[73]);
    array[73] = _mm_max_ps(array[9], array[73]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[74]);
    array[74] = _mm_max_ps(array[10], array[74]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[75]);
    array[75] = _mm_max_ps(array[11], array[75]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[76]);
    array[76] = _mm_max_ps(array[12], array[76]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[77]);
    array[77] = _mm_max_ps(array[13], array[77]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[78]);
    array[78] = _mm_max_ps(array[14], array[78]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[79]);
    array[79] = _mm_max_ps(array[15], array[79]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[16], array[80]);
    array[80] = _mm_max_ps(array[16], array[80]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[0], array[32]);
    array[32] = _mm_max_ps(array[0], array[32]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[33]);
    array[33] = _mm_max_ps(array[1], array[33]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[34]);
    array[34] = _mm_max_ps(array[2], array[34]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[35]);
    array[35] = _mm_max_ps(array[3], array[35]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[4], array[36]);
    array[36] = _mm_max_ps(array[4], array[36]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[37]);
    array[37] = _mm_max_ps(array[5], array[37]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[38]);
    array[38] = _mm_max_ps(array[6], array[38]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[39]);
    array[39] = _mm_max_ps(array[7], array[39]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[8], array[40]);
    array[40] = _mm_max_ps(array[8], array[40]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[41]);
    array[41] = _mm_max_ps(array[9], array[41]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[42]);
    array[42] = _mm_max_ps(array[10], array[42]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[43]);
    array[43] = _mm_max_ps(array[11], array[43]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[44]);
    array[44] = _mm_max_ps(array[12], array[44]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[45]);
    array[45] = _mm_max_ps(array[13], array[45]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[46]);
    array[46] = _mm_max_ps(array[14], array[46]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[47]);
    array[47] = _mm_max_ps(array[15], array[47]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[16], array[48]);
    array[48] = _mm_max_ps(array[16], array[48]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[49]);
    array[49] = _mm_max_ps(array[17], array[49]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[50]);
    array[50] = _mm_max_ps(array[18], array[50]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[51]);
    array[51] = _mm_max_ps(array[19], array[51]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[20], array[52]);
    array[52] = _mm_max_ps(array[20], array[52]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[53]);
    array[53] = _mm_max_ps(array[21], array[53]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[54]);
    array[54] = _mm_max_ps(array[22], array[54]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[55]);
    array[55] = _mm_max_ps(array[23], array[55]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[24], array[56]);
    array[56] = _mm_max_ps(array[24], array[56]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[57]);
    array[57] = _mm_max_ps(array[25], array[57]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[58]);
    array[58] = _mm_max_ps(array[26], array[58]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[59]);
    array[59] = _mm_max_ps(array[27], array[59]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[28], array[60]);
    array[60] = _mm_max_ps(array[28], array[60]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[61]);
    array[61] = _mm_max_ps(array[29], array[61]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[62]);
    array[62] = _mm_max_ps(array[30], array[62]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[63]);
    array[63] = _mm_max_ps(array[31], array[63]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[32], array[64]);
    array[64] = _mm_max_ps(array[32], array[64]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[65]);
    array[65] = _mm_max_ps(array[33], array[65]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[34], array[66]);
    array[66] = _mm_max_ps(array[34], array[66]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[67]);
    array[67] = _mm_max_ps(array[35], array[67]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[36], array[68]);
    array[68] = _mm_max_ps(array[36], array[68]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[69]);
    array[69] = _mm_max_ps(array[37], array[69]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[70]);
    array[70] = _mm_max_ps(array[38], array[70]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[71]);
    array[71] = _mm_max_ps(array[39], array[71]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[40], array[72]);
    array[72] = _mm_max_ps(array[40], array[72]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[73]);
    array[73] = _mm_max_ps(array[41], array[73]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[42], array[74]);
    array[74] = _mm_max_ps(array[42], array[74]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[75]);
    array[75] = _mm_max_ps(array[43], array[75]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[44], array[76]);
    array[76] = _mm_max_ps(array[44], array[76]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[77]);
    array[77] = _mm_max_ps(array[45], array[77]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[46], array[78]);
    array[78] = _mm_max_ps(array[46], array[78]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[79]);
    array[79] = _mm_max_ps(array[47], array[79]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[48], array[80]);
    array[80] = _mm_max_ps(array[48], array[80]);
    array[48] = tmp;
    tmp = _mm_min_ps(array[0], array[16]);
    array[16] = _mm_max_ps(array[0], array[16]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[17]);
    array[17] = _mm_max_ps(array[1], array[17]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[18]);
    array[18] = _mm_max_ps(array[2], array[18]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[19]);
    array[19] = _mm_max_ps(array[3], array[19]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[4], array[20]);
    array[20] = _mm_max_ps(array[4], array[20]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[21]);
    array[21] = _mm_max_ps(array[5], array[21]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[22]);
    array[22] = _mm_max_ps(array[6], array[22]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[23]);
    array[23] = _mm_max_ps(array[7], array[23]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[8], array[24]);
    array[24] = _mm_max_ps(array[8], array[24]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[25]);
    array[25] = _mm_max_ps(array[9], array[25]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[26]);
    array[26] = _mm_max_ps(array[10], array[26]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[27]);
    array[27] = _mm_max_ps(array[11], array[27]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[28]);
    array[28] = _mm_max_ps(array[12], array[28]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[29]);
    array[29] = _mm_max_ps(array[13], array[29]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[30]);
    array[30] = _mm_max_ps(array[14], array[30]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[31]);
    array[31] = _mm_max_ps(array[15], array[31]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[32], array[48]);
    array[48] = _mm_max_ps(array[32], array[48]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[49]);
    array[49] = _mm_max_ps(array[33], array[49]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[34], array[50]);
    array[50] = _mm_max_ps(array[34], array[50]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[51]);
    array[51] = _mm_max_ps(array[35], array[51]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[36], array[52]);
    array[52] = _mm_max_ps(array[36], array[52]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[53]);
    array[53] = _mm_max_ps(array[37], array[53]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[54]);
    array[54] = _mm_max_ps(array[38], array[54]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[55]);
    array[55] = _mm_max_ps(array[39], array[55]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[40], array[56]);
    array[56] = _mm_max_ps(array[40], array[56]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[57]);
    array[57] = _mm_max_ps(array[41], array[57]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[42], array[58]);
    array[58] = _mm_max_ps(array[42], array[58]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[59]);
    array[59] = _mm_max_ps(array[43], array[59]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[44], array[60]);
    array[60] = _mm_max_ps(array[44], array[60]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[61]);
    array[61] = _mm_max_ps(array[45], array[61]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[46], array[62]);
    array[62] = _mm_max_ps(array[46], array[62]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[63]);
    array[63] = _mm_max_ps(array[47], array[63]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[64], array[80]);
    array[80] = _mm_max_ps(array[64], array[80]);
    array[64] = tmp;
    tmp = _mm_min_ps(array[16], array[64]);
    array[64] = _mm_max_ps(array[16], array[64]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[65]);
    array[65] = _mm_max_ps(array[17], array[65]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[66]);
    array[66] = _mm_max_ps(array[18], array[66]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[67]);
    array[67] = _mm_max_ps(array[19], array[67]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[20], array[68]);
    array[68] = _mm_max_ps(array[20], array[68]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[69]);
    array[69] = _mm_max_ps(array[21], array[69]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[70]);
    array[70] = _mm_max_ps(array[22], array[70]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[71]);
    array[71] = _mm_max_ps(array[23], array[71]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[24], array[72]);
    array[72] = _mm_max_ps(array[24], array[72]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[73]);
    array[73] = _mm_max_ps(array[25], array[73]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[74]);
    array[74] = _mm_max_ps(array[26], array[74]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[75]);
    array[75] = _mm_max_ps(array[27], array[75]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[28], array[76]);
    array[76] = _mm_max_ps(array[28], array[76]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[77]);
    array[77] = _mm_max_ps(array[29], array[77]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[78]);
    array[78] = _mm_max_ps(array[30], array[78]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[79]);
    array[79] = _mm_max_ps(array[31], array[79]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[16], array[32]);
    array[32] = _mm_max_ps(array[16], array[32]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[33]);
    array[33] = _mm_max_ps(array[17], array[33]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[34]);
    array[34] = _mm_max_ps(array[18], array[34]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[35]);
    array[35] = _mm_max_ps(array[19], array[35]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[20], array[36]);
    array[36] = _mm_max_ps(array[20], array[36]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[37]);
    array[37] = _mm_max_ps(array[21], array[37]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[38]);
    array[38] = _mm_max_ps(array[22], array[38]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[39]);
    array[39] = _mm_max_ps(array[23], array[39]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[24], array[40]);
    array[40] = _mm_max_ps(array[24], array[40]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[41]);
    array[41] = _mm_max_ps(array[25], array[41]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[42]);
    array[42] = _mm_max_ps(array[26], array[42]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[43]);
    array[43] = _mm_max_ps(array[27], array[43]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[28], array[44]);
    array[44] = _mm_max_ps(array[28], array[44]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[45]);
    array[45] = _mm_max_ps(array[29], array[45]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[46]);
    array[46] = _mm_max_ps(array[30], array[46]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[47]);
    array[47] = _mm_max_ps(array[31], array[47]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[48], array[64]);
    array[64] = _mm_max_ps(array[48], array[64]);
    array[48] = tmp;
    tmp = _mm_min_ps(array[49], array[65]);
    array[65] = _mm_max_ps(array[49], array[65]);
    array[49] = tmp;
    tmp = _mm_min_ps(array[50], array[66]);
    array[66] = _mm_max_ps(array[50], array[66]);
    array[50] = tmp;
    tmp = _mm_min_ps(array[51], array[67]);
    array[67] = _mm_max_ps(array[51], array[67]);
    array[51] = tmp;
    tmp = _mm_min_ps(array[52], array[68]);
    array[68] = _mm_max_ps(array[52], array[68]);
    array[52] = tmp;
    tmp = _mm_min_ps(array[53], array[69]);
    array[69] = _mm_max_ps(array[53], array[69]);
    array[53] = tmp;
    tmp = _mm_min_ps(array[54], array[70]);
    array[70] = _mm_max_ps(array[54], array[70]);
    array[54] = tmp;
    tmp = _mm_min_ps(array[55], array[71]);
    array[71] = _mm_max_ps(array[55], array[71]);
    array[55] = tmp;
    tmp = _mm_min_ps(array[56], array[72]);
    array[72] = _mm_max_ps(array[56], array[72]);
    array[56] = tmp;
    tmp = _mm_min_ps(array[57], array[73]);
    array[73] = _mm_max_ps(array[57], array[73]);
    array[57] = tmp;
    tmp = _mm_min_ps(array[58], array[74]);
    array[74] = _mm_max_ps(array[58], array[74]);
    array[58] = tmp;
    tmp = _mm_min_ps(array[59], array[75]);
    array[75] = _mm_max_ps(array[59], array[75]);
    array[59] = tmp;
    tmp = _mm_min_ps(array[60], array[76]);
    array[76] = _mm_max_ps(array[60], array[76]);
    array[60] = tmp;
    tmp = _mm_min_ps(array[61], array[77]);
    array[77] = _mm_max_ps(array[61], array[77]);
    array[61] = tmp;
    tmp = _mm_min_ps(array[62], array[78]);
    array[78] = _mm_max_ps(array[62], array[78]);
    array[62] = tmp;
    tmp = _mm_min_ps(array[63], array[79]);
    array[79] = _mm_max_ps(array[63], array[79]);
    array[63] = tmp;
    tmp = _mm_min_ps(array[0], array[8]);
    array[8] = _mm_max_ps(array[0], array[8]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[9]);
    array[9] = _mm_max_ps(array[1], array[9]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[10]);
    array[10] = _mm_max_ps(array[2], array[10]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[11]);
    array[11] = _mm_max_ps(array[3], array[11]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[4], array[12]);
    array[12] = _mm_max_ps(array[4], array[12]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[13]);
    array[13] = _mm_max_ps(array[5], array[13]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[14]);
    array[14] = _mm_max_ps(array[6], array[14]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[15]);
    array[15] = _mm_max_ps(array[7], array[15]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[16], array[24]);
    array[24] = _mm_max_ps(array[16], array[24]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[25]);
    array[25] = _mm_max_ps(array[17], array[25]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[26]);
    array[26] = _mm_max_ps(array[18], array[26]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[27]);
    array[27] = _mm_max_ps(array[19], array[27]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[20], array[28]);
    array[28] = _mm_max_ps(array[20], array[28]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[29]);
    array[29] = _mm_max_ps(array[21], array[29]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[30]);
    array[30] = _mm_max_ps(array[22], array[30]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[31]);
    array[31] = _mm_max_ps(array[23], array[31]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[32], array[40]);
    array[40] = _mm_max_ps(array[32], array[40]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[41]);
    array[41] = _mm_max_ps(array[33], array[41]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[34], array[42]);
    array[42] = _mm_max_ps(array[34], array[42]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[43]);
    array[43] = _mm_max_ps(array[35], array[43]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[36], array[44]);
    array[44] = _mm_max_ps(array[36], array[44]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[45]);
    array[45] = _mm_max_ps(array[37], array[45]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[46]);
    array[46] = _mm_max_ps(array[38], array[46]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[47]);
    array[47] = _mm_max_ps(array[39], array[47]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[48], array[56]);
    array[56] = _mm_max_ps(array[48], array[56]);
    array[48] = tmp;
    tmp = _mm_min_ps(array[49], array[57]);
    array[57] = _mm_max_ps(array[49], array[57]);
    array[49] = tmp;
    tmp = _mm_min_ps(array[50], array[58]);
    array[58] = _mm_max_ps(array[50], array[58]);
    array[50] = tmp;
    tmp = _mm_min_ps(array[51], array[59]);
    array[59] = _mm_max_ps(array[51], array[59]);
    array[51] = tmp;
    tmp = _mm_min_ps(array[52], array[60]);
    array[60] = _mm_max_ps(array[52], array[60]);
    array[52] = tmp;
    tmp = _mm_min_ps(array[53], array[61]);
    array[61] = _mm_max_ps(array[53], array[61]);
    array[53] = tmp;
    tmp = _mm_min_ps(array[54], array[62]);
    array[62] = _mm_max_ps(array[54], array[62]);
    array[54] = tmp;
    tmp = _mm_min_ps(array[55], array[63]);
    array[63] = _mm_max_ps(array[55], array[63]);
    array[55] = tmp;
    tmp = _mm_min_ps(array[64], array[72]);
    array[72] = _mm_max_ps(array[64], array[72]);
    array[64] = tmp;
    tmp = _mm_min_ps(array[65], array[73]);
    array[73] = _mm_max_ps(array[65], array[73]);
    array[65] = tmp;
    tmp = _mm_min_ps(array[66], array[74]);
    array[74] = _mm_max_ps(array[66], array[74]);
    array[66] = tmp;
    tmp = _mm_min_ps(array[67], array[75]);
    array[75] = _mm_max_ps(array[67], array[75]);
    array[67] = tmp;
    tmp = _mm_min_ps(array[68], array[76]);
    array[76] = _mm_max_ps(array[68], array[76]);
    array[68] = tmp;
    tmp = _mm_min_ps(array[69], array[77]);
    array[77] = _mm_max_ps(array[69], array[77]);
    array[69] = tmp;
    tmp = _mm_min_ps(array[70], array[78]);
    array[78] = _mm_max_ps(array[70], array[78]);
    array[70] = tmp;
    tmp = _mm_min_ps(array[71], array[79]);
    array[79] = _mm_max_ps(array[71], array[79]);
    array[71] = tmp;
    tmp = _mm_min_ps(array[8], array[64]);
    array[64] = _mm_max_ps(array[8], array[64]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[65]);
    array[65] = _mm_max_ps(array[9], array[65]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[66]);
    array[66] = _mm_max_ps(array[10], array[66]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[67]);
    array[67] = _mm_max_ps(array[11], array[67]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[68]);
    array[68] = _mm_max_ps(array[12], array[68]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[69]);
    array[69] = _mm_max_ps(array[13], array[69]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[70]);
    array[70] = _mm_max_ps(array[14], array[70]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[71]);
    array[71] = _mm_max_ps(array[15], array[71]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[24], array[80]);
    array[80] = _mm_max_ps(array[24], array[80]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[8], array[32]);
    array[32] = _mm_max_ps(array[8], array[32]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[33]);
    array[33] = _mm_max_ps(array[9], array[33]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[34]);
    array[34] = _mm_max_ps(array[10], array[34]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[35]);
    array[35] = _mm_max_ps(array[11], array[35]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[36]);
    array[36] = _mm_max_ps(array[12], array[36]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[37]);
    array[37] = _mm_max_ps(array[13], array[37]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[38]);
    array[38] = _mm_max_ps(array[14], array[38]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[39]);
    array[39] = _mm_max_ps(array[15], array[39]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[24], array[48]);
    array[48] = _mm_max_ps(array[24], array[48]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[49]);
    array[49] = _mm_max_ps(array[25], array[49]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[50]);
    array[50] = _mm_max_ps(array[26], array[50]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[51]);
    array[51] = _mm_max_ps(array[27], array[51]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[28], array[52]);
    array[52] = _mm_max_ps(array[28], array[52]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[53]);
    array[53] = _mm_max_ps(array[29], array[53]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[54]);
    array[54] = _mm_max_ps(array[30], array[54]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[55]);
    array[55] = _mm_max_ps(array[31], array[55]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[40], array[64]);
    array[64] = _mm_max_ps(array[40], array[64]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[65]);
    array[65] = _mm_max_ps(array[41], array[65]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[42], array[66]);
    array[66] = _mm_max_ps(array[42], array[66]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[67]);
    array[67] = _mm_max_ps(array[43], array[67]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[44], array[68]);
    array[68] = _mm_max_ps(array[44], array[68]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[69]);
    array[69] = _mm_max_ps(array[45], array[69]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[46], array[70]);
    array[70] = _mm_max_ps(array[46], array[70]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[71]);
    array[71] = _mm_max_ps(array[47], array[71]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[56], array[80]);
    array[80] = _mm_max_ps(array[56], array[80]);
    array[56] = tmp;
    tmp = _mm_min_ps(array[8], array[16]);
    array[16] = _mm_max_ps(array[8], array[16]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[17]);
    array[17] = _mm_max_ps(array[9], array[17]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[18]);
    array[18] = _mm_max_ps(array[10], array[18]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[19]);
    array[19] = _mm_max_ps(array[11], array[19]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[12], array[20]);
    array[20] = _mm_max_ps(array[12], array[20]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[21]);
    array[21] = _mm_max_ps(array[13], array[21]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[22]);
    array[22] = _mm_max_ps(array[14], array[22]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[23]);
    array[23] = _mm_max_ps(array[15], array[23]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[24], array[32]);
    array[32] = _mm_max_ps(array[24], array[32]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[33]);
    array[33] = _mm_max_ps(array[25], array[33]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[34]);
    array[34] = _mm_max_ps(array[26], array[34]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[35]);
    array[35] = _mm_max_ps(array[27], array[35]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[28], array[36]);
    array[36] = _mm_max_ps(array[28], array[36]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[37]);
    array[37] = _mm_max_ps(array[29], array[37]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[38]);
    array[38] = _mm_max_ps(array[30], array[38]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[39]);
    array[39] = _mm_max_ps(array[31], array[39]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[40], array[48]);
    array[48] = _mm_max_ps(array[40], array[48]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[49]);
    array[49] = _mm_max_ps(array[41], array[49]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[42], array[50]);
    array[50] = _mm_max_ps(array[42], array[50]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[51]);
    array[51] = _mm_max_ps(array[43], array[51]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[44], array[52]);
    array[52] = _mm_max_ps(array[44], array[52]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[53]);
    array[53] = _mm_max_ps(array[45], array[53]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[46], array[54]);
    array[54] = _mm_max_ps(array[46], array[54]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[55]);
    array[55] = _mm_max_ps(array[47], array[55]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[56], array[64]);
    array[64] = _mm_max_ps(array[56], array[64]);
    array[56] = tmp;
    tmp = _mm_min_ps(array[57], array[65]);
    array[65] = _mm_max_ps(array[57], array[65]);
    array[57] = tmp;
    tmp = _mm_min_ps(array[58], array[66]);
    array[66] = _mm_max_ps(array[58], array[66]);
    array[58] = tmp;
    tmp = _mm_min_ps(array[59], array[67]);
    array[67] = _mm_max_ps(array[59], array[67]);
    array[59] = tmp;
    tmp = _mm_min_ps(array[60], array[68]);
    array[68] = _mm_max_ps(array[60], array[68]);
    array[60] = tmp;
    tmp = _mm_min_ps(array[61], array[69]);
    array[69] = _mm_max_ps(array[61], array[69]);
    array[61] = tmp;
    tmp = _mm_min_ps(array[62], array[70]);
    array[70] = _mm_max_ps(array[62], array[70]);
    array[62] = tmp;
    tmp = _mm_min_ps(array[63], array[71]);
    array[71] = _mm_max_ps(array[63], array[71]);
    array[63] = tmp;
    tmp = _mm_min_ps(array[72], array[80]);
    array[80] = _mm_max_ps(array[72], array[80]);
    array[72] = tmp;
    tmp = _mm_min_ps(array[0], array[4]);
    array[4] = _mm_max_ps(array[0], array[4]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[5]);
    array[5] = _mm_max_ps(array[1], array[5]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[2], array[6]);
    array[6] = _mm_max_ps(array[2], array[6]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[7]);
    array[7] = _mm_max_ps(array[3], array[7]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[8], array[12]);
    array[12] = _mm_max_ps(array[8], array[12]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[13]);
    array[13] = _mm_max_ps(array[9], array[13]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[10], array[14]);
    array[14] = _mm_max_ps(array[10], array[14]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[15]);
    array[15] = _mm_max_ps(array[11], array[15]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[16], array[20]);
    array[20] = _mm_max_ps(array[16], array[20]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[21]);
    array[21] = _mm_max_ps(array[17], array[21]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[18], array[22]);
    array[22] = _mm_max_ps(array[18], array[22]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[23]);
    array[23] = _mm_max_ps(array[19], array[23]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[24], array[28]);
    array[28] = _mm_max_ps(array[24], array[28]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[29]);
    array[29] = _mm_max_ps(array[25], array[29]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[26], array[30]);
    array[30] = _mm_max_ps(array[26], array[30]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[31]);
    array[31] = _mm_max_ps(array[27], array[31]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[32], array[36]);
    array[36] = _mm_max_ps(array[32], array[36]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[37]);
    array[37] = _mm_max_ps(array[33], array[37]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[34], array[38]);
    array[38] = _mm_max_ps(array[34], array[38]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[39]);
    array[39] = _mm_max_ps(array[35], array[39]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[40], array[44]);
    array[44] = _mm_max_ps(array[40], array[44]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[45]);
    array[45] = _mm_max_ps(array[41], array[45]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[42], array[46]);
    array[46] = _mm_max_ps(array[42], array[46]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[47]);
    array[47] = _mm_max_ps(array[43], array[47]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[48], array[52]);
    array[52] = _mm_max_ps(array[48], array[52]);
    array[48] = tmp;
    tmp = _mm_min_ps(array[49], array[53]);
    array[53] = _mm_max_ps(array[49], array[53]);
    array[49] = tmp;
    tmp = _mm_min_ps(array[50], array[54]);
    array[54] = _mm_max_ps(array[50], array[54]);
    array[50] = tmp;
    tmp = _mm_min_ps(array[51], array[55]);
    array[55] = _mm_max_ps(array[51], array[55]);
    array[51] = tmp;
    tmp = _mm_min_ps(array[56], array[60]);
    array[60] = _mm_max_ps(array[56], array[60]);
    array[56] = tmp;
    tmp = _mm_min_ps(array[57], array[61]);
    array[61] = _mm_max_ps(array[57], array[61]);
    array[57] = tmp;
    tmp = _mm_min_ps(array[58], array[62]);
    array[62] = _mm_max_ps(array[58], array[62]);
    array[58] = tmp;
    tmp = _mm_min_ps(array[59], array[63]);
    array[63] = _mm_max_ps(array[59], array[63]);
    array[59] = tmp;
    tmp = _mm_min_ps(array[64], array[68]);
    array[68] = _mm_max_ps(array[64], array[68]);
    array[64] = tmp;
    tmp = _mm_min_ps(array[65], array[69]);
    array[69] = _mm_max_ps(array[65], array[69]);
    array[65] = tmp;
    tmp = _mm_min_ps(array[66], array[70]);
    array[70] = _mm_max_ps(array[66], array[70]);
    array[66] = tmp;
    tmp = _mm_min_ps(array[67], array[71]);
    array[71] = _mm_max_ps(array[67], array[71]);
    array[67] = tmp;
    tmp = _mm_min_ps(array[72], array[76]);
    array[76] = _mm_max_ps(array[72], array[76]);
    array[72] = tmp;
    tmp = _mm_min_ps(array[73], array[77]);
    array[77] = _mm_max_ps(array[73], array[77]);
    array[73] = tmp;
    tmp = _mm_min_ps(array[74], array[78]);
    array[78] = _mm_max_ps(array[74], array[78]);
    array[74] = tmp;
    tmp = _mm_min_ps(array[75], array[79]);
    array[79] = _mm_max_ps(array[75], array[79]);
    array[75] = tmp;
    tmp = _mm_min_ps(array[4], array[64]);
    array[64] = _mm_max_ps(array[4], array[64]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[65]);
    array[65] = _mm_max_ps(array[5], array[65]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[66]);
    array[66] = _mm_max_ps(array[6], array[66]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[67]);
    array[67] = _mm_max_ps(array[7], array[67]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[72]);
    array[72] = _mm_max_ps(array[12], array[72]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[73]);
    array[73] = _mm_max_ps(array[13], array[73]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[74]);
    array[74] = _mm_max_ps(array[14], array[74]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[75]);
    array[75] = _mm_max_ps(array[15], array[75]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[20], array[80]);
    array[80] = _mm_max_ps(array[20], array[80]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[4], array[32]);
    array[32] = _mm_max_ps(array[4], array[32]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[33]);
    array[33] = _mm_max_ps(array[5], array[33]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[34]);
    array[34] = _mm_max_ps(array[6], array[34]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[35]);
    array[35] = _mm_max_ps(array[7], array[35]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[40]);
    array[40] = _mm_max_ps(array[12], array[40]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[41]);
    array[41] = _mm_max_ps(array[13], array[41]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[42]);
    array[42] = _mm_max_ps(array[14], array[42]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[43]);
    array[43] = _mm_max_ps(array[15], array[43]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[20], array[48]);
    array[48] = _mm_max_ps(array[20], array[48]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[49]);
    array[49] = _mm_max_ps(array[21], array[49]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[50]);
    array[50] = _mm_max_ps(array[22], array[50]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[51]);
    array[51] = _mm_max_ps(array[23], array[51]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[28], array[56]);
    array[56] = _mm_max_ps(array[28], array[56]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[57]);
    array[57] = _mm_max_ps(array[29], array[57]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[58]);
    array[58] = _mm_max_ps(array[30], array[58]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[59]);
    array[59] = _mm_max_ps(array[31], array[59]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[36], array[64]);
    array[64] = _mm_max_ps(array[36], array[64]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[65]);
    array[65] = _mm_max_ps(array[37], array[65]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[66]);
    array[66] = _mm_max_ps(array[38], array[66]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[67]);
    array[67] = _mm_max_ps(array[39], array[67]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[44], array[72]);
    array[72] = _mm_max_ps(array[44], array[72]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[73]);
    array[73] = _mm_max_ps(array[45], array[73]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[46], array[74]);
    array[74] = _mm_max_ps(array[46], array[74]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[75]);
    array[75] = _mm_max_ps(array[47], array[75]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[52], array[80]);
    array[80] = _mm_max_ps(array[52], array[80]);
    array[52] = tmp;
    tmp = _mm_min_ps(array[4], array[16]);
    array[16] = _mm_max_ps(array[4], array[16]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[17]);
    array[17] = _mm_max_ps(array[5], array[17]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[18]);
    array[18] = _mm_max_ps(array[6], array[18]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[19]);
    array[19] = _mm_max_ps(array[7], array[19]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[24]);
    array[24] = _mm_max_ps(array[12], array[24]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[25]);
    array[25] = _mm_max_ps(array[13], array[25]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[26]);
    array[26] = _mm_max_ps(array[14], array[26]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[27]);
    array[27] = _mm_max_ps(array[15], array[27]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[20], array[32]);
    array[32] = _mm_max_ps(array[20], array[32]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[33]);
    array[33] = _mm_max_ps(array[21], array[33]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[34]);
    array[34] = _mm_max_ps(array[22], array[34]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[35]);
    array[35] = _mm_max_ps(array[23], array[35]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[28], array[40]);
    array[40] = _mm_max_ps(array[28], array[40]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[41]);
    array[41] = _mm_max_ps(array[29], array[41]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[42]);
    array[42] = _mm_max_ps(array[30], array[42]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[43]);
    array[43] = _mm_max_ps(array[31], array[43]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[36], array[48]);
    array[48] = _mm_max_ps(array[36], array[48]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[49]);
    array[49] = _mm_max_ps(array[37], array[49]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[50]);
    array[50] = _mm_max_ps(array[38], array[50]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[51]);
    array[51] = _mm_max_ps(array[39], array[51]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[44], array[56]);
    array[56] = _mm_max_ps(array[44], array[56]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[57]);
    array[57] = _mm_max_ps(array[45], array[57]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[46], array[58]);
    array[58] = _mm_max_ps(array[46], array[58]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[59]);
    array[59] = _mm_max_ps(array[47], array[59]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[52], array[64]);
    array[64] = _mm_max_ps(array[52], array[64]);
    array[52] = tmp;
    tmp = _mm_min_ps(array[53], array[65]);
    array[65] = _mm_max_ps(array[53], array[65]);
    array[53] = tmp;
    tmp = _mm_min_ps(array[54], array[66]);
    array[66] = _mm_max_ps(array[54], array[66]);
    array[54] = tmp;
    tmp = _mm_min_ps(array[55], array[67]);
    array[67] = _mm_max_ps(array[55], array[67]);
    array[55] = tmp;
    tmp = _mm_min_ps(array[60], array[72]);
    array[72] = _mm_max_ps(array[60], array[72]);
    array[60] = tmp;
    tmp = _mm_min_ps(array[61], array[73]);
    array[73] = _mm_max_ps(array[61], array[73]);
    array[61] = tmp;
    tmp = _mm_min_ps(array[62], array[74]);
    array[74] = _mm_max_ps(array[62], array[74]);
    array[62] = tmp;
    tmp = _mm_min_ps(array[63], array[75]);
    array[75] = _mm_max_ps(array[63], array[75]);
    array[63] = tmp;
    tmp = _mm_min_ps(array[68], array[80]);
    array[80] = _mm_max_ps(array[68], array[80]);
    array[68] = tmp;
    tmp = _mm_min_ps(array[4], array[8]);
    array[8] = _mm_max_ps(array[4], array[8]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[9]);
    array[9] = _mm_max_ps(array[5], array[9]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[6], array[10]);
    array[10] = _mm_max_ps(array[6], array[10]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[11]);
    array[11] = _mm_max_ps(array[7], array[11]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[12], array[16]);
    array[16] = _mm_max_ps(array[12], array[16]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[17]);
    array[17] = _mm_max_ps(array[13], array[17]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[14], array[18]);
    array[18] = _mm_max_ps(array[14], array[18]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[19]);
    array[19] = _mm_max_ps(array[15], array[19]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[20], array[24]);
    array[24] = _mm_max_ps(array[20], array[24]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[25]);
    array[25] = _mm_max_ps(array[21], array[25]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[22], array[26]);
    array[26] = _mm_max_ps(array[22], array[26]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[27]);
    array[27] = _mm_max_ps(array[23], array[27]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[28], array[32]);
    array[32] = _mm_max_ps(array[28], array[32]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[33]);
    array[33] = _mm_max_ps(array[29], array[33]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[30], array[34]);
    array[34] = _mm_max_ps(array[30], array[34]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[35]);
    array[35] = _mm_max_ps(array[31], array[35]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[36], array[40]);
    array[40] = _mm_max_ps(array[36], array[40]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[41]);
    array[41] = _mm_max_ps(array[37], array[41]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[38], array[42]);
    array[42] = _mm_max_ps(array[38], array[42]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[43]);
    array[43] = _mm_max_ps(array[39], array[43]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[44], array[48]);
    array[48] = _mm_max_ps(array[44], array[48]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[49]);
    array[49] = _mm_max_ps(array[45], array[49]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[46], array[50]);
    array[50] = _mm_max_ps(array[46], array[50]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[51]);
    array[51] = _mm_max_ps(array[47], array[51]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[52], array[56]);
    array[56] = _mm_max_ps(array[52], array[56]);
    array[52] = tmp;
    tmp = _mm_min_ps(array[53], array[57]);
    array[57] = _mm_max_ps(array[53], array[57]);
    array[53] = tmp;
    tmp = _mm_min_ps(array[54], array[58]);
    array[58] = _mm_max_ps(array[54], array[58]);
    array[54] = tmp;
    tmp = _mm_min_ps(array[55], array[59]);
    array[59] = _mm_max_ps(array[55], array[59]);
    array[55] = tmp;
    tmp = _mm_min_ps(array[60], array[64]);
    array[64] = _mm_max_ps(array[60], array[64]);
    array[60] = tmp;
    tmp = _mm_min_ps(array[61], array[65]);
    array[65] = _mm_max_ps(array[61], array[65]);
    array[61] = tmp;
    tmp = _mm_min_ps(array[62], array[66]);
    array[66] = _mm_max_ps(array[62], array[66]);
    array[62] = tmp;
    tmp = _mm_min_ps(array[63], array[67]);
    array[67] = _mm_max_ps(array[63], array[67]);
    array[63] = tmp;
    tmp = _mm_min_ps(array[68], array[72]);
    array[72] = _mm_max_ps(array[68], array[72]);
    array[68] = tmp;
    tmp = _mm_min_ps(array[69], array[73]);
    array[73] = _mm_max_ps(array[69], array[73]);
    array[69] = tmp;
    tmp = _mm_min_ps(array[70], array[74]);
    array[74] = _mm_max_ps(array[70], array[74]);
    array[70] = tmp;
    tmp = _mm_min_ps(array[71], array[75]);
    array[75] = _mm_max_ps(array[71], array[75]);
    array[71] = tmp;
    tmp = _mm_min_ps(array[76], array[80]);
    array[80] = _mm_max_ps(array[76], array[80]);
    array[76] = tmp;
    tmp = _mm_min_ps(array[0], array[2]);
    array[2] = _mm_max_ps(array[0], array[2]);
    array[0] = tmp;
    tmp = _mm_min_ps(array[1], array[3]);
    array[3] = _mm_max_ps(array[1], array[3]);
    array[1] = tmp;
    tmp = _mm_min_ps(array[4], array[6]);
    array[6] = _mm_max_ps(array[4], array[6]);
    array[4] = tmp;
    tmp = _mm_min_ps(array[5], array[7]);
    array[7] = _mm_max_ps(array[5], array[7]);
    array[5] = tmp;
    tmp = _mm_min_ps(array[8], array[10]);
    array[10] = _mm_max_ps(array[8], array[10]);
    array[8] = tmp;
    tmp = _mm_min_ps(array[9], array[11]);
    array[11] = _mm_max_ps(array[9], array[11]);
    array[9] = tmp;
    tmp = _mm_min_ps(array[12], array[14]);
    array[14] = _mm_max_ps(array[12], array[14]);
    array[12] = tmp;
    tmp = _mm_min_ps(array[13], array[15]);
    array[15] = _mm_max_ps(array[13], array[15]);
    array[13] = tmp;
    tmp = _mm_min_ps(array[16], array[18]);
    array[18] = _mm_max_ps(array[16], array[18]);
    array[16] = tmp;
    tmp = _mm_min_ps(array[17], array[19]);
    array[19] = _mm_max_ps(array[17], array[19]);
    array[17] = tmp;
    tmp = _mm_min_ps(array[20], array[22]);
    array[22] = _mm_max_ps(array[20], array[22]);
    array[20] = tmp;
    tmp = _mm_min_ps(array[21], array[23]);
    array[23] = _mm_max_ps(array[21], array[23]);
    array[21] = tmp;
    tmp = _mm_min_ps(array[24], array[26]);
    array[26] = _mm_max_ps(array[24], array[26]);
    array[24] = tmp;
    tmp = _mm_min_ps(array[25], array[27]);
    array[27] = _mm_max_ps(array[25], array[27]);
    array[25] = tmp;
    tmp = _mm_min_ps(array[28], array[30]);
    array[30] = _mm_max_ps(array[28], array[30]);
    array[28] = tmp;
    tmp = _mm_min_ps(array[29], array[31]);
    array[31] = _mm_max_ps(array[29], array[31]);
    array[29] = tmp;
    tmp = _mm_min_ps(array[32], array[34]);
    array[34] = _mm_max_ps(array[32], array[34]);
    array[32] = tmp;
    tmp = _mm_min_ps(array[33], array[35]);
    array[35] = _mm_max_ps(array[33], array[35]);
    array[33] = tmp;
    tmp = _mm_min_ps(array[36], array[38]);
    array[38] = _mm_max_ps(array[36], array[38]);
    array[36] = tmp;
    tmp = _mm_min_ps(array[37], array[39]);
    array[39] = _mm_max_ps(array[37], array[39]);
    array[37] = tmp;
    tmp = _mm_min_ps(array[40], array[42]);
    array[42] = _mm_max_ps(array[40], array[42]);
    array[40] = tmp;
    tmp = _mm_min_ps(array[41], array[43]);
    array[43] = _mm_max_ps(array[41], array[43]);
    array[41] = tmp;
    tmp = _mm_min_ps(array[44], array[46]);
    array[46] = _mm_max_ps(array[44], array[46]);
    array[44] = tmp;
    tmp = _mm_min_ps(array[45], array[47]);
    array[47] = _mm_max_ps(array[45], array[47]);
    array[45] = tmp;
    tmp = _mm_min_ps(array[48], array[50]);
    array[50] = _mm_max_ps(array[48], array[50]);
    array[48] = tmp;
    tmp = _mm_min_ps(array[49], array[51]);
    array[51] = _mm_max_ps(array[49], array[51]);
    array[49] = tmp;
    tmp = _mm_min_ps(array[52], array[54]);
    array[54] = _mm_max_ps(array[52], array[54]);
    array[52] = tmp;
    tmp = _mm_min_ps(array[53], array[55]);
    array[55] = _mm_max_ps(array[53], array[55]);
    array[53] = tmp;
    tmp = _mm_min_ps(array[56], array[58]);
    array[58] = _mm_max_ps(array[56], array[58]);
    array[56] = tmp;
    tmp = _mm_min_ps(array[57], array[59]);
    array[59] = _mm_max_ps(array[57], array[59]);
    array[57] = tmp;
    tmp = _mm_min_ps(array[60], array[62]);
    array[62] = _mm_max_ps(array[60], array[62]);
    array[60] = tmp;
    tmp = _mm_min_ps(array[61], array[63]);
    array[63] = _mm_max_ps(array[61], array[63]);
    array[61] = tmp;
    tmp = _mm_min_ps(array[64], array[66]);
    array[66] = _mm_max_ps(array[64], array[66]);
    array[64] = tmp;
    tmp = _mm_min_ps(array[65], array[67]);
    array[67] = _mm_max_ps(array[65], array[67]);
    array[65] = tmp;
    tmp = _mm_min_ps(array[68], array[70]);
    array[70] = _mm_max_ps(array[68], array[70]);
    array[68] = tmp;
    tmp = _mm_min_ps(array[69], array[71]);
    array[71] = _mm_max_ps(array[69], array[71]);
    array[69] = tmp;
    tmp = _mm_min_ps(array[72], array[74]);
    array[74] = _mm_max_ps(array[72], array[74]);
    array[72] = tmp;
    tmp = _mm_min_ps(array[73], array[75]);
    array[75] = _mm_max_ps(array[73], array[75]);
    array[73] = tmp;
    tmp = _mm_min_ps(array[76], array[78]);
    array[78] = _mm_max_ps(array[76], array[78]);
    array[76] = tmp;
    tmp = _mm_min_ps(array[77], array[79]);
    array[79] = _mm_max_ps(array[77], array[79]);
    array[77] = tmp;
    tmp = _mm_min_ps(array[2], array[64]);
    array[64] = _mm_max_ps(array[2], array[64]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[65]);
    array[65] = _mm_max_ps(array[3], array[65]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[68]);
    array[68] = _mm_max_ps(array[6], array[68]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[69]);
    array[69] = _mm_max_ps(array[7], array[69]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[72]);
    array[72] = _mm_max_ps(array[10], array[72]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[73]);
    array[73] = _mm_max_ps(array[11], array[73]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[76]);
    array[76] = _mm_max_ps(array[14], array[76]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[77]);
    array[77] = _mm_max_ps(array[15], array[77]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[80]);
    array[80] = _mm_max_ps(array[18], array[80]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[2], array[32]);
    array[32] = _mm_max_ps(array[2], array[32]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[33]);
    array[33] = _mm_max_ps(array[3], array[33]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[36]);
    array[36] = _mm_max_ps(array[6], array[36]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[37]);
    array[37] = _mm_max_ps(array[7], array[37]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[40]);
    array[40] = _mm_max_ps(array[10], array[40]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[41]);
    array[41] = _mm_max_ps(array[11], array[41]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[44]);
    array[44] = _mm_max_ps(array[14], array[44]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[45]);
    array[45] = _mm_max_ps(array[15], array[45]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[48]);
    array[48] = _mm_max_ps(array[18], array[48]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[49]);
    array[49] = _mm_max_ps(array[19], array[49]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[22], array[52]);
    array[52] = _mm_max_ps(array[22], array[52]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[53]);
    array[53] = _mm_max_ps(array[23], array[53]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[26], array[56]);
    array[56] = _mm_max_ps(array[26], array[56]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[57]);
    array[57] = _mm_max_ps(array[27], array[57]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[30], array[60]);
    array[60] = _mm_max_ps(array[30], array[60]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[61]);
    array[61] = _mm_max_ps(array[31], array[61]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[34], array[64]);
    array[64] = _mm_max_ps(array[34], array[64]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[65]);
    array[65] = _mm_max_ps(array[35], array[65]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[38], array[68]);
    array[68] = _mm_max_ps(array[38], array[68]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[69]);
    array[69] = _mm_max_ps(array[39], array[69]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[42], array[72]);
    array[72] = _mm_max_ps(array[42], array[72]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[73]);
    array[73] = _mm_max_ps(array[43], array[73]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[46], array[76]);
    array[76] = _mm_max_ps(array[46], array[76]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[77]);
    array[77] = _mm_max_ps(array[47], array[77]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[50], array[80]);
    array[80] = _mm_max_ps(array[50], array[80]);
    array[50] = tmp;
    tmp = _mm_min_ps(array[2], array[16]);
    array[16] = _mm_max_ps(array[2], array[16]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[17]);
    array[17] = _mm_max_ps(array[3], array[17]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[20]);
    array[20] = _mm_max_ps(array[6], array[20]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[21]);
    array[21] = _mm_max_ps(array[7], array[21]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[24]);
    array[24] = _mm_max_ps(array[10], array[24]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[25]);
    array[25] = _mm_max_ps(array[11], array[25]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[28]);
    array[28] = _mm_max_ps(array[14], array[28]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[29]);
    array[29] = _mm_max_ps(array[15], array[29]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[32]);
    array[32] = _mm_max_ps(array[18], array[32]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[33]);
    array[33] = _mm_max_ps(array[19], array[33]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[22], array[36]);
    array[36] = _mm_max_ps(array[22], array[36]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[37]);
    array[37] = _mm_max_ps(array[23], array[37]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[26], array[40]);
    array[40] = _mm_max_ps(array[26], array[40]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[41]);
    array[41] = _mm_max_ps(array[27], array[41]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[30], array[44]);
    array[44] = _mm_max_ps(array[30], array[44]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[45]);
    array[45] = _mm_max_ps(array[31], array[45]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[34], array[48]);
    array[48] = _mm_max_ps(array[34], array[48]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[49]);
    array[49] = _mm_max_ps(array[35], array[49]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[38], array[52]);
    array[52] = _mm_max_ps(array[38], array[52]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[53]);
    array[53] = _mm_max_ps(array[39], array[53]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[42], array[56]);
    array[56] = _mm_max_ps(array[42], array[56]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[57]);
    array[57] = _mm_max_ps(array[43], array[57]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[46], array[60]);
    array[60] = _mm_max_ps(array[46], array[60]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[61]);
    array[61] = _mm_max_ps(array[47], array[61]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[50], array[64]);
    array[64] = _mm_max_ps(array[50], array[64]);
    array[50] = tmp;
    tmp = _mm_min_ps(array[51], array[65]);
    array[65] = _mm_max_ps(array[51], array[65]);
    array[51] = tmp;
    tmp = _mm_min_ps(array[54], array[68]);
    array[68] = _mm_max_ps(array[54], array[68]);
    array[54] = tmp;
    tmp = _mm_min_ps(array[55], array[69]);
    array[69] = _mm_max_ps(array[55], array[69]);
    array[55] = tmp;
    tmp = _mm_min_ps(array[58], array[72]);
    array[72] = _mm_max_ps(array[58], array[72]);
    array[58] = tmp;
    tmp = _mm_min_ps(array[59], array[73]);
    array[73] = _mm_max_ps(array[59], array[73]);
    array[59] = tmp;
    tmp = _mm_min_ps(array[62], array[76]);
    array[76] = _mm_max_ps(array[62], array[76]);
    array[62] = tmp;
    tmp = _mm_min_ps(array[63], array[77]);
    array[77] = _mm_max_ps(array[63], array[77]);
    array[63] = tmp;
    tmp = _mm_min_ps(array[66], array[80]);
    array[80] = _mm_max_ps(array[66], array[80]);
    array[66] = tmp;
    tmp = _mm_min_ps(array[2], array[8]);
    array[8] = _mm_max_ps(array[2], array[8]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[9]);
    array[9] = _mm_max_ps(array[3], array[9]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[12]);
    array[12] = _mm_max_ps(array[6], array[12]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[13]);
    array[13] = _mm_max_ps(array[7], array[13]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[16]);
    array[16] = _mm_max_ps(array[10], array[16]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[17]);
    array[17] = _mm_max_ps(array[11], array[17]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[20]);
    array[20] = _mm_max_ps(array[14], array[20]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[21]);
    array[21] = _mm_max_ps(array[15], array[21]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[24]);
    array[24] = _mm_max_ps(array[18], array[24]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[25]);
    array[25] = _mm_max_ps(array[19], array[25]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[22], array[28]);
    array[28] = _mm_max_ps(array[22], array[28]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[29]);
    array[29] = _mm_max_ps(array[23], array[29]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[26], array[32]);
    array[32] = _mm_max_ps(array[26], array[32]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[33]);
    array[33] = _mm_max_ps(array[27], array[33]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[30], array[36]);
    array[36] = _mm_max_ps(array[30], array[36]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[37]);
    array[37] = _mm_max_ps(array[31], array[37]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[34], array[40]);
    array[40] = _mm_max_ps(array[34], array[40]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[41]);
    array[41] = _mm_max_ps(array[35], array[41]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[38], array[44]);
    array[44] = _mm_max_ps(array[38], array[44]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[45]);
    array[45] = _mm_max_ps(array[39], array[45]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[42], array[48]);
    array[48] = _mm_max_ps(array[42], array[48]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[49]);
    array[49] = _mm_max_ps(array[43], array[49]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[46], array[52]);
    array[52] = _mm_max_ps(array[46], array[52]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[53]);
    array[53] = _mm_max_ps(array[47], array[53]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[50], array[56]);
    array[56] = _mm_max_ps(array[50], array[56]);
    array[50] = tmp;
    tmp = _mm_min_ps(array[51], array[57]);
    array[57] = _mm_max_ps(array[51], array[57]);
    array[51] = tmp;
    tmp = _mm_min_ps(array[54], array[60]);
    array[60] = _mm_max_ps(array[54], array[60]);
    array[54] = tmp;
    tmp = _mm_min_ps(array[55], array[61]);
    array[61] = _mm_max_ps(array[55], array[61]);
    array[55] = tmp;
    tmp = _mm_min_ps(array[58], array[64]);
    array[64] = _mm_max_ps(array[58], array[64]);
    array[58] = tmp;
    tmp = _mm_min_ps(array[59], array[65]);
    array[65] = _mm_max_ps(array[59], array[65]);
    array[59] = tmp;
    tmp = _mm_min_ps(array[62], array[68]);
    array[68] = _mm_max_ps(array[62], array[68]);
    array[62] = tmp;
    tmp = _mm_min_ps(array[63], array[69]);
    array[69] = _mm_max_ps(array[63], array[69]);
    array[63] = tmp;
    tmp = _mm_min_ps(array[66], array[72]);
    array[72] = _mm_max_ps(array[66], array[72]);
    array[66] = tmp;
    tmp = _mm_min_ps(array[67], array[73]);
    array[73] = _mm_max_ps(array[67], array[73]);
    array[67] = tmp;
    tmp = _mm_min_ps(array[70], array[76]);
    array[76] = _mm_max_ps(array[70], array[76]);
    array[70] = tmp;
    tmp = _mm_min_ps(array[71], array[77]);
    array[77] = _mm_max_ps(array[71], array[77]);
    array[71] = tmp;
    tmp = _mm_min_ps(array[74], array[80]);
    array[80] = _mm_max_ps(array[74], array[80]);
    array[74] = tmp;
    tmp = _mm_min_ps(array[2], array[4]);
    array[4] = _mm_max_ps(array[2], array[4]);
    array[2] = tmp;
    tmp = _mm_min_ps(array[3], array[5]);
    array[5] = _mm_max_ps(array[3], array[5]);
    array[3] = tmp;
    tmp = _mm_min_ps(array[6], array[8]);
    array[8] = _mm_max_ps(array[6], array[8]);
    array[6] = tmp;
    tmp = _mm_min_ps(array[7], array[9]);
    array[9] = _mm_max_ps(array[7], array[9]);
    array[7] = tmp;
    tmp = _mm_min_ps(array[10], array[12]);
    array[12] = _mm_max_ps(array[10], array[12]);
    array[10] = tmp;
    tmp = _mm_min_ps(array[11], array[13]);
    array[13] = _mm_max_ps(array[11], array[13]);
    array[11] = tmp;
    tmp = _mm_min_ps(array[14], array[16]);
    array[16] = _mm_max_ps(array[14], array[16]);
    array[14] = tmp;
    tmp = _mm_min_ps(array[15], array[17]);
    array[17] = _mm_max_ps(array[15], array[17]);
    array[15] = tmp;
    tmp = _mm_min_ps(array[18], array[20]);
    array[20] = _mm_max_ps(array[18], array[20]);
    array[18] = tmp;
    tmp = _mm_min_ps(array[19], array[21]);
    array[21] = _mm_max_ps(array[19], array[21]);
    array[19] = tmp;
    tmp = _mm_min_ps(array[22], array[24]);
    array[24] = _mm_max_ps(array[22], array[24]);
    array[22] = tmp;
    tmp = _mm_min_ps(array[23], array[25]);
    array[25] = _mm_max_ps(array[23], array[25]);
    array[23] = tmp;
    tmp = _mm_min_ps(array[26], array[28]);
    array[28] = _mm_max_ps(array[26], array[28]);
    array[26] = tmp;
    tmp = _mm_min_ps(array[27], array[29]);
    array[29] = _mm_max_ps(array[27], array[29]);
    array[27] = tmp;
    tmp = _mm_min_ps(array[30], array[32]);
    array[32] = _mm_max_ps(array[30], array[32]);
    array[30] = tmp;
    tmp = _mm_min_ps(array[31], array[33]);
    array[33] = _mm_max_ps(array[31], array[33]);
    array[31] = tmp;
    tmp = _mm_min_ps(array[34], array[36]);
    array[36] = _mm_max_ps(array[34], array[36]);
    array[34] = tmp;
    tmp = _mm_min_ps(array[35], array[37]);
    array[37] = _mm_max_ps(array[35], array[37]);
    array[35] = tmp;
    tmp = _mm_min_ps(array[38], array[40]);
    array[40] = _mm_max_ps(array[38], array[40]);
    array[38] = tmp;
    tmp = _mm_min_ps(array[39], array[41]);
    array[41] = _mm_max_ps(array[39], array[41]);
    array[39] = tmp;
    tmp = _mm_min_ps(array[42], array[44]);
    array[44] = _mm_max_ps(array[42], array[44]);
    array[42] = tmp;
    tmp = _mm_min_ps(array[43], array[45]);
    array[45] = _mm_max_ps(array[43], array[45]);
    array[43] = tmp;
    tmp = _mm_min_ps(array[46], array[48]);
    array[48] = _mm_max_ps(array[46], array[48]);
    array[46] = tmp;
    tmp = _mm_min_ps(array[47], array[49]);
    array[49] = _mm_max_ps(array[47], array[49]);
    array[47] = tmp;
    tmp = _mm_min_ps(array[50], array[52]);
    array[52] = _mm_max_ps(array[50], array[52]);
    array[50] = tmp;
    tmp = _mm_min_ps(array[51], array[53]);
    array[53] = _mm_max_ps(array[51], array[53]);
    array[51] = tmp;
    tmp = _mm_min_ps(array[54], array[56]);
    array[56] = _mm_max_ps(array[54], array[56]);
    array[54] = tmp;
    tmp = _mm_min_ps(array[55], array[57]);
    array[57] = _mm_max_ps(array[55], array[57]);
    array[55] = tmp;
    tmp = _mm_min_ps(array[58], array[60]);
    array[60] = _mm_max_ps(array[58], array[60]);
    array[58] = tmp;
    tmp = _mm_min_ps(array[59], array[61]);
    array[61] = _mm_max_ps(array[59], array[61]);
    array[59] = tmp;
    tmp = _mm_min_ps(array[62], array[64]);
    array[64] = _mm_max_ps(array[62], array[64]);
    array[62] = tmp;
    tmp = _mm_min_ps(array[63], array[65]);
    array[65] = _mm_max_ps(array[63], array[65]);
    array[63] = tmp;
    tmp = _mm_min_ps(array[66], array[68]);
    array[68] = _mm_max_ps(array[66], array[68]);
    array[66] = tmp;
    tmp = _mm_min_ps(array[67], array[69]);
    array[69] = _mm_max_ps(array[67], array[69]);
    array[67] = tmp;
    tmp = _mm_min_ps(array[70], array[72]);
    array[72] = _mm_max_ps(array[70], array[72]);
    array[70] = tmp;
    tmp = _mm_min_ps(array[71], array[73]);
    array[73] = _mm_max_ps(array[71], array[73]);
    array[71] = tmp;
    tmp = _mm_min_ps(array[74], array[76]);
    array[76] = _mm_max_ps(array[74], array[76]);
    array[74] = tmp;
    tmp = _mm_min_ps(array[75], array[77]);
    array[77] = _mm_max_ps(array[75], array[77]);
    array[75] = tmp;
    tmp = _mm_min_ps(array[78], array[80]);
    array[80] = _mm_max_ps(array[78], array[80]);
    array[78] = tmp;
    array[1] = _mm_max_ps(array[0], array[1]);
    array[3] = _mm_max_ps(array[2], array[3]);
    array[5] = _mm_max_ps(array[4], array[5]);
    array[7] = _mm_max_ps(array[6], array[7]);
    array[9] = _mm_max_ps(array[8], array[9]);
    array[11] = _mm_max_ps(array[10], array[11]);
    array[13] = _mm_max_ps(array[12], array[13]);
    array[15] = _mm_max_ps(array[14], array[15]);
    array[17] = _mm_max_ps(array[16], array[17]);
    array[19] = _mm_max_ps(array[18], array[19]);
    array[21] = _mm_max_ps(array[20], array[21]);
    array[23] = _mm_max_ps(array[22], array[23]);
    array[25] = _mm_max_ps(array[24], array[25]);
    array[27] = _mm_max_ps(array[26], array[27]);
    array[29] = _mm_max_ps(array[28], array[29]);
    array[31] = _mm_max_ps(array[30], array[31]);
    array[33] = _mm_max_ps(array[32], array[33]);
    array[35] = _mm_max_ps(array[34], array[35]);
    array[37] = _mm_max_ps(array[36], array[37]);
    array[39] = _mm_max_ps(array[38], array[39]);
    array[40] = _mm_min_ps(array[40], array[41]);
    array[42] = _mm_min_ps(array[42], array[43]);
    array[44] = _mm_min_ps(array[44], array[45]);
    array[46] = _mm_min_ps(array[46], array[47]);
    array[48] = _mm_min_ps(array[48], array[49]);
    array[50] = _mm_min_ps(array[50], array[51]);
    array[52] = _mm_min_ps(array[52], array[53]);
    array[54] = _mm_min_ps(array[54], array[55]);
    array[56] = _mm_min_ps(array[56], array[57]);
    array[58] = _mm_min_ps(array[58], array[59]);
    array[60] = _mm_min_ps(array[60], array[61]);
    array[62] = _mm_min_ps(array[62], array[63]);
    array[64] = _mm_min_ps(array[64], array[65]);
    array[66] = _mm_min_ps(array[66], array[67]);
    array[68] = _mm_min_ps(array[68], array[69]);
    array[70] = _mm_min_ps(array[70], array[71]);
    array[72] = _mm_min_ps(array[72], array[73]);
    array[74] = _mm_min_ps(array[74], array[75]);
    array[76] = _mm_min_ps(array[76], array[77]);
    array[78] = _mm_min_ps(array[78], array[79]);
    array[64] = _mm_max_ps(array[1], array[64]);
    array[66] = _mm_max_ps(array[3], array[66]);
    array[68] = _mm_max_ps(array[5], array[68]);
    array[70] = _mm_max_ps(array[7], array[70]);
    array[9] = _mm_min_ps(array[9], array[72]);
    array[11] = _mm_min_ps(array[11], array[74]);
    array[13] = _mm_min_ps(array[13], array[76]);
    array[15] = _mm_min_ps(array[15], array[78]);
    array[17] = _mm_min_ps(array[17], array[80]);
    array[40] = _mm_max_ps(array[9], array[40]);
    array[42] = _mm_max_ps(array[11], array[42]);
    array[44] = _mm_max_ps(array[13], array[44]);
    array[46] = _mm_max_ps(array[15], array[46]);
    array[48] = _mm_max_ps(array[17], array[48]);
    array[50] = _mm_max_ps(array[19], array[50]);
    array[52] = _mm_max_ps(array[21], array[52]);
    array[54] = _mm_max_ps(array[23], array[54]);
    array[25] = _mm_min_ps(array[25], array[56]);
    array[27] = _mm_min_ps(array[27], array[58]);
    array[29] = _mm_min_ps(array[29], array[60]);
    array[31] = _mm_min_ps(array[31], array[62]);
    array[33] = _mm_min_ps(array[33], array[64]);
    array[35] = _mm_min_ps(array[35], array[66]);
    array[37] = _mm_min_ps(array[37], array[68]);
    array[39] = _mm_min_ps(array[39], array[70]);
    array[40] = _mm_max_ps(array[25], array[40]);
    array[42] = _mm_max_ps(array[27], array[42]);
    array[44] = _mm_max_ps(array[29], array[44]);
    array[46] = _mm_max_ps(array[31], array[46]);
    array[33] = _mm_min_ps(array[33], array[48]);
    array[35] = _mm_min_ps(array[35], array[50]);
    array[37] = _mm_min_ps(array[37], array[52]);
    array[39] = _mm_min_ps(array[39], array[54]);
    array[40] = _mm_max_ps(array[33], array[40]);
    array[42] = _mm_max_ps(array[35], array[42]);
    array[37] = _mm_min_ps(array[37], array[44]);
    array[39] = _mm_min_ps(array[39], array[46]);
    array[40] = _mm_max_ps(array[37], array[40]);
    array[39] = _mm_min_ps(array[39], array[42]);
    return _mm_max_ps(array[39], array[40]);
}
#endif
