#!/bin/sh -e

# $1 version
TAR=../spring-build_$1.orig.tar.gz
DIR=spring-build-$1.orig
VERSION=`echo $1 | sed -e 's/[+~].*//g'`
TAG=$VERSION

GIT_ROOT=git://git.springsource.org/spring-build
GIT_MODULES="misc-ant aws-ant aws-ivy osgi-ant"

mkdir orig_tmp
(cd orig_tmp && \
mkdir $DIR && \
git clone ${GIT_ROOT}/spring-build.git && \
(cd spring-build; git archive --prefix=project-build/ --format=tar $TAG | tar -C ../$DIR -xf -) && \
for git_module in $GIT_MODULES; do \
  git clone ${GIT_ROOT}/${git_module}.git && \
  (cd ${git_module}; git archive --format=tar HEAD | tar -C ../$DIR -xf -); \
done
)

GZIP=--best tar -C orig_tmp -c -z -f $TAR -X debian/orig-tar.exclude $DIR

rm -rf orig_tmp

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0

