"""
Place to hold TurboGears built-in templates

With 'paster quickstart' or 'paster create' command you can create a new
TurboGears project which you can use as a basis for your own project.
Let's take the command 'paster quickstart helloworld' for example.
The generated directory structure is as follows::

    - helloworld/
        - helloworld/
        - development.ini
        - setup.cfg
        - setup.py
        - test.ini


The setup.py file is used to create a re-distributable Python
package of your project called an egg. Eggs can be thought of as
similar to .jar files in Java.
The setup.cfg file contains extra information about your project.

The sub 'helloworld' directory within the root 'helloworld' directory
is where all your application specific code and files are placed.
The sub directory looks like this::

    - helloworld/
        - config/
        - controllers/
        - lib/
        - model/
        - public/
        - templates/
        - tests/
        - __init__.py
        - websetup.py

The config directory contains the configuration options for your web application.

The controllers directory is where your application controllers are written.
Controllers are the core of your application where the decision is made on what
data to load, and how to view it.

The lib directory is where you can put code that is used between different
controllers, third party code, or any other code that doesn't fit in well elsewhere.

The models directory is for your model objects, if you're using an ORM this is
where the classes for them should go.
Objects defined in models/__init__.py will be loaded and present as model.
YourObject inside your controllers. The database configuration string can be set
in your development.ini file.

The public directory is where you put all your HTML, images, Javascript, CSS and
other static files. It is similar to the htdocs directory in Apache.

The templates directory is where templates are stored. Templates contain a mixture of
plain text and Python code and are used for creating HTML and other documents in a way
that is easy for designers to tweak without them needing to see all the code that
goes on behind the scenes.

TurboGears 2 uses Genshi templates by default but also supports Mako, and jinja
out of the box.  Cheetah, Kid and any other template system you want can be 
easily used by writing a simple render function for them. 

The tests directory is where you can put controller and other tests. The controller
testing functionality uses Nose and paste.fixture.

The __init__.py file is present so that the helloworld directory can be used as a Python
module within the egg.

The websetup.py should contain any code that should be executed when an end user of your
application runs the paster setup-app command described in Application Setup.
If you're looking for where to put that should be run before your application is,
this is the place.

"""
